/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.MemoryStorageManager;

public class TestBufferManagerImpl {
    @Test
    public void testReserve() throws Exception {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setCache((Cache)new MemoryStorageManager());
        bufferManager.setMaxProcessingKB(1024);
        bufferManager.setMaxReserveKB(1024);
        bufferManager.initialize();
        bufferManager.setNominalProcessingMemoryMax(512000);
        Assert.assertEquals((long)512000L, (long)bufferManager.reserveBuffers(1024000, BufferManager.BufferReserveMode.NO_WAIT));
        Assert.assertEquals((long)1024000L, (long)bufferManager.reserveBuffersBlocking(1024000, new long[]{0L, 0L}, true));
        Assert.assertEquals((long)0L, (long)bufferManager.reserveBuffersBlocking(1024000, new long[]{0L, 0L}, false));
        bufferManager.releaseBuffers(512000);
        Assert.assertEquals((long)24576L, (long)bufferManager.reserveBuffers(1024000, BufferManager.BufferReserveMode.NO_WAIT));
    }
}

