/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.PreparedStatementRequest;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TestPreparedStatement;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestCallableStatement {
    @Test
    public void testMissingInput() throws Exception {
        String sql = "{? = call pm4.spTest9()}";
        try {
            TestPreparedStatement.helpTestProcessing(sql, Collections.EMPTY_LIST, null, new HardcodedDataManager(), (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), true, RealMetadataFactory.exampleBQTVDB());
            Assert.fail();
        }
        catch (QueryResolverException e) {
            Assert.assertEquals((Object)"TEIID30089 Required parameter 'pm4.spTest9.inkey' has no value was set or is an invalid parameter.", (Object)e.getMessage());
        }
    }

    @Test
    public void testProcedurePlanCaching() throws Exception {
        String sql = "{? = call BQT_V.v_spTest9(?)}";
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(1);
        List[] expected = new List[]{Arrays.asList(1)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("ret = EXEC pm4.spTest9(1)", expected);
        TestPreparedStatement.helpTestProcessing(sql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), true, RealMetadataFactory.exampleBQTVDB());
    }

    @Test
    public void testReturnParameter() throws Exception {
        String sql = "{? = call pm4.spTest9(inkey=>?)}";
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(1);
        List[] expected = new List[]{Arrays.asList(1)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("? = EXEC pm4.spTest9(1)", expected);
        this.helpProcess(sql, values, expected, dataManager);
    }

    private void helpProcess(String sql, List values, List[] expected, HardcodedDataManager dataManager) throws TeiidComponentException, TeiidProcessingException, Exception {
        SessionAwareCache planCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        PreparedStatementRequest plan = TestPreparedStatement.helpGetProcessorPlan(sql, values, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), (SessionAwareCache<PreparedPlan>)planCache, 1, true, false, RealMetadataFactory.exampleBQTVDB());
        TestProcessor.doProcess(plan.processPlan, dataManager, expected, plan.context);
        TestPreparedStatement.helpGetProcessorPlan(sql, values, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), (SessionAwareCache<PreparedPlan>)planCache, 1, true, false, RealMetadataFactory.exampleBQTVDB());
        Assert.assertEquals((long)0L, (long)planCache.getCacheHitCount());
    }

    @Test
    public void testNoReturnParameter() throws Exception {
        String sql = "{call pm4.spTest9(?)}";
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(1);
        List[] expected = new List[]{Arrays.asList(1)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm4.spTest9(1)", expected);
        this.helpProcess(sql, values, expected, dataManager);
    }

    @Test
    public void testOutParameter() throws Exception {
        String sql = "{call pm2.spTest8(?, ?)}";
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(2);
        List[] expected = new List[]{Arrays.asList(null, null, 1)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm2.spTest8(2)", expected);
        this.helpProcess(sql, values, expected, dataManager);
    }

    @Test(expected=QueryResolverException.class)
    public void testInvalidReturn() throws Exception {
        String sql = "{? = call pm2.spTest8(?, ?)}";
        List<Integer> values = Arrays.asList(2);
        List[] expected = new List[]{};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        TestPreparedStatement.helpTestProcessing(sql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), true, RealMetadataFactory.exampleBQTVDB());
    }

    @Test
    public void testInputExpression() throws Exception {
        String sql = "{call pm2.spTest8(1, ?)}";
        List[] expected = new List[]{Arrays.asList(null, null, 0)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm2.spTest8(1)", expected);
        this.helpProcess(sql, null, expected, dataManager);
    }
}

