/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import junit.framework.TestCase;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.rules.RuleValidateWhereAll;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestRuleValidateWhereAll
extends TestCase {
    public TestRuleValidateWhereAll(String name) {
        super(name);
    }

    public void testHasNoCriteria1() {
        TestRuleValidateWhereAll.assertEquals((String)"Got incorrect answer checking for no criteria", (boolean)false, (boolean)RuleValidateWhereAll.hasNoCriteria((Command)new Insert()));
    }

    public void testHasNoCriteria2() {
        Query query = new Query();
        CompareCriteria crit = new CompareCriteria((Expression)new Constant((Object)"a"), 1, (Expression)new Constant((Object)"b"));
        query.setCriteria((Criteria)crit);
        TestRuleValidateWhereAll.assertEquals((String)"Got incorrect answer checking for no criteria", (boolean)false, (boolean)RuleValidateWhereAll.hasNoCriteria((Command)query));
    }

    public void testHasNoCriteria3() {
        TestRuleValidateWhereAll.assertEquals((String)"Got incorrect answer checking for no criteria", (boolean)true, (boolean)RuleValidateWhereAll.hasNoCriteria((Command)new Query()));
    }

    private FakeCapabilitiesFinder getWhereAllCapabilities() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.REQUIRES_CRITERIA, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        capFinder.addCapabilities("pm6", (SourceCapabilities)caps);
        return capFinder;
    }

    public void testDefect21982_3() {
        TestOptimizer.helpPlan("SELECT * FROM vm1.g38", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)this.getWhereAllCapabilities(), new String[0], false);
    }

    public void testWhereAll1() {
        TestOptimizer.helpPlan("SELECT * FROM pm6.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)this.getWhereAllCapabilities(), new String[0], false);
    }

    public void testWhereAll2() throws Exception {
        TestOptimizer.helpPlan("SELECT pm1.g1.e1 FROM pm1.g1, pm6.g1 WHERE pm1.g1.e1=pm6.g1.e1 OPTION MAKEDEP pm6.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)this.getWhereAllCapabilities(), new String[]{"SELECT g_0.e1 AS c_0 FROM pm6.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>) ORDER BY c_0", "SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }
}

