/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleAssignOutputElements;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.optimizer.relational.rules.RulePushAggregates;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleChooseDependent
implements OptimizerRule {
    private static AtomicInteger ID = new AtomicInteger();
    public static final int DEFAULT_INDEPENDENT_CARDINALITY = PropertiesUtils.getIntProperty((Properties)System.getProperties(), (String)"org.teiid.defaultIndependentCardinality", (int)10);
    public static final int UNKNOWN_INDEPENDENT_CARDINALITY = 256;
    private boolean fullPushOnly;

    public RuleChooseDependent() {
    }

    public RuleChooseDependent(boolean b) {
        this.fullPushOnly = b;
    }

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        List<CandidateJoin> matches = this.findCandidate(plan, metadata, analysisRecord);
        boolean pushCriteria = false;
        for (CandidateJoin entry : matches) {
            PlanNode joinNode = entry.joinNode;
            PlanNode sourceNode = entry.leftCandidate ? joinNode.getFirstChild() : joinNode.getLastChild();
            PlanNode siblingNode = entry.leftCandidate ? joinNode.getLastChild() : joinNode.getFirstChild();
            boolean bothCandidates = entry.leftCandidate && entry.rightCandidate;
            PlanNode chosenNode = this.chooseDepWithoutCosting(sourceNode, bothCandidates ? siblingNode : null, analysisRecord);
            if (chosenNode != null) {
                pushCriteria |= this.markDependent(chosenNode, joinNode, metadata, null, false, capFinder, context, rules, analysisRecord);
                continue;
            }
            if (this.fullPushOnly) continue;
            NewCalculateCostUtil.DependentCostAnalysis dca = NewCalculateCostUtil.computeCostForDepJoin(joinNode, !entry.leftCandidate, metadata, capFinder, context);
            PlanNode dependentNode = sourceNode;
            if (bothCandidates && dca.expectedCardinality == null) {
                dca = NewCalculateCostUtil.computeCostForDepJoin(joinNode, true, metadata, capFinder, context);
                if (dca.expectedCardinality != null) {
                    dependentNode = siblingNode;
                }
            }
            if (dca.expectedCardinality != null) {
                pushCriteria |= this.markDependent(dependentNode, joinNode, metadata, dca, null, capFinder, context, rules, analysisRecord);
                continue;
            }
            float sourceCost = NewCalculateCostUtil.computeCostForTree(sourceNode, metadata);
            float siblingCost = NewCalculateCostUtil.computeCostForTree(siblingNode, metadata);
            List leftExpressions = (List)joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS);
            List rightExpressions = (List)joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS);
            float sourceNdv = NewCalculateCostUtil.getNDVEstimate(joinNode.getFirstChild(), metadata, sourceCost, leftExpressions, true);
            float siblingNdv = NewCalculateCostUtil.getNDVEstimate(joinNode.getLastChild(), metadata, siblingCost, rightExpressions, true);
            if (sourceCost != -1.0f && sourceNdv == -1.0f) {
                sourceNdv = sourceCost;
            }
            if (siblingCost != -1.0f && siblingNdv == -1.0f) {
                siblingNdv = siblingCost;
            }
            if (bothCandidates && sourceNdv != -1.0f && (sourceCost <= (float)DEFAULT_INDEPENDENT_CARDINALITY && sourceCost <= siblingCost || siblingCost == -1.0f && sourceNdv <= 256.0f)) {
                pushCriteria |= this.markDependent(siblingNode, joinNode, metadata, null, sourceCost > (float)DEFAULT_INDEPENDENT_CARDINALITY ? Boolean.valueOf(true) : null, capFinder, context, rules, analysisRecord);
                continue;
            }
            if (siblingNdv == -1.0f || !(siblingCost <= (float)DEFAULT_INDEPENDENT_CARDINALITY) && (sourceCost != -1.0f || !(siblingNdv <= 256.0f))) continue;
            pushCriteria |= this.markDependent(sourceNode, joinNode, metadata, null, siblingCost > (float)DEFAULT_INDEPENDENT_CARDINALITY ? Boolean.valueOf(true) : null, capFinder, context, rules, analysisRecord);
        }
        if (pushCriteria) {
            rules.push(RuleConstants.CLEAN_CRITERIA);
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        if (!matches.isEmpty() && plan.getParent() != null) {
            return plan.getParent();
        }
        return plan;
    }

    List<CandidateJoin> findCandidate(PlanNode root, QueryMetadataInterface metadata, AnalysisRecord analysisRecord) throws QueryMetadataException, TeiidComponentException {
        ArrayList<CandidateJoin> candidates = new ArrayList<CandidateJoin>();
        for (PlanNode joinNode : NodeEditor.findAllNodes(root, 4, 1)) {
            CandidateJoin candidate = null;
            Iterator<PlanNode> j = joinNode.getChildren().iterator();
            while (j.hasNext()) {
                PlanNode child = j.next();
                if ((child = FrameUtil.findJoinSourceNode(child)).hasBooleanProperty(NodeConstants.Info.MAKE_NOT_DEP) || !this.isValidJoin(joinNode, child, analysisRecord)) continue;
                if (candidate == null) {
                    candidate = new CandidateJoin();
                    candidate.joinNode = joinNode;
                    candidates.add(candidate);
                }
                if (j.hasNext()) {
                    candidate.leftCandidate = true;
                    continue;
                }
                candidate.rightCandidate = true;
            }
        }
        return candidates;
    }

    boolean isValidJoin(PlanNode joinNode, PlanNode sourceNode, AnalysisRecord analysisRecord) throws QueryMetadataException, TeiidComponentException {
        JoinType jtype = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jtype.equals(JoinType.JOIN_CROSS)) {
            sourceNode.recordDebugAnnotation("parent join is CROSS", null, "Rejecting dependent join", analysisRecord, null);
            return false;
        }
        if (!joinNode.getExportedCorrelatedReferences().isEmpty()) {
            sourceNode.recordDebugAnnotation("parent join has a correlated nested table", null, "Rejecting dependent join", analysisRecord, null);
            return false;
        }
        List jcrit = (List)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        if (jcrit == null || jcrit.size() == 0) {
            sourceNode.recordDebugAnnotation("parent join has has no join criteria", null, "Rejecting dependent join", analysisRecord, null);
            return false;
        }
        if (joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS) == null) {
            sourceNode.recordDebugAnnotation("parent join has no equa-join predicates", null, "Rejecting dependent join", analysisRecord, null);
            return false;
        }
        return true;
    }

    PlanNode chooseDepWithoutCosting(PlanNode rootNode1, PlanNode rootNode2, AnalysisRecord analysisRecord) throws QueryMetadataException, TeiidComponentException {
        PlanNode sourceNode1 = FrameUtil.findJoinSourceNode(rootNode1);
        if (sourceNode1.getType() == 128) {
            sourceNode1 = FrameUtil.findJoinSourceNode(sourceNode1.getFirstChild());
        }
        PlanNode sourceNode2 = null;
        if (rootNode2 != null && (sourceNode2 = FrameUtil.findJoinSourceNode(rootNode2)).getType() == 128) {
            sourceNode2 = FrameUtil.findJoinSourceNode(sourceNode2.getFirstChild());
        }
        if (sourceNode1.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            if (sourceNode2 != null && sourceNode2.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
                rootNode1.getParent().recordDebugAnnotation("both children have unsatisfied access patterns", null, "Neither node can be made dependent", analysisRecord, null);
                return null;
            }
            rootNode1.recordDebugAnnotation("unsatisfied access pattern detected", null, "marking as dependent side of join", analysisRecord, null);
            return rootNode1;
        }
        if (sourceNode2 != null && sourceNode2.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            sourceNode2.recordDebugAnnotation("unsatisfied access pattern detected", null, "marking as dependent side of join", analysisRecord, null);
            return rootNode2;
        }
        if (sourceNode1.hasProperty(NodeConstants.Info.MAKE_DEP)) {
            sourceNode1.recordDebugAnnotation("MAKE_DEP hint detected", null, "marking as dependent side of join", analysisRecord, null);
            rootNode1.setProperty(NodeConstants.Info.MAKE_DEP, sourceNode1.getProperty(NodeConstants.Info.MAKE_DEP));
            return rootNode1;
        }
        if (sourceNode2 != null && sourceNode2.hasProperty(NodeConstants.Info.MAKE_DEP)) {
            sourceNode2.recordDebugAnnotation("MAKE_DEP hint detected", null, "marking as dependent side of join", analysisRecord, null);
            rootNode2.setProperty(NodeConstants.Info.MAKE_DEP, sourceNode2.getProperty(NodeConstants.Info.MAKE_DEP));
            return rootNode2;
        }
        if (sourceNode1.hasBooleanProperty(NodeConstants.Info.MAKE_IND) && sourceNode2 != null) {
            sourceNode2.recordDebugAnnotation("MAKE_IND hint detected", null, "marking as dependent side of join", analysisRecord, null);
            return rootNode2;
        }
        if (sourceNode2 != null && sourceNode2.hasBooleanProperty(NodeConstants.Info.MAKE_IND)) {
            sourceNode1.recordDebugAnnotation("MAKE_IND hint detected", null, "marking as dependent side of join", analysisRecord, null);
            return rootNode1;
        }
        return null;
    }

    boolean markDependent(PlanNode sourceNode, PlanNode joinNode, QueryMetadataInterface metadata, NewCalculateCostUtil.DependentCostAnalysis dca, Boolean bound, CapabilitiesFinder capabilitiesFinder, CommandContext context, RuleStack rules, AnalysisRecord analysisRecord) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        Option.MakeDep makeDep;
        PlanNode indNode;
        boolean isLeft = joinNode.getFirstChild() == sourceNode;
        List independentExpressions = (List)(isLeft ? joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS));
        List dependentExpressions = (List)(isLeft ? joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS));
        if (independentExpressions == null || independentExpressions.isEmpty()) {
            return false;
        }
        PlanNode planNode = indNode = isLeft ? joinNode.getLastChild() : joinNode.getFirstChild();
        if (bound == null) {
            List<PlanNode> sources = NodeEditor.findAllNodes(indNode, 64);
            block0: for (PlanNode planNode2 : sources) {
                for (GroupSymbol gs : planNode2.getGroups()) {
                    if (!gs.isTempTable() || metadata.getCardinality(gs.getMetadataID()) != -1.0f) continue;
                    bound = true;
                    continue block0;
                }
            }
            if (bound == null) {
                bound = false;
            }
        }
        if (this.fullyPush(sourceNode, joinNode, metadata, capabilitiesFinder, context, indNode, rules, makeDep = (Option.MakeDep)sourceNode.getProperty(NodeConstants.Info.MAKE_DEP), analysisRecord, independentExpressions) || this.fullPushOnly) {
            return false;
        }
        JoinType jtype = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jtype == JoinType.JOIN_FULL_OUTER || jtype.isOuter() && JoinUtil.getInnerSideJoinNodes(joinNode)[0] != sourceNode) {
            sourceNode.recordDebugAnnotation("node is on outer side of the join", null, "Rejecting dependent join", analysisRecord, null);
            return false;
        }
        String id = RuleChooseDependent.nextId();
        joinNode.setProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE, id);
        PlanNode depNode = isLeft ? joinNode.getFirstChild() : joinNode.getLastChild();
        depNode = FrameUtil.findJoinSourceNode(depNode);
        if (!depNode.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            this.handleDuplicate(joinNode, isLeft, independentExpressions, dependentExpressions);
            this.handleDuplicate(joinNode, !isLeft, dependentExpressions, independentExpressions);
        }
        PlanNode crit = RuleChooseDependent.getDependentCriteriaNode(id, independentExpressions, dependentExpressions, indNode, metadata, dca, bound, makeDep);
        sourceNode.addAsParent(crit);
        if (isLeft) {
            JoinUtil.swapJoinChildren(joinNode);
        }
        return true;
    }

    private void handleDuplicate(PlanNode joinNode, boolean isLeft, List independentExpressions, List dependentExpressions) {
        HashMap<Expression, Integer> seen = new HashMap<Expression, Integer>();
        for (int i = 0; i < dependentExpressions.size(); ++i) {
            Expression ex = (Expression)dependentExpressions.get(i);
            Integer index = (Integer)seen.get(ex);
            if (index == null) {
                seen.put(ex, i);
                continue;
            }
            Expression e1 = (Expression)independentExpressions.get(i);
            Expression e2 = (Expression)independentExpressions.get(index);
            CompareCriteria cc = new CompareCriteria(e1, 1, e2);
            PlanNode impliedCriteria = RelationalPlanner.createSelectNode(cc, false);
            if (isLeft) {
                joinNode.getLastChild().addAsParent(impliedCriteria);
            } else {
                joinNode.getFirstChild().addAsParent(impliedCriteria);
            }
            independentExpressions.remove(i);
            dependentExpressions.remove(i);
            --i;
        }
    }

    public static String nextId() {
        return "$dsc/id" + ID.getAndIncrement();
    }

    private boolean fullyPush(PlanNode sourceNode, PlanNode joinNode, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, CommandContext context, PlanNode indNode, RuleStack rules, Option.MakeDep makeDep, AnalysisRecord analysisRecord, List independentExpressions) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        PlanNode root;
        if (sourceNode.getType() != 1) {
            return false;
        }
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(sourceNode, metadata);
        boolean hasHint = false;
        if (makeDep != null && makeDep.isJoin()) {
            hasHint = true;
        }
        if (!CapabilitiesUtil.supports(SourceCapabilities.Capability.FULL_DEPENDENT_JOIN, modelID, metadata, capabilitiesFinder)) {
            if (hasHint) {
                sourceNode.recordDebugAnnotation("cannot pushdown dependent join", modelID, "dependent join pushdown needs enabled at the source", analysisRecord, null);
            }
            return false;
        }
        List projected = (List)indNode.getProperty(NodeConstants.Info.OUTPUT_COLS);
        if (projected == null) {
            Object plan = sourceNode;
            while (((PlanNode)plan).getParent() != null) {
                plan = ((PlanNode)plan).getParent();
            }
            new RuleAssignOutputElements(false).execute((PlanNode)plan, metadata, capabilitiesFinder, null, AnalysisRecord.createNonRecordingRecord(), context);
            projected = (List)indNode.getProperty(NodeConstants.Info.OUTPUT_COLS);
        }
        if (!hasHint) {
            for (Expression ex : projected) {
                if (!DataTypeManager.isLOB(ex.getClass())) continue;
                return false;
            }
            if (context.getBufferManager() == null) {
                return false;
            }
            if (makeDep != null && makeDep.getMax() != null) {
                return false;
            }
        }
        PlanNode tempAccess = NodeFactory.getNewNode(1);
        GroupSymbol gs = RulePlaceAccess.recontextSymbol(new GroupSymbol("TEIID_TEMP"), context.getGroups());
        gs.setDefinition(null);
        tempAccess.addGroup(gs);
        tempAccess.setProperty(NodeConstants.Info.MODEL_ID, modelID);
        indNode.addAsParent(tempAccess);
        PlanNode originalSource = sourceNode;
        sourceNode = originalSource.clone();
        if (sourceNode.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            sourceNode.setProperty(NodeConstants.Info.ACCESS_PATTERNS, new ArrayList((List)sourceNode.getProperty(NodeConstants.Info.ACCESS_PATTERNS)));
        }
        if (sourceNode.hasCollectionProperty(NodeConstants.Info.CONFORMED_SOURCES)) {
            sourceNode.setProperty(NodeConstants.Info.CONFORMED_SOURCES, new LinkedHashSet((Set)sourceNode.getProperty(NodeConstants.Info.CONFORMED_SOURCES)));
        }
        originalSource.addAsParent(sourceNode);
        boolean raised = false;
        boolean moreProcessing = false;
        boolean first = true;
        while (sourceNode.getParent() != null && RuleRaiseAccess.raiseAccessNode(sourceNode, sourceNode, metadata, capabilitiesFinder, true, null, context) != null) {
            raised = true;
            if (first) {
                first = false;
                continue;
            }
            switch (sourceNode.getFirstChild().getType()) {
                case 8: {
                    if (!sourceNode.getFirstChild().hasBooleanProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS)) break;
                    moreProcessing = true;
                    break;
                }
                case 2: 
                case 4: 
                case 16: 
                case 32: 
                case 128: 
                case 1024: {
                    moreProcessing = true;
                }
            }
        }
        if (!raised) {
            tempAccess.getParent().replaceChild(tempAccess, tempAccess.getFirstChild());
            sourceNode.getParent().replaceChild(sourceNode, sourceNode.getFirstChild());
            return false;
        }
        if (!moreProcessing && !hasHint) {
            if (sourceNode.getParent() != null) {
                sourceNode.getParent().replaceChild(sourceNode, sourceNode.getFirstChild());
            } else {
                sourceNode.removeAllChildren();
            }
            return false;
        }
        originalSource.getParent().replaceChild(originalSource, originalSource.getFirstChild());
        PlanNode project = NodeFactory.getNewNode(8);
        PlanNode source = NodeFactory.getNewNode(64);
        source.addGroup(gs);
        project.setProperty(NodeConstants.Info.OUTPUT_COLS, projected);
        project.setProperty(NodeConstants.Info.PROJECT_COLS, projected);
        Set<GroupSymbol> newGroups = Collections.singleton(gs);
        ArrayList<ElementSymbol> virtualSymbols = new ArrayList<ElementSymbol>(projected.size());
        for (int i = 0; i < projected.size(); ++i) {
            ElementSymbol es = new ElementSymbol("col" + (i + 1));
            Expression ex = (Expression)projected.get(i);
            es.setType(ex.getType());
            virtualSymbols.add(es);
            if (!(ex instanceof ElementSymbol)) continue;
            es.setMetadataID(((ElementSymbol)ex).getMetadataID());
        }
        List<ElementSymbol> newCols = RulePushAggregates.defineNewGroup(gs, virtualSymbols, metadata);
        SymbolMap symbolMap = SymbolMap.createSymbolMap(newCols, projected);
        Map<Expression, ElementSymbol> inverse = symbolMap.inserseMapping();
        for (GroupSymbol group : indNode.getGroups()) {
            FrameUtil.convertFrame(joinNode, group, newGroups, inverse, metadata);
        }
        indNode.addAsParent(source);
        indNode.removeFromParent();
        project.addFirstChild(indNode);
        RuleStack ruleCopy = rules.clone();
        if (indNode.getType() == 1 && (root = RuleRaiseAccess.raiseAccessNode(project, indNode, metadata, capabilitiesFinder, true, null, context)) != project) {
            project = root;
        }
        project = rules.getPlanner().executeRules(ruleCopy, project);
        source.setProperty(NodeConstants.Info.SYMBOL_MAP, symbolMap);
        source.setProperty(NodeConstants.Info.SUB_PLAN, project);
        return true;
    }

    public static PlanNode getDependentCriteriaNode(String id, List<Expression> independentExpressions, List<Expression> dependentExpressions, PlanNode indNode, QueryMetadataInterface metadata, NewCalculateCostUtil.DependentCostAnalysis dca, Boolean bound, Option.MakeDep makeDep) throws QueryMetadataException, TeiidComponentException {
        Float cardinality = null;
        ArrayList<DependentSetCriteria.AttributeComparison> expressions = new ArrayList<DependentSetCriteria.AttributeComparison>(dependentExpressions.size());
        for (int i = 0; i < dependentExpressions.size(); ++i) {
            Expression depExpr = dependentExpressions.get(i);
            Expression indExpr = independentExpressions.get(i);
            DependentSetCriteria.AttributeComparison comp = new DependentSetCriteria.AttributeComparison();
            if (dca != null && dca.expectedNdv[i] != null) {
                if (dca.expectedNdv[i].floatValue() > 4.0f * dca.maxNdv[i].floatValue()) continue;
                comp.ndv = dca.expectedNdv[i].floatValue();
                comp.maxNdv = dca.maxNdv[i].floatValue();
            } else {
                Collection<ElementSymbol> elems = ElementCollectorVisitor.getElements((LanguageObject)indExpr, true);
                if (cardinality == null) {
                    cardinality = Float.valueOf(NewCalculateCostUtil.computeCostForTree(indNode, metadata));
                }
                comp.ndv = NewCalculateCostUtil.getNDVEstimate(indNode, metadata, cardinality.floatValue(), elems, true);
                if (bound.booleanValue()) {
                    comp.maxNdv = dca != null ? Math.max(comp.ndv * 4.0f, dca.expectedCardinality.floatValue() * 2.0f) : Math.max(256.0f, comp.ndv * 4.0f);
                }
            }
            comp.ind = indExpr;
            comp.dep = SymbolMap.getExpression(depExpr);
            expressions.add(comp);
        }
        PlanNode result = RuleChooseDependent.createDependentSetNode(id, expressions);
        if (makeDep != null) {
            DependentSetCriteria dsc = (DependentSetCriteria)result.getProperty(NodeConstants.Info.SELECT_CRITERIA);
            dsc.setMakeDepOptions(makeDep);
        }
        return result;
    }

    static PlanNode createDependentSetNode(String id, List<DependentSetCriteria.AttributeComparison> expressions) {
        DependentSetCriteria crit = RuleChooseDependent.createDependentSetCriteria(id, expressions);
        PlanNode selectNode = RelationalPlanner.createSelectNode(crit, false);
        selectNode.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
        return selectNode;
    }

    static DependentSetCriteria createDependentSetCriteria(String id, List<DependentSetCriteria.AttributeComparison> expressions) {
        if (expressions.isEmpty()) {
            return null;
        }
        Expression indEx = null;
        Expression depEx = null;
        float maxNdv = -1.0f;
        float ndv = -1.0f;
        if (expressions.size() == 1) {
            DependentSetCriteria.AttributeComparison attributeComparison = expressions.get(0);
            indEx = attributeComparison.ind;
            depEx = attributeComparison.dep;
            maxNdv = attributeComparison.maxNdv;
            ndv = attributeComparison.ndv;
        } else {
            ArrayList<Expression> indExprs = new ArrayList<Expression>(expressions.size());
            ArrayList<Expression> depExprs = new ArrayList<Expression>(expressions.size());
            boolean unknown = false;
            for (DependentSetCriteria.AttributeComparison comp : expressions) {
                indExprs.add(comp.ind);
                depExprs.add(comp.dep);
                if (comp.ndv == -1.0f) {
                    ndv = -1.0f;
                    maxNdv = -1.0f;
                    unknown = true;
                    continue;
                }
                if (unknown) continue;
                ndv = Math.max(ndv, comp.ndv);
                maxNdv = Math.max(maxNdv, comp.maxNdv);
            }
            indEx = new Array(DataTypeManager.DefaultDataClasses.OBJECT, indExprs);
            depEx = new Array(DataTypeManager.DefaultDataClasses.OBJECT, depExprs);
        }
        DependentSetCriteria crit = new DependentSetCriteria(depEx, id);
        crit.setValueExpression(indEx);
        crit.setAttributes(expressions);
        crit.setMaxNdv(maxNdv);
        crit.setNdv(ndv);
        return crit;
    }

    public String toString() {
        return "ChooseDependent";
    }

    private static class CandidateJoin {
        PlanNode joinNode;
        boolean leftCandidate;
        boolean rightCandidate;

        private CandidateJoin() {
        }
    }
}

