/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.symbol.Expression;

public class TextTable
extends TableFunctionReference {
    private Expression file;
    private List<TextColumn> columns = new ArrayList<TextColumn>();
    private Character rowDelimiter;
    private Character delimiter;
    private Character quote;
    private boolean escape;
    private Integer header;
    private Integer skip;
    private boolean usingRowDelimiter = true;
    private String selector;
    private boolean fixedWidth;

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public Character getQuote() {
        return this.quote;
    }

    public void setQuote(Character quote) {
        this.quote = quote;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public boolean isFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedWidth(boolean fixedWidth) {
        this.fixedWidth = fixedWidth;
    }

    public List<TextColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<TextColumn> columns) {
        this.columns = columns;
    }

    public Character getRowDelimiter() {
        return this.rowDelimiter;
    }

    public void setRowDelimiter(Character rowDelimiter) {
        this.rowDelimiter = rowDelimiter;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
    }

    public Integer getHeader() {
        return this.header;
    }

    public void setHeader(Integer header) {
        this.header = header;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public void setSkip(Integer skip) {
        this.skip = skip;
    }

    public Expression getFile() {
        return this.file;
    }

    public void setFile(Expression file) {
        this.file = file;
    }

    public boolean isUsingRowDelimiter() {
        return this.usingRowDelimiter;
    }

    public void setUsingRowDelimiter(boolean usingRowDelimiter) {
        this.usingRowDelimiter = usingRowDelimiter;
    }

    public void setNoTrim() {
        for (TextColumn col : this.columns) {
            col.noTrim = true;
        }
    }

    public boolean isNoTrim() {
        for (TextColumn col : this.columns) {
            if (col.noTrim) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected TextTable cloneDirect() {
        TextTable clone = new TextTable();
        this.copy(clone);
        clone.setDelimiter(this.delimiter);
        clone.setFile((Expression)this.file.clone());
        clone.setHeader(this.header);
        clone.setSkip(this.skip);
        clone.setQuote(this.quote);
        clone.escape = this.escape;
        for (TextColumn column : this.columns) {
            clone.getColumns().add(column.clone());
        }
        clone.fixedWidth = this.fixedWidth;
        clone.usingRowDelimiter = this.usingRowDelimiter;
        clone.rowDelimiter = this.rowDelimiter;
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof TextTable)) {
            return false;
        }
        TextTable other = (TextTable)obj;
        return this.columns.equals(other.columns) && EquivalenceUtil.areEqual((Object)this.file, (Object)other.file) && EquivalenceUtil.areEqual((Object)this.delimiter, (Object)other.delimiter) && EquivalenceUtil.areEqual((Object)this.escape, (Object)other.escape) && EquivalenceUtil.areEqual((Object)this.quote, (Object)other.quote) && EquivalenceUtil.areEqual((Object)this.header, (Object)other.header) && EquivalenceUtil.areEqual((Object)this.skip, (Object)other.skip) && this.usingRowDelimiter == other.usingRowDelimiter && EquivalenceUtil.areEqual((Object)this.rowDelimiter, (Object)other.rowDelimiter);
    }

    public static class TextColumn
    extends TableFunctionReference.ProjectedColumn {
        private Integer width;
        private boolean noTrim;
        private String selector;
        private Integer position;
        private boolean ordinal;
        private String header;

        public TextColumn(String name) {
            super(name, "integer");
            this.ordinal = true;
        }

        public TextColumn(String name, String type, Integer width, boolean noTrim) {
            super(name, type);
            this.width = width;
            this.noTrim = noTrim;
        }

        protected TextColumn() {
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public boolean isNoTrim() {
            return this.noTrim;
        }

        public void setNoTrim(boolean noTrim) {
            this.noTrim = noTrim;
        }

        public String getHeader() {
            return this.header;
        }

        public void setHeader(String header) {
            this.header = header;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj) || !(obj instanceof TextColumn)) {
                return false;
            }
            TextColumn other = (TextColumn)obj;
            return EquivalenceUtil.areEqual((Object)this.width, (Object)other.width) && EquivalenceUtil.areEqual((Object)this.selector, (Object)other.selector) && EquivalenceUtil.areEqual((Object)this.position, (Object)other.position) && this.noTrim == other.noTrim && this.ordinal == other.ordinal && EquivalenceUtil.areEqual((Object)this.header, (Object)other.header);
        }

        public TextColumn clone() {
            TextColumn clone = new TextColumn();
            clone.width = this.width;
            clone.noTrim = this.noTrim;
            clone.selector = this.selector;
            clone.position = this.position;
            clone.ordinal = this.ordinal;
            clone.header = this.header;
            this.copyTo(clone);
            return clone;
        }

        public String getSelector() {
            return this.selector;
        }

        public void setSelector(String selector) {
            this.selector = selector;
        }

        public Integer getPosition() {
            return this.position;
        }

        public void setPosition(Integer position) {
            this.position = position;
        }

        public boolean isOrdinal() {
            return this.ordinal;
        }
    }
}

