/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.security.Credentials;
import org.teiid.security.GSSResult;
import org.teiid.security.SecurityHelper;

public class TestDQPWorkContext {
    public static DQPWorkContext example() {
        DQPWorkContext message = new DQPWorkContext();
        message.getSession().setVDBName("vdbName");
        message.getSession().setVDBVersion(1);
        message.getSession().setApplicationName("querybuilder");
        message.getSession().setSessionId(String.valueOf(5));
        message.getSession().setUserName("userName");
        return message;
    }

    @Test
    public void testSerialize() throws Exception {
        DQPWorkContext copy = (DQPWorkContext)UnitTestUtil.helpSerialize((Serializable)TestDQPWorkContext.example());
        Assert.assertEquals((Object)"5", (Object)copy.getSessionId());
        Assert.assertEquals((Object)"userName", (Object)copy.getUserName());
        Assert.assertEquals((Object)"vdbName", (Object)copy.getVdbName());
        Assert.assertEquals((long)1L, (long)copy.getVdbVersion());
        Assert.assertEquals((Object)"querybuilder", (Object)copy.getAppName());
    }

    @Test
    public void testClearPolicies() {
        DQPWorkContext message = new DQPWorkContext();
        message.setSession((SessionMetadata)Mockito.mock(SessionMetadata.class));
        Mockito.stub((Object)message.getSession().getVdb()).toReturn((Object)new VDBMetaData());
        HashMap map = message.getAllowedDataPolicies();
        map.put("role", Mockito.mock(DataPolicy.class));
        Assert.assertFalse((boolean)map.isEmpty());
        message.setSession((SessionMetadata)Mockito.mock(SessionMetadata.class));
        Mockito.stub((Object)message.getSession().getVdb()).toReturn((Object)new VDBMetaData());
        map = message.getAllowedDataPolicies();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testAnyAuthenticated() {
        DQPWorkContext message = new DQPWorkContext();
        message.setSession((SessionMetadata)Mockito.mock(SessionMetadata.class));
        VDBMetaData vdb = new VDBMetaData();
        DataPolicyMetadata dpm = new DataPolicyMetadata();
        dpm.setAnyAuthenticated(true);
        vdb.addDataPolicy(dpm);
        Mockito.stub((Object)message.getSession().getVdb()).toReturn((Object)vdb);
        HashMap map = message.getAllowedDataPolicies();
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testRestoreSecurityContext() {
        final SecurityHelper sc = new SecurityHelper(){
            Object mycontext = null;

            public Object getSecurityContext() {
                return this.mycontext;
            }

            public void clearSecurityContext() {
                this.mycontext = null;
            }

            public Object associateSecurityContext(Object context) {
                Object old = this.mycontext;
                this.mycontext = context;
                return old;
            }

            public Subject getSubjectInContext(String securityDomain) {
                return null;
            }

            public Object authenticate(String securityDomain, String baseUserName, Credentials credentials, String applicationName) throws LoginException {
                return null;
            }

            public GSSResult negotiateGssLogin(String securityDomain, byte[] serviceTicket) throws LoginException {
                return null;
            }
        };
        String previousSC = "testSC";
        sc.associateSecurityContext((Object)previousSC);
        DQPWorkContext message = new DQPWorkContext(){

            public Subject getSubject() {
                return new Subject();
            }
        };
        message.setSecurityHelper(sc);
        message.setSession((SessionMetadata)Mockito.mock(SessionMetadata.class));
        String currentSC = "teiid-security-context";
        Mockito.stub((Object)message.getSession().getSecurityContext()).toReturn((Object)"teiid-security-context");
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((Object)"teiid-security-context", (Object)sc.getSecurityContext());
            }
        };
        message.runInContext(r);
        Assert.assertEquals((Object)previousSC, (Object)sc.getSecurityContext());
    }
}

