/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.eval;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.sql.lang.CollectionValueIterator;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.ValueIterator;
import org.teiid.query.util.CommandContext;

public class TestCriteriaEvaluator {
    private void helpTestMatch(String value, String pattern, char escape, boolean negated, boolean expectedMatch) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        MatchCriteria crit = new MatchCriteria((Expression)new Constant((Object)value), (Expression)new Constant((Object)pattern), escape);
        crit.setNegated(negated);
        boolean actualMatch = Evaluator.evaluate((Criteria)crit);
        Assert.assertEquals((String)("Match criteria test failed for value=[" + value + "], pattern=[" + pattern + "], hasEscape=" + (escape != '\u0000') + ": "), (Object)expectedMatch, (Object)actualMatch);
    }

    private void helpTestMatch(String value, String pattern, char escape, boolean expectedMatch) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        this.helpTestMatch(value, pattern, escape, false, expectedMatch);
    }

    private void helpTestIsNull(String value, boolean negated, boolean expectedMatch) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        IsNullCriteria criteria = new IsNullCriteria((Expression)new Constant((Object)value));
        criteria.setNegated(negated);
        boolean result = Evaluator.evaluate((Criteria)criteria);
        Assert.assertEquals((String)"Result did not match expected value", (Object)expectedMatch, (Object)result);
    }

    private void helpTestSetCriteria(int value, boolean negated, boolean expectedMatch) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        this.helpTestSetCriteria(new Integer(value), negated, expectedMatch);
    }

    private void helpTestSetCriteria(Integer value, boolean negated, boolean expectedMatch) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        ArrayList<Constant> constants = new ArrayList<Constant>(2);
        constants.add(new Constant((Object)new Integer(1000)));
        constants.add(new Constant((Object)new Integer(5000)));
        SetCriteria crit = new SetCriteria((Expression)new Constant((Object)value), constants);
        crit.setNegated(negated);
        boolean result = Evaluator.evaluate((Criteria)crit);
        Assert.assertEquals((String)"Result did not match expected value", (Object)expectedMatch, (Object)result);
    }

    private void helpTestCompareSubqueryCriteria(Criteria crit, Boolean expectedResult, final Collection<Object> values) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        HashMap<ElementSymbol, Integer> elementMap = new HashMap<ElementSymbol, Integer>();
        ElementSymbol e1 = new ElementSymbol("e1");
        elementMap.put(e1, new Integer(0));
        List<String> tuple = Arrays.asList("a");
        CommandContext cc = new CommandContext();
        Assert.assertEquals((Object)expectedResult, (Object)new Evaluator(elementMap, null, cc){

            protected ValueIterator evaluateSubquery(SubqueryContainer container, List tuple) throws TeiidProcessingException, BlockedException, TeiidComponentException {
                return new CollectionValueIterator(values);
            }
        }.evaluateTVL(crit, tuple));
    }

    private SubqueryCompareCriteria helpGetCompareSubqueryCriteria(int operator, int predicateQuantifier) {
        ElementSymbol e1 = new ElementSymbol("e1");
        SubqueryCompareCriteria crit = new SubqueryCompareCriteria((Expression)e1, (QueryCommand)new Query(), operator, predicateQuantifier);
        return crit;
    }

    @Test
    public void testIsNull1() throws Exception {
        this.helpTestIsNull(null, false, true);
    }

    @Test
    public void testIsNull2() throws Exception {
        this.helpTestIsNull(null, true, false);
    }

    @Test
    public void testIsNull3() throws Exception {
        this.helpTestIsNull("x", false, false);
    }

    @Test
    public void testIsNull4() throws Exception {
        this.helpTestIsNull("x", true, true);
    }

    @Test
    public void testMatch1() throws Exception {
        this.helpTestMatch("", "", '\u0000', true);
    }

    @Test
    public void testMatch2() throws Exception {
        this.helpTestMatch("x", "", '\u0000', false);
    }

    @Test
    public void testMatch3() throws Exception {
        this.helpTestMatch("", "%", '\u0000', true);
    }

    @Test
    public void testMatch4() throws Exception {
        this.helpTestMatch("x", "%", '\u0000', true);
    }

    @Test
    public void testMatch5() throws Exception {
        this.helpTestMatch("xx", "%", '\u0000', true);
    }

    @Test
    public void testMatch7() throws Exception {
        this.helpTestMatch("a", "a%", '\u0000', true);
    }

    @Test
    public void testMatch8() throws Exception {
        this.helpTestMatch("ab", "a%", '\u0000', true);
    }

    @Test
    public void testMatch9() throws Exception {
        this.helpTestMatch("a.", "a%", '\u0000', true);
    }

    @Test
    public void testMatch11() throws Exception {
        this.helpTestMatch("ax.", "a%", '\u0000', true);
    }

    @Test
    public void testMatch12() throws Exception {
        this.helpTestMatch("a..", "a%", '\u0000', true);
    }

    @Test
    public void testMatch13() throws Exception {
        this.helpTestMatch("a.b", "a%.", '\u0000', false);
    }

    @Test
    public void testMatch14() throws Exception {
        this.helpTestMatch("aaa", "%aaa", '\u0000', true);
    }

    @Test
    public void testMatch15() throws Exception {
        this.helpTestMatch("baaa", "%aaa", '\u0000', true);
    }

    @Test
    public void testMatch16() throws Exception {
        this.helpTestMatch("aaaa", "%aaa", '\u0000', true);
    }

    @Test
    public void testMatch17() throws Exception {
        this.helpTestMatch("aaxaa", "%aaa", '\u0000', false);
    }

    @Test
    public void testMatch18() throws Exception {
        this.helpTestMatch("", "a%b%", '\u0000', false);
    }

    @Test
    public void testMatch19() throws Exception {
        this.helpTestMatch("a", "a%b%", '\u0000', false);
    }

    @Test
    public void testMatch20() throws Exception {
        this.helpTestMatch("ab", "a%b%", '\u0000', true);
    }

    @Test
    public void testMatch21() throws Exception {
        this.helpTestMatch("axb", "a%b%", '\u0000', true);
    }

    @Test
    public void testMatch22() throws Exception {
        this.helpTestMatch("abx", "a%b%", '\u0000', true);
    }

    @Test
    public void testMatch23() throws Exception {
        this.helpTestMatch("", "X%", 'X', false);
    }

    @Test
    public void testMatch24() throws Exception {
        this.helpTestMatch("x", "X%", 'X', false);
    }

    @Test
    public void testMatch25() throws Exception {
        this.helpTestMatch("xx", "X%", 'X', false);
    }

    @Test
    public void testMatch26() throws Exception {
        this.helpTestMatch("a%", "aX%", 'X', true);
    }

    @Test
    public void testMatch27() throws Exception {
        this.helpTestMatch("aX%", "aX%", 'X', false);
    }

    @Test
    public void testMatch28() throws Exception {
        this.helpTestMatch("a%bb", "aX%b%", 'X', true);
    }

    @Test
    public void testMatch29() throws Exception {
        this.helpTestMatch("aX%bb", "aX%b%", 'X', false);
    }

    @Test
    public void testMatch30() throws Exception {
        this.helpTestMatch("", "_", '\u0000', false);
    }

    @Test
    public void testMatch31() throws Exception {
        this.helpTestMatch("X", "_", '\u0000', true);
    }

    @Test
    public void testMatch32() throws Exception {
        this.helpTestMatch("XX", "_", '\u0000', false);
    }

    @Test
    public void testMatch33() throws Exception {
        this.helpTestMatch("", "__", '\u0000', false);
    }

    @Test
    public void testMatch34() throws Exception {
        this.helpTestMatch("X", "__", '\u0000', false);
    }

    @Test
    public void testMatch35() throws Exception {
        this.helpTestMatch("XX", "__", '\u0000', true);
    }

    @Test
    public void testMatch36() throws Exception {
        this.helpTestMatch("XX", "_%_", '\u0000', true);
    }

    @Test
    public void testMatch37() throws Exception {
        this.helpTestMatch("XaaY", "_%_", '\u0000', true);
    }

    @Test
    public void testMatch38() throws Exception {
        this.helpTestMatch("a.b.c", "a.b.c", '\u0000', true);
    }

    @Test
    public void testMatch39() throws Exception {
        this.helpTestMatch("a.b.c", "a%.c", '\u0000', true);
    }

    @Test
    public void testMatch40() throws Exception {
        this.helpTestMatch("a.b.", "a.b.", '\u0000', true);
    }

    @Test
    public void testMatch41() throws Exception {
        this.helpTestMatch("asjdfajsdf (&). asdfasdf\nkjhkjh", "%&%", '\u0000', true);
    }

    @Test
    public void testMatch42() throws Exception {
        this.helpTestMatch("x", "", '\u0000', true, true);
    }

    @Test
    public void testMatch43() throws Exception {
        this.helpTestMatch("a.b.", "a.b.", '\u0000', true, false);
    }

    @Test
    public void testMatch44() throws Exception {
        this.helpTestMatch(null, "a.b.", '\u0000', false);
    }

    @Test
    public void testMatch45() throws Exception {
        this.helpTestMatch("a.b.", null, '\u0000', false);
    }

    @Test
    public void testMatch46() throws Exception {
        this.helpTestMatch("ab\r\n", "ab%", '\u0000', true);
    }

    @Test
    public void testMatch47() throws Exception {
        this.helpTestMatch("", "", 'a', true);
    }

    @Test
    public void testMatch48() throws Exception {
        this.helpTestMatch("abc", "aa%", 'a', true);
    }

    @Test
    public void testMatch49() throws Exception {
        try {
            this.helpTestMatch("abc", "a", 'a', true);
        }
        catch (ExpressionEvaluationException cee) {
            Assert.assertEquals((Object)"TEIID30449 Invalid escape sequence \"a\" with escape character \"a\"", (Object)cee.getMessage());
        }
    }

    @Test
    public void testMatch50() throws Exception {
        try {
            this.helpTestMatch("abc", "ab", 'a', true);
        }
        catch (ExpressionEvaluationException cee) {
            Assert.assertEquals((Object)"TEIID30449 Invalid escape sequence \"ab\" with escape character \"a\"", (Object)cee.getMessage());
        }
    }

    @Test
    public void testMatch51() throws Exception {
        this.helpTestMatch("$", "$$", '$', true);
    }

    @Test
    public void testMatch52() throws Exception {
        this.helpTestMatch("abc\nde", "a%e", '\u0000', true);
    }

    @Test
    public void testMatch53() throws Exception {
        this.helpTestMatch("\\", "\\%", '\u0000', true);
    }

    @Test
    public void testSetCriteria1() throws Exception {
        this.helpTestSetCriteria(1000, false, true);
    }

    @Test
    public void testSetCriteria2() throws Exception {
        this.helpTestSetCriteria(1, false, false);
    }

    @Test
    public void testSetCriteria3() throws Exception {
        this.helpTestSetCriteria(1000, true, false);
    }

    @Test
    public void testSetCriteria4() throws Exception {
        this.helpTestSetCriteria(1, true, true);
    }

    @Test
    public void testSetCriteria5() throws Exception {
        this.helpTestSetCriteria(null, true, false);
    }

    @Test
    public void testSetCriteria6() throws Exception {
        this.helpTestSetCriteria(null, false, false);
    }

    @Test
    public void testExistsCriteria() throws Exception {
        ExistsCriteria crit = new ExistsCriteria((QueryCommand)new Query());
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("a");
        values.add("b");
        values.add("c");
        this.helpTestCompareSubqueryCriteria((Criteria)crit, true, values);
    }

    @Test
    public void testExistsCriteria2() throws Exception {
        ExistsCriteria crit = new ExistsCriteria((QueryCommand)new Query());
        this.helpTestCompareSubqueryCriteria((Criteria)crit, false, Collections.<Object>emptyList());
    }

    @Test
    public void testExistsCriteria3() throws Exception {
        ExistsCriteria crit = new ExistsCriteria((QueryCommand)new Query());
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(null);
        values.add(null);
        values.add(null);
        this.helpTestCompareSubqueryCriteria((Criteria)crit, true, values);
    }

    @Test
    public void testCompareSubqueryCriteriaNoRows() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(1, 4);
        this.helpTestCompareSubqueryCriteria((Criteria)crit, true, Collections.<Object>emptyList());
    }

    @Test
    public void testCompareSubqueryCriteriaNoRows1() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(1, 3);
        crit.setLeftExpression((Expression)new Constant(null));
        crit.negate();
        this.helpTestCompareSubqueryCriteria((Criteria)crit, true, Collections.<Object>emptyList());
    }

    @Test
    public void testCompareSubqueryCriteriaNoRows2() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(1, 2);
        this.helpTestCompareSubqueryCriteria((Criteria)crit, false, Collections.<Object>emptyList());
    }

    @Test
    public void testCompareSubqueryCriteria2() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(1, 4);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("a");
        values.add("b");
        values.add("c");
        this.helpTestCompareSubqueryCriteria((Criteria)crit, false, values);
    }

    @Test
    public void testCompareSubqueryCriteria3() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(1, 2);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("a");
        values.add("b");
        values.add("c");
        this.helpTestCompareSubqueryCriteria((Criteria)crit, true, values);
    }

    @Test
    public void testCompareSubqueryCriteria4() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(1, 2);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("b");
        values.add("c");
        this.helpTestCompareSubqueryCriteria((Criteria)crit, false, values);
    }

    @Test
    public void testCompareSubqueryCriteria5() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(1, 2);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("a");
        values.add("b");
        values.add("c");
        this.helpTestCompareSubqueryCriteria((Criteria)crit, true, values);
    }

    @Test
    public void testCompareSubqueryCriteriaNulls3() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(1, 4);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(null);
        values.add(null);
        this.helpTestCompareSubqueryCriteria((Criteria)crit, null, values);
    }

    @Test
    public void testCompareSubqueryCriteriaNulls4() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(1, 2);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(null);
        values.add(null);
        this.helpTestCompareSubqueryCriteria((Criteria)crit, null, values);
    }

    @Test
    public void testCompareSubqueryCriteriaNulls5() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(1, 2);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(null);
        values.add("a");
        values.add(null);
        this.helpTestCompareSubqueryCriteria((Criteria)crit, true, values);
    }

    @Test
    public void testCompareSubqueryCriteriaNulls6() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(1, 2);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("a");
        values.add(null);
        values.add("a");
        this.helpTestCompareSubqueryCriteria((Criteria)crit, true, values);
    }

    @Test
    public void testCompareSubqueryCriteriaNulls7() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(3, 4);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(null);
        values.add(null);
        this.helpTestCompareSubqueryCriteria((Criteria)crit, null, values);
    }

    @Test
    public void testCompareSubqueryCriteriaNulls8() throws Exception {
        SubqueryCompareCriteria crit = this.helpGetCompareSubqueryCriteria(4, 4);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(null);
        values.add(null);
        this.helpTestCompareSubqueryCriteria((Criteria)crit, null, values);
    }

    @Test
    public void testBigDecimalEquality() throws Exception {
        CompareCriteria crit = new CompareCriteria((Expression)new Constant((Object)new BigDecimal("3.10")), 1, (Expression)new Constant((Object)new BigDecimal("3.1")));
        Assert.assertTrue((boolean)Evaluator.evaluate((Criteria)crit));
    }
}

