/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class ProjectIntoNode
extends RelationalNode {
    private static int REQUEST_CREATION = 1;
    private static int RESPONSE_PROCESSING = 2;
    private GroupSymbol intoGroup;
    private List intoElements;
    private String modelName;
    private Mode mode;
    private int batchRow = 1;
    private int insertCount = 0;
    private int phase = REQUEST_CREATION;
    private int requestsRegistered = 0;
    private int tupleSourcesProcessed = 0;
    private boolean sourceDone;
    private TupleBuffer buffer;
    private TupleBuffer last;
    private TupleBatch currentBatch;
    private TupleSource tupleSource;
    private Criteria constraint;
    private Evaluator eval;

    protected ProjectIntoNode() {
    }

    public ProjectIntoNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.phase = REQUEST_CREATION;
        this.batchRow = 1;
        this.insertCount = 0;
        this.tupleSourcesProcessed = 0;
        this.requestsRegistered = 0;
        this.currentBatch = null;
        this.sourceDone = false;
    }

    public void setIntoGroup(GroupSymbol group) {
        this.intoGroup = group;
    }

    public void setIntoElements(List intoElements) {
        this.intoElements = intoElements;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        block7: while (this.phase == REQUEST_CREATION) {
            if (this.currentBatch == null) {
                if (this.sourceDone) {
                    this.phase = RESPONSE_PROCESSING;
                    break;
                }
                this.currentBatch = this.getChildren()[0].nextBatch();
                this.sourceDone = this.currentBatch.getTerminationFlag();
                this.batchRow = this.currentBatch.getBeginRow();
                if (!(this.currentBatch.getRowCount() != 0 || this.currentBatch.getTerminationFlag() && this.mode == Mode.ITERATOR)) {
                    this.currentBatch = null;
                    continue;
                }
                if (this.constraint != null) {
                    if (this.eval == null) {
                        this.eval = new Evaluator(ProjectIntoNode.createLookupMap(this.intoElements), this.getDataManager(), this.getContext());
                    }
                    List<List<?>> tuples = this.currentBatch.getTuples();
                    for (int i = 0; i < tuples.size(); ++i) {
                        if (this.eval.evaluate(this.constraint, tuples.get(i))) continue;
                        throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31130, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31130, new Object[]{new Insert(this.intoGroup, this.intoElements, this.convertValuesToConstants(tuples.get(i), this.intoElements))}));
                    }
                }
            }
            if (this.mode != Mode.ITERATOR) {
                this.checkExitConditions();
            }
            int batchSize = this.currentBatch.getRowCount();
            int requests = 1;
            switch (this.mode) {
                case ITERATOR: {
                    if (this.buffer == null) {
                        this.buffer = this.getBufferManager().createTupleBuffer(this.intoElements, this.getConnectionID(), BufferManager.TupleSourceType.PROCESSOR);
                    }
                    if (this.sourceDone) {
                        this.checkExitConditions();
                    }
                    for (List<?> tuple : this.currentBatch.getTuples()) {
                        this.buffer.addTuple(tuple);
                    }
                    try {
                        this.checkExitConditions();
                    }
                    catch (BlockedException e) {
                        this.batchRow += batchSize;
                        this.currentBatch = null;
                        continue block7;
                    }
                    if (this.currentBatch.getTerminationFlag() && (this.buffer.getRowCount() != 0 || this.intoGroup.isImplicitTempGroupSymbol())) {
                        this.registerIteratorRequest();
                        break;
                    }
                    if (this.buffer.getRowCount() >= this.buffer.getBatchSize() * 4 && this.getContext().getTransactionContext() != null && (this.getContext().getTransactionContext().getTransaction() != null || this.getContext().getTransactionContext().isNoTxn())) {
                        this.registerIteratorRequest();
                        break;
                    }
                    requests = 0;
                    break;
                }
                case BATCH: {
                    int endRow = this.currentBatch.getEndRow();
                    ArrayList<Insert> rows = new ArrayList<Insert>(endRow - this.batchRow);
                    for (int rowNum = this.batchRow; rowNum <= endRow; ++rowNum) {
                        Insert insert = new Insert(this.intoGroup, this.intoElements, this.convertValuesToConstants(this.currentBatch.getTuple(rowNum), this.intoElements));
                        rows.add(insert);
                    }
                    this.registerRequest(new BatchedUpdateCommand(rows));
                    break;
                }
                case SINGLE: {
                    batchSize = 1;
                    this.registerRequest(new Insert(this.intoGroup, this.intoElements, this.convertValuesToConstants(this.currentBatch.getTuple(this.batchRow), this.intoElements)));
                }
            }
            this.batchRow += batchSize;
            if (this.batchRow > this.currentBatch.getEndRow()) {
                this.currentBatch = null;
            }
            this.requestsRegistered += requests;
        }
        this.checkExitConditions();
        if (this.buffer != null) {
            this.buffer.remove();
            this.buffer = null;
        }
        this.addBatchRow(Arrays.asList(this.insertCount));
        this.terminateBatches();
        return this.pullBatch();
    }

    private void registerIteratorRequest() throws TeiidComponentException, TeiidProcessingException {
        Insert insert = new Insert(this.intoGroup, this.intoElements, null);
        this.buffer.close();
        insert.setTupleSource(this.buffer.createIndexedTupleSource(true));
        this.registerRequest(insert);
        this.last = this.buffer;
        this.buffer = null;
    }

    private void checkExitConditions() throws TeiidComponentException, BlockedException, TeiidProcessingException {
        if (this.tupleSource != null) {
            if (this.mode == Mode.BATCH || this.mode == Mode.ITERATOR) {
                List<?> tuple = null;
                while ((tuple = this.tupleSource.nextTuple()) != null) {
                    Integer count = (Integer)tuple.get(0);
                    if (count <= 0 && count != -2) continue;
                    ++this.insertCount;
                }
            } else {
                Integer count = (Integer)this.tupleSource.nextTuple().get(0);
                this.insertCount += count.intValue();
            }
            this.closeRequest();
            ++this.tupleSourcesProcessed;
        }
        if (this.tupleSourcesProcessed < this.requestsRegistered) {
            throw BlockedException.block(this.getContext().getRequestId(), "Blocking on insert update count");
        }
    }

    private void registerRequest(Command command) throws TeiidComponentException, TeiidProcessingException {
        this.tupleSource = this.getDataManager().registerRequest(this.getContext(), command, this.modelName, new RegisterRequestParameter(null, this.getID(), -1));
    }

    private void closeRequest() {
        if (this.last != null) {
            this.last.remove();
            this.last = null;
        }
        if (this.tupleSource != null) {
            this.tupleSource.closeSource();
            this.tupleSource = null;
        }
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.intoGroup);
    }

    @Override
    public Object clone() {
        ProjectIntoNode clonedNode = new ProjectIntoNode();
        super.copyTo(clonedNode);
        clonedNode.intoGroup = this.intoGroup;
        clonedNode.intoElements = this.intoElements;
        clonedNode.modelName = this.modelName;
        clonedNode.mode = this.mode;
        clonedNode.constraint = this.constraint;
        return clonedNode;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        props.addProperty("Into Target", this.intoGroup.toString());
        ArrayList<String> selectCols = new ArrayList<String>(this.intoElements.size());
        for (int i = 0; i < this.intoElements.size(); ++i) {
            selectCols.add(this.intoElements.get(i).toString());
        }
        props.addProperty("Select Columns", selectCols);
        return props;
    }

    private List<Constant> convertValuesToConstants(List<?> values, List<ElementSymbol> elements) {
        ArrayList<Constant> constants = new ArrayList<Constant>(values.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol es = elements.get(i);
            Class<?> type = es.getType();
            constants.add(new Constant(values.get(i), type));
        }
        return constants;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public boolean isTempGroupInsert() {
        return this.intoGroup.isTempGroupSymbol();
    }

    @Override
    public void closeDirect() {
        if (this.buffer != null) {
            this.buffer.remove();
            this.buffer = null;
        }
        this.closeRequest();
    }

    public String getModelName() {
        return this.modelName;
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        if (this.getMode() != Mode.ITERATOR) {
            return true;
        }
        return null;
    }

    public void setConstraint(Criteria constraint) {
        this.constraint = constraint;
    }

    public static enum Mode {
        BATCH,
        ITERATOR,
        SINGLE;

    }
}

