/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.RequestID;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.ReplicatedObject;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.TempTable;
import org.teiid.query.tempdata.TempTableStore;

public class GlobalTableStoreImpl
implements GlobalTableStore,
ReplicatedObject<String> {
    private static final String TEIID_FBI = "teiid:fbi";
    private ConcurrentHashMap<String, MatTableInfo> matTables = new ConcurrentHashMap();
    private TempTableStore tableStore = new TempTableStore("SYSTEM", TempTableStore.TransactionMode.ISOLATE_READS);
    private BufferManager bufferManager;
    private QueryMetadataInterface metadata;
    private Serializable localAddress;
    private VDBMetaData vdbMetaData;

    public GlobalTableStoreImpl(BufferManager bufferManager, VDBMetaData vdbMetaData, QueryMetadataInterface metadata) {
        this.bufferManager = bufferManager;
        this.vdbMetaData = vdbMetaData;
        this.metadata = new TempMetadataAdapter(metadata, new TempMetadataStore());
    }

    @Override
    public synchronized MatTableInfo getMatTableInfo(String tableName) {
        MatTableInfo info = this.matTables.get(tableName);
        if (info == null) {
            info = new MatTableInfo();
            this.matTables.put(tableName, info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failedLoad(String matTableName) {
        MatTableInfo info;
        MatTableInfo matTableInfo = info = this.getMatTableInfo(matTableName);
        synchronized (matTableInfo) {
            if (info.state != MatState.LOADED) {
                info.setState(MatState.FAILED_LOAD, null);
            }
        }
    }

    @Override
    public boolean needsLoading(String matTableName, Serializable loadingAddress, boolean firstPass, boolean refresh, boolean invalidate) {
        MatTableInfo info = this.getMatTableInfo(matTableName);
        return info.shouldLoad(loadingAddress, firstPass, refresh, invalidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TempMetadataID getGlobalTempTableMetadataId(Object viewId) throws TeiidProcessingException, TeiidComponentException {
        String matViewName = this.metadata.getFullName(viewId);
        String matTableName = "#MAT_" + matViewName.toUpperCase();
        GroupSymbol group = new GroupSymbol(matViewName);
        group.setMetadataID(viewId);
        TempMetadataID id = this.tableStore.getMetadataStore().getTempGroupID(matTableName);
        if (id == null) {
            Object object = viewId;
            synchronized (object) {
                id = this.tableStore.getMetadataStore().getTempGroupID(matTableName);
                LinkedHashMap<Expression, Integer> newExprs = null;
                if (id == null) {
                    Table t;
                    List fbis;
                    List<ElementSymbol> allCols = ResolverUtil.resolveElementsInGroup(group, this.metadata);
                    QueryNode qnode = this.metadata.getVirtualPlan(viewId);
                    if (viewId instanceof Table && !(fbis = (t = (Table)viewId).getFunctionBasedIndexes()).isEmpty()) {
                        List<GroupSymbol> groups = Arrays.asList(group);
                        int i = 0;
                        newExprs = new LinkedHashMap<Expression, Integer>();
                        for (KeyRecord keyRecord : fbis) {
                            for (int j = 0; j < keyRecord.getColumns().size(); ++j) {
                                Column c = (Column)keyRecord.getColumns().get(j);
                                if (c.getParent() != keyRecord) continue;
                                String exprString = c.getNameInSource();
                                Expression ex = QueryParser.getQueryParser().parseExpression(exprString);
                                Integer index = (Integer)newExprs.get(ex);
                                if (index == null) {
                                    ResolverVisitor.resolveLanguageObject(ex, (Collection<GroupSymbol>)groups, this.metadata);
                                    ex = QueryRewriter.rewriteExpression(ex, null, this.metadata);
                                    String colName = TEIID_FBI + i;
                                    while (t.getColumnByName(colName) != null) {
                                        colName = TEIID_FBI + ++i;
                                    }
                                    ElementSymbol es = new ElementSymbol(colName);
                                    es.setType(ex.getType());
                                    allCols.add(es);
                                    c.setPosition(allCols.size());
                                    newExprs.put(ex, allCols.size());
                                    ex = (Expression)ex.clone();
                                    continue;
                                }
                                c.setPosition(index.intValue());
                            }
                        }
                        ResolverUtil.clearGroupInfo(group, this.metadata);
                        StringBuilder query = new StringBuilder("SELECT ");
                        query.append(group).append(".*, ");
                        Iterator<Object> iter = newExprs.keySet().iterator();
                        while (iter.hasNext()) {
                            query.append(iter.next());
                            if (!iter.hasNext()) continue;
                            query.append(", ");
                        }
                        query.append(" FROM ").append(group).append(" option nocache ").append(group);
                        qnode = new QueryNode(query.toString());
                    }
                    id = this.tableStore.getMetadataStore().addTempGroup(matTableName, allCols, false, true);
                    id.setQueryNode(qnode);
                    id.setCardinality((int)this.metadata.getCardinality(viewId));
                    id.setOriginalMetadataID(viewId);
                    Object pk = this.metadata.getPrimaryKey(viewId);
                    if (pk != null) {
                        ArrayList<TempMetadataID> primaryKey = GlobalTableStoreImpl.resolveIndex(this.metadata, id, pk);
                        id.setPrimaryKey(primaryKey);
                    }
                    Collection keys = this.metadata.getUniqueKeysInGroup(viewId);
                    for (Object key : keys) {
                        id.addUniqueKey(GlobalTableStoreImpl.resolveIndex(this.metadata, id, key));
                    }
                    Collection indexes = this.metadata.getIndexesInGroup(viewId);
                    for (Object index : indexes) {
                        id.addIndex(index, GlobalTableStoreImpl.resolveIndex(this.metadata, id, index));
                    }
                    if (newExprs != null) {
                        Table table = (Table)viewId;
                        List fbis2 = table.getFunctionBasedIndexes();
                        for (KeyRecord keyRecord : fbis2) {
                            id.addIndex(keyRecord, GlobalTableStoreImpl.resolveIndex(this.metadata, id, (Object)keyRecord));
                        }
                        GroupSymbol gs = new GroupSymbol(matTableName);
                        gs.setMetadataID(id);
                        SymbolMap map = SymbolMap.createSymbolMap(group, ResolverUtil.resolveElementsInGroup(gs, this.metadata).subList(0, allCols.size() - newExprs.size()), this.metadata);
                        LinkedHashMap<Expression, Integer> mappedExprs = new LinkedHashMap<Expression, Integer>();
                        for (Map.Entry entry : newExprs.entrySet()) {
                            Expression ex = (Expression)((Expression)entry.getKey()).clone();
                            ExpressionMappingVisitor.mapExpressions(ex, map.asMap());
                            mappedExprs.put(ex, (Integer)entry.getValue());
                        }
                        id.getTableData().setFunctionBasedExpressions(mappedExprs);
                    }
                }
            }
        }
        this.updateCacheHint(viewId, group, id);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TempMetadataID getCodeTableMetadataId(String codeTableName, String returnElementName, String keyElementName, String matTableName) throws TeiidComponentException, QueryMetadataException {
        ElementSymbol keyElement = new ElementSymbol(matTableName + "." + keyElementName);
        ElementSymbol returnElement = new ElementSymbol(matTableName + "." + returnElementName);
        keyElement.setType(DataTypeManager.getDataTypeClass((String)this.metadata.getElementType(this.metadata.getElementID(codeTableName + "." + keyElementName))));
        returnElement.setType(DataTypeManager.getDataTypeClass((String)this.metadata.getElementType(this.metadata.getElementID(codeTableName + "." + returnElementName))));
        TempMetadataID id = this.tableStore.getMetadataStore().getTempGroupID(matTableName);
        if (id == null) {
            GlobalTableStoreImpl globalTableStoreImpl = this;
            synchronized (globalTableStoreImpl) {
                id = this.tableStore.getMetadataStore().addTempGroup(matTableName, Arrays.asList(keyElement, returnElement), false, true);
                String queryString = "SELECT " + keyElementName + " ," + returnElementName + ' ' + "FROM" + ' ' + codeTableName;
                id.setQueryNode(new QueryNode(queryString));
                id.setPrimaryKey(id.getElements().subList(0, 1));
                CacheHint hint = new CacheHint(true, null);
                id.setCacheHint(hint);
            }
        }
        return id;
    }

    private void updateCacheHint(Object viewId, GroupSymbol group, TempMetadataID id) throws TeiidComponentException, QueryMetadataException, QueryResolverException, QueryValidatorException {
        String scope;
        String updatableString;
        if (id.getCacheHint() != null && !id.getTableData().updateCacheHint(((Table)viewId).getLastModified())) {
            return;
        }
        Command c = QueryResolver.resolveView(group, this.metadata.getVirtualPlan(viewId), "SELECT", this.metadata).getCommand();
        CacheHint hint = c.getCacheHint();
        hint = hint != null ? hint.clone() : new CacheHint();
        String ttlString = this.metadata.getExtensionProperty(viewId, "{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL", false);
        if (Boolean.valueOf(this.metadata.getExtensionProperty(viewId, "{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT", false)).booleanValue()) {
            hint.setTtl(null);
        } else if (ttlString != null) {
            hint.setTtl(Long.parseLong(ttlString));
        }
        String memString = this.metadata.getExtensionProperty(viewId, "{http://www.teiid.org/ext/relational/2012}MATVIEW_PREFER_MEMORY", false);
        if (memString != null) {
            hint.setPrefersMemory(Boolean.valueOf(memString));
        }
        if ((updatableString = this.metadata.getExtensionProperty(viewId, "{http://www.teiid.org/ext/relational/2012}MATVIEW_UPDATABLE", false)) != null) {
            hint.setUpdatable(Boolean.valueOf(updatableString));
        }
        if ((scope = this.metadata.getExtensionProperty(viewId, "{http://www.teiid.org/ext/relational/2012}MATVIEW_SCOPE", false)) != null) {
            hint.setScope(scope);
        }
        id.setCacheHint(hint);
    }

    static ArrayList<TempMetadataID> resolveIndex(QueryMetadataInterface metadata, TempMetadataID id, Object pk) throws TeiidComponentException, QueryMetadataException {
        List cols = metadata.getElementIDsInKey(pk);
        ArrayList<TempMetadataID> primaryKey = new ArrayList<TempMetadataID>(cols.size());
        for (Object coldId : cols) {
            int pos = metadata.getPosition(coldId) - 1;
            primaryKey.add(id.getElements().get(pos));
        }
        return primaryKey;
    }

    @Override
    public void loaded(String matTableName, TempTable table) {
        this.swapTempTable(matTableName, table);
        this.getMatTableInfo(matTableName).setState(MatState.LOADED, true);
    }

    private void swapTempTable(String tempTableName, TempTable tempTable) {
        this.tableStore.getTempTables().put(tempTableName, tempTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> updateMatViewRow(String matTableName, List<?> tuple, boolean delete) throws TeiidComponentException {
        TempTable tempTable = this.tableStore.getTempTable(matTableName);
        if (tempTable != null) {
            TempMetadataID id;
            TempMetadataID tempMetadataID = id = this.tableStore.getMetadataStore().getTempGroupID(matTableName);
            synchronized (tempMetadataID) {
                boolean clone;
                boolean bl = clone = tempTable.getActive().get() != 0;
                if (clone) {
                    tempTable = tempTable.clone();
                }
                List<?> result = tempTable.updateTuple(tuple, delete);
                if (clone) {
                    this.swapTempTable(matTableName, tempTable);
                }
                return result;
            }
        }
        return null;
    }

    public TempTableStore getTempTableStore() {
        return this.tableStore;
    }

    @Override
    public TempTable createMatTable(String tableName, GroupSymbol group) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        Create create = GlobalTableStoreImpl.getCreateCommand(group, true, this.metadata);
        TempTable table = this.tableStore.addTempTable(tableName, create, this.bufferManager, false, null);
        table.setUpdatable(false);
        CacheHint hint = table.getCacheHint();
        if (hint != null) {
            table.setPreferMemory(hint.isPrefersMemory());
            if (hint.getTtl() != null) {
                this.getMatTableInfo(tableName).setTtl(hint.getTtl());
            }
            if (!create.getPrimaryKey().isEmpty()) {
                table.setUpdatable(hint.isUpdatable(false));
            }
        }
        return table;
    }

    public static Create getCreateCommand(GroupSymbol group, boolean matview, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Object pk;
        Create create = new Create();
        create.setTable(group);
        List<ElementSymbol> allColumns = ResolverUtil.resolveElementsInGroup(group, metadata);
        create.setElementSymbolsAsColumns(allColumns);
        if (!matview) {
            for (int i = 0; i < allColumns.size(); ++i) {
                ElementSymbol es = allColumns.get(i);
                if (metadata.elementSupports(es.getMetadataID(), 4)) continue;
                create.getColumns().get(i).setNullType(BaseColumn.NullType.No_Nulls);
                if (es.getType() != DataTypeManager.DefaultDataClasses.INTEGER || !metadata.elementSupports(es.getMetadataID(), 8)) continue;
                create.getColumns().get(i).setAutoIncremented(true);
            }
        }
        if ((pk = metadata.getPrimaryKey(group.getMetadataID())) != null) {
            List<ElementSymbol> pkColumns = GlobalTableStoreImpl.resolveIndex(metadata, allColumns, pk);
            create.getPrimaryKey().addAll(pkColumns);
        }
        return create;
    }

    public static List<ElementSymbol> resolveIndex(QueryMetadataInterface metadata, List<ElementSymbol> allColumns, Object pk) throws TeiidComponentException, QueryMetadataException {
        List pkIds = metadata.getElementIDsInKey(pk);
        ArrayList<ElementSymbol> pkColumns = new ArrayList<ElementSymbol>(pkIds.size());
        for (Object col : pkIds) {
            pkColumns.add(allColumns.get(metadata.getPosition(col) - 1));
        }
        return pkColumns;
    }

    @Override
    public void setAddress(Serializable address) {
        this.localAddress = address;
    }

    @Override
    public Serializable getAddress() {
        return this.localAddress;
    }

    @Override
    public void getState(OutputStream ostream) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(ostream);
            for (Map.Entry<String, TempTable> entry : this.tableStore.getTempTables().entrySet()) {
                this.sendTable(entry.getKey(), oos, true);
            }
            oos.writeObject(null);
            oos.close();
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30217, (Throwable)e);
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30218, (Throwable)e);
        }
    }

    @Override
    public void setState(InputStream istream) {
        try {
            String tableName;
            ObjectInputStream ois = new ObjectInputStream(istream);
            while ((tableName = (String)ois.readObject()) != null) {
                this.loadTable(tableName, ois);
            }
            ois.close();
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30219, (Throwable)e);
        }
    }

    @Override
    public void getState(String stateId, OutputStream ostream) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(ostream);
            this.sendTable(stateId, oos, false);
            oos.close();
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30220, (Throwable)e);
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30221, (Throwable)e);
        }
    }

    private void sendTable(String stateId, ObjectOutputStream oos, boolean writeName) throws IOException, TeiidComponentException {
        TempTable tempTable = this.tableStore.getTempTable(stateId);
        if (tempTable == null) {
            return;
        }
        MatTableInfo info = this.getMatTableInfo(stateId);
        if (!info.isValid()) {
            return;
        }
        if (writeName) {
            oos.writeObject(stateId);
        }
        oos.writeLong(info.updateTime);
        oos.writeObject(info.loadingAddress);
        oos.writeObject((Object)info.state);
        tempTable.writeTo(oos);
    }

    @Override
    public void setState(String stateId, InputStream istream) {
        try {
            ObjectInputStream ois = new ObjectInputStream(istream);
            this.loadTable(stateId, ois);
            ois.close();
        }
        catch (Exception e) {
            MatTableInfo info = this.getMatTableInfo(stateId);
            info.setState(MatState.FAILED_LOAD, null);
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30222, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTable(String stateId, ObjectInputStream ois) throws TeiidComponentException, QueryMetadataException, IOException, ClassNotFoundException, TeiidProcessingException {
        MatTableInfo info;
        String viewName;
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"loading table from remote stream", (Object)stateId);
        long updateTime = ois.readLong();
        Serializable loadingAddress = (Serializable)ois.readObject();
        MatState state = (MatState)((Object)ois.readObject());
        GroupSymbol group = new GroupSymbol(stateId);
        if (stateId.startsWith("#MAT_")) {
            viewName = stateId.substring("#MAT_".length());
            Object viewId = this.metadata.getGroupID(viewName);
            group.setMetadataID(this.getGlobalTempTableMetadataId(viewId));
        } else {
            viewName = stateId.substring("#CODE_".length());
            int index = viewName.lastIndexOf(46);
            String returnElementName = viewName.substring(index + 1);
            viewName = viewName.substring(0, index);
            index = viewName.lastIndexOf(46);
            String keyElementName = viewName.substring(index + 1);
            viewName = viewName.substring(0, index);
            group.setMetadataID(this.getCodeTableMetadataId(viewName, returnElementName, keyElementName, stateId));
        }
        TempTable tempTable = this.createMatTable(stateId, group);
        tempTable.readFrom(ois);
        MatTableInfo matTableInfo = info = this.getMatTableInfo(stateId);
        synchronized (matTableInfo) {
            this.swapTempTable(stateId, tempTable);
            info.setState(state, true);
            info.updateTime = updateTime;
            info.loadingAddress = loadingAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void droppedMembers(Collection<Serializable> addresses) {
        Iterator<MatTableInfo> iterator = this.matTables.values().iterator();
        while (iterator.hasNext()) {
            MatTableInfo info;
            MatTableInfo matTableInfo = info = iterator.next();
            synchronized (matTableInfo) {
                if (info.getState() == MatState.LOADING && addresses.contains(info.loadingAddress)) {
                    info.setState(MatState.FAILED_LOAD, null);
                }
            }
        }
    }

    @Override
    public boolean hasState(String stateId) {
        return this.tableStore.getTempTable(stateId) != null;
    }

    @Override
    public TempMetadataID getGlobalTempTableMetadataId(String matTableName) {
        return this.tableStore.getMetadataStore().getTempGroupID(matTableName);
    }

    @Override
    public TempTable getTempTable(String matTableName) {
        return this.tableStore.getTempTable(matTableName);
    }

    public class MatTableInfo {
        private long updateTime = -1L;
        private MatState state = MatState.NEEDS_LOADING;
        private Serializable loadingAddress;
        private long ttl = -1L;
        private boolean valid;
        private boolean asynch;
        private Map<RequestID, WeakReference<RequestWorkItem>> waiters = new HashMap<RequestID, WeakReference<RequestWorkItem>>(2);

        protected MatTableInfo() {
        }

        private synchronized boolean shouldLoad(Serializable possibleLoadingAddress, boolean firstPass, boolean refresh, boolean invalidate) {
            if (invalidate) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR.MATVIEWS", (Object)this, (Object)"invalidating");
                this.valid = false;
            }
            switch (this.state) {
                case NEEDS_LOADING: 
                case FAILED_LOAD: {
                    if (!firstPass) {
                        this.loadingAddress = possibleLoadingAddress;
                        this.setState(MatState.LOADING, null);
                    }
                    return true;
                }
                case LOADING: {
                    if (!firstPass && GlobalTableStoreImpl.this.localAddress instanceof Comparable && ((Comparable)((Object)GlobalTableStoreImpl.this.localAddress)).compareTo(possibleLoadingAddress) < 0 || refresh && this.asynch) {
                        this.asynch = false;
                        this.loadingAddress = possibleLoadingAddress;
                        return true;
                    }
                    return false;
                }
                case LOADED: {
                    if (!firstPass || refresh || this.ttl >= 0L && System.currentTimeMillis() - this.updateTime - this.ttl > 0L) {
                        if (firstPass) {
                            this.setState(MatState.NEEDS_LOADING, null);
                        } else {
                            this.loadingAddress = possibleLoadingAddress;
                            this.setState(MatState.LOADING, null);
                        }
                        return true;
                    }
                    return false;
                }
            }
            throw new AssertionError();
        }

        private synchronized void setState(MatState state, Boolean valid) {
            MatState oldState = this.state;
            long timestamp = System.currentTimeMillis();
            LogManager.logDetail((String)"org.teiid.PROCESSOR.MATVIEWS", (Object[])new Object[]{this, "setting matState to", state, valid, timestamp, "old values", oldState, this.valid});
            if (valid != null) {
                this.valid = valid;
            }
            this.state = state;
            this.updateTime = System.currentTimeMillis();
            for (WeakReference<RequestWorkItem> request : this.waiters.values()) {
                RequestWorkItem workItem = (RequestWorkItem)request.get();
                if (workItem == null) continue;
                workItem.moreWork();
            }
            this.waiters.clear();
        }

        public synchronized void setAsynchLoad() {
            assert (this.state == MatState.LOADING);
            this.asynch = true;
        }

        public synchronized void setTtl(long ttl) {
            this.ttl = ttl;
        }

        public synchronized long getUpdateTime() {
            return this.updateTime;
        }

        public synchronized MatState getState() {
            return this.state;
        }

        public synchronized boolean isUpToDate() {
            return this.isValid() && (this.ttl < 0L || System.currentTimeMillis() - this.updateTime - this.ttl <= 0L);
        }

        public synchronized boolean isValid() {
            return this.valid;
        }

        public synchronized long getTtl() {
            return this.ttl;
        }

        public VDBMetaData getVdbMetaData() {
            return GlobalTableStoreImpl.this.vdbMetaData;
        }

        public synchronized void addWaiter(RequestWorkItem waiter) {
            this.waiters.put(waiter.getRequestID(), new WeakReference<RequestWorkItem>(waiter));
        }
    }

    public static enum MatState {
        NEEDS_LOADING,
        LOADING,
        FAILED_LOAD,
        LOADED;

    }
}

