/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.RecordTable;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;

abstract class BaseExtractionTable<T> {
    private Evaluator eval;
    private int cols;

    public BaseExtractionTable(List<ElementSymbol> columns) {
        Map<Expression, Integer> map = RelationalNode.createLookupMap(columns);
        this.eval = new Evaluator(map, null, null);
        this.cols = columns.size();
    }

    public TupleSource processQuery(Query query, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc) throws QueryMetadataException, TeiidComponentException {
        return new ExtractionTupleSource<T>(query.getCriteria(), this.createIterator(vdb, metadata, cc), cc, vdb, metadata, this);
    }

    protected RecordTable.SimpleIterator<T> createIterator(VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc) throws QueryMetadataException, TeiidComponentException {
        return null;
    }

    protected abstract void fillRow(List<Object> var1, T var2, VDBMetaData var3, TransformationMetadata var4, CommandContext var5, RecordTable.SimpleIterator<T> var6);

    static final class ExtractionTupleSource<T>
    implements TupleSource {
        private final Criteria condition;
        private final RecordTable.SimpleIterator<T> iter;
        private final CommandContext cc;
        private final VDBMetaData vdb;
        private final TransformationMetadata metadata;
        private ArrayList<Object> rowBuffer;
        private BaseExtractionTable<T> extraction;

        ExtractionTupleSource(Criteria condition, RecordTable.SimpleIterator<T> iter, CommandContext cc, VDBMetaData vdb, TransformationMetadata metadata, BaseExtractionTable<T> extraction) {
            this.condition = condition;
            this.iter = iter;
            this.cc = cc;
            this.vdb = vdb;
            this.metadata = metadata;
            this.extraction = extraction;
        }

        @Override
        public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
            do {
                T val;
                if ((val = this.iter.next()) == null) {
                    return null;
                }
                if (this.rowBuffer == null) {
                    this.rowBuffer = new ArrayList(((BaseExtractionTable)this.extraction).cols);
                } else {
                    this.rowBuffer.clear();
                }
                this.extraction.fillRow(this.rowBuffer, val, this.vdb, this.metadata, this.cc, this.iter);
            } while (this.condition != null && !((BaseExtractionTable)this.extraction).eval.evaluate(this.condition, this.rowBuffer));
            ArrayList<Object> result = this.rowBuffer;
            this.rowBuffer = null;
            return result;
        }

        @Override
        public void closeSource() {
        }
    }
}

