/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestMultisource
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9999, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testSourceOperations() throws Exception {
        this.admin.deploy("multisource-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"arquillian/multisource-vdb.xml")));
        Properties props = new Properties();
        props.setProperty("ParentDirectory", UnitTestUtil.getTestDataFile((String)"/arquillian/txt/").getAbsolutePath());
        props.setProperty("AllowParentPaths", "true");
        props.setProperty("class-name", "org.teiid.resource.adapter.file.FileManagedConnectionFactory");
        AdminUtil.createDataSource(this.admin, "test-file", "file", props);
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "multisource", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:multisource@mm://localhost:31000;user=user;password=user", null);
        this.execute("exec getfiles('*.txt')", new Object[0]);
        this.assertRowCount(1);
        this.admin.addSource("multisource", 1, "MarketData", "text-connector1", "file1", "java:/test-file");
        this.execute("exec getfiles('*.txt')", new Object[0]);
        this.assertRowCount(2);
        this.admin.removeSource("multisource", 1, "MarketData", "text-connector");
        this.execute("exec getfiles('*.txt')", new Object[0]);
        this.assertRowCount(1);
    }
}

