/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.teiid.query.sql.symbol.ElementSymbol;

public class AccessPattern
implements Comparable<AccessPattern>,
Cloneable {
    private Set<ElementSymbol> unsatisfied = new HashSet<ElementSymbol>();
    private LinkedList<Collection<ElementSymbol>> history = new LinkedList();

    public AccessPattern(Collection<ElementSymbol> elements) {
        this.unsatisfied.addAll(elements);
        this.history.add(elements);
    }

    public Collection<ElementSymbol> getCurrentElements() {
        return this.history.getFirst();
    }

    public void addElementHistory(Collection<ElementSymbol> elements) {
        this.history.addFirst(elements);
    }

    public LinkedList<Collection<ElementSymbol>> getHistory() {
        return this.history;
    }

    public Set<ElementSymbol> getUnsatisfied() {
        return this.unsatisfied;
    }

    public void setUnsatisfied(Set<ElementSymbol> unstaisfied) {
        this.unsatisfied = unstaisfied;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Access Pattern: Unsatisfied ");
        sb.append(this.unsatisfied);
        sb.append(" History ");
        sb.append(this.history);
        return sb.toString();
    }

    @Override
    public int compareTo(AccessPattern other) {
        if (this.unsatisfied.size() > other.unsatisfied.size()) {
            return 1;
        }
        if (this.unsatisfied.size() < other.unsatisfied.size()) {
            return -1;
        }
        return 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException err) {
            return null;
        }
    }
}

