/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class From
implements LanguageObject {
    private List<FromClause> clauses;

    public From() {
        this.clauses = new ArrayList<FromClause>();
    }

    public From(List<? extends FromClause> parameters) {
        this.clauses = new ArrayList<FromClause>(parameters);
    }

    public void addClause(FromClause clause) {
        this.clauses.add(clause);
    }

    public void addClauses(Collection<? extends FromClause> toAdd) {
        this.clauses.addAll(toAdd);
    }

    public List<FromClause> getClauses() {
        return this.clauses;
    }

    public void setClauses(List<FromClause> clauses) {
        this.clauses = clauses;
    }

    public void addGroup(GroupSymbol group) {
        if (group != null) {
            this.clauses.add(new UnaryFromClause(group));
        }
    }

    public void addGroups(Collection<GroupSymbol> groups) {
        if (groups != null) {
            for (GroupSymbol groupSymbol : groups) {
                this.clauses.add(new UnaryFromClause(groupSymbol));
            }
        }
    }

    public List<GroupSymbol> getGroups() {
        ArrayList<GroupSymbol> groups = new ArrayList<GroupSymbol>();
        if (this.clauses != null) {
            for (int i = 0; i < this.clauses.size(); ++i) {
                FromClause clause = this.clauses.get(i);
                clause.collectGroups(groups);
            }
        }
        return groups;
    }

    public boolean containsGroup(GroupSymbol group) {
        return this.getGroups().contains(group);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        return new From(LanguageObject.Util.deepClone(this.clauses, FromClause.class));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof From)) {
            return false;
        }
        return EquivalenceUtil.areEqual(this.getClauses(), ((From)obj).getClauses());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getGroups()});
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

