/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.StringUtil;

public final class FileUtils {
    public static final char SEPARATOR = '/';
    public static int DEFAULT_BUFFER_SIZE = 2048;
    public static String TEMP_DIRECTORY;
    public static String LINE_SEPARATOR;
    public static char[] LINE_SEPARATOR_CHARS;
    public static final String JAVA_IO_TEMP_DIR = "java.io.tmpdir";
    public static final char[] SUFFIX_class;
    public static final char[] SUFFIX_CLASS;
    public static final char[] SUFFIX_java;
    public static final char[] SUFFIX_JAVA;
    public static final char[] SUFFIX_jar;
    public static final char[] SUFFIX_JAR;
    public static final char[] SUFFIX_zip;
    public static final char[] SUFFIX_ZIP;

    private FileUtils() {
    }

    public static String toFileNameWithExtension(String name, String extension) {
        return FileUtils.toFileNameWithExtension(name, extension, false);
    }

    public static String toFileNameWithExtension(String name, String extension, boolean force) {
        boolean extBeginsWithExtChr;
        if (name == null) {
            String msg = CorePlugin.Util.getString("FileUtils.The_name_of_the_file_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (extension == null) {
            String msg = CorePlugin.Util.getString("FileUtils.The_file_extension_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (name.endsWith(extension)) {
            return name;
        }
        if (!force && name.indexOf(46) >= 0) {
            return name;
        }
        int nameLen = name.length() - 1;
        int extLen = extension.length();
        boolean nameEndsWithExtChr = nameLen >= 0 && name.charAt(nameLen) == '.';
        boolean bl = extBeginsWithExtChr = extLen > 0 && extension.charAt(0) == '.';
        if (nameEndsWithExtChr && extBeginsWithExtChr) {
            return name.substring(0, nameLen) + extension;
        }
        if (!nameEndsWithExtChr && !extBeginsWithExtChr) {
            return name + Constants.FILE_EXTENSION_SEPARATOR + extension;
        }
        return name + extension;
    }

    public static boolean isFilenameValid(String newName) {
        return true;
    }

    public static void copy(String fromFileName, String toFileName) throws IOException {
        FileUtils.copy(fromFileName, toFileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String fromFileName, String toFileName, boolean overwrite) throws IOException {
        File fromFile;
        File toFile = new File(toFileName);
        if (toFile.exists()) {
            if (overwrite) {
                toFile.delete();
            } else {
                String msg = CorePlugin.Util.getString("FileUtils.File_already_exists", toFileName);
                throw new IOException(msg);
            }
        }
        if (!(fromFile = new File(fromFileName)).exists()) {
            throw new FileNotFoundException(CorePlugin.Util.getString("FileUtils.File_does_not_exist._1", fromFileName));
        }
        try (FileInputStream fis = null;){
            fis = new FileInputStream(fromFile);
            FileUtils.write((InputStream)fis, toFileName);
        }
    }

    public static void copyDirectoryContentsRecursively(File sourceDirectory, File targetDirectory) throws Exception {
        FileUtils.copyRecursively(sourceDirectory, targetDirectory, false);
    }

    public static void copyFile(String orginDirectory, String destDirectory, String fileName) throws Exception {
        FileUtils.copyFile(orginDirectory, fileName, destDirectory, fileName);
    }

    public static void copyFile(String orginDirectory, String orginFileName, String destDirectory, String destFileName) throws Exception {
        FileUtils.copy(orginDirectory + File.separator + orginFileName, destDirectory + File.separator + destFileName);
    }

    public static void copyDirectoriesRecursively(File sourceDirectory, File targetDirectory) throws Exception {
        FileUtils.copyRecursively(sourceDirectory, targetDirectory, true);
    }

    private static void copyRecursively(File sourceDirectory, File targetDirectory, boolean includeSourceRoot) throws FileNotFoundException, Exception {
        if (!sourceDirectory.exists()) {
            throw new FileNotFoundException(CorePlugin.Util.getString("FileUtils.File_does_not_exist._1", sourceDirectory));
        }
        if (!sourceDirectory.isDirectory()) {
            throw new FileNotFoundException(CorePlugin.Util.getString("FileUtils.Not_a_directory", sourceDirectory));
        }
        File targetDir = new File(targetDirectory.getAbsolutePath() + File.separatorChar + sourceDirectory.getName());
        if (includeSourceRoot) {
            targetDir.mkdir();
        } else {
            targetDir = new File(targetDirectory.getAbsolutePath() + File.separatorChar);
        }
        File[] sourceFiles = sourceDirectory.listFiles();
        for (int i = 0; i < sourceFiles.length; ++i) {
            File srcFile = sourceFiles[i];
            if (srcFile.isDirectory()) {
                File childTargetDir = new File(targetDir.getAbsolutePath());
                FileUtils.copyRecursively(srcFile, childTargetDir, true);
                continue;
            }
            FileUtils.copy(srcFile.getAbsolutePath(), targetDir.getAbsolutePath() + File.separatorChar + srcFile.getName());
        }
    }

    public static void write(InputStream is, String fileName) throws IOException {
        File f = new File(fileName);
        FileUtils.write(is, f);
    }

    public static void write(InputStream is, File f) throws IOException {
        FileUtils.write(is, f, DEFAULT_BUFFER_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream is, File f, int bufferSize) throws IOException {
        f.delete();
        File parentDir = f.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        FileOutputStream fio = null;
        FilterOutputStream bos = null;
        try {
            fio = new FileOutputStream(f);
            bos = new BufferedOutputStream(fio);
            if (bufferSize > 0) {
                int bytesRead;
                byte[] buff = new byte[bufferSize];
                while (-1 != (bytesRead = is.read(buff, 0, buff.length))) {
                    ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
                }
            }
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (fio != null) {
                fio.close();
            }
        }
    }

    public static void write(File f, OutputStream outputStream) throws IOException {
        FileUtils.write(f, outputStream, DEFAULT_BUFFER_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File f, OutputStream outputStream, int bufferSize) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(f);
            FileUtils.write((InputStream)fis, outputStream, bufferSize);
        }
    }

    public static void write(InputStream fis, OutputStream outputStream, int bufferSize) throws IOException {
        int bytesRead;
        byte[] buff = new byte[bufferSize];
        while (-1 != (bytesRead = fis.read(buff, 0, buff.length))) {
            outputStream.write(buff, 0, bytesRead);
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] data, String fileName) throws IOException {
        ByteArrayInputStream bais = null;
        InputStream is = null;
        try {
            bais = new ByteArrayInputStream(data);
            is = new BufferedInputStream(bais);
            FileUtils.write(is, fileName);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] data, File file) throws IOException {
        ByteArrayInputStream bais = null;
        InputStream is = null;
        try {
            bais = new ByteArrayInputStream(data);
            is = new BufferedInputStream(bais);
            FileUtils.write(is, file);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
    }

    public static File[] findAllFilesInDirectoryRecursively(String dir) {
        ArrayList allFiles = new ArrayList();
        File directory = new File(dir);
        FileUtils.addFilesInDirectoryRecursively(directory, allFiles);
        return allFiles.toArray(new File[allFiles.size()]);
    }

    private static void addFilesInDirectoryRecursively(File directory, List allFiles) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileUtils.addFilesInDirectoryRecursively(file, allFiles);
                    continue;
                }
                allFiles.add(file);
            }
        }
    }

    public static File[] findAllFilesInDirectory(String dir) {
        File modelsDirFile = new File(dir);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String fileName = file.getName();
                return fileName != null && fileName.length() != 0;
            }
        };
        File[] modelFiles = modelsDirFile.listFiles(fileFilter);
        return modelFiles;
    }

    public static File[] findAllFilesInDirectoryHavingExtension(String dir, final String extension) {
        File modelsDirFile = new File(dir);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String fileName = file.getName();
                if (fileName == null || fileName.length() == 0) {
                    return false;
                }
                int index = fileName.lastIndexOf(".");
                if (index < 0 || index == fileName.length()) {
                    return false;
                }
                return fileName.substring(index, fileName.length()).equalsIgnoreCase(extension);
            }
        };
        File[] modelFiles = modelsDirFile.listFiles(fileFilter);
        return modelFiles;
    }

    public static String getFilenameWithoutExtension(String filename) {
        if (filename == null || filename.length() == 0) {
            return filename;
        }
        int extensionIndex = filename.lastIndexOf(46);
        if (extensionIndex == -1) {
            return filename;
        }
        if (extensionIndex == 0) {
            return "";
        }
        return filename.substring(0, extensionIndex);
    }

    public static String getBaseFileNameWithoutExtension(String path) {
        return StringUtil.getFirstToken(StringUtil.getLastToken(path, "/"), ".");
    }

    public static String getExtension(File theFile) {
        return FileUtils.getExtension(theFile.getPath());
    }

    public static String getExtension(String theFileName) {
        String result = null;
        int index = theFileName.lastIndexOf(46);
        if (index != -1 && index + 1 != theFileName.length()) {
            result = theFileName.substring(index + 1);
        }
        return result;
    }

    public static final boolean isArchiveFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_JAR.length)) {
            return false;
        }
        for (int i = 0; i < suffixLength; ++i) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c == SUFFIX_jar[suffixIndex = suffixLength - i - 1] || c == SUFFIX_JAR[suffixIndex]) continue;
            suffixLength = SUFFIX_ZIP.length;
            if (nameLength < suffixLength) {
                return false;
            }
            for (int j = 0; j < suffixLength; ++j) {
                c = name.charAt(nameLength - j - 1);
                if (c == SUFFIX_zip[suffixIndex = suffixLength - j - 1] || c == SUFFIX_ZIP[suffixIndex]) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static final boolean isClassFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_CLASS.length)) {
            return false;
        }
        for (int i = 0; i < suffixLength; ++i) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c == SUFFIX_class[suffixIndex = suffixLength - i - 1] || c == SUFFIX_CLASS[suffixIndex]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isJavaFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_JAVA.length)) {
            return false;
        }
        for (int i = 0; i < suffixLength; ++i) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c == SUFFIX_java[suffixIndex = suffixLength - i - 1] || c == SUFFIX_JAVA[suffixIndex]) continue;
            return false;
        }
        return true;
    }

    public static File convertByteArrayToFile(byte[] contents, String parentDirectoryPath, String fileName) {
        if (contents != null) {
            FileOutputStream os = null;
            try {
                File temp = new File(parentDirectoryPath, fileName);
                os = new FileOutputStream(temp);
                os.write(contents);
                File file = temp;
                return file;
            }
            catch (Exception e) {
                throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10024, (Throwable)e);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public static void removeDirectoryAndChildren(File directory) {
        FileUtils.removeChildrenRecursively(directory);
        if (!directory.delete()) {
            directory.deleteOnExit();
        }
    }

    public static void removeChildrenRecursively(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileUtils.removeDirectoryAndChildren(file);
                    continue;
                }
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }
    }

    public static String buildDirectoryPath(String[] paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        if (paths.length == 1) {
            return paths[0] != null ? paths[0] : "";
        }
        int l = paths.length;
        StringBuffer sb = new StringBuffer();
        for (int cur = 0; cur < l; ++cur) {
            String nextValue;
            String value;
            int next = cur + 1;
            String string = value = paths[cur] != null ? paths[cur] : "";
            if (value.equals("")) continue;
            sb.append(value);
            if (next >= l) continue;
            String string2 = nextValue = paths[next] != null ? paths[next] : "";
            if (value.endsWith(File.separator) || nextValue.startsWith(File.separator)) continue;
            sb.append(File.separator);
        }
        return sb.toString();
    }

    public static void rename(String oldFilePath, String newFilePath, boolean overwrite) throws IOException {
        boolean renamed;
        File oldFile = new File(oldFilePath);
        File newFile = new File(newFilePath);
        if (newFile.exists()) {
            if (overwrite) {
                newFile.delete();
            } else {
                String msg = CorePlugin.Util.getString("FileUtils.File_already_exists", newFilePath);
                throw new IOException(msg);
            }
        }
        if (!(renamed = oldFile.renameTo(newFile))) {
            FileUtils.copy(oldFilePath, newFilePath);
            oldFile.delete();
        }
    }

    public static void remove(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    public static void remove(String filePath) throws IOException {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
        LINE_SEPARATOR_CHARS = LINE_SEPARATOR.toCharArray();
        SUFFIX_class = ".class".toCharArray();
        SUFFIX_CLASS = ".CLASS".toCharArray();
        SUFFIX_java = ".java".toCharArray();
        SUFFIX_JAVA = ".JAVA".toCharArray();
        SUFFIX_jar = ".jar".toCharArray();
        SUFFIX_JAR = ".JAR".toCharArray();
        SUFFIX_zip = ".zip".toCharArray();
        SUFFIX_ZIP = ".ZIP".toCharArray();
        String tempDirPath = System.getProperty(JAVA_IO_TEMP_DIR);
        TEMP_DIRECTORY = tempDirPath.endsWith(File.separator) ? tempDirPath : tempDirPath + File.separator;
    }

    public static interface Constants {
        public static final char CURRENT_FOLDER_SYMBOL_CHAR = '.';
        public static final char DRIVE_SEPARATOR_CHAR = ':';
        public static final char FILE_EXTENSION_SEPARATOR_CHAR = '.';
        public static final char FILE_NAME_WILDCARD_CHAR = '*';
        public static final String CURRENT_FOLDER_SYMBOL = String.valueOf('.');
        public static final String DRIVE_SEPARATOR = String.valueOf(':');
        public static final String FILE_EXTENSION_SEPARATOR = String.valueOf('.');
        public static final String FILE_NAME_WILDCARD = String.valueOf('*');
        public static final String PARENT_FOLDER_SYMBOL = "..";
    }
}

