/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.teiid.CommandContext;
import org.teiid.PolicyDecider;
import org.teiid.adminapi.DataPolicy;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.dqp.internal.process.AuthorizationValidationVisitor;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.Request;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.MultipleElementSymbol;

public class DefaultAuthorizationValidator
implements AuthorizationValidator {
    public static final String IGNORE_UNAUTHORIZED_ASTERISK = "ignore_unauthorized_asterisk";
    private PolicyDecider policyDecider;
    private boolean ignoreUnauthorizedAsteriskDefault = PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.ignoreUnauthorizedAsterisk", (boolean)false);

    @Override
    public boolean validate(String[] originalSql, Command command, QueryMetadataInterface metadata, org.teiid.query.util.CommandContext commandContext, AuthorizationValidator.CommandType commandType) throws QueryValidatorException, TeiidComponentException {
        boolean modified = false;
        if (this.policyDecider != null && this.policyDecider.validateCommand((CommandContext)commandContext)) {
            if (this.ignoreUnathorizedInAsterisk(command, commandContext)) {
                Query query = (Query)command;
                HashMap<String, LanguageObject> map = null;
                for (Expression ex : query.getSelect().getSymbols()) {
                    if (!(ex instanceof MultipleElementSymbol)) continue;
                    MultipleElementSymbol mes = (MultipleElementSymbol)ex;
                    if (map == null) {
                        map = new HashMap<String, LanguageObject>();
                    }
                    Iterator<ElementSymbol> iter = mes.getElementSymbols().iterator();
                    while (iter.hasNext()) {
                        ElementSymbol es = iter.next();
                        Object metadataObject = es.getMetadataID();
                        if (metadataObject instanceof MultiSourceElement || metadataObject instanceof TempMetadataID) continue;
                        map.clear();
                        AuthorizationValidationVisitor.addToNameMap(metadataObject, es, map, commandContext.getMetadata());
                        Set results = this.policyDecider.getInaccessibleResources(DataPolicy.PermissionType.READ, map.keySet(), DataPolicy.Context.QUERY, (CommandContext)commandContext);
                        if (results.isEmpty()) continue;
                        iter.remove();
                        modified = true;
                    }
                }
                if (query.getProjectedSymbols().isEmpty()) {
                    throw new QueryValidatorException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31151, new Object[0]));
                }
            }
            AuthorizationValidationVisitor visitor = new AuthorizationValidationVisitor(this.policyDecider, commandContext);
            Request.validateWithVisitor(visitor, metadata, command);
        }
        return modified;
    }

    private boolean ignoreUnathorizedInAsterisk(Command command, org.teiid.query.util.CommandContext commandContext) {
        if (!(command instanceof Query)) {
            return false;
        }
        Query query = (Query)command;
        if (query.getIsXML() || query.getInto() != null) {
            return false;
        }
        if (this.ignoreUnauthorizedAsteriskDefault) {
            return true;
        }
        Object value = commandContext.getSessionVariable(IGNORE_UNAUTHORIZED_ASTERISK);
        if (value != null) {
            try {
                return Boolean.TRUE.equals(DataTypeManager.transformValue((Object)value, (Class)DataTypeManager.DefaultDataClasses.BOOLEAN));
            }
            catch (TransformationException transformationException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean hasRole(String roleName, org.teiid.query.util.CommandContext commandContext) {
        if (this.policyDecider == null) {
            return true;
        }
        return this.policyDecider.hasRole(roleName, (CommandContext)commandContext);
    }

    public void setPolicyDecider(PolicyDecider policyDecider) {
        this.policyDecider = policyDecider;
    }
}

