/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.InputStreamInStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.gml2.GMLHandler;
import com.vividsolutions.jts.io.gml2.GMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.teiid.CommandContext;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.GeometryTransformUtils;
import org.wololo.geojson.Geometry;
import org.wololo.jts2geojson.GeoJSONReader;
import org.wololo.jts2geojson.GeoJSONWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GeometryUtils {
    private static final int SRID_4326 = 4326;

    public static ClobType geometryToClob(GeometryType geometry, boolean withSrid) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry jtsGeometry = GeometryUtils.getGeometry(geometry);
        int srid = jtsGeometry.getSRID();
        StringBuilder geomText = new StringBuilder();
        if (withSrid && srid != 0) {
            geomText.append("SRID=").append(jtsGeometry.getSRID()).append(";");
        }
        geomText.append(jtsGeometry.toText());
        return new ClobType((Clob)new ClobImpl(geomText.toString()));
    }

    public static GeometryType geometryFromClob(ClobType wkt) throws FunctionExecutionException {
        return GeometryUtils.geometryFromClob(wkt, 0);
    }

    public static GeometryType geometryFromClob(ClobType wkt, int srid) throws FunctionExecutionException {
        Reader r = null;
        try {
            WKTReader reader = new WKTReader();
            r = wkt.getCharacterStream();
            com.vividsolutions.jts.geom.Geometry jtsGeometry = reader.read(r);
            GeometryType geometryType = GeometryUtils.getGeometryType(jtsGeometry, srid);
            return geometryType;
        }
        catch (ParseException e) {
            throw new FunctionExecutionException(e);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static ClobType geometryToGeoJson(GeometryType geometry) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry jtsGeometry = GeometryUtils.getGeometry(geometry);
        GeoJSONWriter writer = new GeoJSONWriter();
        try {
            Geometry geoJson = writer.write(jtsGeometry);
            ClobType result = new ClobType((Clob)new ClobImpl(geoJson.toString()));
            result.setType(ClobType.Type.JSON);
            return result;
        }
        catch (Exception e) {
            throw new FunctionExecutionException(e);
        }
    }

    public static GeometryType geometryFromGeoJson(ClobType json) throws FunctionExecutionException {
        return GeometryUtils.geometryFromGeoJson(json, 0);
    }

    public static GeometryType geometryFromGeoJson(ClobType json, int srid) throws FunctionExecutionException {
        try {
            GeoJSONReader reader = new GeoJSONReader();
            String jsonText = ClobType.getString((Clob)json);
            com.vividsolutions.jts.geom.Geometry jtsGeometry = reader.read(jsonText);
            return GeometryUtils.getGeometryType(jtsGeometry, srid);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
        catch (IOException e) {
            throw new FunctionExecutionException(e);
        }
    }

    public static ClobType geometryToGml(CommandContext ctx, GeometryType geometry, boolean withGmlPrefix) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry jtsGeometry = GeometryUtils.getGeometry(geometry);
        GMLWriter writer = new GMLWriter();
        if (!withGmlPrefix) {
            if (geometry.getSrid() != 4326) {
                if (geometry.getSrid() == 0) {
                    throw new FunctionExecutionException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31161, new Object[0]));
                }
                jtsGeometry = GeometryTransformUtils.transform(ctx, jtsGeometry, 4326);
            }
            writer.setPrefix(null);
        } else if (geometry.getSrid() != 0) {
            // empty if block
        }
        String gmlText = writer.write(jtsGeometry);
        return new ClobType((Clob)new ClobImpl(gmlText));
    }

    public static GeometryType geometryFromGml(ClobType gml, Integer srid) throws FunctionExecutionException {
        try {
            return GeometryUtils.geometryFromGml(gml.getCharacterStream(), srid);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
    }

    public static GeometryType geometryFromGml(Reader reader, Integer srid) throws FunctionExecutionException {
        GeometryFactory gf = new GeometryFactory();
        com.vividsolutions.jts.geom.Geometry jtsGeometry = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            GmlSridHandler handler = new GmlSridHandler(gf, null);
            parser.parse(new InputSource(reader), (DefaultHandler)((Object)handler));
            jtsGeometry = handler.getGeometry();
            if (srid == null) {
                srid = jtsGeometry.getSRID() == 0 ? Integer.valueOf(handler.getSrid()) : Integer.valueOf(jtsGeometry.getSRID());
            }
        }
        catch (IOException e) {
            throw new FunctionExecutionException(e);
        }
        catch (SAXException e) {
            throw new FunctionExecutionException(e);
        }
        catch (ParserConfigurationException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return GeometryUtils.getGeometryType(jtsGeometry, srid);
    }

    public static GeometryType geometryFromBlob(BlobType wkb) throws FunctionExecutionException {
        return GeometryUtils.geometryFromBlob(wkb, 0);
    }

    public static GeometryType geometryFromBlob(BlobType wkb, int srid) throws FunctionExecutionException {
        GeometryType gt = new GeometryType((Blob)wkb.getReference(), srid);
        GeometryUtils.getGeometry(gt);
        return gt;
    }

    public static Boolean intersects(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.intersects(g2);
    }

    public static Boolean contains(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.contains(g2);
    }

    public static Boolean disjoint(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.disjoint(g2);
    }

    public static Boolean crosses(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.crosses(g2);
    }

    public static Double distance(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.distance(g2);
    }

    public static Boolean touches(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.touches(g2);
    }

    public static Boolean overlaps(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.overlaps(g2);
    }

    public static GeometryType getGeometryType(com.vividsolutions.jts.geom.Geometry jtsGeom) {
        return GeometryUtils.getGeometryType(jtsGeom, jtsGeom.getSRID());
    }

    public static GeometryType getGeometryType(com.vividsolutions.jts.geom.Geometry jtsGeom, int srid) {
        WKBWriter writer = new WKBWriter();
        byte[] bytes = writer.write(jtsGeom);
        return new GeometryType(bytes, srid);
    }

    public static com.vividsolutions.jts.geom.Geometry getGeometry(GeometryType geom) throws FunctionExecutionException {
        try {
            return GeometryUtils.getGeometry(geom.getBinaryStream(), geom.getSrid(), false);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
    }

    public static com.vividsolutions.jts.geom.Geometry getGeometry(InputStream is1, Integer srid, boolean allowEwkb) throws FunctionExecutionException {
        try {
            WKBReader reader = new WKBReader();
            com.vividsolutions.jts.geom.Geometry jtsGeom = reader.read((InStream)new InputStreamInStream(is1));
            if (!(allowEwkb || jtsGeom.getSRID() == 0 && jtsGeom.getDimension() <= 2)) {
                throw new FunctionExecutionException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31160, new Object[0]));
            }
            if (srid != null) {
                jtsGeom.setSRID(srid.intValue());
            }
            com.vividsolutions.jts.geom.Geometry geometry = jtsGeom;
            return geometry;
        }
        catch (ParseException e) {
            throw new FunctionExecutionException(e);
        }
        catch (IOException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (is1 != null) {
                try {
                    is1.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Boolean equals(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.getGeometry(geom1).equalsTopo(GeometryUtils.getGeometry(geom2));
    }

    public static GeometryType geometryFromEwkb(InputStream is, Integer srid) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry geom = GeometryUtils.getGeometry(is, srid, true);
        return GeometryUtils.getGeometryType(geom);
    }

    private static class GmlSridHandler
    extends GMLHandler {
        private int srid = 0;

        public GmlSridHandler(GeometryFactory gf, ErrorHandler delegate) {
            super(gf, delegate);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String srsName = attributes.getValue("srsName");
            if (srsName != null) {
                String[] srsParts = srsName.split(":");
                try {
                    if (srsParts.length == 2) {
                        this.srid = Integer.parseInt(srsParts[1]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            super.startElement(uri, localName, qName, attributes);
        }

        public int getSrid() {
            return this.srid;
        }
    }
}

