/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.ArrayList;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.query.processor.xml.ProcessorInstruction;

public class Program {
    private List<ProcessorInstruction> processorInstructions;

    public ProcessorInstruction getInstructionAt(int instructionIndex) {
        return this.getInstructionAtIndex(instructionIndex);
    }

    public void removeInstructionAt(int instructionIndex) {
        List<ProcessorInstruction> instructions = this.getProcessorInstructions();
        if (instructionIndex < instructions.size()) {
            instructions.remove(instructionIndex);
        }
    }

    public void addInstruction(ProcessorInstruction instruction) {
        if (instruction != null) {
            this.getProcessorInstructions().add(instruction);
        }
    }

    public void addInstructions(Program instructions) {
        if (instructions != null) {
            this.getProcessorInstructions().addAll(instructions.getProcessorInstructions());
        }
    }

    public String toString() {
        return "PROGRAM size " + this.getProcessorInstructions().size();
    }

    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("XML Program");
        if (this.processorInstructions != null) {
            for (int i = 0; i < this.processorInstructions.size(); ++i) {
                ProcessorInstruction inst = this.processorInstructions.get(i);
                PlanNode childProps = inst.getDescriptionProperties();
                props.addProperty("Instruction " + i, childProps);
            }
        }
        return props;
    }

    private ProcessorInstruction getInstructionAtIndex(int instructionIndex) {
        if (this.processorInstructions != null && instructionIndex < this.getProcessorInstructions().size()) {
            return this.getProcessorInstructions().get(instructionIndex);
        }
        return null;
    }

    List<ProcessorInstruction> getProcessorInstructions() {
        if (this.processorInstructions == null) {
            this.processorInstructions = new ArrayList<ProcessorInstruction>();
        }
        return this.processorInstructions;
    }
}

