/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.ConnectorWorkItem;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.TranslatorException;

public class AutoGenDataService
extends ConnectorManager {
    private int rows = 10;
    private SourceCapabilities caps;
    public boolean throwExceptionOnExecute;
    public Integer dataNotAvailable;
    public boolean strict;
    public int sleep;
    private final AtomicInteger executeCount = new AtomicInteger();
    private final AtomicInteger closeCount = new AtomicInteger();
    private boolean useIntCounter;
    public boolean addWarning;
    public CacheDirective cacheDirective;
    public boolean dataAvailable;
    public boolean threadBound;
    private static final String STRING_VAL = "ABCDEFG";
    private static final Integer INTEGER_VAL = new Integer(0);
    private static final Long LONG_VAL = new Long(0L);
    private static final Float FLOAT_VAL = new Float(0.0);
    private static final Short SHORT_VAL = new Short(0);
    private static final Double DOUBLE_VAL = new Double(0.0);
    private static final Character CHAR_VAL = new Character('c');
    private static final Byte BYTE_VAL = new Byte(0);
    public static final Clob CLOB_VAL = new ClobImpl(new InputStreamFactory(){

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream("hello world".getBytes(Streamable.CHARSET));
        }
    }, -1L);
    private static final Boolean BOOLEAN_VAL = Boolean.FALSE;
    private static final BigInteger BIG_INTEGER_VAL = new BigInteger("0");
    private static final BigDecimal BIG_DECIMAL_VAL = new BigDecimal("0");
    private static final Date SQL_DATE_VAL = new Date(0L);
    private static final Time TIME_VAL = new Time(0L);
    private static final Timestamp TIMESTAMP_VAL = new Timestamp(0L);

    public AutoGenDataService() {
        super("FakeConnector", "FakeConnector");
        this.caps = TestOptimizer.getTypicalCapabilities();
    }

    public void setUseIntCounter(boolean useIntCounter) {
        this.useIntCounter = useIntCounter;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public void setCaps(SourceCapabilities caps) {
        this.caps = caps;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getRows() {
        return this.rows;
    }

    public ConnectorWork registerRequest(AtomicRequestMessage message) throws TeiidComponentException {
        List projectedSymbols = message.getCommand().getProjectedSymbols();
        List[] results = AutoGenDataService.createResults(projectedSymbols, this.rows, this.useIntCounter);
        if (RelationalNodeUtil.isUpdate((Command)message.getCommand())) {
            results = new List[]{Arrays.asList(1)};
        }
        final AtomicResultsMessage msg = ConnectorWorkItem.createResultsMessage((List[])results);
        msg.setFinalRow(this.rows);
        return new ConnectorWork(){
            boolean returnedInitial;

            public boolean isDataAvailable() {
                return AutoGenDataService.this.dataAvailable;
            }

            public AtomicResultsMessage more() throws TranslatorException {
                if (AutoGenDataService.this.dataNotAvailable != null) {
                    int delay = AutoGenDataService.this.dataNotAvailable;
                    AutoGenDataService.this.dataNotAvailable = null;
                    DataNotAvailableException dnae = new DataNotAvailableException((long)delay);
                    dnae.setStrict(AutoGenDataService.this.strict);
                    throw dnae;
                }
                if (AutoGenDataService.this.addWarning) {
                    msg.setWarnings(Arrays.asList(new Exception()));
                }
                if (!this.returnedInitial) {
                    this.returnedInitial = true;
                    return msg;
                }
                throw new RuntimeException("Should not be called");
            }

            public void execute() throws TranslatorException {
                AutoGenDataService.this.executeCount.incrementAndGet();
                if (AutoGenDataService.this.sleep > 0) {
                    try {
                        Thread.sleep(AutoGenDataService.this.sleep);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (AutoGenDataService.this.throwExceptionOnExecute) {
                    throw new TranslatorException("Connector Exception");
                }
            }

            public void close() {
                AutoGenDataService.this.closeCount.incrementAndGet();
            }

            public void cancel(boolean abnormal) {
            }

            public CacheDirective getCacheDirective() {
                return AutoGenDataService.this.cacheDirective;
            }

            public boolean isForkable() {
                return true;
            }

            public boolean isThreadBound() {
                return AutoGenDataService.this.threadBound;
            }

            public AtomicRequestID getId() {
                return null;
            }
        };
    }

    public AtomicInteger getExecuteCount() {
        return this.executeCount;
    }

    public AtomicInteger getCloseCount() {
        return this.closeCount;
    }

    public static List[] createResults(List symbols, int rowCount, boolean useIntCounter) {
        List[] rows = new List[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (Expression symbol : symbols) {
                Class type = symbol.getType();
                row.add(AutoGenDataService.getValue(type, i, useIntCounter));
            }
            rows[i] = row;
        }
        return rows;
    }

    static Object getValue(Class<?> type, int row, boolean useIntCounter) {
        if (type.equals(DataTypeManager.DefaultDataClasses.STRING)) {
            return STRING_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.INTEGER)) {
            return useIntCounter ? row : INTEGER_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.SHORT)) {
            return SHORT_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.LONG)) {
            return LONG_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.FLOAT)) {
            return FLOAT_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.DOUBLE)) {
            return DOUBLE_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.CHAR)) {
            return CHAR_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BYTE)) {
            return BYTE_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
            return BOOLEAN_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER)) {
            return BIG_INTEGER_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
            return BIG_DECIMAL_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
            return SQL_DATE_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
            return TIME_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            return TIMESTAMP_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.CLOB)) {
            return CLOB_VAL;
        }
        return null;
    }

    public SourceCapabilities getCapabilities() {
        return this.caps;
    }
}

