/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.BatchedUpdatePlan;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.BatchedUpdateNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorReport;

public class TestBatchedUpdatePlanner
extends TestCase {
    private static final boolean DEBUG = false;

    public TestBatchedUpdatePlanner(String name) {
        super(name);
    }

    public static List<Command> helpGetCommands(String[] sql, QueryMetadataInterface md) throws TeiidComponentException, TeiidProcessingException {
        ArrayList<Command> commands = new ArrayList<Command>(sql.length);
        for (int i = 0; i < sql.length; ++i) {
            Command command = QueryParser.getQueryParser().parseCommand(sql[i]);
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)md);
            ValidatorReport repo = Validator.validate((LanguageObject)command, (QueryMetadataInterface)md);
            ArrayList failures = new ArrayList();
            repo.collectInvalidObjects(failures);
            if (failures.size() > 0) {
                TestBatchedUpdatePlanner.fail((String)("Exception during validation (" + repo));
            }
            command = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)md, null);
            commands.add(command);
        }
        return commands;
    }

    private BatchedUpdateCommand helpGetCommand(String[] sql, QueryMetadataInterface md) throws TeiidComponentException, TeiidProcessingException {
        BatchedUpdateCommand command = new BatchedUpdateCommand(TestBatchedUpdatePlanner.helpGetCommands(sql, md));
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchedUpdatePlan helpPlanCommand(Command command, QueryMetadataInterface md, CapabilitiesFinder capFinder, boolean shouldSucceed) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        ProcessorPlan plan = null;
        AnalysisRecord analysisRecord = new AnalysisRecord(false, false);
        if (shouldSucceed) {
            plan = QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)md, null, (CapabilitiesFinder)capFinder, (AnalysisRecord)analysisRecord, null);
            return (BatchedUpdatePlan)plan;
        }
        Throwable exception = null;
        try {
            QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)md, null, (CapabilitiesFinder)capFinder, (AnalysisRecord)analysisRecord, null);
        }
        catch (QueryPlannerException e) {
            exception = e;
        }
        catch (TeiidComponentException e) {
            exception = e;
        }
        TestBatchedUpdatePlanner.assertNotNull((String)"Expected exception but did not get one.", (Object)exception);
        return null;
    }

    public static CapabilitiesFinder getGenericFinder() {
        return new DefaultCapabilitiesFinder((SourceCapabilities)new FakeCapabilities(true));
    }

    private BatchedUpdatePlan helpPlan(String[] sql, QueryMetadataInterface md) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        return this.helpPlan(sql, md, TestBatchedUpdatePlanner.getGenericFinder(), true);
    }

    private BatchedUpdatePlan helpPlan(String[] sql, QueryMetadataInterface md, CapabilitiesFinder capFinder, boolean shouldSucceed) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        BatchedUpdateCommand command = this.helpGetCommand(sql, md);
        if (capFinder == null) {
            capFinder = TestBatchedUpdatePlanner.getGenericFinder();
        }
        return this.helpPlanCommand((Command)command, md, capFinder, shouldSucceed);
    }

    private void helpAssertIsBatchedPlan(RelationalPlan plan, boolean isBatchedPlan) {
        RelationalNode node = plan.getRootNode();
        if (node instanceof ProjectNode) {
            node = node.getChildren()[0];
        }
        if (isBatchedPlan) {
            TestBatchedUpdatePlanner.assertTrue((String)"Plan should have been a batched", (boolean)(node instanceof BatchedUpdateNode));
        } else {
            TestBatchedUpdatePlanner.assertTrue((String)"Plan should not have been batched.", (boolean)(node instanceof AccessNode));
        }
    }

    private void helpTestPlanner(String[] sql, boolean[] expectedBatching) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        BatchedUpdatePlan plan = this.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        List plans = plan.getUpdatePlans();
        TestBatchedUpdatePlanner.assertEquals((String)"Number of child plans did not match expected", (int)expectedBatching.length, (int)plans.size());
        for (int i = 0; i < expectedBatching.length; ++i) {
            this.helpAssertIsBatchedPlan((RelationalPlan)plans.get(i), expectedBatching[i]);
        }
    }

    private void helpTestPlanner(String[] sql, boolean[] expectedBatching, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        BatchedUpdatePlan plan = this.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), capFinder, true);
        List plans = plan.getUpdatePlans();
        TestBatchedUpdatePlanner.assertEquals((String)"Number of child plans did not match expected", (int)expectedBatching.length, (int)plans.size());
        for (int i = 0; i < expectedBatching.length; ++i) {
            this.helpAssertIsBatchedPlan((RelationalPlan)plans.get(i), expectedBatching[i]);
        }
    }

    public void testPlannerAllCommandsBatched() throws Exception {
        String[] sql = new String[]{"INSERT INTO pm1.g1 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)", "INSERT INTO pm1.g2 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)", "DELETE FROM pm1.g1 WHERE e2 > 5000", "UPDATE pm1.g1 set e2 = -1 WHERE e2 = 4999"};
        boolean[] expectedBatching = new boolean[]{true};
        this.helpTestPlanner(sql, expectedBatching);
    }

    public void testPlannerNoCommandsBatched() throws Exception {
        String[] sql = new String[]{"INSERT INTO pm1.g1 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)", "INSERT INTO pm1.g2 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)", "DELETE FROM pm1.g1 WHERE e2 > 5000", "UPDATE pm1.g1 set e2 = -1 WHERE e2 = 4999"};
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        finder.addCapabilities("pm1", (SourceCapabilities)new FakeCapabilities(false));
        boolean[] expectedBatching = new boolean[]{false, false, false, false};
        this.helpTestPlanner(sql, expectedBatching, finder);
    }

    public void testPlannerSomeCommandsBatched() throws Exception {
        String[] sql = new String[]{"INSERT INTO pm1.g1 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)", "INSERT INTO pm1.g2 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)", "DELETE FROM pm2.g1 WHERE e2 > 5000", "INSERT INTO pm2.g1 (e1, e2, e3, e4) values ('5000', 5000, {b'true'}, 5000.0)", "UPDATE pm2.g1 set e2 = -1 WHERE e2 = 4999", "DELETE FROM pm1.g2 WHERE e2 = 50"};
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        finder.addCapabilities("pm1", (SourceCapabilities)new FakeCapabilities(false));
        finder.addCapabilities("pm2", (SourceCapabilities)new FakeCapabilities(true));
        boolean[] expectedBatching = new boolean[]{false, false, true, false};
        this.helpTestPlanner(sql, expectedBatching, finder);
    }

    private static final class FakeCapabilities
    extends BasicSourceCapabilities {
        private boolean supportsBatching = false;

        private FakeCapabilities(boolean supportsBatching) {
            this.supportsBatching = supportsBatching;
        }

        public boolean supportsCapability(SourceCapabilities.Capability capability) {
            return !capability.equals((Object)SourceCapabilities.Capability.BATCHED_UPDATES) || this.supportsBatching;
        }
    }
}

