/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.relational.rules.RuleChooseDependent;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.xml.ExecSqlInstruction;
import org.teiid.query.processor.xml.ExecStagingTableInstruction;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.TestXMLProcessor;
import org.teiid.query.processor.xml.XMLPlan;
import org.teiid.query.processor.xml.XMLProgramUtil;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestXMLPlanningEnhancements {
    private TransformationMetadata getMetadata(String query) {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadata();
        Schema xmltest = (Schema)metadata.getMetadataStore().getSchemas().get("XMLTEST");
        QueryNode rsQueryY = new QueryNode(query);
        rsQueryY.addBinding("xmltest.group.items.itemNum");
        rsQueryY.addBinding("xmltest.group.items.itemNum");
        Table rsQY = RealMetadataFactory.createVirtualGroup("suppliersY", xmltest, rsQueryY);
        RealMetadataFactory.createElements(rsQY, new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string"});
        RealMetadataFactory.createXmlDocument("doc18a", xmltest, TestXMLProcessor.createXMLPlanNested("xmltest.suppliersY"));
        return metadata;
    }

    private TransformationMetadata getTempTableMetadata(boolean simpleTempSelect) {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadata();
        Schema xmltest = (Schema)metadata.getMetadataStore().getSchemas().get("XMLTEST");
        RealMetadataFactory.createXmlDocument("docJoin", xmltest, TestXMLPlanningEnhancements.createXMLPlanNestedJoin());
        QueryNode tempQueryJoin = null;
        tempQueryJoin = !simpleTempSelect ? new QueryNode("SELECT stock.orders.* FROM stock.orders") : new QueryNode("SELECT stock.orders.* FROM stock.orders join stock.suppliers on stock.orders.supplierFK=stock.suppliers.supplierNum");
        Table tempJoin = RealMetadataFactory.createXmlStagingTable("docJoin.orders", xmltest, tempQueryJoin);
        QueryNode rsQueryJoin = null;
        if (!simpleTempSelect) {
            rsQueryJoin = new QueryNode("SELECT orderNum, orderDate, orderQty, orderStatus FROM docJoin.orders join stock.suppliers on docJoin.orders.supplierFK=stock.suppliers.supplierNum WHERE itemFK = ? AND supplierNameFK = ?");
            rsQueryJoin.addBinding("xmltest.group.items.itemNum");
            rsQueryJoin.addBinding("xmltest.suppliers.supplierName");
        } else {
            rsQueryJoin = new QueryNode("SELECT orderNum, orderDate, orderQty, orderStatus FROM docJoin.orders WHERE supplierNameFK = ?");
            rsQueryJoin.addBinding("xmltest.suppliers.supplierName");
        }
        Table rsJoin = RealMetadataFactory.createVirtualGroup("ordersC", xmltest, rsQueryJoin);
        RealMetadataFactory.createElements(tempJoin, new String[]{"orderNum", "itemFK", "supplierFK", "supplierNameFK", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "string", "string", "string", "integer", "string"});
        RealMetadataFactory.createElements(rsJoin, new String[]{"orderNum", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "integer", "string"});
        return metadata;
    }

    private static MappingDocument createXMLPlanNestedJoin() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        root.setStagingTables(Arrays.asList("xmltest.docJoin.orders"));
        MappingElement cats = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        MappingElement nestedWrapper = item.addChildElement(new MappingElement("Suppliers"));
        MappingElement supplier = nestedWrapper.addChildElement(new MappingElement("Supplier"));
        supplier.setSource("xmltest.suppliers");
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", "xmltest.suppliers.supplierNum"));
        supplier.addChildElement(new MappingElement("Name", "xmltest.suppliers.supplierName"));
        supplier.addChildElement(new MappingElement("Zip", "xmltest.suppliers.supplierZipCode"));
        MappingElement ordersWrapper = supplier.addChildElement(new MappingElement("Orders"));
        MappingElement order = ordersWrapper.addChildElement(new MappingElement("Order"));
        order.setSource("xmltest.ordersC");
        order.setMaxOccurrs(-1);
        order.addAttribute(new MappingAttribute("OrderID", "xmltest.ordersC.orderNum"));
        order.addChildElement(new MappingElement("OrderDate", "xmltest.ordersC.orderDate"));
        order.addChildElement(new MappingElement("OrderQuantity", "xmltest.ordersC.orderQty"));
        order.addChildElement(new MappingElement("OrderStatus", "xmltest.ordersC.orderStatus")).setMinOccurrs(0);
        return doc;
    }

    @Test
    public void testThreeWayOrWithNestedSiblings() throws Exception {
        QueryMetadataInterface metadata = TestXMLProcessor.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNestedWithSibling(metadata);
        String resultFile = "TestXMLPlanningEnhancements-testThreeWayOrWithNestedSiblings.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("select * from xmltest.doc9c where itemid='003' or supplierid = '600' or orderid = '1'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testBaseballPlayersDocDefect19541() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleCase3225();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerCase3225((QueryMetadataInterface)metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<BaseballPlayers>\r\n   <Player PlayerID=\"1001\">\r\n      <FirstName>Albert</FirstName>\r\n      <LastName>Pujols</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1002\">\r\n      <FirstName>Jim</FirstName>\r\n      <LastName>Edmunds</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1003\">\r\n      <FirstName>David</FirstName>\r\n      <LastName>Eckstein</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n</BaseballPlayers>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("select * from xmltest.playersDoc where owner.@ownerid = '1009'", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria5c() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5c.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE NOT(SupplierID='52') AND (OrderID='5' OR OrderID='2')", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria5d() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5d.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE OrderID='5' OR context(SupplierID, OrderID)='2'", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria5d1() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5d.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(SupplierID, OrderID)='5' OR OrderID='2'", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria5e() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5e.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE OrderID='5' OR SupplierID='52'", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testXQTChoice_6796() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager((QueryMetadataInterface)metadata);
        String resultFile = "TestXMLProcessor-testXQTChoice_6796.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc4 WHERE root.key.keys.nestedkey = 4", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testOrderByWithChoiceCriteriaElement() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager((QueryMetadataInterface)metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n</root>";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc5 order by root.wrapper.key", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testXQTChoice_withContextCriteria() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager((QueryMetadataInterface)metadata);
        String resultFile = "TestXMLProcessor-testXQTChoice_withContextCriteria.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc4 WHERE context(root.key.keys.nestedkey, root.key.keys.nestedkey) = 4", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testXQTChoice_withContextCriteria1() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager((QueryMetadataInterface)metadata);
        String resultFile = "TestXMLProcessor-testXQTChoice_withContextCriteria1.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc4 WHERE context(root.key.keys.nestedkey, root.key.keys.nestedkey) = 4 and context(root.wrapper.key.keys.nestedkey, root.wrapper.key.keys.nestedkey) = 3", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testMappingClassWithInlineViewAndCriteria() throws Exception {
        TransformationMetadata metadata = this.getMetadata("SELECT upper(x.supplierNum) as supplierNum, x.supplierName, x.supplierZipCode from (select stock.suppliers.supplierNum, supplierName, supplierZipCode, itemNum FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum) x where x.itemNum = ?");
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLPlanningEnhancements-testMappingClassWithStoredProcedureAndCriteria.xml");
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18a where supplierID<56", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testMappingClassWithUnionAndCriteria() throws Exception {
        TransformationMetadata metadata = this.getMetadata("SELECT concat(stock.suppliers.supplierNum, '') as supplierNum, supplierName, supplierZipCode FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.itemNum = ? union all SELECT concat(stock.suppliers.supplierNum, '1'), supplierName, convert(12345, string) FROM stock.suppliers WHERE stock.suppliers.supplierNum = ?");
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLPlanningEnhancements-testMappingClassWithStoredProcedureAndCriteria.xml");
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18a where supplierID<56", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testMappingClassWithInputSetElementNameConflict() throws Exception {
        TransformationMetadata metadata = this.getMetadata("SELECT concat(stock.suppliers.supplierNum, '') as supplierNum, supplierName, supplierZipCode FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.supplierNum = ?");
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Catalogs>\n<Catalog>\n<Items/>\n</Catalog>\n</Catalogs>";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18a where supplierID<56", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Ignore(value="Will plan with a dependent join")
    @Test
    public void testAutoStagingFailsForMappingClassWithProcRelational() throws Exception {
        TransformationMetadata metadata = this.getMetadata("SELECT supplierNum, supplierName, supplierZipCode FROM v1.supplierProc where itemnum = ?");
        Schema v1 = RealMetadataFactory.createVirtualModel("v1", (MetadataStore)metadata.getMetadataStore());
        ColumnSet<Procedure> rs1 = RealMetadataFactory.createResultSet("v1.rs1", new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string"});
        ProcedureParameter rs1p2 = RealMetadataFactory.createParameter("itemNum", 1, "string");
        QueryNode n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT concat(stock.suppliers.supplierNum, '') as supplierNum, supplierName, supplierZipCode FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.itemNum = v1.supplierProc.itemNum; END");
        Procedure vt1 = RealMetadataFactory.createVirtualProcedure("supplierProc", v1, Arrays.asList(rs1p2), n1);
        vt1.setResultSet(rs1);
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLPlanningEnhancements-testMappingClassWithStoredProcedureAndCriteria.xml");
        XMLPlan plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18a where supplierID<56", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
        Map<Class<?>, List<ProcessorInstruction>> stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertNull(stats.get(ExecStagingTableInstruction.class));
    }

    @Test
    public void testMappingClassWitSelectDistinctAndCriteria() throws Exception {
        TransformationMetadata metadata = this.getMetadata("SELECT distinct '1' as supplierNum, '2' as supplierName, '3' as supplierZipCode FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.itemNum like substring(?,1,1) || '%'");
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLPlanningEnhancements-testMappingClassWitSelectDistinctAndCriteria.xml");
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18a", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testMappingClassWithStoredProcedureAndCriteria() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLPlanningEnhancements-testMappingClassWithStoredProcedureAndCriteria.xml");
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18 where supplierID<56", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    public void defer_testXMLQueryWithFalseRootCriteria() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String expectedDoc = "";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18 where 1 = 0", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
    }

    @Test
    public void testAutoStagingByCosting() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadata();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        Table suppliers = metadata.getGroupID("stock.suppliers");
        Table itemSuppliers = metadata.getGroupID("stock.item_supplier");
        suppliers.setCardinality(10);
        itemSuppliers.setCardinality(10);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
        Map<Class<?>, List<ProcessorInstruction>> stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertEquals((long)2L, (long)stats.get(ExecStagingTableInstruction.class).size());
    }

    @Ignore(value="Will use a dependent join instead")
    @Test
    public void testAutoStagingFailsByCosting() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadata();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        Table suppliers = metadata.getGroupID("stock.suppliers");
        Table itemSuppliers = metadata.getGroupID("stock.item_supplier");
        suppliers.setCardinality(10000);
        itemSuppliers.setCardinality(10000);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
        Map<Class<?>, List<ProcessorInstruction>> stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertNull(stats.get(ExecStagingTableInstruction.class));
    }

    @Ignore(value="Will use dependent join instead")
    @Test
    public void testAutoStagingFailsByNoCache() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 OPTION NOCACHE", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
        Map<Class<?>, List<ProcessorInstruction>> stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertNull(stats.get(ExecStagingTableInstruction.class));
    }

    @Ignore(value="Will use dependent join")
    @Test
    public void testAutoStagingFailsByNoCacheByGroup() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 OPTION NOCACHE XMLTEST.SUPPLIERS", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
        Map<Class<?>, List<ProcessorInstruction>> stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertNull(stats.get(ExecStagingTableInstruction.class));
        plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 OPTION NOCACHE XMLTEST.SUPPLIERS", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
        stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertNull(stats.get(ExecStagingTableInstruction.class));
    }

    @Test
    public void testUseOfStagingCardinalityOnDependentJoinsNoCost() throws Exception {
        TransformationMetadata metadata = this.getTempTableMetadata(false);
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan xmlPlan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.docJoin", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
        Map<Class<?>, List<ProcessorInstruction>> stats = XMLProgramUtil.getProgramStats(xmlPlan.getOriginalProgram());
        List<ProcessorInstruction> list = stats.get(ExecSqlInstruction.class);
        ExecSqlInstruction instr = (ExecSqlInstruction)list.get(2);
        ProcessorPlan plan = instr.info.getPlan();
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0});
        TestOptimizer.checkDependentJoinCount(plan, 1);
    }

    @Test
    public void testUseOfStagingCardinalityOnDependentJoinsWithCost() throws Exception {
        TransformationMetadata metadata = this.getTempTableMetadata(false);
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        Table orders = metadata.getGroupID("stock.orders");
        Table suppliers = metadata.getGroupID("stock.suppliers");
        orders.setCardinality(255);
        suppliers.setCardinality(RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY - 1);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan xmlPlan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.docJoin", (QueryMetadataInterface)metadata, dataMgr, null, TestOptimizer.getGenericFinder(false), expectedDoc);
        Map<Class<?>, List<ProcessorInstruction>> stats = XMLProgramUtil.getProgramStats(xmlPlan.getOriginalProgram());
        List<ProcessorInstruction> list = stats.get(ExecSqlInstruction.class);
        ExecSqlInstruction instr = (ExecSqlInstruction)list.get(2);
        ProcessorPlan plan = instr.info.getPlan();
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkDependentJoinCount(plan, 1);
    }

    @Test
    public void testNoRedundentStagingTables() throws Exception {
        TransformationMetadata metadata = this.getTempTableMetadata(true);
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        Table suppliers = metadata.getGroupID("stock.suppliers");
        Table orders = metadata.getGroupID("stock.orders");
        suppliers.setCardinality(10);
        orders.setCardinality(10);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-OnlySupplier51.xml");
        XMLPlan xmlPlan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.docJoin where context(Supplier, SupplierID) = 51", expectedDoc, (QueryMetadataInterface)metadata, dataMgr);
        Map<Class<?>, List<ProcessorInstruction>> stats = XMLProgramUtil.getProgramStats(xmlPlan.getOriginalProgram());
        Assert.assertEquals((long)4L, (long)stats.get(ExecStagingTableInstruction.class).size());
    }
}

