/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class TestMatchCriteria {
    public static MatchCriteria example(String element, String str) {
        MatchCriteria crit = new MatchCriteria();
        crit.setLeftExpression((Expression)new ElementSymbol(element));
        crit.setRightExpression((Expression)new Constant((Object)str));
        return crit;
    }

    public static MatchCriteria example(String str) {
        MatchCriteria crit = new MatchCriteria();
        crit.setLeftExpression((Expression)new ElementSymbol("m.g1.e1"));
        crit.setRightExpression((Expression)new Constant((Object)str));
        return crit;
    }

    public static MatchCriteria example(String str, char escapeChar) {
        MatchCriteria crit = new MatchCriteria();
        crit.setLeftExpression((Expression)new ElementSymbol("m.g1.e1"));
        crit.setRightExpression((Expression)new Constant((Object)str));
        crit.setEscapeChar(escapeChar);
        return crit;
    }

    @Test
    public void testEquals1() {
        MatchCriteria c1 = TestMatchCriteria.example("abc");
        MatchCriteria c2 = TestMatchCriteria.example("abc");
        Assert.assertTrue((String)("Equivalent match criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    @Test
    public void testEquals2() {
        MatchCriteria c1 = TestMatchCriteria.example("abc", '#');
        c1.setNegated(true);
        MatchCriteria c2 = TestMatchCriteria.example("abc", '#');
        c2.setNegated(true);
        Assert.assertTrue((String)("Equivalent match criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    @Test
    public void testEquals3() {
        MatchCriteria c1 = TestMatchCriteria.example("abc", '#');
        c1.setNegated(true);
        MatchCriteria c2 = (MatchCriteria)c1.clone();
        Assert.assertTrue((String)("Equivalent match criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    @Test
    public void testEquals4() {
        MatchCriteria c1 = TestMatchCriteria.example("abc");
        MatchCriteria c2 = TestMatchCriteria.example("abc", '#');
        Assert.assertTrue((String)("Different match criteria compare as equal: " + c1 + ", " + c2), (!c1.equals((Object)c2) ? 1 : 0) != 0);
    }

    @Test
    public void testEquals5() {
        MatchCriteria c1 = TestMatchCriteria.example("e1", "abc");
        MatchCriteria c2 = TestMatchCriteria.example("e2", "abc");
        Assert.assertTrue((String)("Different match criteria compare as equal: " + c1 + ", " + c2), (!c1.equals((Object)c2) ? 1 : 0) != 0);
    }

    @Test
    public void testSelfEquivalence() {
        MatchCriteria c1 = TestMatchCriteria.example("abc");
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c1);
    }

    @Test
    public void testEquivalence() {
        MatchCriteria c1 = TestMatchCriteria.example("abc");
        MatchCriteria c2 = TestMatchCriteria.example("abc");
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    @Test
    public void testCloneEquivalence() {
        MatchCriteria c1 = TestMatchCriteria.example("abc");
        MatchCriteria c2 = (MatchCriteria)c1.clone();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    @Test
    public void testNonEquivalence1() {
        MatchCriteria c1 = TestMatchCriteria.example("e1", "abc");
        MatchCriteria c2 = TestMatchCriteria.example("ozzy", '#');
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    @Test
    public void testNonEquivalence2() {
        MatchCriteria c1 = TestMatchCriteria.example("abc", '#');
        c1.setNegated(true);
        MatchCriteria c2 = TestMatchCriteria.example("abc", '#');
        c2.setNegated(false);
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }
}

