/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client.impl;

import java.sql.ResultSet;
import java.util.Properties;
import org.teiid.test.client.QueryScenario;
import org.teiid.test.client.TestResult;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class QueryScenarioImpl
extends QueryScenario {
    public QueryScenarioImpl(String scenarioName, Properties queryProperties) {
        super(scenarioName, queryProperties);
    }

    @Override
    public void handleTestResult(TestResult tr, ResultSet resultSet, int updateCnt, boolean resultFromQuery, String sql) {
        Throwable resultException = tr.getException();
        if (this.getResultsMode().equalsIgnoreCase("compare")) {
            Object results = null;
            try {
                results = this.getExpectedResults(tr.getQuerySetID()).compareResults(tr.getQueryID(), sql, resultSet, resultException, tr.getStatus(), this.isOrdered(sql), updateCnt, resultFromQuery);
                if (results == null) {
                    tr.setStatus(0);
                } else {
                    tr.setStatus(1);
                    tr.setExceptionMessage("Results did not compare to expected results");
                }
            }
            catch (QueryTestFailedException qtf) {
                resultException = resultException != null ? resultException : qtf;
                tr.setException(resultException);
                tr.setStatus(1);
            }
            if (tr.getStatus() == 1) {
                try {
                    this.getResultsGenerator().generateErrorFile(tr.getQuerySetID(), tr.getQueryID(), sql, resultSet, resultException, results);
                }
                catch (QueryTestFailedException qtfe) {
                    throw new TransactionRuntimeException(qtfe.getMessage());
                }
            }
        } else {
            if (this.getResultsMode().equalsIgnoreCase("generate")) {
                try {
                    this.getResultsGenerator().generateQueryResultFile(tr.getQuerySetID(), tr.getQueryID(), sql, resultSet, resultException, tr.getStatus());
                }
                catch (QueryTestFailedException qtfe) {
                    throw new TransactionRuntimeException(qtfe.getMessage());
                }
            }
            if (tr.getException() != null) {
                tr.setStatus(1);
                try {
                    this.getResultsGenerator().generateErrorFile(tr.getQuerySetID(), tr.getQueryID(), sql, resultSet, resultException, null);
                }
                catch (QueryTestFailedException qtfe) {
                    throw new TransactionRuntimeException(qtfe.getMessage());
                }
            }
        }
    }

    private boolean isOrdered(String sql) {
        return sql.toLowerCase().indexOf(" order by ") > 0;
    }
}

