/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.nio.charset.Charset;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.client.DQP;
import org.teiid.client.ResultsMessage;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.XMLType;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TestAllResultsImpl;

public class TestResultSet {
    private static final int BATCH_SIZE = 400;
    public static final int PROC_BATCH_SIZE = 100;

    @Test
    public void testNext1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assert.assertEquals((String)" Actual doesn't match with expected. ", (Object)new Integer(0), (Object)new Integer(cs.getRow()));
        cs.close();
    }

    @Test
    public void testNext2() throws SQLException {
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(1000);
        ResultSetImpl cs = this.helpExecuteQuery();
        int i = 0;
        while (cs.next()) {
            Assert.assertEquals((String)" Actual doesn't match with expected. ", expected[i], (Object)cs.getCurrentRecord());
            Assert.assertEquals((long)((i < 800 ? 400 : 200) - i % 400 - 1), (long)cs.available());
            ++i;
        }
        cs.close();
    }

    @Test
    public void testNextBeyondEnd_fetchEqualsCount() throws Exception {
        this.helpTestNextBeyondResultSet(1000, 1000);
    }

    @Test
    public void testNextBeyondEnd_fetchLessThanCount() throws Exception {
        this.helpTestNextBeyondResultSet(100, 1000);
    }

    @Test
    public void testNextBeyondEnd_fetchLessThanCount1() throws Exception {
        this.helpTestNextBeyondResultSet(100, 101);
    }

    @Test
    public void testNextBeyondEnd_fetchLessThanCountNonMultiple() throws Exception {
        this.helpTestNextBeyondResultSet(120, 1000);
    }

    @Test
    public void testNextBeyondEnd_fetchGreaterThanCount() throws Exception {
        this.helpTestNextBeyondResultSet(300, 100);
    }

    @Test
    public void testNextBeyondEnd_fetchGreaterThanCountNonMultiple() throws Exception {
        this.helpTestNextBeyondResultSet(310, 50);
    }

    @Test
    public void testNextBeyondEnd_fetchGreaterThanCountNonMultiple2() throws Exception {
        this.helpTestNextBeyondResultSet(300, 110);
    }

    @Test
    public void testNextBeyondEnd_fetchLessThanCount_ResultsBetweenFetchAndProcBatch() throws Exception {
        this.helpTestNextBeyondResultSet(30, 75);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void helpTestNextBeyondResultSet(int fetchSize, int numRows) throws Exception {
        try (ResultSetImpl cs = this.helpExecuteQuery(fetchSize, numRows, 1004);){
            Object lastRowValue = null;
            for (int rowNum = 1; rowNum <= numRows; ++rowNum) {
                Assert.assertEquals((String)"Should return true before end cs.next()", (Object)true, (Object)cs.next());
            }
            lastRowValue = cs.getObject(1);
            for (int i = numRows + 1; i < numRows + 4; ++i) {
                Assert.assertEquals((String)("Should return false when going past the end: " + i), (Object)false, (Object)cs.next());
                Assert.assertEquals((String)("Is after last should be true: " + i), (Object)true, (Object)cs.isAfterLast());
            }
            cs.previous();
            Assert.assertEquals((String)"Is last should be true", (Object)true, (Object)cs.isLast());
            Assert.assertEquals((String)"Not on last row", (Object)lastRowValue, (Object)cs.getObject(1));
        }
    }

    @Test
    public void testBidirection() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assert.assertNotNull((Object)cs);
        cs.absolute(290);
        Assert.assertEquals((String)" Actual value doesn't match with expected one.", (Object)new Integer(290), cs.getCurrentRecord().get(0));
        cs.next();
        Assert.assertEquals((String)" Actual value doesn't match with expected one.", (Object)new Integer(291), cs.getCurrentRecord().get(0));
        cs.next();
        Assert.assertEquals((String)" Actual value doesn't match with expected one.", (Object)new Integer(292), cs.getCurrentRecord().get(0));
        cs.previous();
        Assert.assertEquals((String)" Actual value doesn't match with expected one.", (Object)new Integer(291), cs.getCurrentRecord().get(0));
        cs.next();
        Assert.assertEquals((String)" Actual value doesn't match with expected one.", (Object)new Integer(292), cs.getCurrentRecord().get(0));
        cs.close();
    }

    @Test
    public void testHasNext1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assert.assertEquals((String)" hasNext() doesn't match expected value. ", (Object)true, (Object)cs.hasNext());
        cs.close();
    }

    @Test
    public void testHasNext2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(100);
        Assert.assertEquals((String)" hasNext() doesn't match expected value. ", (Object)true, (Object)cs.hasNext());
        cs.close();
    }

    @Test
    public void testHasNext3() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        for (int i = 0; cs.next() && i != 289; ++i) {
        }
        Assert.assertEquals((String)" hasNext() doesn't match expected value. ", (Object)true, (Object)cs.hasNext());
        cs.close();
    }

    @Test
    public void testHasNext4() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(1000);
        Assert.assertTrue((!cs.hasNext() ? 1 : 0) != 0);
        cs.close();
    }

    @Test
    public void testPrevious1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(1000);
        while (cs.next()) {
        }
        Assert.assertEquals((String)" current row doesn't match expected value. ", (long)0L, (long)cs.getRow());
        int i = 1000;
        while (cs.previous()) {
            Assert.assertEquals((String)" Actual doesn't match with expected. ", expected[i - 1], (Object)cs.getCurrentRecord());
            --i;
        }
        Assert.assertEquals((String)" current row doesn't match expected value. ", (long)0L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testPrevious2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(290);
        Assert.assertTrue((boolean)cs.previous());
        Assert.assertEquals((String)" current row doesn't match expected value. ", (long)289L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testPrevious3() throws Exception {
        ResultSetImpl cs = this.helpExecuteQuery(600, 10000, 1004);
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(10000);
        while (cs.next()) {
        }
        Assert.assertEquals((String)" current row doesn't match expected value. ", (long)0L, (long)cs.getRow());
        int i = 10000;
        while (cs.previous()) {
            Assert.assertEquals((String)" Actual doesn't match with expected. ", expected[i - 1], (Object)cs.getCurrentRecord());
            --i;
        }
        Assert.assertEquals((String)" current row doesn't match expected value. ", (long)0L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testPrevious4() throws Exception {
        ResultSetImpl cs = this.helpExecuteQuery(50, 1000, 1004);
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(1000);
        while (cs.next()) {
        }
        Assert.assertEquals((String)" current row doesn't match expected value. ", (long)0L, (long)cs.getRow());
        int i = 1000;
        while (cs.previous()) {
            Assert.assertEquals((String)" Actual doesn't match with expected. ", expected[i - 1], (Object)cs.getCurrentRecord());
            --i;
        }
        Assert.assertEquals((String)" current row doesn't match expected value. ", (long)0L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testChangeDirection() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(291);
        cs.previous();
        Assert.assertEquals((String)" current row doesn't match expected value. ", (long)290L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testIsFirst() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assert.assertTrue((boolean)cs.isFirst());
        cs.close();
    }

    @Test
    public void testIsLast1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assert.assertTrue((!cs.isLast() ? 1 : 0) != 0);
        cs.close();
    }

    @Test
    public void testIsLast2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        for (int i = 0; cs.next() && i != 99; ++i) {
        }
        Assert.assertTrue((!cs.isLast() ? 1 : 0) != 0);
        cs.close();
    }

    @Test
    public void testIsLast3() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(1000);
        Assert.assertTrue((boolean)cs.isLast());
        cs.close();
    }

    @Test
    public void testIsBeforeFirst() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assert.assertTrue((boolean)cs.isBeforeFirst());
        cs.close();
    }

    @Test
    public void testBeforeFirst() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)1L, (long)cs.getRow());
        cs.beforeFirst();
        Assert.assertTrue((boolean)cs.isBeforeFirst());
        cs.close();
    }

    @Test
    public void testFirst() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)2L, (long)cs.getRow());
        cs.first();
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)1L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testAfterLast() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.afterLast();
        Assert.assertTrue((boolean)cs.isAfterLast());
        cs.close();
    }

    @Test
    public void testIsAfterLast1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(1000);
        cs.next();
        Assert.assertTrue((boolean)cs.isAfterLast());
        cs.close();
    }

    @Test
    public void testIsAfterLast2() throws Exception {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assert.assertTrue((!cs.isAfterLast() ? 1 : 0) != 0);
        cs.close();
    }

    @Test
    public void testAbsolute1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)2L, (long)cs.getRow());
        cs.absolute(1);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)1L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testAbsolute2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)2L, (long)cs.getRow());
        cs.absolute(3);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)3L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testAbsolute3() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)2L, (long)cs.getRow());
        cs.absolute(100);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)100L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testAbsolute4() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)2L, (long)cs.getRow());
        cs.absolute(200);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)200L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testAbsolute5() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)2L, (long)cs.getRow());
        cs.absolute(-1);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)1000L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testAbsolute6() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(1005);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)0L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testRelative1() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(3);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)3L, (long)cs.getRow());
        cs.relative(137);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)140L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testRelative2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(137);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)137L, (long)cs.getRow());
        cs.relative(-133);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)4L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testRelative3() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(137);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)137L, (long)cs.getRow());
        cs.relative(-37);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)100L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testRelative4() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(237);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)237L, (long)cs.getRow());
        cs.relative(-200);
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)37L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testGetRow1() throws SQLException {
        int i;
        ResultSetImpl cs = this.helpExecuteQuery();
        for (i = 0; cs.next() && i != 102; ++i) {
        }
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)(i + 1), (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testGetRow2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)1L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testGetRow3() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        for (int i = 0; cs.next() && i != 99; ++i) {
        }
        Assert.assertEquals((String)" Current row number doesn't match with expected one.", (long)100L, (long)cs.getRow());
        cs.close();
    }

    @Test
    public void testGetCurrentRecord() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.absolute(103);
        Assert.assertEquals((String)" Current record doesn't match with expected one.", (Object)new Integer(103), cs.getCurrentRecord().get(0));
        cs.close();
    }

    @Test
    public void testClose() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assert.assertEquals((String)" Actual doesn't match with expected. ", (Object)new Integer(0), (Object)new Integer(cs.getRow()));
        cs.close();
    }

    @Test
    public void testGetMetaData() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        List<String> columnName = this.getBQTRSMetaData1a();
        List<Integer> columnType = this.getBQTRSMetaData1b();
        List<String> columnTypeName = this.getBQTRSMetaData1c();
        ResultSetMetaData rm = cs.getMetaData();
        Assert.assertNotNull((Object)rm);
        for (int j = 1; j <= rm.getColumnCount(); ++j) {
            Assert.assertEquals((String)" Actual doesn't match with expected. ", (Object)columnName.get(j - 1), (Object)rm.getColumnLabel(j));
            Assert.assertEquals((String)" Actual doesn't match with expected. ", (Object)columnType.get(j - 1), (Object)new Integer(rm.getColumnType(j)));
            Assert.assertEquals((String)" Actual doesn't match with expected. ", (Object)columnTypeName.get(j - 1), (Object)rm.getColumnTypeName(j));
        }
        cs.close();
    }

    @Test
    public void testFindColumn() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        ResultSetMetaData rm = cs.getMetaData();
        Assert.assertNotNull((Object)rm);
        Assert.assertEquals((String)" Actual columnName doesn't match with expected. ", (long)1L, (long)cs.findColumn("IntKey"));
        cs.close();
    }

    @Test
    public void testFindNonExistentColumn() throws SQLException {
        ResultSetImpl rs = this.helpExecuteQuery();
        rs.next();
        try {
            rs.findColumn("BOGUS");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            rs.getObject("BOGUS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        rs.close();
    }

    @Test
    public void testGetStatement() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assert.assertNotNull((Object)cs.getStatement());
        cs.close();
    }

    @Test
    public void testGetPlanDescription() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assert.assertNotNull((Object)cs);
        Assert.assertNull((Object)cs.getStatement().getPlanDescription());
        cs.close();
    }

    @Test
    public void testGetObject2() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assert.assertEquals((String)" Actual value doesn't match with expected. ", (Object)new Integer(1), (Object)cs.getObject("IntKey"));
        cs.close();
    }

    @Test
    public void testGetWarnings() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assert.assertNull((Object)cs.getWarnings());
        cs.close();
    }

    @Test
    public void testGetCursorName() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        Assert.assertNull((Object)cs.getCursorName());
        cs.close();
    }

    @Test
    public void testAllGetters() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assert.assertEquals((String)" Actual value of getInt() doesn't match with expected one. ", (long)1L, (long)cs.getInt("IntKey"));
        Assert.assertEquals((String)" Actual value of getString() doesn't match with expected one. ", (Object)"1", (Object)cs.getString("IntKey"));
        Assert.assertEquals((String)" Actual value of getFloat() doesn't match with expected one. ", (Object)new Float(1.0f), (Object)new Float(cs.getFloat("IntKey")));
        Assert.assertEquals((String)" Actual value of getLong() doesn't match with expected one. ", (long)1L, (long)cs.getLong("IntKey"));
        Assert.assertEquals((String)" Actual value of getDouble() doesn't match with expected one. ", (Object)new Double(1.0), (Object)new Double(cs.getDouble("IntKey")));
        Assert.assertEquals((String)" Actual value of getByte() doesn't match with expected one. ", (long)1L, (long)cs.getByte("IntKey"));
    }

    @Test
    public void testWasNull() throws SQLException {
        ResultSetImpl cs = this.helpExecuteQuery();
        cs.next();
        Assert.assertNotNull((Object)cs.getObject("IntKey"));
        Assert.assertFalse((boolean)cs.wasNull());
    }

    @Test
    public void testForwardOnly() throws Exception {
        ResultSetImpl cs = this.helpExecuteQuery(400, 1300, 1003);
        int i = 0;
        while (cs.next()) {
            if (++i <= 1200) {
                Assert.assertNotNull((Object)cs.getPrefetch());
            } else {
                Assert.assertNull((Object)cs.getPrefetch());
            }
            cs.getObject(1);
        }
        Assert.assertTrue((boolean)cs.isAfterLast());
        cs.close();
    }

    @Test
    public void testForwardOnlyPrefetchSmallFetchSize() throws Exception {
        StatementImpl statement = TestResultSet.createMockStatement(1003);
        ResultSetImpl cs = TestAllResultsImpl.helpTestBatching(statement, 10, 128, 256, true);
        for (int i = 0; i < 256; ++i) {
            cs.next();
            cs.getObject(1);
        }
        ((DQP)Mockito.verify((Object)statement.getDQP(), (VerificationMode)Mockito.atMost((int)1))).processCursorRequest(0L, 11, 10);
        Assert.assertFalse((boolean)cs.next());
        Assert.assertTrue((boolean)cs.isAfterLast());
        cs.close();
    }

    @Test
    public void testOutputParameter() throws Exception {
        StatementImpl statement = TestResultSet.createMockStatement(1003);
        ResultsMessage resultsMsg = new ResultsMessage();
        resultsMsg.setResults(new List[]{Arrays.asList(1, null, null), Arrays.asList(null, 2, 3)});
        resultsMsg.setLastRow(2);
        resultsMsg.setFirstRow(1);
        resultsMsg.setFinalRow(2);
        resultsMsg.setColumnNames(new String[]{"x", "out1", "out2"});
        resultsMsg.setDataTypes(new String[]{"integer", "integer", "integer"});
        ResultSetImpl cs = new ResultSetImpl(resultsMsg, statement, null, 2);
        int count = 0;
        while (cs.next()) {
            cs.getObject(1);
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertTrue((boolean)cs.isAfterLast());
        Assert.assertEquals((Object)2, (Object)cs.getOutputParamValue(2));
        Assert.assertEquals((Object)3, (Object)cs.getOutputParamValue(3));
    }

    @Test
    public void testXML() throws Exception {
        StatementImpl statement = TestResultSet.createMockStatement(1003);
        ResultsFuture future = new ResultsFuture();
        future.getResultsReceiver().receiveResults((Object)new LobChunk("<a/>".getBytes(Charset.forName("UTF-8")), true));
        XMLType result = new XMLType();
        Mockito.stub((Object)statement.getDQP().requestNextLobChunk(0, 0L, result.getReferenceStreamId())).toReturn((Object)future);
        ResultsMessage resultsMsg = new ResultsMessage();
        result.setEncoding("UTF-8");
        resultsMsg.setResults(new List[]{Arrays.asList(result)});
        resultsMsg.setLastRow(1);
        resultsMsg.setFirstRow(1);
        resultsMsg.setFinalRow(1);
        resultsMsg.setColumnNames(new String[]{"x"});
        resultsMsg.setDataTypes(new String[]{"xml"});
        ResultSetImpl cs = new ResultSetImpl(resultsMsg, statement);
        cs.next();
        Assert.assertEquals((Object)"<a/>", (Object)cs.getString(1));
    }

    private ResultSetImpl helpExecuteQuery() {
        try {
            return this.helpExecuteQuery(400, 1000, 1004);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ResultSetImpl helpExecuteQuery(int fetchSize, int totalResults, int cursorType) throws SQLException, TeiidProcessingException {
        StatementImpl statement = TestResultSet.createMockStatement(cursorType);
        return TestAllResultsImpl.helpTestBatching(statement, fetchSize, Math.min(fetchSize, totalResults), totalResults);
    }

    static StatementImpl createMockStatement(int cursorType) throws SQLException {
        StatementImpl statement = (StatementImpl)Mockito.mock(StatementImpl.class);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        Mockito.stub((Object)statement.getDQP()).toReturn((Object)dqp);
        Mockito.stub((Object)statement.getResultSetType()).toReturn((Object)cursorType);
        TimeZone tz = TimeZone.getTimeZone("GMT-06:00");
        TimeZone serverTz = TimeZone.getTimeZone("GMT-05:00");
        Mockito.stub((Object)statement.getDefaultCalendar()).toReturn((Object)Calendar.getInstance(tz));
        Mockito.stub((Object)statement.getServerTimeZone()).toReturn((Object)serverTz);
        return statement;
    }

    private List<String> getBQTRSMetaData1a() {
        ArrayList<String> results = new ArrayList<String>();
        results.add("IntKey");
        return results;
    }

    private List<Integer> getBQTRSMetaData1b() {
        ArrayList<Integer> results = new ArrayList<Integer>();
        results.add(4);
        return results;
    }

    private List<String> getBQTRSMetaData1c() {
        ArrayList<String> results = new ArrayList<String>();
        results.add("integer");
        return results;
    }
}

