/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.FakeConnector;
import org.teiid.dqp.internal.datamgr.TestConnectorWorkItem;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public final class TestConnectorManager {
    private AtomicRequestMessage request;
    private ConnectorManager csm;

    static ConnectorManager getConnectorManager() throws Exception {
        final FakeConnector c = new FakeConnector();
        ConnectorManager cm = new ConnectorManager("FakeConnector", "FakeConnector"){

            public ExecutionFactory getExecutionFactory() {
                return c;
            }

            public Object getConnectionFactory() {
                return c;
            }
        };
        cm.start();
        return cm;
    }

    @Before
    public void setUp() throws Exception {
        this.request = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        this.csm = TestConnectorManager.getConnectorManager();
    }

    void helpAssureOneState() throws Exception {
        this.csm.registerRequest(this.request);
        ConnectorWork state = this.csm.getState(this.request.getAtomicRequestID());
        Assert.assertEquals((Object)state, (Object)this.csm.getState(this.request.getAtomicRequestID()));
    }

    @Test
    public void testCreateAndAddRequestState() throws Exception {
        this.helpAssureOneState();
        Assert.assertEquals((String)"Expected size of 1", (long)1L, (long)this.csm.size());
    }

    @Test
    public void testIllegalCreate() throws Exception {
        this.helpAssureOneState();
        try {
            this.helpAssureOneState();
            Assert.fail((String)"expected exception");
        }
        catch (AssertionError e) {
            Assert.assertEquals((Object)"State already existed", (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void testRemoveRequestState() throws Exception {
        this.helpAssureOneState();
        this.csm.removeState(this.request.getAtomicRequestID());
        Assert.assertEquals((String)"Expected size of 0", (long)0L, (long)this.csm.size());
    }

    @Test
    public void testRemoveUnknownRequestState() throws Exception {
        this.helpAssureOneState();
        this.csm.removeState(new AtomicRequestID(new RequestID("ZZZZ", 3210L), 5, 5));
        Assert.assertEquals((String)"Expected size of 1", (long)1L, (long)this.csm.size());
    }

    @Test
    public void testGetCapabilities() throws Exception {
        final Object cf = new Object();
        ExecutionFactory ef = new ExecutionFactory(){

            public boolean isSourceRequiredForCapabilities() {
                return true;
            }
        };
        final Object[] cfHolder = new Object[1];
        ConnectorManager cm = new ConnectorManager("FakeConnector", "FakeConnector", ef){

            public Object getConnectionFactory() {
                return cfHolder[0];
            }
        };
        cm.start();
        try {
            cm.getCapabilities();
            Assert.fail();
        }
        catch (TranslatorException e) {
            // empty catch block
        }
        ef = new ExecutionFactory(){

            public boolean isSourceRequiredForCapabilities() {
                return true;
            }

            public Object getConnection(Object factory, ExecutionContext executionContext) throws TranslatorException {
                Assert.assertEquals((Object)cf, (Object)factory);
                return factory;
            }

            public void closeConnection(Object connection, Object factory) {
            }
        };
        cm = new ConnectorManager("FakeConnector", "FakeConnector", ef){

            public Object getConnectionFactory() {
                return cfHolder[0];
            }
        };
        cfHolder[0] = cf;
        cm.getCapabilities();
    }
}

