/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client.ctc;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teiid.core.util.FileUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.test.client.QueryReader;
import org.teiid.test.client.QueryTest;
import org.teiid.test.client.ctc.XMLQueryVisitationStrategy;
import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class XMLQueryReader
implements QueryReader {
    private Properties props = null;
    private String queryScenarioIdentifier;
    private Map<String, String> querySetIDToFileMap = new HashMap<String, String>();

    public XMLQueryReader(String queryScenarioID, Properties properties) throws QueryTestFailedException {
        this.props = properties;
        this.queryScenarioIdentifier = queryScenarioID;
        this.loadQuerySets();
    }

    @Override
    public List<QueryTest> getQueries(String querySetID) throws QueryTestFailedException {
        String queryFile = this.querySetIDToFileMap.get(querySetID);
        try {
            return this.loadQueries(querySetID, queryFile);
        }
        catch (IOException e) {
            throw new QueryTestFailedException("Failed to load queries from file: " + queryFile + " error:" + e.getMessage());
        }
    }

    @Override
    public Collection<String> getQuerySetIDs() {
        return new HashSet<String>(this.querySetIDToFileMap.keySet());
    }

    private void loadQuerySets() throws QueryTestFailedException {
        String query_dir_loc = this.props.getProperty("queryfiles.loc");
        if (query_dir_loc == null) {
            throw new QueryTestFailedException("queryfiles.loc property was not specified ");
        }
        String query_root_loc = this.props.getProperty("queryfiles.root.dir");
        String loc = query_dir_loc;
        if (query_root_loc != null) {
            File dir = new File(query_root_loc, query_dir_loc);
            loc = dir.getAbsolutePath();
        }
        TestLogger.log("Loading queries from " + loc);
        File[] files = FileUtils.findAllFilesInDirectoryHavingExtension((String)loc, (String)".xml");
        if (files == null || files.length == 0) {
            throw new QueryTestFailedException("No query files found in directory " + loc);
        }
        for (int i = 0; i < files.length; ++i) {
            String queryfile = files[i].getAbsolutePath();
            String querySet = XMLQueryReader.getQuerySetName(queryfile);
            this.querySetIDToFileMap.put(querySet, queryfile);
        }
    }

    private List<QueryTest> loadQueries(String querySetID, String queryFileName) throws IOException {
        File queryFile = new File(queryFileName);
        if (!queryFile.exists() || !queryFile.canRead()) {
            String msg = "Query file doesn't exist or cannot be read: " + queryFileName + ", ignoring and continuing";
            TestLogger.log(msg);
            throw new TransactionRuntimeException(msg);
        }
        XMLQueryVisitationStrategy jstrat = new XMLQueryVisitationStrategy();
        try {
            return jstrat.parseXMLQueryFile(this.queryScenarioIdentifier, queryFile, querySetID);
        }
        catch (Exception e) {
            String msg = "Error reading query file: " + queryFileName + ", " + e.getMessage();
            TestLogger.log(msg);
            throw new IOException(msg);
        }
    }

    private static String getQuerySetName(String queryFileName) {
        String querySet = queryFileName;
        List nameParts = StringUtil.split((String)querySet, (String)"./\\");
        if (nameParts.size() > 1) {
            querySet = (String)nameParts.get(nameParts.size() - 2);
        }
        return querySet;
    }

    public static void main(String[] args) {
        System.setProperty("config", "ctc-bqt-test.properties");
        ConfigPropertyLoader _instance = ConfigPropertyLoader.getInstance();
        Properties p = _instance.getProperties();
        if (p == null || p.isEmpty()) {
            throw new RuntimeException("Failed to load config properties file");
        }
        _instance.setProperty("queryfiles.root.dir", new File("src/main/resources/").getAbsolutePath());
        try {
            XMLQueryReader reader = new XMLQueryReader("scenario_id", _instance.getProperties());
            for (String querySetID : reader.getQuerySetIDs()) {
                List<QueryTest> queries = reader.getQueries(querySetID);
                if ((long)queries.size() != 0L) continue;
                System.out.println("Failed, didn't load any queries ");
            }
        }
        catch (QueryTestFailedException e) {
            e.printStackTrace();
        }
    }
}

