/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.rewriter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.StringUtil;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.language.Like;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.relational.rules.RuleMergeCriteria;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.ObjectTable;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TargetedCommand;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.navigator.DeepPostOrderNavigator;
import org.teiid.query.sql.navigator.PostOrderNavigator;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.ExpressionStatement;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.RaiseStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.XMLCast;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.CorrelatedReferenceCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.UpdateValidator;
import org.teiid.query.validator.ValidationVisitor;

public class QueryRewriter {
    private static final Constant ZERO_CONSTANT = new Constant(0, DataTypeManager.DefaultDataClasses.INTEGER);
    public static final CompareCriteria TRUE_CRITERIA = new CompareCriteria(new Constant(1, DataTypeManager.DefaultDataClasses.INTEGER), 1, new Constant(1, DataTypeManager.DefaultDataClasses.INTEGER));
    public static final CompareCriteria FALSE_CRITERIA = new CompareCriteria(new Constant(1, DataTypeManager.DefaultDataClasses.INTEGER), 1, ZERO_CONSTANT){

        @Override
        public void setOptional(Boolean isOptional) {
        }
    };
    public static final CompareCriteria UNKNOWN_CRITERIA = new CompareCriteria(new Constant(null, DataTypeManager.DefaultDataClasses.STRING), 2, new Constant(null, DataTypeManager.DefaultDataClasses.STRING)){

        @Override
        public void setOptional(Boolean isOptional) {
        }
    };
    private static final Map<String, String> ALIASED_FUNCTIONS = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> PARSE_FORMAT_TYPES = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Integer INTEGER_ZERO;
    private static final Double DOUBLE_ZERO;
    private static final Float FLOAT_ZERO;
    private static final Long LONG_ZERO;
    private static final BigInteger BIG_INTEGER_ZERO;
    private static final BigDecimal BIG_DECIMAL_ZERO;
    private static final Short SHORT_ZERO;
    private static final Byte BYTE_ZERO;
    private boolean rewriteAggs = true;
    private boolean preserveUnknown;
    private QueryMetadataInterface metadata;
    private CommandContext context;
    private boolean rewriteSubcommands;
    private boolean processing;
    private Evaluator evaluator;
    private Map<ElementSymbol, Expression> variables;
    private static Map<String, Integer> FUNCTION_MAP;

    private QueryRewriter(QueryMetadataInterface metadata, CommandContext context) {
        this.metadata = metadata;
        this.context = context;
        this.evaluator = new Evaluator(Collections.emptyMap(), null, context);
    }

    public static Command evaluateAndRewrite(Command command, Evaluator eval, CommandContext context, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
        QueryRewriter queryRewriter = new QueryRewriter(metadata, context);
        queryRewriter.evaluator = eval;
        queryRewriter.rewriteSubcommands = true;
        queryRewriter.processing = true;
        return queryRewriter.rewriteCommand(command, false);
    }

    public static Command rewrite(Command command, QueryMetadataInterface metadata, CommandContext context, Map<ElementSymbol, Expression> variableValues) throws TeiidComponentException, TeiidProcessingException {
        QueryRewriter rewriter = new QueryRewriter(metadata, context);
        rewriter.rewriteSubcommands = true;
        rewriter.variables = variableValues;
        return rewriter.rewriteCommand(command, false);
    }

    public static Command rewrite(Command command, QueryMetadataInterface metadata, CommandContext context) throws TeiidComponentException, TeiidProcessingException {
        return QueryRewriter.rewrite(command, metadata, context, null);
    }

    private Command rewriteCommand(Command command, boolean removeOrderBy) throws TeiidComponentException, TeiidProcessingException {
        boolean oldRewriteAggs = this.rewriteAggs;
        QueryMetadataInterface oldMetadata = this.metadata;
        TempMetadataStore tempMetadata = command.getTemporaryMetadata();
        if (tempMetadata != null) {
            this.metadata = new TempMetadataAdapter(this.metadata, tempMetadata);
        }
        switch (command.getType()) {
            case 1: {
                QueryCommand queryCommand = (QueryCommand)command;
                if (removeOrderBy && queryCommand.getLimit() == null) {
                    queryCommand.setOrderBy(null);
                }
                HashMap<Object, WithQueryCommand> replacements = null;
                if (queryCommand.getWith() != null) {
                    block10: for (WithQueryCommand withQueryCommand : queryCommand.getWith()) {
                        if (withQueryCommand.getColumns() == null) {
                            List<ElementSymbol> columns = ResolverUtil.resolveElementsInGroup(withQueryCommand.getGroupSymbol(), this.metadata);
                            withQueryCommand.setColumns(LanguageObject.Util.deepClone(columns, ElementSymbol.class));
                        }
                        this.rewriteSubqueryContainer(withQueryCommand, true);
                        if (!GroupCollectorVisitor.getGroups((LanguageObject)withQueryCommand.getCommand(), false).isEmpty()) continue;
                        for (Expression expression : FunctionCollectorVisitor.getFunctions((LanguageObject)withQueryCommand.getCommand(), false, true)) {
                            if (!FunctionCollectorVisitor.isNonDeterministic(expression)) continue;
                            continue block10;
                        }
                        if (replacements == null) {
                            replacements = new HashMap<Object, WithQueryCommand>();
                        }
                        replacements.put(withQueryCommand.getGroupSymbol().getMetadataID(), withQueryCommand);
                    }
                }
                if (command instanceof Query) {
                    command = this.rewriteQuery((Query)command, replacements);
                    break;
                }
                command = this.rewriteSetQuery((SetQuery)command);
                break;
            }
            case 6: {
                command = this.rewriteExec((StoredProcedure)command);
                break;
            }
            case 2: {
                command = this.rewriteInsert((Insert)command);
                break;
            }
            case 3: {
                command = this.rewriteUpdate((Update)command);
                break;
            }
            case 4: {
                command = this.rewriteDelete((Delete)command);
                break;
            }
            case 7: {
                command = this.rewriteUpdateProcedure((CreateProcedureCommand)command);
                break;
            }
            case 9: {
                List<Command> subCommands = ((BatchedUpdateCommand)command).getUpdateCommands();
                for (int i = 0; i < subCommands.size(); ++i) {
                    Command subCommand = subCommands.get(i);
                    subCommand = this.rewriteCommand(subCommand, false);
                    subCommands.set(i, subCommand);
                }
                break;
            }
            case 13: {
                TriggerAction ta = (TriggerAction)command;
                ta.setBlock(this.rewriteBlock(ta.getBlock()));
            }
        }
        this.rewriteAggs = oldRewriteAggs;
        this.metadata = oldMetadata;
        return command;
    }

    private Command rewriteUpdateProcedure(CreateProcedureCommand command) throws TeiidComponentException {
        Block block = this.rewriteBlock(command.getBlock());
        command.setBlock(block);
        return command;
    }

    private Block rewriteBlock(Block block) throws TeiidComponentException {
        List<Statement> statements = block.getStatements();
        List<Statement> newStmts = this.rewriteStatements(statements);
        block.setStatements(newStmts);
        if (block.getExceptionStatements() != null) {
            block.setExceptionStatements(this.rewriteStatements(block.getExceptionStatements()));
        }
        return block;
    }

    private List<Statement> rewriteStatements(List<Statement> statements) throws TeiidComponentException {
        Iterator<Statement> stmtIter = statements.iterator();
        ArrayList<Statement> newStmts = new ArrayList<Statement>(statements.size());
        while (stmtIter.hasNext()) {
            Statement stmnt = stmtIter.next();
            try {
                this.rewriteStatement(stmnt, newStmts);
            }
            catch (TeiidProcessingException e) {
                RaiseStatement raise = new RaiseStatement(new Constant((Object)e));
                newStmts.add(raise);
                break;
            }
        }
        return newStmts;
    }

    private void rewriteStatement(Statement statement, List<Statement> newStmts) throws TeiidComponentException, TeiidProcessingException {
        int stmtType = statement.getType();
        switch (stmtType) {
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Criteria ifCrit = ifStmt.getCondition();
                Criteria evalCrit = this.rewriteCriteria(ifCrit);
                ifStmt.setCondition(evalCrit);
                if (evalCrit.equals(TRUE_CRITERIA)) {
                    Block ifblock = this.rewriteBlock(ifStmt.getIfBlock());
                    if (ifblock.isAtomic()) {
                        newStmts.add(ifblock);
                    } else {
                        newStmts.addAll(ifblock.getStatements());
                    }
                    return;
                }
                if (evalCrit.equals(FALSE_CRITERIA) || evalCrit.equals(UNKNOWN_CRITERIA)) {
                    if (ifStmt.hasElseBlock()) {
                        Block elseBlock = this.rewriteBlock(ifStmt.getElseBlock());
                        if (elseBlock.isAtomic()) {
                            newStmts.add(elseBlock);
                        } else {
                            newStmts.addAll(elseBlock.getStatements());
                        }
                        return;
                    }
                    return;
                }
                Block ifblock = this.rewriteBlock(ifStmt.getIfBlock());
                ifStmt.setIfBlock(ifblock);
                if (!ifStmt.hasElseBlock()) break;
                Block elseBlock = this.rewriteBlock(ifStmt.getElseBlock());
                ifStmt.setElseBlock(elseBlock);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                ExpressionStatement exprStmt = (ExpressionStatement)((Object)statement);
                Expression expr = exprStmt.getExpression();
                if (expr == null) break;
                boolean preserveUnknownOld = this.preserveUnknown;
                this.preserveUnknown = true;
                expr = this.rewriteExpressionDirect(expr);
                this.preserveUnknown = preserveUnknownOld;
                exprStmt.setExpression(expr);
                break;
            }
            case 2: {
                Update update;
                CommandStatement cmdStmt = (CommandStatement)statement;
                this.rewriteSubqueryContainer(cmdStmt, false);
                if (cmdStmt.getCommand().getType() != 3 || !(update = (Update)cmdStmt.getCommand()).getChangeList().isEmpty()) break;
                return;
            }
            case 6: {
                LoopStatement loop = (LoopStatement)statement;
                this.rewriteSubqueryContainer(loop, false);
                this.rewriteBlock(loop.getBlock());
                if (!loop.getBlock().getStatements().isEmpty()) break;
                return;
            }
            case 7: {
                WhileStatement whileStatement = (WhileStatement)statement;
                Criteria crit = whileStatement.getCondition();
                crit = this.rewriteCriteria(crit);
                whileStatement.setCondition(crit);
                if (crit.equals(FALSE_CRITERIA) || crit.equals(UNKNOWN_CRITERIA)) {
                    return;
                }
                whileStatement.setBlock(this.rewriteBlock(whileStatement.getBlock()));
                if (!whileStatement.getBlock().getStatements().isEmpty()) break;
                return;
            }
            case 11: {
                statement = this.rewriteBlock((Block)statement);
            }
        }
        newStmts.add(statement);
    }

    private void rewriteSubqueryContainer(SubqueryContainer container, boolean removeOrderBy) throws TeiidComponentException, TeiidProcessingException {
        if (this.rewriteSubcommands && container.getCommand() != null && (((Command)container.getCommand()).getProcessorPlan() == null || this.processing)) {
            container.setCommand(this.rewriteCommand((Command)container.getCommand(), removeOrderBy));
        }
    }

    private Command rewriteQuery(Query query, Map<Object, WithQueryCommand> replacements) throws TeiidComponentException, TeiidProcessingException {
        boolean preserveUnknownOld;
        Criteria having;
        From from = query.getFrom();
        if (from != null) {
            ArrayList<FromClause> clauses = new ArrayList<FromClause>(from.getClauses().size());
            Iterator<FromClause> clauseIter = from.getClauses().iterator();
            while (clauseIter.hasNext()) {
                clauses.add(this.rewriteFromClause(query, clauseIter.next(), replacements));
            }
            from.setClauses(clauses);
        } else {
            query.setOrderBy(null);
        }
        Criteria crit = query.getCriteria();
        if (crit != null) {
            if (query.getIsXML()) {
                this.rewriteExpressions(crit);
            } else {
                boolean preserveUnknownOld2 = this.preserveUnknown;
                this.preserveUnknown = false;
                crit = this.rewriteCriteria(crit);
                this.preserveUnknown = preserveUnknownOld2;
            }
            if (crit == TRUE_CRITERIA) {
                query.setCriteria(null);
            } else if (crit == UNKNOWN_CRITERIA) {
                query.setCriteria(FALSE_CRITERIA);
            } else {
                query.setCriteria(crit);
            }
        }
        if (from != null && !query.getIsXML()) {
            this.rewriteSubqueriesAsJoins(query);
        }
        if ((having = (query = this.rewriteGroupBy(query)).getHaving()) != null) {
            preserveUnknownOld = this.preserveUnknown;
            this.preserveUnknown = false;
            crit = this.rewriteCriteria(having);
            this.preserveUnknown = preserveUnknownOld;
            if (crit == TRUE_CRITERIA) {
                query.setHaving(null);
            } else {
                query.setHaving(crit);
            }
        }
        if (!query.getIsXML()) {
            boolean hasMes = false;
            for (Expression ex : query.getSelect().getSymbols()) {
                if (!(ex instanceof MultipleElementSymbol)) continue;
                hasMes = true;
            }
            if (hasMes) {
                query.getSelect().setSymbols(query.getSelect().getProjectedSymbols());
            }
        }
        preserveUnknownOld = this.preserveUnknown;
        this.preserveUnknown = true;
        this.rewriteExpressions(query.getSelect());
        if (!query.getIsXML()) {
            query = (Query)this.rewriteOrderBy(query);
        }
        this.preserveUnknown = preserveUnknownOld;
        if (query.getLimit() != null) {
            query.setLimit(this.rewriteLimitClause(query.getLimit()));
        }
        if (query.getInto() != null) {
            return this.rewriteSelectInto(query);
        }
        return query;
    }

    private void rewriteSubqueriesAsJoins(Query query) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        if (query.getCriteria() == null) {
            return;
        }
        RuleMergeCriteria rmc = new RuleMergeCriteria(null, null, null, this.context, this.metadata);
        List<Criteria> current = Criteria.separateCriteriaByAnd(query.getCriteria());
        query.setCriteria(null);
        List<GroupSymbol> groups = query.getFrom().getGroups();
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (GroupSymbol gs : groups) {
            names.add(gs.getName());
        }
        Iterator<Criteria> crits = current.iterator();
        while (crits.hasNext()) {
            boolean requiresDistinct;
            RuleMergeCriteria.PlannedResult plannedResult = rmc.findSubquery(crits.next(), this.context != null ? this.context.getOptions().isSubqueryUnnestDefault() : false);
            if (plannedResult.not || plannedResult.query == null || plannedResult.query.getProcessorPlan() != null || plannedResult.query.getWith() != null) continue;
            if (plannedResult.query.getCorrelatedReferences() == null) {
                ArrayList<Reference> correlatedReferences = new ArrayList<Reference>();
                CorrelatedReferenceCollectorVisitor.collectReferences(plannedResult.query, groups, correlatedReferences, this.metadata);
                if (!correlatedReferences.isEmpty()) {
                    SymbolMap map = new SymbolMap();
                    for (Reference reference : correlatedReferences) {
                        map.addMapping(reference.getExpression(), reference.getExpression());
                    }
                    plannedResult.query.setCorrelatedReferences(map);
                }
            }
            if (!rmc.planQuery(groups, requiresDistinct = this.requiresDistinctRows(query), plannedResult)) continue;
            crits.remove();
            GroupSymbol viewName = RulePlaceAccess.recontextSymbol(new GroupSymbol("X"), names);
            viewName.setName(viewName.getName());
            viewName.setDefinition(null);
            Query q = QueryRewriter.createInlineViewQuery(viewName, plannedResult.query, this.metadata, plannedResult.query.getSelect().getProjectedSymbols());
            Iterator<Expression> iter = q.getSelect().getProjectedSymbols().iterator();
            HashMap<Expression, Expression> expressionMap = new HashMap<Expression, Expression>();
            for (Expression symbol : plannedResult.query.getSelect().getProjectedSymbols()) {
                expressionMap.put(SymbolMap.getExpression(symbol), SymbolMap.getExpression(iter.next()));
            }
            for (int i = 0; i < plannedResult.leftExpressions.size(); ++i) {
                plannedResult.nonEquiJoinCriteria.add(new CompareCriteria(SymbolMap.getExpression((Expression)plannedResult.leftExpressions.get(i)), 1, (Expression)plannedResult.rightExpressions.get(i)));
            }
            Criteria mappedCriteria = Criteria.combineCriteria(plannedResult.nonEquiJoinCriteria);
            ExpressionMappingVisitor.mapExpressions(mappedCriteria, expressionMap);
            query.setCriteria(Criteria.combineCriteria(query.getCriteria(), mappedCriteria));
            FromClause clause = q.getFrom().getClauses().get(0);
            if (plannedResult.makeInd) {
                clause.setMakeInd(new Option.MakeDep());
            }
            query.getFrom().addClause(clause);
            query.getTemporaryMetadata().getData().putAll(q.getTemporaryMetadata().getData());
        }
        query.setCriteria(Criteria.combineCriteria(query.getCriteria(), Criteria.combineCriteria(current)));
    }

    private boolean requiresDistinctRows(Query query) {
        HashSet<AggregateSymbol> aggs = new HashSet<AggregateSymbol>();
        aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(query.getSelect(), false));
        aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(query.getHaving(), false));
        if (!aggs.isEmpty() || query.getGroupBy() != null) {
            if (!AggregateSymbol.areAggregatesCardinalityDependent(aggs)) {
                return false;
            }
        } else if (query.getSelect().isDistinct()) {
            for (Expression projectSymbol : query.getSelect().getProjectedSymbols()) {
                Expression ex = SymbolMap.getExpression(projectSymbol);
                if (FunctionCollectorVisitor.isNonDeterministic(ex)) {
                    return true;
                }
                if (ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(ex).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Query rewriteGroupBy(Query query) throws TeiidComponentException, TeiidProcessingException {
        if (query.getGroupBy() == null) {
            this.rewriteAggs = false;
            return query;
        }
        if (QueryRewriter.isDistinctWithGroupBy(query)) {
            query.getSelect().setDistinct(false);
        }
        this.rewriteExpressions(query.getGroupBy());
        List<Expression> expr = query.getGroupBy().getSymbols();
        Iterator<Expression> iter = expr.iterator();
        while (iter.hasNext()) {
            if (!EvaluatableVisitor.willBecomeConstant(iter.next())) continue;
            iter.remove();
        }
        if (expr.isEmpty()) {
            query.setGroupBy(null);
        }
        return query;
    }

    public static boolean isDistinctWithGroupBy(Query query) {
        GroupBy groupBy = query.getGroupBy();
        if (groupBy == null) {
            return false;
        }
        HashSet<Expression> selectExpressions = new HashSet<Expression>();
        for (Expression selectExpr : query.getSelect().getProjectedSymbols()) {
            selectExpressions.add(SymbolMap.getExpression(selectExpr));
        }
        for (Expression groupByExpr : groupBy.getSymbols()) {
            if (selectExpressions.contains(groupByExpr)) continue;
            return false;
        }
        return true;
    }

    private void rewriteExpressions(LanguageObject obj) throws TeiidComponentException, TeiidProcessingException {
        if (obj == null) {
            return;
        }
        ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(null){

            @Override
            public Expression replaceExpression(Expression element) {
                try {
                    return QueryRewriter.this.rewriteExpressionDirect(element);
                }
                catch (TeiidException err) {
                    throw new TeiidRuntimeException((Throwable)err);
                }
            }
        };
        try {
            PostOrderNavigator.doVisit(obj, visitor);
        }
        catch (TeiidRuntimeException err) {
            if (err.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)err.getCause();
            }
            if (err.getCause() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)err.getCause();
            }
            throw err;
        }
    }

    public QueryCommand rewriteOrderBy(QueryCommand queryCommand) throws TeiidComponentException, TeiidProcessingException {
        OrderBy orderBy = queryCommand.getOrderBy();
        if (orderBy == null) {
            return queryCommand;
        }
        Select select = queryCommand.getProjectedQuery().getSelect();
        List<Expression> projectedSymbols = select.getProjectedSymbols();
        QueryRewriter.rewriteOrderBy(queryCommand, orderBy, projectedSymbols, this.context, this.metadata);
        return queryCommand;
    }

    public static void rewriteOrderBy(QueryCommand queryCommand, OrderBy orderBy, List projectedSymbols, CommandContext context, QueryMetadataInterface metadata) throws TeiidComponentException, TeiidProcessingException {
        HashSet<Expression> previousExpressions = new HashSet<Expression>();
        for (int i = 0; i < orderBy.getVariableCount(); ++i) {
            Expression querySymbol = orderBy.getVariable(i);
            int index = orderBy.getExpressionPosition(i);
            querySymbol = index == -1 ? QueryRewriter.rewriteExpression(querySymbol, context, metadata) : (Expression)projectedSymbols.get(index);
            Expression expr = SymbolMap.getExpression(querySymbol);
            if (!previousExpressions.add(expr) || queryCommand instanceof Query && EvaluatableVisitor.willBecomeConstant(expr)) {
                orderBy.removeOrderByItem(i--);
                continue;
            }
            orderBy.getOrderByItems().get(i).setSymbol((Expression)querySymbol.clone());
        }
        if (orderBy.getVariableCount() == 0) {
            queryCommand.setOrderBy(null);
        }
    }

    private Command rewriteSelectInto(Query query) throws TeiidProcessingException {
        Into into = query.getInto();
        try {
            ArrayList<ElementSymbol> allIntoElements = LanguageObject.Util.deepClone(ResolverUtil.resolveElementsInGroup(into.getGroup(), this.metadata), ElementSymbol.class);
            Insert insert = new Insert(into.getGroup(), allIntoElements, Collections.emptyList());
            insert.setSourceHint(query.getSourceHint());
            query.setSourceHint(null);
            query.setInto(null);
            insert.setQueryExpression(query);
            return this.rewriteInsert(this.correctDatatypes(insert));
        }
        catch (QueryMetadataException e) {
            throw new QueryValidatorException((Throwable)((Object)e));
        }
        catch (TeiidComponentException e) {
            throw new QueryValidatorException(e);
        }
    }

    private Insert correctDatatypes(Insert insert) {
        boolean needsView = false;
        for (int i = 0; !needsView && i < insert.getVariables().size(); ++i) {
            Expression ses = insert.getVariables().get(i);
            if (ses.getType() == insert.getQueryExpression().getProjectedSymbols().get(i).getType()) continue;
            needsView = true;
        }
        if (needsView) {
            try {
                insert.setQueryExpression(QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), insert.getQueryExpression(), this.metadata, insert.getVariables()));
            }
            catch (TeiidException err) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30371, (Throwable)err);
            }
        }
        return insert;
    }

    private void correctProjectedTypes(List actualSymbolTypes, Query query) {
        List<Expression> symbols = query.getSelect().getProjectedSymbols();
        List<Expression> newSymbols = SetQuery.getTypedProjectedSymbols(symbols, actualSymbolTypes, this.metadata);
        query.getSelect().setSymbols(newSymbols);
    }

    private SetQuery rewriteSetQuery(SetQuery setQuery) throws TeiidComponentException, TeiidProcessingException {
        if (setQuery.getProjectedTypes() != null) {
            for (QueryCommand command : setQuery.getQueryCommands()) {
                if (!(command instanceof Query)) continue;
                this.correctProjectedTypes(setQuery.getProjectedTypes(), (Query)command);
            }
            setQuery.setProjectedTypes(null, null);
        }
        setQuery.setLeftQuery((QueryCommand)this.rewriteCommand(setQuery.getLeftQuery(), true));
        setQuery.setRightQuery((QueryCommand)this.rewriteCommand(setQuery.getRightQuery(), true));
        this.rewriteOrderBy(setQuery);
        if (setQuery.getLimit() != null) {
            setQuery.setLimit(this.rewriteLimitClause(setQuery.getLimit()));
        }
        return setQuery;
    }

    private FromClause rewriteFromClause(Query parent, FromClause clause, Map<Object, WithQueryCommand> replacements) throws TeiidComponentException, TeiidProcessingException {
        UnaryFromClause ufc;
        WithQueryCommand command;
        if (clause instanceof JoinPredicate) {
            return this.rewriteJoinPredicate(parent, (JoinPredicate)clause, replacements);
        }
        if (clause instanceof SubqueryFromClause) {
            this.rewriteSubqueryContainer((SubqueryFromClause)clause, true);
        } else if (clause instanceof TextTable) {
            TextTable tt = (TextTable)clause;
            tt.setFile(this.rewriteExpressionDirect(tt.getFile()));
        } else if (clause instanceof XMLTable) {
            this.rewriteExpressions(clause);
        } else if (clause instanceof ObjectTable) {
            this.rewriteExpressions(clause);
        } else if (clause instanceof ArrayTable) {
            ArrayTable at = (ArrayTable)clause;
            at.setArrayValue(this.rewriteExpressionDirect(at.getArrayValue()));
        } else if (clause instanceof UnaryFromClause && replacements != null && (command = replacements.get((ufc = (UnaryFromClause)clause).getGroup().getMetadataID())) != null) {
            ufc.setExpandedCommand((Command)command.getCommand().clone());
        }
        return clause;
    }

    private JoinPredicate rewriteJoinPredicate(Query parent, JoinPredicate predicate, Map<Object, WithQueryCommand> replacements) throws TeiidComponentException, TeiidProcessingException {
        List joinCrits = predicate.getJoinCriteria();
        if (joinCrits != null && joinCrits.size() > 0) {
            Criteria criteria = new CompoundCriteria(new ArrayList(joinCrits));
            criteria = this.rewriteCriteria(criteria);
            joinCrits.clear();
            if (criteria instanceof CompoundCriteria && ((CompoundCriteria)criteria).getOperator() == 0) {
                joinCrits.addAll(((CompoundCriteria)criteria).getCriteria());
            } else {
                joinCrits.add(criteria);
            }
            predicate.setJoinCriteria(joinCrits);
        }
        if (predicate.getJoinType() == JoinType.JOIN_UNION) {
            predicate.setJoinType(JoinType.JOIN_FULL_OUTER);
            predicate.setJoinCriteria(new ArrayList<CompareCriteria>(Arrays.asList(FALSE_CRITERIA)));
        } else if (predicate.getJoinType() == JoinType.JOIN_RIGHT_OUTER) {
            predicate.setJoinType(JoinType.JOIN_LEFT_OUTER);
            FromClause leftClause = predicate.getLeftClause();
            predicate.setLeftClause(predicate.getRightClause());
            predicate.setRightClause(leftClause);
        }
        predicate.setLeftClause(this.rewriteFromClause(parent, predicate.getLeftClause(), replacements));
        predicate.setRightClause(this.rewriteFromClause(parent, predicate.getRightClause(), replacements));
        return predicate;
    }

    public static Criteria rewriteCriteria(Criteria criteria, CommandContext context, QueryMetadataInterface metadata) throws TeiidComponentException, TeiidProcessingException {
        return new QueryRewriter(metadata, context).rewriteCriteria(criteria);
    }

    private Criteria rewriteCriteria(Criteria criteria) throws TeiidComponentException, TeiidProcessingException {
        if (criteria instanceof CompoundCriteria) {
            return this.rewriteCriteria((CompoundCriteria)criteria, true);
        }
        if (criteria instanceof NotCriteria) {
            criteria = this.rewriteCriteria((NotCriteria)criteria);
        } else if (criteria instanceof CompareCriteria) {
            criteria = this.rewriteCriteria((CompareCriteria)criteria);
        } else if (criteria instanceof SubqueryCompareCriteria) {
            criteria = this.rewriteCriteria((SubqueryCompareCriteria)criteria);
        } else if (criteria instanceof MatchCriteria) {
            criteria = this.rewriteCriteria((MatchCriteria)criteria);
        } else if (criteria instanceof SetCriteria) {
            criteria = this.rewriteCriteria((SetCriteria)criteria);
        } else if (criteria instanceof IsNullCriteria) {
            criteria = this.rewriteCriteria((IsNullCriteria)criteria);
        } else if (criteria instanceof BetweenCriteria) {
            criteria = this.rewriteCriteria((BetweenCriteria)criteria);
        } else if (criteria instanceof ExistsCriteria) {
            ExistsCriteria exists = (ExistsCriteria)criteria;
            if (exists.shouldEvaluate() && this.processing) {
                return this.getCriteria(this.evaluator.evaluate((Criteria)exists, null));
            }
            this.rewriteSubqueryContainer((SubqueryContainer)((Object)criteria), true);
            if (!RelationalNodeUtil.shouldExecute(exists.getCommand(), false, true)) {
                return exists.isNegated() ? TRUE_CRITERIA : FALSE_CRITERIA;
            }
            if (exists.getCommand().getProcessorPlan() == null) {
                Query query;
                if (exists.getCommand() instanceof Query && ((query = (Query)exists.getCommand()).getLimit() == null || query.getOrderBy() == null) && query.getSelect().getProjectedSymbols().size() > 1) {
                    query.getSelect().clearSymbols();
                    query.getSelect().addSymbol(new ExpressionSymbol("x", new Constant(1)));
                }
                this.addImplicitLimit(exists, 1);
            }
        } else if (criteria instanceof SubquerySetCriteria) {
            SubquerySetCriteria sub = (SubquerySetCriteria)criteria;
            this.rewriteSubqueryContainer(sub, true);
            if (!RelationalNodeUtil.shouldExecute(sub.getCommand(), false, true)) {
                return sub.isNegated() ? TRUE_CRITERIA : FALSE_CRITERIA;
            }
            if (this.rewriteLeftExpression(sub)) {
                this.addImplicitLimit(sub, 1);
            }
        } else if (criteria instanceof DependentSetCriteria) {
            criteria = this.rewriteDependentSetCriteria((DependentSetCriteria)criteria);
        } else if (criteria instanceof ExpressionCriteria) {
            return this.rewriteCriteria(new CompareCriteria(((ExpressionCriteria)criteria).getExpression(), 1, new Constant(Boolean.TRUE)));
        }
        return this.evaluateCriteria(criteria);
    }

    private void addImplicitLimit(SubqueryContainer<QueryCommand> container, int rowLimit) {
        if (container.getCommand().getLimit() != null) {
            Constant c;
            Limit lim = container.getCommand().getLimit();
            if (lim.getRowLimit() instanceof Constant && !(c = (Constant)lim.getRowLimit()).isMultiValued() && Integer.valueOf(rowLimit).compareTo((Integer)c.getValue()) <= 0) {
                lim.setRowLimit(new Constant(rowLimit));
                if (lim.getRowLimit() == null) {
                    lim.setImplicit(true);
                    container.getCommand().setOrderBy(null);
                }
            }
            return;
        }
        boolean addLimit = true;
        if (container.getCommand() instanceof Query) {
            Query query = (Query)container.getCommand();
            boolean bl = addLimit = !query.hasAggregates() || query.getGroupBy() != null;
        }
        if (addLimit) {
            Limit lim = new Limit(null, new Constant(rowLimit));
            lim.setImplicit(true);
            container.getCommand().setLimit(lim);
        }
    }

    private Criteria rewriteDependentSetCriteria(DependentSetCriteria dsc) throws TeiidComponentException, TeiidProcessingException {
        if (!this.processing && this.rewriteLeftExpression(dsc)) {
            return UNKNOWN_CRITERIA;
        }
        return dsc;
    }

    public static Criteria optimizeCriteria(CompoundCriteria criteria, QueryMetadataInterface metadata) {
        try {
            return new QueryRewriter(metadata, null).rewriteCriteria(criteria, false);
        }
        catch (TeiidException err) {
            return criteria;
        }
    }

    private Criteria rewriteCriteria(CompoundCriteria criteria, boolean rewrite) throws TeiidComponentException, TeiidProcessingException {
        List<Criteria> crits = criteria.getCriteria();
        int operator = criteria.getOperator();
        LinkedHashSet<Criteria> newCrits = new LinkedHashSet<Criteria>(crits.size());
        HashMap<Expression, Criteria> exprMap = new HashMap<Expression, Criteria>();
        for (Criteria converted : crits) {
            CompoundCriteria other;
            if (rewrite) {
                converted = this.rewriteCriteria(converted);
            } else if (converted instanceof CompoundCriteria) {
                converted = this.rewriteCriteria((CompoundCriteria)converted, false);
            }
            List<Criteria> critList = null;
            if (converted instanceof CompoundCriteria && (other = (CompoundCriteria)converted).getOperator() == criteria.getOperator()) {
                critList = other.getCriteria();
            }
            if (critList == null) {
                critList = Arrays.asList(converted);
            }
            for (Criteria criteria2 : critList) {
                CompareCriteria cc;
                PredicateCriteria other2;
                Criteria crit;
                converted = criteria2;
                if (TRUE_CRITERIA.equals(converted)) {
                    if (operator != 1) continue;
                    return converted;
                }
                if (FALSE_CRITERIA.equals(converted)) {
                    if (operator != 0) continue;
                    return converted;
                }
                if (UNKNOWN_CRITERIA.equals(converted)) {
                    if (this.preserveUnknown) {
                        newCrits.add(converted);
                        continue;
                    }
                    if (operator != 0) continue;
                    return FALSE_CRITERIA;
                }
                if (operator == 0) {
                    if ((converted = this.rewriteAndConjunct(converted, exprMap, newCrits)) == null) continue;
                    return converted;
                }
                if (converted instanceof SetCriteria) {
                    SetCriteria sc = (SetCriteria)converted;
                    if (!sc.isNegated() && sc.isAllConstants()) {
                        crit = exprMap.get(sc.getExpression());
                        if (crit == null) {
                            exprMap.put(sc.getExpression(), sc);
                        } else {
                            if (crit instanceof SetCriteria) {
                                other2 = (SetCriteria)crit;
                                ((SetCriteria)other2).getValues().addAll(sc.getValues());
                                continue;
                            }
                            newCrits.remove(crit);
                            CompareCriteria cc2 = (CompareCriteria)crit;
                            sc.getValues().add(cc2.getRightExpression());
                        }
                    }
                } else if (converted instanceof CompareCriteria && (cc = (CompareCriteria)converted).getOperator() == 1 && cc.getRightExpression() instanceof Constant) {
                    crit = exprMap.get(cc.getLeftExpression());
                    if (crit == null) {
                        exprMap.put(cc.getLeftExpression(), cc);
                    } else {
                        if (crit instanceof SetCriteria) {
                            other2 = (SetCriteria)crit;
                            ((SetCriteria)other2).getValues().add(cc.getRightExpression());
                            continue;
                        }
                        newCrits.remove(crit);
                        other2 = (CompareCriteria)crit;
                        SetCriteria sc = new SetCriteria(cc.getLeftExpression(), DataTypeManager.isHashable(((CompareCriteria)other2).getRightExpression().getType()) ? new LinkedHashSet() : new TreeSet());
                        sc.setAllConstants(true);
                        sc.getValues().add(cc.getRightExpression());
                        sc.getValues().add(((CompareCriteria)other2).getRightExpression());
                        exprMap.put(sc.getExpression(), sc);
                        converted = sc;
                    }
                }
                newCrits.add(converted);
            }
        }
        if (newCrits.size() == 0) {
            if (operator == 0) {
                return TRUE_CRITERIA;
            }
            return FALSE_CRITERIA;
        }
        if (newCrits.size() == 1) {
            return (Criteria)newCrits.iterator().next();
        }
        criteria.getCriteria().clear();
        criteria.getCriteria().addAll(newCrits);
        return criteria;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Criteria rewriteAndConjunct(Criteria converted, Map<Expression, Criteria> exprMap, LinkedHashSet<Criteria> newCrits) {
        if (converted instanceof IsNullCriteria) {
            IsNullCriteria inc = (IsNullCriteria)converted;
            if (!inc.isNegated()) {
                Criteria crit = exprMap.get(inc.getExpression());
                if (crit == null) {
                    exprMap.put(inc.getExpression(), converted);
                } else if (!(crit instanceof IsNullCriteria)) {
                    return FALSE_CRITERIA;
                }
            }
        } else if (converted instanceof SetCriteria) {
            SetCriteria sc = (SetCriteria)converted;
            Criteria crit = exprMap.get(sc.getExpression());
            if (crit instanceof IsNullCriteria) {
                return FALSE_CRITERIA;
            }
            if (!sc.isNegated() && sc.isAllConstants()) {
                if (crit == null) {
                    exprMap.put(sc.getExpression(), converted);
                } else {
                    if (crit instanceof SetCriteria) {
                        SetCriteria sc1 = (SetCriteria)crit;
                        newCrits.remove(sc1);
                        sc1.getValues().retainAll(sc.getValues());
                        if (sc1.getValues().isEmpty()) {
                            return FALSE_CRITERIA;
                        }
                        newCrits.add(sc1);
                        exprMap.put(sc1.getExpression(), sc1);
                        return null;
                    }
                    CompareCriteria cc = (CompareCriteria)crit;
                    Iterator exprIter = sc.getValues().iterator();
                    while (exprIter.hasNext()) {
                        if (Evaluator.compare(cc.getOperator(), ((Constant)exprIter.next()).getValue(), ((Constant)cc.getRightExpression()).getValue()).booleanValue()) continue;
                        exprIter.remove();
                    }
                    if (sc.getValues().isEmpty()) {
                        return FALSE_CRITERIA;
                    }
                    if (cc.getOperator() == 1) return null;
                    newCrits.remove(cc);
                    exprMap.put(sc.getExpression(), sc);
                }
            }
        } else if (converted instanceof CompareCriteria) {
            CompareCriteria cc = (CompareCriteria)converted;
            Criteria crit = exprMap.get(cc.getLeftExpression());
            if (crit instanceof IsNullCriteria) {
                return FALSE_CRITERIA;
            }
            if (cc.getRightExpression() instanceof Constant) {
                if (crit == null) {
                    exprMap.put(cc.getLeftExpression(), cc);
                } else if (crit instanceof SetCriteria) {
                    SetCriteria sc = (SetCriteria)crit;
                    boolean modified = false;
                    Iterator exprIter = sc.getValues().iterator();
                    while (exprIter.hasNext()) {
                        if (Evaluator.compare(cc.getOperator(), ((Constant)exprIter.next()).getValue(), ((Constant)cc.getRightExpression()).getValue()).booleanValue()) continue;
                        if (!modified) {
                            modified = true;
                            newCrits.remove(sc);
                        }
                        exprIter.remove();
                    }
                    if (sc.getValues().isEmpty()) {
                        return FALSE_CRITERIA;
                    }
                    if (cc.getOperator() == 1) {
                        exprMap.put(cc.getLeftExpression(), cc);
                    } else if (modified) {
                        if (sc.getNumberOfValues() == 1) {
                            CompareCriteria comp = new CompareCriteria(sc.getExpression(), 1, (Expression)sc.getValues().iterator().next());
                            newCrits.add(comp);
                            exprMap.put(sc.getExpression(), comp);
                            return null;
                        } else {
                            newCrits.add(sc);
                            exprMap.put(sc.getExpression(), sc);
                        }
                        return null;
                    }
                } else {
                    CompareCriteria cc1 = (CompareCriteria)crit;
                    if (cc1.getOperator() == 2) {
                        exprMap.put(cc.getLeftExpression(), cc);
                    } else if (cc1.getOperator() == 1) {
                        if (Evaluator.compare(cc.getOperator(), ((Constant)cc1.getRightExpression()).getValue(), ((Constant)cc.getRightExpression()).getValue()).booleanValue()) return null;
                        return FALSE_CRITERIA;
                    }
                    if (cc.getOperator() == 1) {
                        if (!Evaluator.compare(cc1.getOperator(), ((Constant)cc.getRightExpression()).getValue(), ((Constant)cc1.getRightExpression()).getValue()).booleanValue()) {
                            return FALSE_CRITERIA;
                        }
                        exprMap.put(cc.getLeftExpression(), cc);
                        newCrits.remove(cc1);
                    }
                }
            }
        }
        newCrits.add(converted);
        return null;
    }

    private Criteria evaluateCriteria(Criteria crit) throws TeiidComponentException, TeiidProcessingException {
        if (EvaluatableVisitor.isFullyEvaluatable(crit, !this.processing)) {
            try {
                Boolean eval = this.evaluator.evaluateTVL(crit, Collections.emptyList());
                return this.getCriteria(eval);
            }
            catch (ExpressionEvaluationException e) {
                throw new QueryValidatorException(QueryPlugin.Event.TEIID30372, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30372, new Object[]{crit}));
            }
        }
        return crit;
    }

    private Criteria getCriteria(Boolean eval) {
        if (eval == null) {
            return UNKNOWN_CRITERIA;
        }
        if (Boolean.TRUE.equals(eval)) {
            return TRUE_CRITERIA;
        }
        return FALSE_CRITERIA;
    }

    private Criteria rewriteCriteria(NotCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Criteria innerCrit = criteria.getCriteria();
        if (innerCrit instanceof CompoundCriteria) {
            return this.rewriteCriteria(Criteria.applyDemorgan(innerCrit));
        }
        if (innerCrit instanceof PredicateCriteria.Negatable) {
            ((PredicateCriteria.Negatable)((Object)innerCrit)).negate();
            return this.rewriteCriteria(innerCrit);
        }
        if (innerCrit instanceof NotCriteria) {
            return this.rewriteCriteria(((NotCriteria)innerCrit).getCriteria());
        }
        if ((innerCrit = this.rewriteCriteria(innerCrit)) == TRUE_CRITERIA) {
            return FALSE_CRITERIA;
        }
        if (innerCrit == FALSE_CRITERIA) {
            return TRUE_CRITERIA;
        }
        if (innerCrit == UNKNOWN_CRITERIA) {
            return UNKNOWN_CRITERIA;
        }
        criteria.setCriteria(innerCrit);
        return criteria;
    }

    private Criteria rewriteCriteria(BetweenCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        CompareCriteria lowerCriteria = new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 3 : 6, criteria.getLowerExpression());
        CompareCriteria upperCriteria = new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 4 : 5, criteria.getUpperExpression());
        CompoundCriteria newCriteria = new CompoundCriteria(criteria.isNegated() ? 1 : 0, lowerCriteria, upperCriteria);
        return this.rewriteCriteria(newCriteria);
    }

    private Criteria rewriteCriteria(CompareCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Expression leftExpr = this.rewriteExpressionDirect(criteria.getLeftExpression());
        Expression rightExpr = this.rewriteExpressionDirect(criteria.getRightExpression());
        criteria.setLeftExpression(leftExpr);
        criteria.setRightExpression(rightExpr);
        if (QueryRewriter.isNull(leftExpr) || QueryRewriter.isNull(rightExpr)) {
            return UNKNOWN_CRITERIA;
        }
        if (leftExpr.equals(rightExpr)) {
            switch (criteria.getOperator()) {
                case 1: 
                case 5: 
                case 6: {
                    if (leftExpr instanceof Constant) {
                        return TRUE_CRITERIA;
                    }
                    return this.getSimpliedCriteria(criteria, criteria.getLeftExpression(), true, true);
                }
            }
            if (leftExpr instanceof Constant) {
                return FALSE_CRITERIA;
            }
            return this.getSimpliedCriteria(criteria, criteria.getLeftExpression(), false, true);
        }
        boolean rightConstant = false;
        if (EvaluatableVisitor.willBecomeConstant(rightExpr)) {
            rightConstant = true;
        } else if (EvaluatableVisitor.willBecomeConstant(leftExpr)) {
            criteria.setLeftExpression(rightExpr);
            criteria.setRightExpression(leftExpr);
            switch (criteria.getOperator()) {
                case 3: {
                    criteria.setOperator(4);
                    break;
                }
                case 5: {
                    criteria.setOperator(6);
                    break;
                }
                case 4: {
                    criteria.setOperator(3);
                    break;
                }
                case 6: {
                    criteria.setOperator(5);
                }
            }
            rightConstant = true;
        }
        Function f = null;
        while (rightConstant && f != criteria.getLeftExpression() && criteria.getLeftExpression() instanceof Function) {
            f = (Function)criteria.getLeftExpression();
            Criteria result = this.simplifyWithInverse(criteria);
            if (!(result instanceof CompareCriteria)) {
                return result;
            }
            criteria = (CompareCriteria)result;
        }
        Criteria modCriteria = this.simplifyTimestampMerge(criteria);
        if (modCriteria instanceof CompareCriteria) {
            modCriteria = this.simplifyTimestampMerge2((CompareCriteria)modCriteria);
        }
        return modCriteria;
    }

    public static boolean isNull(Expression expr) {
        return expr instanceof Constant && ((Constant)expr).isNull();
    }

    private Criteria rewriteCriteria(SubqueryCompareCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Expression leftExpr;
        if (criteria.getCommand().getProcessorPlan() == null) {
            if (criteria.getOperator() == 1 && criteria.getPredicateQuantifier() != 4 || criteria.getOperator() == 2 && criteria.getPredicateQuantifier() == 4) {
                SubquerySetCriteria result = new SubquerySetCriteria(criteria.getLeftExpression(), criteria.getCommand());
                result.setNegated(criteria.getOperator() == 2);
                return this.rewriteCriteria(result);
            }
            if (criteria.getPredicateQuantifier() != 4 && criteria.getOperator() != 1 && criteria.getOperator() != 2) {
                Query query;
                CompareCriteria cc = new CompareCriteria();
                cc.setLeftExpression(criteria.getLeftExpression());
                boolean useView = true;
                if (criteria.getCommand() instanceof Query && !(query = (Query)criteria.getCommand()).hasAggregates() && query.getCriteria() != null && query.getOrderBy() == null) {
                    final boolean[] hasWindowFunctions = new boolean[1];
                    PreOrPostOrderNavigator.doVisit(query.getSelect(), new LanguageVisitor(){

                        @Override
                        public void visit(WindowFunction windowFunction) {
                            hasWindowFunctions[0] = true;
                        }
                    }, true);
                    useView = hasWindowFunctions[0];
                }
                AggregateSymbol.Type type = AggregateSymbol.Type.MAX;
                if (criteria.getOperator() == 4 || criteria.getOperator() == 6) {
                    type = AggregateSymbol.Type.MIN;
                }
                if (useView) {
                    Query q = QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), criteria.getCommand(), this.metadata, criteria.getCommand().getProjectedSymbols());
                    Expression ses = q.getProjectedSymbols().get(0);
                    Expression expr = SymbolMap.getExpression(ses);
                    q.getSelect().clearSymbols();
                    q.getSelect().addSymbol(new AggregateSymbol(type.name(), false, expr));
                    ScalarSubquery ss = new ScalarSubquery(q);
                    ss.setSubqueryHint(criteria.getSubqueryHint());
                    cc.setRightExpression(ss);
                    cc.setOperator(criteria.getOperator());
                    return this.rewriteCriteria(cc);
                }
                Select select = ((Query)criteria.getCommand()).getSelect();
                Expression ex = select.getProjectedSymbols().get(0);
                ex = SymbolMap.getExpression(ex);
                select.setSymbols(Arrays.asList(new AggregateSymbol(type.name(), false, ex)));
                select.setDistinct(false);
            }
        }
        if (QueryRewriter.isNull(leftExpr = this.rewriteExpressionDirect(criteria.getLeftExpression()))) {
            this.addImplicitLimit(criteria, 1);
        }
        criteria.setLeftExpression(leftExpr);
        if (criteria.getPredicateQuantifier() == 3) {
            criteria.setPredicateQuantifier(2);
        }
        this.rewriteSubqueryContainer(criteria, true);
        if (!RelationalNodeUtil.shouldExecute(criteria.getCommand(), false, true)) {
            if (criteria.getPredicateQuantifier() == 2) {
                return FALSE_CRITERIA;
            }
            return TRUE_CRITERIA;
        }
        return criteria;
    }

    private Criteria simplifyWithInverse(CompareCriteria criteria) throws TeiidProcessingException {
        Expression leftExpr = criteria.getLeftExpression();
        Function leftFunction = (Function)leftExpr;
        if (this.isSimpleMathematicalFunction(leftFunction)) {
            return this.simplifyMathematicalCriteria(criteria);
        }
        if (FunctionLibrary.isConvert(leftFunction)) {
            return this.simplifyConvertFunction(criteria);
        }
        return this.simplifyParseFormatFunction(criteria);
    }

    private boolean isSimpleMathematicalFunction(Function function) {
        Expression[] args;
        String funcName = function.getName();
        return !(!funcName.equals("+") && !funcName.equals("-") && !funcName.equals("*") && !funcName.equals("/") || !((args = function.getArgs())[0] instanceof Constant) && !(args[1] instanceof Constant));
    }

    private CompareCriteria simplifyMathematicalCriteria(CompareCriteria criteria) throws TeiidProcessingException {
        Object value;
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function function = (Function)leftExpr;
        String funcName = function.getName();
        Expression[] args = function.getArgs();
        Constant const1 = null;
        Expression expr = null;
        if (args[1] instanceof Constant) {
            const1 = (Constant)args[1];
            expr = args[0];
        } else if (funcName.equals("+") || funcName.equals("*")) {
            const1 = (Constant)args[0];
            expr = args[1];
        } else {
            return criteria;
        }
        int operator = criteria.getOperator();
        String oppFunc = null;
        switch (funcName.charAt(0)) {
            case '+': {
                oppFunc = "-";
                break;
            }
            case '-': {
                oppFunc = "+";
                break;
            }
            case '*': {
                oppFunc = "/";
                break;
            }
            case '/': {
                oppFunc = "*";
            }
        }
        Expression combinedConst = null;
        FunctionLibrary funcLib = this.metadata.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findFunction(oppFunc, new Class[]{rightExpr.getType(), const1.getType()});
        if (descriptor == null) {
            return criteria;
        }
        if (rightExpr instanceof Constant) {
            Constant const2 = (Constant)rightExpr;
            try {
                Object result = descriptor.invokeFunction(new Object[]{const2.getValue(), const1.getValue()}, null, this.context);
                combinedConst = new Constant(result, descriptor.getReturnType());
            }
            catch (FunctionExecutionException e) {
                throw new QueryValidatorException(QueryPlugin.Event.TEIID30373, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30373, new Object[]{e.getMessage()}));
            }
            catch (BlockedException e) {
                throw new QueryValidatorException(QueryPlugin.Event.TEIID30373, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30373, new Object[]{e.getMessage()}));
            }
        } else {
            Function conversion = new Function(descriptor.getName(), new Expression[]{rightExpr, const1});
            conversion.setType(leftExpr.getType());
            conversion.setFunctionDescriptor(descriptor);
            combinedConst = conversion;
        }
        if (operator != 1 && operator != 2 && (oppFunc.equals("*") || oppFunc.equals("/")) && (value = const1.getValue()) != null) {
            Class<?> type = const1.getType();
            Number comparisonObject = null;
            if (type.equals(DataTypeManager.DefaultDataClasses.INTEGER)) {
                comparisonObject = INTEGER_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.DOUBLE)) {
                comparisonObject = DOUBLE_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.FLOAT)) {
                comparisonObject = FLOAT_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.LONG)) {
                comparisonObject = LONG_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER)) {
                comparisonObject = BIG_INTEGER_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
                comparisonObject = BIG_DECIMAL_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.SHORT)) {
                comparisonObject = SHORT_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BYTE)) {
                comparisonObject = BYTE_ZERO;
            } else {
                return criteria;
            }
            if (comparisonObject.compareTo(value) > 0) {
                switch (operator) {
                    case 5: {
                        operator = 6;
                        break;
                    }
                    case 3: {
                        operator = 4;
                        break;
                    }
                    case 6: {
                        operator = 5;
                        break;
                    }
                    case 4: {
                        operator = 3;
                    }
                }
            }
        }
        criteria.setLeftExpression(expr);
        criteria.setRightExpression(combinedConst);
        criteria.setOperator(operator);
        return criteria;
    }

    private Criteria simplifyConvertFunction(CompareCriteria crit) {
        Function leftFunction = (Function)crit.getLeftExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        if (!(crit.getRightExpression() instanceof Constant) || crit.getOperator() != 1 && crit.getOperator() != 2) {
            return crit;
        }
        Constant rightConstant = (Constant)crit.getRightExpression();
        String leftExprTypeName = DataTypeManager.getDataTypeName(leftExpr.getType());
        Constant result = ResolverUtil.convertConstant(DataTypeManager.getDataTypeName(rightConstant.getType()), leftExprTypeName, rightConstant);
        if (result == null) {
            return this.getSimpliedCriteria(crit, leftExpr, crit.getOperator() != 1, true);
        }
        Constant other = ResolverUtil.convertConstant(leftExprTypeName, DataTypeManager.getDataTypeName(rightConstant.getType()), result);
        if (other == null || rightConstant.compareTo(other) != 0) {
            return this.getSimpliedCriteria(crit, leftExpr, crit.getOperator() != 1, true);
        }
        if (!DataTypeManager.isImplicitConversion((String)leftExprTypeName, (String)DataTypeManager.getDataTypeName(rightConstant.getType()))) {
            return crit;
        }
        crit.setRightExpression(result);
        crit.setLeftExpression(leftExpr);
        return crit;
    }

    private Criteria simplifyConvertFunction(SetCriteria crit) throws TeiidComponentException, TeiidProcessingException {
        Function leftFunction = (Function)crit.getExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        String leftExprTypeName = DataTypeManager.getDataTypeName(leftExpr.getType());
        Iterator i = crit.getValues().iterator();
        ArrayList<Constant> newValues = new ArrayList<Constant>(crit.getNumberOfValues());
        boolean convertedAll = true;
        boolean removedSome = false;
        while (i.hasNext()) {
            Constant other;
            Object next = i.next();
            if (!(next instanceof Constant)) {
                convertedAll = false;
                continue;
            }
            Constant rightConstant = (Constant)next;
            Constant result = ResolverUtil.convertConstant(DataTypeManager.getDataTypeName(rightConstant.getType()), leftExprTypeName, rightConstant);
            if (result != null && ((other = ResolverUtil.convertConstant(leftExprTypeName, DataTypeManager.getDataTypeName(rightConstant.getType()), result)) == null || ((Comparable)rightConstant.getValue()).compareTo(other.getValue()) != 0)) {
                result = null;
            }
            if (result == null) {
                removedSome = true;
                i.remove();
                continue;
            }
            if (DataTypeManager.isImplicitConversion((String)leftExprTypeName, (String)DataTypeManager.getDataTypeName(rightConstant.getType()))) {
                newValues.add(result);
                continue;
            }
            convertedAll = false;
        }
        if (!convertedAll) {
            if (!removedSome) {
                return crit;
            }
        } else {
            crit.setExpression(leftExpr);
            crit.setValues(newValues);
        }
        return this.rewriteCriteria(crit);
    }

    private Criteria simplifyParseFormatFunction(CompareCriteria crit) {
        String type;
        if (crit.getOperator() != 1 && crit.getOperator() != 2) {
            return crit;
        }
        boolean isFormat = false;
        Function leftFunction = (Function)crit.getLeftExpression();
        String funcName = leftFunction.getName();
        String inverseFunction = null;
        if (StringUtil.startsWithIgnoreCase((String)funcName, (String)"parse")) {
            type = funcName.substring(5);
            if (!PARSE_FORMAT_TYPES.contains(type)) {
                return crit;
            }
            inverseFunction = "format" + type;
        } else if (StringUtil.startsWithIgnoreCase((String)funcName, (String)"format")) {
            type = funcName.substring(6);
            if (!PARSE_FORMAT_TYPES.contains(type)) {
                return crit;
            }
            inverseFunction = "parse" + type;
            isFormat = true;
        } else {
            return crit;
        }
        Expression rightExpr = crit.getRightExpression();
        if (!(rightExpr instanceof Constant)) {
            return crit;
        }
        Expression leftExpr = leftFunction.getArgs()[0];
        Expression formatExpr = leftFunction.getArgs()[1];
        if (!(formatExpr instanceof Constant)) {
            return crit;
        }
        String format = (String)((Constant)formatExpr).getValue();
        FunctionLibrary funcLib = this.metadata.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findFunction(inverseFunction, new Class[]{rightExpr.getType(), formatExpr.getType()});
        if (descriptor == null) {
            return crit;
        }
        Object value = ((Constant)rightExpr).getValue();
        try {
            Object result = descriptor.invokeFunction(new Object[]{this.context, ((Constant)rightExpr).getValue(), format}, null, this.context);
            result = leftFunction.getFunctionDescriptor().invokeFunction(new Object[]{this.context, result, format}, null, this.context);
            if (Constant.COMPARATOR.compare(value, result) != 0) {
                return this.getSimpliedCriteria(crit, leftExpr, crit.getOperator() != 1, true);
            }
        }
        catch (FunctionExecutionException e) {
            return crit;
        }
        catch (BlockedException e) {
            return crit;
        }
        if (!isFormat) {
            return crit;
        }
        return crit;
    }

    private Criteria simplifyTimestampMerge2(CompareCriteria criteria) {
        if (criteria.getOperator() != 1) {
            return criteria;
        }
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function tsCreateFunction = null;
        Constant timestampConstant = null;
        if (!(leftExpr instanceof Function) || !(rightExpr instanceof Constant)) {
            return criteria;
        }
        tsCreateFunction = (Function)leftExpr;
        timestampConstant = (Constant)rightExpr;
        if (!timestampConstant.getType().equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            return criteria;
        }
        if (!tsCreateFunction.getName().equalsIgnoreCase("timestampCreate")) {
            return criteria;
        }
        Timestamp ts = (Timestamp)timestampConstant.getValue();
        String tsStr = ts.toString();
        java.sql.Date date = java.sql.Date.valueOf(tsStr.substring(0, 10));
        Time time = Time.valueOf(tsStr.substring(11, 19));
        Expression[] args = tsCreateFunction.getArgs();
        CompareCriteria dateCrit = new CompareCriteria(args[0], 1, new Constant(date, DataTypeManager.DefaultDataClasses.DATE));
        CompareCriteria timeCrit = new CompareCriteria(args[1], 1, new Constant(time, DataTypeManager.DefaultDataClasses.TIME));
        CompoundCriteria compCrit = new CompoundCriteria(0, dateCrit, timeCrit);
        return compCrit;
    }

    private Criteria simplifyTimestampMerge(CompareCriteria criteria) {
        if (criteria.getOperator() != 1) {
            return criteria;
        }
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function concatFunction = null;
        Constant timestampConstant = null;
        if (!(leftExpr instanceof Function) || !(rightExpr instanceof Constant)) {
            return criteria;
        }
        concatFunction = (Function)leftExpr;
        timestampConstant = (Constant)rightExpr;
        if (!timestampConstant.getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            return criteria;
        }
        if (!concatFunction.getName().equalsIgnoreCase("concat") && !concatFunction.getName().equals("||")) {
            return criteria;
        }
        Expression[] args = concatFunction.getArgs();
        if (!(args[0] instanceof Function) || !(args[1] instanceof Function)) {
            return criteria;
        }
        Function formatDateFunction = (Function)args[0];
        Function formatTimeFunction = (Function)args[1];
        if (!formatDateFunction.getName().equalsIgnoreCase("formatdate") || !formatTimeFunction.getName().equalsIgnoreCase("formattime")) {
            return criteria;
        }
        if (!(formatDateFunction.getArgs()[1] instanceof Constant) || !(formatTimeFunction.getArgs()[1] instanceof Constant)) {
            return criteria;
        }
        String dateFormat = (String)((Constant)formatDateFunction.getArgs()[1]).getValue();
        String timeFormat = (String)((Constant)formatTimeFunction.getArgs()[1]).getValue();
        String timestampValue = (String)timestampConstant.getValue();
        try {
            Timestamp ts = FunctionMethods.parseTimestamp(this.context, timestampValue, dateFormat + timeFormat);
            Constant dateConstant = new Constant(TimestampWithTimezone.createDate((Date)ts));
            CompareCriteria dateCompare = new CompareCriteria(formatDateFunction.getArgs()[0], 1, dateConstant);
            Constant timeConstant = new Constant(TimestampWithTimezone.createTime((Date)ts));
            CompareCriteria timeCompare = new CompareCriteria(formatTimeFunction.getArgs()[0], 1, timeConstant);
            CompoundCriteria compCrit = new CompoundCriteria(0, dateCompare, timeCompare);
            return compCrit;
        }
        catch (FunctionExecutionException e) {
            return criteria;
        }
    }

    private Criteria rewriteCriteria(MatchCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        criteria.setLeftExpression(this.rewriteExpressionDirect(criteria.getLeftExpression()));
        criteria.setRightExpression(this.rewriteExpressionDirect(criteria.getRightExpression()));
        if (QueryRewriter.isNull(criteria.getLeftExpression()) || QueryRewriter.isNull(criteria.getRightExpression())) {
            return UNKNOWN_CRITERIA;
        }
        Expression rightExpr = criteria.getRightExpression();
        if (rightExpr instanceof Constant && rightExpr.getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            Constant constant = (Constant)rightExpr;
            String value = (String)constant.getValue();
            if (criteria.getMode() != Like.MatchMode.REGEX) {
                char escape = criteria.getEscapeChar();
                if (escape != '\u0000' && value.indexOf(escape) < 0) {
                    criteria.setEscapeChar('\u0000');
                }
                if (value.equals(String.valueOf('%'))) {
                    return this.getSimpliedCriteria(criteria, criteria.getLeftExpression(), !criteria.isNegated(), true);
                }
                if (criteria.getMode() == Like.MatchMode.SIMILAR) {
                    criteria.setMode(Like.MatchMode.REGEX);
                    criteria.setRightExpression(new Constant(Evaluator.SIMILAR_TO_REGEX.getPatternString(value, escape)));
                    criteria.setEscapeChar('\u0000');
                } else if (DataTypeManager.DefaultDataClasses.STRING.equals(criteria.getLeftExpression().getType()) && value.indexOf(escape) < 0 && value.indexOf(95) < 0 && value.indexOf(37) < 0) {
                    return this.rewriteCriteria(new CompareCriteria(criteria.getLeftExpression(), criteria.isNegated() ? 2 : 1, criteria.getRightExpression()));
                }
            }
        }
        return criteria;
    }

    private Criteria getSimpliedCriteria(Criteria crit, Expression a, boolean outcome, boolean nullPossible) {
        if (nullPossible) {
            if (outcome) {
                if (this.processing) {
                    return crit;
                }
                IsNullCriteria inc = new IsNullCriteria(a);
                inc.setNegated(true);
                return inc;
            }
        } else if (outcome) {
            return TRUE_CRITERIA;
        }
        return FALSE_CRITERIA;
    }

    private boolean rewriteLeftExpression(AbstractSetCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        criteria.setExpression(this.rewriteExpressionDirect(criteria.getExpression()));
        return QueryRewriter.isNull(criteria.getExpression());
    }

    private Criteria rewriteCriteria(SetCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Function leftFunction;
        if (criteria.isAllConstants() && criteria.getValues().size() > 1 && criteria.getExpression() instanceof ElementSymbol) {
            return criteria;
        }
        criteria.setExpression(this.rewriteExpressionDirect(criteria.getExpression()));
        if (this.rewriteLeftExpression(criteria) && !criteria.getValues().isEmpty()) {
            return UNKNOWN_CRITERIA;
        }
        Collection vals = criteria.getValues();
        LinkedHashSet<Expression> newVals = new LinkedHashSet<Expression>(vals.size());
        Iterator valIter = vals.iterator();
        boolean allConstants = true;
        boolean hasNull = false;
        while (valIter.hasNext()) {
            Expression value = this.rewriteExpressionDirect((Expression)valIter.next());
            if (QueryRewriter.isNull(value)) {
                hasNull = true;
                if (!this.preserveUnknown) {
                    if (!criteria.isNegated()) continue;
                    return FALSE_CRITERIA;
                }
            }
            allConstants &= value instanceof Constant;
            newVals.add(value);
        }
        int size = newVals.size();
        if (size == 1) {
            if (this.preserveUnknown && hasNull) {
                return UNKNOWN_CRITERIA;
            }
            Expression value = (Expression)newVals.iterator().next();
            return this.rewriteCriteria(new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 2 : 1, value));
        }
        criteria.setValues(newVals);
        if (allConstants) {
            criteria.setAllConstants(true);
            if (!DataTypeManager.isHashable(criteria.getExpression().getType())) {
                criteria.setValues(new TreeSet(criteria.getValues()));
            }
        }
        if (size == 0) {
            if (hasNull) {
                return UNKNOWN_CRITERIA;
            }
            return criteria.isNegated() ? TRUE_CRITERIA : FALSE_CRITERIA;
        }
        if (criteria.getExpression() instanceof Function && FunctionLibrary.isConvert(leftFunction = (Function)criteria.getExpression())) {
            return this.simplifyConvertFunction(criteria);
        }
        return criteria;
    }

    private Criteria rewriteCriteria(IsNullCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        criteria.setExpression(this.rewriteExpressionDirect(criteria.getExpression()));
        return criteria;
    }

    public static Expression rewriteExpression(Expression expression, CommandContext context, QueryMetadataInterface metadata) throws TeiidComponentException, TeiidProcessingException {
        return QueryRewriter.rewriteExpression(expression, context, metadata, false);
    }

    public static Expression rewriteExpression(Expression expression, CommandContext context, QueryMetadataInterface metadata, boolean rewriteSubcommands) throws TeiidComponentException, TeiidProcessingException {
        QueryRewriter rewriter = new QueryRewriter(metadata, context);
        rewriter.rewriteSubcommands = rewriteSubcommands;
        return rewriter.rewriteExpressionDirect(expression);
    }

    private Expression rewriteExpressionDirect(Expression expression) throws TeiidComponentException, TeiidProcessingException {
        if (expression instanceof Constant) {
            return expression;
        }
        if (expression instanceof ElementSymbol) {
            ElementSymbol es = (ElementSymbol)expression;
            Class<?> type = es.getType();
            if (!this.processing && es.isExternalReference()) {
                if (this.variables == null) {
                    return new Reference(es);
                }
                Expression value = this.variables.get(es);
                if (value == null) {
                    String grpName;
                    if (es.getGroupSymbol().getSchema() == null && (grpName = es.getGroupSymbol().getName()).equals("CHANGING")) {
                        Assertion.failed((String)"Changing value should not be null");
                    }
                } else if (value instanceof Constant) {
                    if (value.getType() == type) {
                        return value;
                    }
                    try {
                        return new Constant(FunctionMethods.convert(((Constant)value).getValue(), DataTypeManager.getDataTypeName(type)), es.getType());
                    }
                    catch (FunctionExecutionException e) {
                        throw new QueryValidatorException((Throwable)((Object)e));
                    }
                }
                return new Reference(es);
            }
            return expression;
        }
        boolean isBindEligible = true;
        if (expression instanceof AggregateSymbol) {
            expression = this.rewriteExpression((AggregateSymbol)expression);
        } else if (expression instanceof Function) {
            isBindEligible = !this.isConstantConvert(expression);
            expression = this.rewriteFunction((Function)expression);
        } else if (expression instanceof CaseExpression) {
            expression = this.rewriteCaseExpression((CaseExpression)expression);
        } else if (expression instanceof SearchedCaseExpression) {
            expression = this.rewriteCaseExpression((SearchedCaseExpression)expression);
        } else {
            if (expression instanceof ScalarSubquery) {
                ScalarSubquery subquery = (ScalarSubquery)expression;
                if (subquery.shouldEvaluate() && this.processing) {
                    return new Constant(this.evaluator.evaluate((Expression)subquery, null), subquery.getType());
                }
                this.rewriteSubqueryContainer(subquery, true);
                if (!RelationalNodeUtil.shouldExecute(subquery.getCommand(), false, true)) {
                    return new Constant(null, subquery.getType());
                }
                if (subquery.getCommand().getProcessorPlan() == null) {
                    this.addImplicitLimit(subquery, 2);
                }
                return expression;
            }
            if (expression instanceof ExpressionSymbol) {
                expression = this.rewriteExpressionDirect(((ExpressionSymbol)expression).getExpression());
            } else if (expression instanceof Criteria) {
                expression = this.rewriteCriteria((Criteria)expression);
            } else if (expression instanceof XMLSerialize) {
                this.rewriteExpressions(expression);
                XMLSerialize serialize = (XMLSerialize)expression;
                if (QueryRewriter.isNull(serialize.getExpression())) {
                    return new Constant(null, serialize.getType());
                }
                if (serialize.getDeclaration() == null && serialize.isDocument()) {
                    Charset encoding;
                    if (serialize.getVersion() != null && !serialize.getVersion().equals("1.0")) {
                        serialize.setDeclaration(true);
                    } else if (serialize.getEncoding() != null && !(encoding = Charset.forName(serialize.getEncoding())).equals(Charset.forName("UTF-8")) && !encoding.equals(Charset.forName("UTF-16"))) {
                        serialize.setDeclaration(true);
                    }
                }
            } else if (expression instanceof XMLCast) {
                XMLCast cast = (XMLCast)expression;
                if (cast.getType() == DataTypeManager.DefaultDataClasses.XML) {
                    XMLQuery xmlQuery = new XMLQuery();
                    xmlQuery.setXquery("$i");
                    xmlQuery.setPassing(Arrays.asList(new DerivedColumn("i", cast.getExpression())));
                    xmlQuery.compileXqueryExpression();
                    return xmlQuery;
                }
            } else {
                this.rewriteExpressions(expression);
            }
        }
        if (!this.processing ? !EvaluatableVisitor.isFullyEvaluatable(expression, true) : !(expression instanceof Reference) && !EvaluatableVisitor.isEvaluatable(expression, EvaluatableVisitor.EvaluationLevel.PROCESSING)) {
            return expression;
        }
        return this.evaluate(expression, isBindEligible);
    }

    private Constant evaluate(Expression expression, boolean isBindEligible) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object value = null;
        value = expression instanceof Criteria ? this.evaluator.evaluateTVL((Criteria)expression, Collections.emptyList()) : this.evaluator.evaluate(expression, Collections.emptyList());
        if (value instanceof Constant) {
            return (Constant)value;
        }
        Constant result = new Constant(value, expression.getType());
        result.setBindEligible(isBindEligible);
        return result;
    }

    private boolean isConstantConvert(Expression ex) {
        if (ex instanceof Constant) {
            return true;
        }
        if (!(ex instanceof Function)) {
            return false;
        }
        Function f = (Function)ex;
        if (!FunctionLibrary.isConvert(f)) {
            return false;
        }
        return this.isConstantConvert(f.getArg(0));
    }

    private Expression rewriteExpression(AggregateSymbol expression) throws TeiidComponentException, TeiidProcessingException {
        Expression[] args;
        if (expression.isBoolean()) {
            if (expression.getAggregateFunction() == AggregateSymbol.Type.EVERY) {
                expression.setAggregateFunction(AggregateSymbol.Type.MIN);
            } else {
                expression.setAggregateFunction(AggregateSymbol.Type.MAX);
            }
        }
        if (expression.getAggregateFunction() == AggregateSymbol.Type.MAX || expression.getAggregateFunction() == AggregateSymbol.Type.MIN) {
            if (expression.isDistinct()) {
                expression.setDistinct(false);
            }
            if (this.rewriteAggs && expression.getArg(0) != null && EvaluatableVisitor.willBecomeConstant(expression.getArg(0))) {
                return expression.getArg(0);
            }
        }
        if (expression.isDistinct() && expression.getAggregateFunction() == AggregateSymbol.Type.USER_DEFINED && expression.getFunctionDescriptor().getMethod().getAggregateAttributes().usesDistinctRows()) {
            expression.setDistinct(false);
        }
        if ((args = expression.getArgs()).length == 1 && expression.getCondition() != null && !expression.respectsNulls()) {
            Expression cond = expression.getCondition();
            Expression ex = expression.getArg(0);
            if (!(cond instanceof Criteria)) {
                cond = new ExpressionCriteria(cond);
            }
            SearchedCaseExpression sce = new SearchedCaseExpression(Arrays.asList(cond), Arrays.asList(ex));
            sce.setType(ex.getType());
            expression.setCondition(null);
            expression.setArgs(new Expression[]{sce});
            args = expression.getArgs();
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.rewriteExpressionDirect(expression.getArg(i));
        }
        return expression;
    }

    private Expression rewriteFunction(Function function) throws TeiidComponentException, TeiidProcessingException {
        Expression[] args;
        Function result;
        String type;
        FunctionDescriptor descriptor;
        String functionName = function.getName();
        String actualName = ALIASED_FUNCTIONS.get(functionName);
        FunctionLibrary funcLibrary = this.metadata.getFunctionLibrary();
        if (actualName != null) {
            function.setName(actualName);
            Expression[] args2 = function.getArgs();
            Class[] types = new Class[args2.length];
            for (int i = 0; i < args2.length; ++i) {
                types[i] = args2[i].getType();
            }
            descriptor = funcLibrary.findFunction(actualName, types);
            function.setFunctionDescriptor(descriptor);
        }
        if (StringUtil.startsWithIgnoreCase((String)functionName, (String)"parse")) {
            type = functionName.substring(5);
            if (PARSE_FORMAT_TYPES.contains(type) && Number.class.isAssignableFrom(function.getType()) && !type.equals("bigdecimal")) {
                Function result2 = new Function("parsebigdecimal", function.getArgs());
                descriptor = funcLibrary.findFunction("parsebigdecimal", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
                result2.setFunctionDescriptor(descriptor);
                result2.setType(DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
                return this.rewriteFunction(ResolverUtil.getConversion(result2, "bigdecimal", DataTypeManager.getDataTypeName(function.getType()), false, this.metadata.getFunctionLibrary()));
            }
        } else if (StringUtil.startsWithIgnoreCase((String)functionName, (String)"format") && PARSE_FORMAT_TYPES.contains(type = functionName.substring(6)) && Number.class.isAssignableFrom(function.getArg(0).getType()) && !type.equals("bigdecimal")) {
            Function bigDecimalParam = ResolverUtil.getConversion(function.getArg(0), DataTypeManager.getDataTypeName(function.getArg(0).getType()), "bigdecimal", false, this.metadata.getFunctionLibrary());
            result = new Function("formatbigdecimal", new Expression[]{bigDecimalParam, function.getArg(1)});
            FunctionDescriptor descriptor2 = funcLibrary.findFunction("formatbigdecimal", new Class[]{DataTypeManager.DefaultDataClasses.BIG_DECIMAL, DataTypeManager.DefaultDataClasses.STRING});
            result.setFunctionDescriptor(descriptor2);
            result.setType(DataTypeManager.DefaultDataClasses.STRING);
            return this.rewriteFunction(result);
        }
        boolean omitNull = false;
        Integer code = FUNCTION_MAP.get(functionName);
        if (code != null) {
            switch (code) {
                case 0: {
                    result = new Function("repeat", new Expression[]{new Constant(" "), function.getArg(0)});
                    FunctionDescriptor descriptor3 = funcLibrary.findFunction("repeat", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER});
                    result.setFunctionDescriptor(descriptor3);
                    result.setType(DataTypeManager.DefaultDataClasses.STRING);
                    function = result;
                    break;
                }
                case 1: {
                    result = new Function("timestampadd", new Expression[]{new Constant("SQL_TSI_SECOND"), function.getArg(0), new Constant(new Timestamp(0L))});
                    FunctionDescriptor descriptor3 = funcLibrary.findFunction("timestampadd", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.TIMESTAMP});
                    result.setFunctionDescriptor(descriptor3);
                    result.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
                    function = result;
                    break;
                }
                case 2: {
                    List<Criteria> when = Arrays.asList(new CompareCriteria(function.getArg(0), 1, function.getArg(1)));
                    Constant nullConstant = new Constant(null, function.getType());
                    List<Expression> then = Arrays.asList(nullConstant);
                    SearchedCaseExpression caseExpr = new SearchedCaseExpression(when, then);
                    caseExpr.setElseExpression(function.getArg(0));
                    caseExpr.setType(function.getType());
                    return this.rewriteExpressionDirect(caseExpr);
                }
                case 3: {
                    args = function.getArgs();
                    if (args.length != 2) break;
                    Function result3 = new Function("ifnull", new Expression[]{function.getArg(0), function.getArg(1)});
                    FunctionDescriptor descriptor4 = funcLibrary.findFunction("ifnull", new Class[]{function.getType(), function.getType()});
                    result3.setFunctionDescriptor(descriptor4);
                    result3.setType(function.getType());
                    function = result3;
                    break;
                }
                case 4: {
                    omitNull = true;
                    break;
                }
                case 5: {
                    if (function.getType() == DataTypeManager.DefaultDataClasses.TIMESTAMP) break;
                    descriptor = funcLibrary.findFunction("timestampadd", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.TIMESTAMP});
                    function.setFunctionDescriptor(descriptor);
                    Class<?> type2 = function.getType();
                    function.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
                    function.getArgs()[2] = ResolverUtil.getConversion(function.getArg(2), DataTypeManager.getDataTypeName(type2), "timestamp", false, funcLibrary);
                    function = ResolverUtil.getConversion(function, "timestamp", DataTypeManager.getDataTypeName(type2), false, funcLibrary);
                    break;
                }
                case 6: 
                case 7: {
                    descriptor = funcLibrary.findFunction("parsetimestamp", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
                    function.setName("parsetimestamp");
                    function.setFunctionDescriptor(descriptor);
                    Class<?> type2 = function.getType();
                    function.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
                    function = ResolverUtil.getConversion(function, "timestamp", DataTypeManager.getDataTypeName(type2), false, funcLibrary);
                    break;
                }
                case 8: 
                case 9: {
                    descriptor = funcLibrary.findFunction("formattimestamp", new Class[]{DataTypeManager.DefaultDataClasses.TIMESTAMP, DataTypeManager.DefaultDataClasses.STRING});
                    function.setName("formattimestamp");
                    function.setFunctionDescriptor(descriptor);
                    function.getArgs()[0] = ResolverUtil.getConversion(function.getArg(0), DataTypeManager.getDataTypeName(function.getArg(0).getType()), "timestamp", false, funcLibrary);
                    break;
                }
                case 10: {
                    FunctionDescriptor descriptor4;
                    if (!new Constant(" ").equals(function.getArg(1))) break;
                    String spec = (String)((Constant)function.getArg(0)).getValue();
                    Expression string = function.getArg(2);
                    if (!"TRAILING".equalsIgnoreCase(spec)) {
                        function = new Function("ltrim", new Expression[]{string});
                        descriptor4 = funcLibrary.findFunction("ltrim", new Class[]{DataTypeManager.DefaultDataClasses.STRING});
                        function.setFunctionDescriptor(descriptor4);
                        function.setType(DataTypeManager.DefaultDataClasses.STRING);
                        string = function;
                    }
                    if ("LEADING".equalsIgnoreCase(spec)) break;
                    function = new Function("rtrim", new Expression[]{string});
                    descriptor4 = funcLibrary.findFunction("rtrim", new Class[]{DataTypeManager.DefaultDataClasses.STRING});
                    function.setFunctionDescriptor(descriptor4);
                    function.setType(DataTypeManager.DefaultDataClasses.STRING);
                }
            }
        }
        args = function.getArgs();
        Expression[] newArgs = new Expression[args.length];
        int j = 0;
        for (int i = 0; i < args.length; ++i) {
            Expression ex = this.rewriteExpressionDirect(args[i]);
            if (QueryRewriter.isNull(ex)) {
                if (!function.getFunctionDescriptor().isNullDependent()) {
                    return new Constant(null, function.getType());
                }
                if (omitNull) continue;
            }
            newArgs[j++] = ex;
        }
        if (omitNull) {
            if (j == 0) {
                return new Constant(null, function.getType());
            }
            if (j == 1) {
                return newArgs[0];
            }
            if (j != args.length) {
                newArgs = Arrays.copyOf(newArgs, j);
            }
        }
        function.setArgs(newArgs);
        if (FunctionLibrary.isConvert(function)) {
            Class<?> srcType = newArgs[0].getType();
            Class<?> tgtType = function.getType();
            if (srcType != null && tgtType != null && srcType.equals(tgtType)) {
                return newArgs[0];
            }
            if (function.isImplicit()) {
                function.setImplicit(false);
            }
            if (!(newArgs[0] instanceof Function) || tgtType == DataTypeManager.DefaultDataClasses.OBJECT) {
                return function;
            }
            Function nested = (Function)newArgs[0];
            if (!FunctionLibrary.isConvert(nested)) {
                return function;
            }
            Class<?> nestedType = nested.getArgs()[0].getType();
            Transform t = DataTypeManager.getTransform(nestedType, nested.getType());
            if (t.isExplicit()) {
                return function;
            }
            if (DataTypeManager.getTransform(nestedType, tgtType) == null) {
                return function;
            }
            if (tgtType == DataTypeManager.DefaultDataClasses.STRING && (nestedType == DataTypeManager.DefaultDataClasses.BOOLEAN || nestedType == DataTypeManager.DefaultDataClasses.DATE || nestedType == DataTypeManager.DefaultDataClasses.TIME || tgtType == DataTypeManager.DefaultDataClasses.BIG_DECIMAL || tgtType == DataTypeManager.DefaultDataClasses.FLOAT || tgtType == DataTypeManager.DefaultDataClasses.DOUBLE && srcType != DataTypeManager.DefaultDataClasses.FLOAT)) {
                return function;
            }
            return this.rewriteExpressionDirect(ResolverUtil.getConversion(nested.getArgs()[0], DataTypeManager.getDataTypeName(nestedType), DataTypeManager.getDataTypeName(tgtType), false, funcLibrary));
        }
        if (function.getName().equalsIgnoreCase("decodestring") || function.getName().equalsIgnoreCase("decodeinteger")) {
            return this.convertDecodeFunction(function);
        }
        return function;
    }

    private Expression convertDecodeFunction(Function function) {
        Expression[] exprs = function.getArgs();
        String decodeString = (String)((Constant)exprs[1]).getValue();
        String decodeDelimiter = ",";
        if (exprs.length == 3) {
            decodeDelimiter = (String)((Constant)exprs[2]).getValue();
        }
        ArrayList<IsNullCriteria> newWhens = new ArrayList<IsNullCriteria>();
        ArrayList<Constant> newThens = new ArrayList<Constant>();
        Constant elseConst = null;
        StringTokenizer tokenizer = new StringTokenizer(decodeString, decodeDelimiter);
        while (tokenizer.hasMoreTokens()) {
            String compareString = QueryRewriter.convertString(tokenizer.nextToken().trim());
            if (tokenizer.hasMoreTokens()) {
                String resultString = QueryRewriter.convertString(tokenizer.nextToken().trim());
                PredicateCriteria crit = compareString == null ? new IsNullCriteria((Expression)exprs[0].clone()) : new CompareCriteria((Expression)exprs[0].clone(), 1, new Constant(compareString));
                newWhens.add((IsNullCriteria)crit);
                newThens.add(new Constant(resultString));
                continue;
            }
            elseConst = new Constant(compareString);
        }
        SearchedCaseExpression newCaseExpr = new SearchedCaseExpression(newWhens, newThens);
        if (elseConst != null) {
            newCaseExpr.setElseExpression(elseConst);
        } else {
            newCaseExpr.setElseExpression(exprs[0]);
        }
        newCaseExpr.setType(DataTypeManager.DefaultDataClasses.STRING);
        if (function.getName().equalsIgnoreCase("decodeinteger")) {
            return ResolverUtil.getConversion(newCaseExpr, "string", "integer", false, this.metadata.getFunctionLibrary());
        }
        return newCaseExpr;
    }

    private static String convertString(String string) {
        if (string.equals("")) {
            return null;
        }
        if (string.equalsIgnoreCase("null")) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            if (string.length() == 2) {
                string = "";
            } else if (!string.equalsIgnoreCase("'") && !string.equalsIgnoreCase("\"")) {
                string = string.substring(1);
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private Expression rewriteCaseExpression(CaseExpression expr) throws TeiidComponentException, TeiidProcessingException {
        ArrayList<CompareCriteria> whens = new ArrayList<CompareCriteria>(expr.getWhenCount());
        for (Expression expression : expr.getWhen()) {
            whens.add(new CompareCriteria((Expression)expr.getExpression().clone(), 1, expression));
        }
        SearchedCaseExpression sce = new SearchedCaseExpression(whens, expr.getThen());
        sce.setElseExpression(expr.getElseExpression());
        sce.setType(expr.getType());
        return this.rewriteCaseExpression(sce);
    }

    private Expression rewriteCaseExpression(SearchedCaseExpression expr) throws TeiidComponentException, TeiidProcessingException {
        int whenCount = expr.getWhenCount();
        ArrayList<Criteria> whens = new ArrayList<Criteria>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        boolean hasTrue = false;
        for (int i = 0; i < whenCount; ++i) {
            Criteria rewrittenWhen = this.rewriteCriteria(expr.getWhenCriteria(i));
            if (rewrittenWhen == FALSE_CRITERIA || rewrittenWhen == UNKNOWN_CRITERIA) continue;
            whens.add(rewrittenWhen);
            thens.add(this.rewriteExpressionDirect(expr.getThenExpression(i)));
            if (rewrittenWhen != TRUE_CRITERIA) continue;
            if (i == 0) {
                return this.rewriteExpressionDirect(expr.getThenExpression(i));
            }
            hasTrue = true;
            break;
        }
        if (expr.getElseExpression() != null) {
            if (!hasTrue) {
                expr.setElseExpression(this.rewriteExpressionDirect(expr.getElseExpression()));
            } else {
                expr.setElseExpression(null);
            }
        }
        Expression elseExpr = expr.getElseExpression();
        if (whens.size() == 0) {
            if (elseExpr == null) {
                return new Constant(null, expr.getType());
            }
            return elseExpr;
        }
        expr.setWhen(whens, thens);
        if (elseExpr != null) {
            boolean bAllMatch = true;
            for (int i = 0; i < whenCount; ++i) {
                if (((Expression)thens.get(i)).equals(elseExpr)) continue;
                bAllMatch = false;
                break;
            }
            if (bAllMatch) {
                return elseExpr;
            }
        }
        return expr;
    }

    private Command rewriteExec(StoredProcedure storedProcedure) throws TeiidComponentException, TeiidProcessingException {
        storedProcedure.setDisplayNamedParameters(false);
        for (SPParameter param : storedProcedure.getInputParameters()) {
            if (!this.processing) {
                param.setExpression(this.rewriteExpressionDirect(param.getExpression()));
                continue;
            }
            if (param.getExpression() instanceof Constant) continue;
            boolean isBindEligible = !this.isConstantConvert(param.getExpression());
            param.setExpression(this.evaluate(param.getExpression(), isBindEligible));
        }
        return storedProcedure;
    }

    private Command rewriteInsert(Insert insert) throws TeiidComponentException, TeiidProcessingException {
        if (insert.isMerge()) {
            Collection keys = this.metadata.getUniqueKeysInGroup(insert.getGroup().getMetadataID());
            if (keys.isEmpty()) {
                throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID31132, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31132, new Object[]{insert.getGroup()}));
            }
            Object key = keys.iterator().next();
            LinkedHashSet keyCols = new LinkedHashSet(this.metadata.getElementIDsInKey(key));
            Insert newInsert = new Insert();
            newInsert.setGroup(insert.getGroup().clone());
            newInsert.setVariables(LanguageObject.Util.deepClone(insert.getVariables(), ElementSymbol.class));
            ArrayList<ElementSymbol> values = new ArrayList<ElementSymbol>();
            IfStatement ifStatement = new IfStatement();
            Query exists = new Query();
            exists.setSelect(new Select(Arrays.asList(new Constant(1))));
            exists.setFrom(new From(Arrays.asList(new UnaryFromClause(insert.getGroup().clone()))));
            ifStatement.setCondition(new ExistsCriteria(exists));
            Update update = new Update();
            update.setGroup(insert.getGroup().clone());
            SetClauseList setClauses = new SetClauseList();
            update.setChangeList(setClauses);
            ArrayList<Criteria> crits = new ArrayList<Criteria>();
            GroupSymbol varGroup = QueryRewriter.getVarGroup(insert);
            for (ElementSymbol es : insert.getVariables()) {
                ElementSymbol var = new ElementSymbol(es.getShortName(), varGroup.clone());
                values.add(var.clone());
                if (keyCols.contains(es.getMetadataID())) {
                    CompareCriteria cc = new CompareCriteria(es.clone(), 1, var.clone());
                    crits.add(cc);
                    continue;
                }
                setClauses.addClause(new SetClause(es.clone(), var.clone()));
            }
            newInsert.setValues(values);
            update.setCriteria((Criteria)Criteria.combineCriteria(crits).clone());
            exists.setCriteria((Criteria)Criteria.combineCriteria(crits).clone());
            ifStatement.setIfBlock(new Block(new CommandStatement(update)));
            ifStatement.setElseBlock(new Block(new CommandStatement(newInsert)));
            QueryCommand query = insert.getQueryExpression();
            if (query == null) {
                Query q = new Query();
                Select s = new Select();
                s.addSymbols(LanguageObject.Util.deepClone(insert.getValues(), Expression.class));
                q.setSelect(s);
                query = q;
            }
            query = QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), query, this.metadata, insert.getVariables());
            return this.asLoopProcedure(insert.getGroup(), query, ifStatement, varGroup, 2);
        }
        UpdateValidator.UpdateInfo info = insert.getUpdateInfo();
        if (info != null && info.isInherentInsert()) {
            UpdateValidator.UpdateMapping mapping = info.findInsertUpdateMapping(insert, true);
            if (mapping == null) {
                throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30375, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30375, new Object[]{insert.getVariables()}));
            }
            Map<ElementSymbol, ElementSymbol> symbolMap = mapping.getUpdatableViewSymbols();
            ArrayList<ElementSymbol> mappedSymbols = new ArrayList<ElementSymbol>(insert.getVariables().size());
            for (ElementSymbol symbol : insert.getVariables()) {
                mappedSymbols.add(symbolMap.get(symbol));
            }
            insert.setVariables(mappedSymbols);
            insert.setGroup(mapping.getGroup().clone());
            insert.setUpdateInfo(ProcedureContainerResolver.getUpdateInfo(insert.getGroup(), this.metadata, 2, true));
            return this.rewriteInsert(insert);
        }
        if (insert.getQueryExpression() != null) {
            insert.setQueryExpression((QueryCommand)this.rewriteCommand(insert.getQueryExpression(), true));
            return this.correctDatatypes(insert);
        }
        List expressions = insert.getValues();
        ArrayList<Expression> evalExpressions = new ArrayList<Expression>(expressions.size());
        Iterator expIter = expressions.iterator();
        boolean preserveUnknownOld = this.preserveUnknown;
        this.preserveUnknown = true;
        while (expIter.hasNext()) {
            Expression exp = (Expression)expIter.next();
            if (this.processing && exp instanceof ExpressionSymbol) {
                evalExpressions.add(this.evaluate(exp, true));
                continue;
            }
            evalExpressions.add(this.rewriteExpressionDirect(exp));
        }
        this.preserveUnknown = preserveUnknownOld;
        insert.setValues(evalExpressions);
        return insert;
    }

    private static GroupSymbol getVarGroup(TargetedCommand cmd) {
        if (cmd.getGroup().getShortName().equalsIgnoreCase("X")) {
            return new GroupSymbol("X1");
        }
        return new GroupSymbol("X");
    }

    public static Query createInlineViewQuery(GroupSymbol inlineGroup, Command nested, QueryMetadataInterface metadata, List<? extends Expression> actualSymbols) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Query query = new Query();
        Select select = new Select();
        query.setSelect(select);
        From from = new From();
        from.addClause(new UnaryFromClause(inlineGroup));
        TempMetadataStore store = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(metadata, store);
        if (nested instanceof QueryCommand) {
            Query firstProject = ((QueryCommand)nested).getProjectedQuery();
            QueryRewriter.makeSelectUnique(firstProject.getSelect(), false);
        }
        TempMetadataID gid = store.addTempGroup(inlineGroup.getName(), nested.getProjectedSymbols());
        inlineGroup.setMetadataID(gid);
        ArrayList actualTypes = new ArrayList(nested.getProjectedSymbols().size());
        for (Expression expression : actualSymbols) {
            actualTypes.add(expression.getType());
        }
        List<Expression> selectSymbols = SetQuery.getTypedProjectedSymbols(ResolverUtil.resolveElementsInGroup(inlineGroup, tma), actualTypes, tma);
        Iterator<? extends Expression> iterator = actualSymbols.iterator();
        for (Expression ses : selectSymbols) {
            ses = (Expression)ses.clone();
            Expression actual = iterator.next();
            if (!Symbol.getShortName(ses).equals(Symbol.getShortName(actual))) {
                if (ses instanceof AliasSymbol) {
                    ((AliasSymbol)ses).setShortName(Symbol.getShortName(actual));
                } else {
                    ses = new AliasSymbol(Symbol.getShortName(actual), ses);
                }
            }
            select.addSymbol(ses);
        }
        query.setFrom(from);
        QueryResolver.resolveCommand(query, tma);
        query.setOption(nested.getOption() != null ? (Option)nested.getOption().clone() : null);
        from.getClauses().clear();
        SubqueryFromClause sqfc = new SubqueryFromClause(inlineGroup.getName());
        sqfc.setCommand(nested);
        sqfc.getGroupSymbol().setMetadataID(inlineGroup.getMetadataID());
        from.addClause(sqfc);
        query.getTemporaryMetadata().getData().putAll(store.getData());
        return query;
    }

    public static void makeSelectUnique(Select select, boolean expressionSymbolsOnly) {
        select.setSymbols(select.getProjectedSymbols());
        List<Expression> symbols = select.getSymbols();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (int i = 0; i < symbols.size(); ++i) {
            String baseName;
            Expression symbol = symbols.get(i);
            String name = baseName = Symbol.getShortName(symbol);
            int exprID = 0;
            while (!uniqueNames.add(name)) {
                name = baseName + '_' + exprID++;
            }
            if (expressionSymbolsOnly && !(symbol instanceof ExpressionSymbol)) continue;
            boolean hasAlias = false;
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
                hasAlias = true;
            }
            if ((!(symbol instanceof ExpressionSymbol) || hasAlias) && name.equalsIgnoreCase(baseName)) continue;
            symbols.set(i, new AliasSymbol(name, symbol));
        }
    }

    private Command rewriteUpdate(Update update) throws TeiidComponentException, TeiidProcessingException {
        UpdateValidator.UpdateInfo info = update.getUpdateInfo();
        if (info != null && info.isInherentUpdate()) {
            if (!info.getUnionBranches().isEmpty()) {
                ArrayList<Command> batchedUpdates = new ArrayList<Command>(info.getUnionBranches().size() + 1);
                for (UpdateValidator.UpdateInfo branchInfo : info.getUnionBranches()) {
                    batchedUpdates.add(this.rewriteInherentUpdate((Update)update.clone(), branchInfo));
                }
                batchedUpdates.add(0, this.rewriteInherentUpdate(update, info));
                return new BatchedUpdateCommand(batchedUpdates, true);
            }
            return this.rewriteInherentUpdate(update, info);
        }
        boolean preserveUnknownOld = this.preserveUnknown;
        this.preserveUnknown = true;
        for (SetClause entry : update.getChangeList().getClauses()) {
            entry.setValue(this.rewriteExpressionDirect(entry.getValue()));
        }
        this.preserveUnknown = preserveUnknownOld;
        Criteria crit = update.getCriteria();
        if (crit != null) {
            this.preserveUnknown = false;
            update.setCriteria(this.rewriteCriteria(crit));
            this.preserveUnknown = preserveUnknownOld;
        }
        return update;
    }

    private Command rewriteInherentUpdate(Update update, UpdateValidator.UpdateInfo info) throws QueryValidatorException, QueryMetadataException, TeiidComponentException, QueryResolverException, TeiidProcessingException {
        UpdateValidator.UpdateMapping mapping = info.findUpdateMapping(update.getChangeList().getClauseMap().keySet(), false);
        if (mapping == null) {
            throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30376, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30376, new Object[]{update.getChangeList().getClauseMap().keySet()}));
        }
        Map<ElementSymbol, ElementSymbol> symbolMap = mapping.getUpdatableViewSymbols();
        if (info.isSimple()) {
            update.setGroup(mapping.getGroup().clone());
            for (SetClause clause : update.getChangeList().getClauses()) {
                clause.setSymbol(symbolMap.get(clause.getSymbol()));
            }
            DeepPostOrderNavigator.doVisit(update, new ExpressionMappingVisitor(symbolMap, true));
            if (info.getViewDefinition().getCriteria() != null) {
                update.setCriteria(Criteria.combineCriteria(update.getCriteria(), (Criteria)info.getViewDefinition().getCriteria().clone()));
            }
            update.setUpdateInfo(ProcedureContainerResolver.getUpdateInfo(update.getGroup(), this.metadata, 3, true));
            return this.rewriteUpdate(update);
        }
        Query query = (Query)info.getViewDefinition().clone();
        query.setOrderBy(null);
        SymbolMap expressionMapping = SymbolMap.createSymbolMap(update.getGroup(), query.getProjectedSymbols(), this.metadata);
        SetClauseList setClauseList = (SetClauseList)update.getChangeList().clone();
        GroupSymbol varGroup = QueryRewriter.getVarGroup(update);
        ArrayList<Expression> selectSymbols = this.mapChangeList(setClauseList, symbolMap, varGroup);
        query.setSelect(new Select(selectSymbols));
        ExpressionMappingVisitor emv = new ExpressionMappingVisitor(expressionMapping.asMap(), true);
        PostOrderNavigator.doVisit(query.getSelect(), emv);
        Criteria crit = update.getCriteria();
        if (crit != null) {
            PostOrderNavigator.doVisit(crit, emv);
            query.setCriteria(Criteria.combineCriteria(query.getCriteria(), crit));
        }
        GroupSymbol group = mapping.getGroup();
        String correlationName = mapping.getCorrelatedName().getName();
        return this.createUpdateProcedure(update, query, group, correlationName, setClauseList, varGroup, null);
    }

    private ArrayList<Expression> mapChangeList(SetClauseList setClauses, Map<ElementSymbol, ElementSymbol> symbolMap, GroupSymbol varGroup) {
        ArrayList<Expression> selectSymbols = new ArrayList<Expression>(setClauses.getClauses().size());
        int i = 0;
        for (SetClause clause : setClauses.getClauses()) {
            Expression ex = clause.getValue();
            if (!EvaluatableVisitor.willBecomeConstant(ex)) {
                ex = QueryRewriter.mapExpression(varGroup, selectSymbols, i, ex);
                clause.setValue(ex);
            }
            if (symbolMap != null) {
                clause.setSymbol(symbolMap.get(clause.getSymbol()));
            }
            ++i;
        }
        return selectSymbols;
    }

    private static Expression mapExpression(GroupSymbol varGroup, ArrayList<Expression> selectSymbols, int i, Expression ex) {
        String name = "s_" + i;
        selectSymbols.add(new AliasSymbol(name, ex));
        ex = new ElementSymbol(name, varGroup.clone());
        return ex;
    }

    private Command createUpdateProcedure(Update update, Query query, GroupSymbol group, String correlationName, SetClauseList setClauseList, GroupSymbol varGroup, Criteria constraint) throws TeiidComponentException, QueryMetadataException, QueryResolverException, TeiidProcessingException {
        Update newUpdate = new Update();
        newUpdate.setConstraint(constraint);
        newUpdate.setChangeList(setClauseList);
        newUpdate.setGroup(group.clone());
        List<Criteria> pkCriteria = this.createPkCriteria(group, correlationName, query, varGroup);
        newUpdate.setCriteria(new CompoundCriteria(pkCriteria));
        return this.asLoopProcedure(update.getGroup(), (QueryCommand)query, newUpdate, varGroup, 3);
    }

    private Command asLoopProcedure(GroupSymbol group, QueryCommand query, ProcedureContainer newUpdate, GroupSymbol varGroup, int updateType) throws QueryResolverException, TeiidComponentException, TeiidProcessingException {
        return this.asLoopProcedure(group, query, new CommandStatement(newUpdate), varGroup, updateType);
    }

    private Command asLoopProcedure(GroupSymbol group, QueryCommand query, Statement s, GroupSymbol varGroup, int updateType) throws QueryResolverException, TeiidComponentException, TeiidProcessingException {
        Block b = new Block();
        b.addStatement(s);
        CreateProcedureCommand cupc = new CreateProcedureCommand();
        cupc.setUpdateType(updateType);
        Block parent = new Block();
        parent.setAtomic(true);
        ElementSymbol rowsUpdated = new ElementSymbol("VARIABLES.ROWS_UPDATED");
        DeclareStatement ds = new DeclareStatement(rowsUpdated, "integer", new Constant(0));
        parent.addStatement(ds);
        LoopStatement ls = new LoopStatement(b, query, varGroup.getName());
        parent.addStatement(ls);
        AssignmentStatement as = new AssignmentStatement();
        rowsUpdated.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        as.setVariable(rowsUpdated);
        as.setExpression(new Function("+", new Expression[]{rowsUpdated, new Constant(1)}));
        b.addStatement(as);
        Query returnQuery = new Query();
        returnQuery.setSelect(new Select(Arrays.asList(rowsUpdated.clone())));
        parent.addStatement(new CommandStatement(returnQuery));
        cupc.setBlock(parent);
        cupc.setVirtualGroup(group);
        QueryResolver.resolveCommand(cupc, this.metadata);
        return QueryRewriter.rewrite(cupc, this.metadata, this.context);
    }

    private List<Criteria> createPkCriteria(GroupSymbol group, String correlationName, Query query, GroupSymbol varGroup) throws TeiidComponentException, QueryMetadataException {
        Object pk = this.metadata.getPrimaryKey(group.getMetadataID());
        if (pk == null) {
            pk = this.metadata.getUniqueKeysInGroup(group.getMetadataID()).iterator().next();
        }
        int i = query.getSelect().getSymbols().size();
        List ids = this.metadata.getElementIDsInKey(pk);
        ArrayList<Criteria> pkCriteria = new ArrayList<Criteria>(ids.size());
        for (Object object : ids) {
            ElementSymbol es = new ElementSymbol(correlationName + "." + this.metadata.getName(object));
            query.getSelect().addSymbol(new AliasSymbol("s_" + i, es));
            es = new ElementSymbol(group.getName() + "." + this.metadata.getName(object));
            pkCriteria.add(new CompareCriteria(es, 1, new ElementSymbol("s_" + i, varGroup.clone())));
            ++i;
        }
        return pkCriteria;
    }

    private Command rewriteDelete(Delete delete) throws TeiidComponentException, TeiidProcessingException {
        UpdateValidator.UpdateInfo info = delete.getUpdateInfo();
        if (info != null && info.isInherentDelete()) {
            if (!info.getUnionBranches().isEmpty()) {
                ArrayList<Command> batchedUpdates = new ArrayList<Command>(info.getUnionBranches().size() + 1);
                for (UpdateValidator.UpdateInfo branchInfo : info.getUnionBranches()) {
                    batchedUpdates.add(this.rewriteInherentDelete((Delete)delete.clone(), branchInfo));
                }
                batchedUpdates.add(0, this.rewriteInherentDelete(delete, info));
                return new BatchedUpdateCommand(batchedUpdates, true);
            }
            return this.rewriteInherentDelete(delete, info);
        }
        Criteria crit = delete.getCriteria();
        if (crit != null) {
            boolean preserveUnknownOld = this.preserveUnknown;
            this.preserveUnknown = false;
            delete.setCriteria(this.rewriteCriteria(crit));
            this.preserveUnknown = preserveUnknownOld;
        }
        return delete;
    }

    private Command rewriteInherentDelete(Delete delete, UpdateValidator.UpdateInfo info) throws QueryMetadataException, TeiidComponentException, QueryResolverException, TeiidProcessingException {
        UpdateValidator.UpdateMapping mapping = info.getDeleteTarget();
        if (info.isSimple()) {
            delete.setGroup(mapping.getGroup().clone());
            DeepPostOrderNavigator.doVisit(delete, new ExpressionMappingVisitor(mapping.getUpdatableViewSymbols(), true));
            delete.setUpdateInfo(ProcedureContainerResolver.getUpdateInfo(delete.getGroup(), this.metadata, 4, true));
            if (info.getViewDefinition().getCriteria() != null) {
                delete.setCriteria(Criteria.combineCriteria(delete.getCriteria(), (Criteria)info.getViewDefinition().getCriteria().clone()));
            }
            return this.rewriteDelete(delete);
        }
        Query query = (Query)info.getViewDefinition().clone();
        query.setOrderBy(null);
        SymbolMap expressionMapping = SymbolMap.createSymbolMap(delete.getGroup(), query.getProjectedSymbols(), this.metadata);
        query.setSelect(new Select());
        ExpressionMappingVisitor emv = new ExpressionMappingVisitor(expressionMapping.asMap(), true);
        Criteria crit = delete.getCriteria();
        if (crit != null) {
            PostOrderNavigator.doVisit(crit, emv);
            query.setCriteria(Criteria.combineCriteria(query.getCriteria(), crit));
        }
        GroupSymbol group = mapping.getGroup();
        String correlationName = mapping.getCorrelatedName().getName();
        return this.createDeleteProcedure(delete, query, group, correlationName);
    }

    public static Command createDeleteProcedure(Delete delete, QueryMetadataInterface metadata, CommandContext context) throws QueryResolverException, QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        QueryRewriter rewriter = new QueryRewriter(metadata, context);
        Criteria crit = delete.getCriteria();
        Query query = new Query(new Select(), new From(Arrays.asList(new UnaryFromClause(delete.getGroup()))), crit, null, null);
        return rewriter.createDeleteProcedure(delete, query, delete.getGroup(), delete.getGroup().getName());
    }

    public static Command createUpdateProcedure(Update update, QueryMetadataInterface metadata, CommandContext context) throws QueryResolverException, QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        QueryRewriter rewriter = new QueryRewriter(metadata, context);
        Criteria crit = update.getCriteria();
        if (crit != null) {
            crit = (Criteria)crit.clone();
        }
        SetClauseList setClauseList = (SetClauseList)update.getChangeList().clone();
        GroupSymbol varGroup = QueryRewriter.getVarGroup(update);
        ArrayList<Expression> selectSymbols = rewriter.mapChangeList(setClauseList, null, varGroup);
        Criteria constraint = null;
        if (update.getConstraint() != null) {
            constraint = update.getConstraint();
            HashMap<ElementSymbol, Expression> map = null;
            Collection<ElementSymbol> elems = ElementCollectorVisitor.getElements((LanguageObject)update.getConstraint(), true);
            Set<ElementSymbol> existing = setClauseList.getClauseMap().keySet();
            for (ElementSymbol es : elems) {
                if (existing.contains(es)) continue;
                if (map == null) {
                    map = new HashMap<ElementSymbol, Expression>();
                }
                map.put(es, QueryRewriter.mapExpression(varGroup, selectSymbols, selectSymbols.size(), es));
            }
            if (map != null) {
                constraint = (Criteria)constraint.clone();
                ExpressionMappingVisitor.mapExpressions(constraint, map);
            }
        }
        Query query = new Query(new Select(selectSymbols), new From(Arrays.asList(new UnaryFromClause(update.getGroup()))), crit, null, null);
        return rewriter.createUpdateProcedure(update, query, update.getGroup(), update.getGroup().getName(), setClauseList, varGroup, constraint);
    }

    private Command createDeleteProcedure(Delete delete, Query query, GroupSymbol group, String correlationName) throws TeiidComponentException, QueryMetadataException, QueryResolverException, TeiidProcessingException {
        Delete newUpdate = new Delete();
        newUpdate.setGroup(group.clone());
        GroupSymbol varGroup = QueryRewriter.getVarGroup(delete);
        List<Criteria> pkCriteria = this.createPkCriteria(group, correlationName, query, varGroup);
        newUpdate.setCriteria(new CompoundCriteria(pkCriteria));
        return this.asLoopProcedure(delete.getGroup(), (QueryCommand)query, newUpdate, varGroup, 4);
    }

    private Limit rewriteLimitClause(Limit limit) throws TeiidComponentException, TeiidProcessingException {
        Constant c;
        if (limit.getOffset() != null) {
            if (!this.processing) {
                limit.setOffset(this.rewriteExpressionDirect(limit.getOffset()));
            } else {
                c = this.evaluate(limit.getOffset(), false);
                limit.setOffset(c);
                ValidationVisitor.LIMIT_CONSTRAINT.validate(c.getValue());
            }
            if (ZERO_CONSTANT.equals(limit.getOffset())) {
                limit.setOffset(null);
            }
        }
        if (limit.getRowLimit() != null) {
            if (!this.processing) {
                limit.setRowLimit(this.rewriteExpressionDirect(limit.getRowLimit()));
            } else {
                c = this.evaluate(limit.getRowLimit(), false);
                limit.setRowLimit(c);
                ValidationVisitor.LIMIT_CONSTRAINT.validate(c.getValue());
            }
        }
        return limit;
    }

    static {
        ALIASED_FUNCTIONS.put("lower", "lcase");
        ALIASED_FUNCTIONS.put("upper", "ucase");
        ALIASED_FUNCTIONS.put("cast", "convert");
        ALIASED_FUNCTIONS.put("nvl", "ifnull");
        ALIASED_FUNCTIONS.put("||", "concat");
        ALIASED_FUNCTIONS.put("chr", "char");
        ALIASED_FUNCTIONS.put("st_geomfrombinary", "st_geomfromwkb");
        PARSE_FORMAT_TYPES.addAll(Arrays.asList("time", "date", "timestamp", "bigdecimal", "biginteger", "integer", "long", "float", "double"));
        INTEGER_ZERO = new Integer(0);
        DOUBLE_ZERO = new Double(0.0);
        FLOAT_ZERO = new Float(0.0f);
        LONG_ZERO = new Long(0L);
        BIG_INTEGER_ZERO = new BigInteger("0");
        BIG_DECIMAL_ZERO = new BigDecimal("0");
        SHORT_ZERO = new Short(0);
        BYTE_ZERO = new Byte(0);
        FUNCTION_MAP = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        FUNCTION_MAP.put("space", 0);
        FUNCTION_MAP.put("from_unixtime", 1);
        FUNCTION_MAP.put("nullif", 2);
        FUNCTION_MAP.put("coalesce", 3);
        FUNCTION_MAP.put("CONCAT2", 4);
        FUNCTION_MAP.put("timestampadd", 5);
        FUNCTION_MAP.put("parsedate", 6);
        FUNCTION_MAP.put("parsetime", 7);
        FUNCTION_MAP.put("formatdate", 8);
        FUNCTION_MAP.put("formattime", 9);
        FUNCTION_MAP.put("trim", 10);
    }
}

