/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ObjectConverterUtil;

public final class ApplicationInfo
implements Serializable {
    public static final String APPLICATION_PRODUCT_INFORMATION = "Product Information";
    public static final String APPLICATION_BUILD_NUMBER_PROPERTY = "Build";
    private static final ApplicationInfo INSTANCE = new ApplicationInfo();
    private static final String LINE_SEPARATOR = "\n";
    private Properties props = new Properties();

    private ApplicationInfo() {
        InputStream is = this.getClass().getResourceAsStream("application.properties");
        try {
            try {
                this.props.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10045, (Throwable)e);
        }
    }

    public String getReleaseNumber() {
        return this.props.getProperty("build.releaseNumber");
    }

    public int getMajorReleaseVersion() {
        String version = this.getReleaseNumber().substring(0, this.getReleaseNumber().indexOf(46));
        return Integer.parseInt(version);
    }

    public int getMinorReleaseVersion() {
        int majorIndex = this.getReleaseNumber().indexOf(46);
        String version = this.getReleaseNumber().substring(majorIndex + 1, this.getReleaseNumber().indexOf(46, majorIndex + 1));
        return Integer.parseInt(version);
    }

    public String getBuildNumber() {
        return this.props.getProperty("build.number");
    }

    public String getUrl() {
        return this.props.getProperty("url");
    }

    public String getCopyright() {
        return this.props.getProperty("copyright");
    }

    public String getBuildDate() {
        return this.props.getProperty("build.date");
    }

    public static ApplicationInfo getInstance() {
        return INSTANCE;
    }

    private static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public String getClasspathInfo() {
        String classPath = ApplicationInfo.getClassPath();
        StringBuffer sb = new StringBuffer();
        sb.append("\nDate: " + DateFormat.getDateInstance().format(new Date()));
        sb.append(LINE_SEPARATOR);
        HashMap<String, Boolean> pathResults = new HashMap<String, Boolean>();
        ArrayList<String> reversetList = new ArrayList<String>();
        String separator = System.getProperty("path.separator");
        StringTokenizer path = new StringTokenizer(classPath, separator);
        while (path.hasMoreTokens()) {
            String pathElement = path.nextToken();
            File pathFile = new File(pathElement);
            if (pathFile.exists()) {
                pathResults.put(pathElement, Boolean.TRUE);
            } else {
                pathResults.put(pathElement, Boolean.FALSE);
            }
            reversetList.add(pathElement);
        }
        sb.append("Classpath Information");
        sb.append(LINE_SEPARATOR);
        sb.append("CLASSPATH: ");
        sb.append(classPath);
        sb.append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        Iterator iter = reversetList.iterator();
        sb.append("---- Classpath Entries ----");
        sb.append(LINE_SEPARATOR);
        while (iter.hasNext()) {
            String epath = (String)iter.next();
            Boolean doesExist = (Boolean)pathResults.get(epath);
            sb.append(epath);
            if (!doesExist.booleanValue()) {
                sb.append(" (MISSING)");
            }
            sb.append(LINE_SEPARATOR);
        }
        sb.append(LINE_SEPARATOR);
        sb.append("Note the (MISSING) at the end to designate that the classpath entry is missing");
        try {
            Enumeration<URL> readmes = ClassLoader.getSystemResources("patch_readme.txt");
            sb.append(LINE_SEPARATOR);
            sb.append(LINE_SEPARATOR);
            sb.append("---- Patch Readme Entries----");
            sb.append(LINE_SEPARATOR);
            int cnt = 0;
            if (readmes != null) {
                while (readmes.hasMoreElements()) {
                    ++cnt;
                    URL url = readmes.nextElement();
                    sb.append("Patch " + url.getFile() + ":");
                    sb.append(LINE_SEPARATOR);
                    InputStream is = url.openStream();
                    byte[] data = ObjectConverterUtil.convertToByteArray(is);
                    sb.append(new String(data));
                    sb.append("-------------------------------------");
                    sb.append(LINE_SEPARATOR);
                    is.close();
                }
            }
            if (cnt == 0) {
                sb.append("no Patch Readme Entries found");
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return sb.toString();
    }
}

