/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.datasource;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.datasource.DataSource;
import org.teiid.test.framework.datasource.DataSourceMgr;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class DataSourceFactory {
    private static final String DO_NOT_USE_DEFAULT = "${usedatasources}";
    private Properties configprops;
    private Map<String, String> useDS = null;
    private Map<String, DataSource> availDS = null;
    private Map<String, String> requiredDataBaseTypes = null;
    private Set<String> assignedDataSources = new HashSet<String>();
    private int lastassigned = 0;
    private boolean metDBRequiredTypes = true;
    private boolean hasRequiredDBTypes = false;

    public DataSourceFactory(ConfigPropertyLoader config) {
        this.configprops = PropertiesUtils.clone((Properties)config.getProperties(), null, (boolean)true);
        this.requiredDataBaseTypes = config.getModelAssignedDatabaseTypes();
    }

    public Properties getConfigProperties() {
        return this.configprops;
    }

    protected void config(DataSourceMgr dsmgr) {
        TestLogger.logDebug("Configure Datasource Factory ");
        dsmgr = DataSourceMgr.getInstance();
        Map<String, DataSource> availDatasources = dsmgr.getDataSources();
        this.availDS = new HashMap<String, DataSource>(availDatasources.size());
        String usedstypeprop = this.configprops.getProperty("usedatasourcetypes");
        HashSet useDBTypes = null;
        if (usedstypeprop != null && usedstypeprop.length() > 0) {
            List eprops = StringUtil.split((String)usedstypeprop, (String)",");
            useDBTypes = new HashSet(eprops.size());
            useDBTypes.addAll(eprops);
            System.out.println("EXCLUDE datasources: " + usedstypeprop);
        } else {
            useDBTypes = Collections.EMPTY_SET;
        }
        String excludeprop = this.configprops.getProperty("excludedatasourcetypes");
        HashSet excludedDBTypes = null;
        if (excludeprop != null && excludeprop.length() > 0) {
            List eprops = StringUtil.split((String)excludeprop, (String)",");
            excludedDBTypes = new HashSet(eprops.size());
            excludedDBTypes.addAll(eprops);
            System.out.println("EXCLUDE datasources: " + excludeprop);
        } else {
            excludedDBTypes = Collections.EMPTY_SET;
        }
        String limitdsprop = this.configprops.getProperty("usedatasources");
        if (limitdsprop != null && limitdsprop.length() > 0 && !limitdsprop.equalsIgnoreCase(DO_NOT_USE_DEFAULT)) {
            TestLogger.log("Use ONLY datasources: " + limitdsprop);
            List dss = StringUtil.split((String)limitdsprop, (String)",");
            this.useDS = new HashMap<String, String>(dss.size());
            DataSource ds = null;
            int i = 1;
            for (String dssName : dss) {
                ds = availDatasources.get(dssName);
                if (ds != null && !excludedDBTypes.contains(ds.getDBType())) {
                    this.useDS.put(String.valueOf(i), dssName);
                    this.availDS.put(dssName, ds);
                    TestLogger.logInfo("Using ds: " + dssName);
                }
                ++i;
            }
        } else {
            for (DataSource ds : availDatasources.values()) {
                if (excludedDBTypes.contains(ds.getDBType())) continue;
                if (useDBTypes.size() > 0) {
                    if (!usedstypeprop.contains(ds.getDBType())) continue;
                    this.availDS.put(ds.getName(), ds);
                    continue;
                }
                this.availDS.put(ds.getName(), ds);
            }
        }
        if (this.requiredDataBaseTypes != null && this.requiredDataBaseTypes.size() > 0) {
            this.hasRequiredDBTypes = true;
            for (String modelName : this.requiredDataBaseTypes.keySet()) {
                String rdbtype = this.requiredDataBaseTypes.get(modelName);
                Iterator<DataSource> ait = this.availDS.values().iterator();
                this.metDBRequiredTypes = false;
                while (ait.hasNext()) {
                    DataSource ds = ait.next();
                    if (!ds.getDBType().equalsIgnoreCase(rdbtype)) continue;
                    this.assignedDataSources.add(ds.getName());
                    dsmgr.setDataSource(modelName, ds);
                    this.metDBRequiredTypes = true;
                }
                if (this.metDBRequiredTypes) continue;
                break;
            }
        }
    }

    public int getNumberAvailableDataSources() {
        return this.metDBRequiredTypes ? this.availDS.size() : 0;
    }

    public synchronized DataSource getDatasource(String modelName) throws QueryTestFailedException {
        DataSource ds = null;
        String key = null;
        key = modelName;
        if (this.hasRequiredDBTypes) {
            if (this.requiredDataBaseTypes.containsKey(modelName)) {
                String dbtype = this.requiredDataBaseTypes.get(modelName);
                for (DataSource checkit : this.availDS.values()) {
                    if (!dbtype.equalsIgnoreCase(checkit.getDBType())) continue;
                    ds = checkit;
                    break;
                }
            }
        } else if (this.useDS != null) {
            String dsname = this.useDS.get(modelName);
            if (dsname != null && (ds = this.availDS.get(dsname)) == null) {
                throw new QueryTestFailedException("Datasource name " + dsname + " was not found in the allDatasources map");
            }
        } else {
            for (DataSource checkit : this.availDS.values()) {
                if (this.assignedDataSources.contains(checkit.getName())) continue;
                ds = checkit;
                break;
            }
        }
        if (ds == null) {
            int cnt = 0;
            for (String dsname : this.assignedDataSources) {
                if (cnt != this.lastassigned) continue;
                ds = this.availDS.get(dsname);
                ++this.lastassigned;
                if (this.lastassigned < this.assignedDataSources.size()) break;
                this.lastassigned = 0;
                break;
            }
        }
        if (ds != null) {
            this.assignedDataSources.add(ds.getName());
        }
        return ds;
    }

    public void cleanup() {
        this.assignedDataSources.clear();
        if (this.useDS != null) {
            this.useDS.clear();
        }
    }

    public static void main(String[] args) {
        ConfigPropertyLoader config = ConfigPropertyLoader.getInstance();
        DataSourceFactory factory = new DataSourceFactory(config);
        try {
            if (factory.getDatasource("model1") == null) {
                throw new TransactionRuntimeException("No datasource was not found");
            }
        }
        catch (QueryTestFailedException e) {
            e.printStackTrace();
        }
        factory.cleanup();
        ConfigPropertyLoader.reset();
        config = ConfigPropertyLoader.getInstance();
        config.setProperty("usedatasources", "oracle,sqlserver");
        factory = new DataSourceFactory(config);
        try {
            DataSource dsfind = factory.getDatasource("model2");
            if (dsfind == null) {
                throw new TransactionRuntimeException("No datasource was not found as the 2nd datasource");
            }
            if (dsfind.getConnectorType() == null) {
                throw new TransactionRuntimeException("Connector types was not defined");
            }
            if (!dsfind.getName().equalsIgnoreCase("sqlserver")) {
                throw new TransactionRuntimeException("Sqlserver was not found as the 2nd datasource");
            }
            dsfind = factory.getDatasource("model1");
            if (dsfind == null) {
                throw new TransactionRuntimeException("No datasource was not found as the 2nd datasource");
            }
            if (!dsfind.getName().equalsIgnoreCase("oracle")) {
                throw new TransactionRuntimeException("Oracle was not found as the 2nd datasource");
            }
            System.out.println("Datasource :" + dsfind.getName() + " was found");
            factory.cleanup();
            ConfigPropertyLoader.reset();
            config = ConfigPropertyLoader.getInstance();
            config.setProperty("excludedatasourcetypes", "sqlserver");
            factory = new DataSourceFactory(config);
            int n = factory.getNumberAvailableDataSources();
            TestLogger.log("Num avail datasources: " + n);
            for (int i = 0; i < n; ++i) {
                String k = String.valueOf(i);
                DataSource ds1 = factory.getDatasource("model" + k);
                if (ds1 == null) {
                    throw new TransactionRuntimeException("No datasource was found for: model:" + k);
                }
                if (!ds1.getDBType().equalsIgnoreCase("sqlserver")) continue;
                throw new TransactionRuntimeException("sqlserver dbtype should have been excluded");
            }
            DataSource reuse = factory.getDatasource("model1");
            if (reuse == null) {
                throw new TransactionRuntimeException("The process was not able to reassign an already used datasource");
            }
            factory.cleanup();
            ConfigPropertyLoader.reset();
            config = ConfigPropertyLoader.getInstance();
            config.setModelAssignedToDatabaseType("pm1", "oracle");
            factory = new DataSourceFactory(config);
            DataSource ds1 = factory.getDatasource("pm1");
            if (!ds1.getDBType().equalsIgnoreCase("oracle")) {
                throw new TransactionRuntimeException("Required DB Type of oracle for model pm1 is :" + ds1.getDBType());
            }
            TestLogger.log("Test1 Required DS1 " + ds1.getDBType());
            factory.cleanup();
            ConfigPropertyLoader.reset();
            config = ConfigPropertyLoader.getInstance();
            config.setModelAssignedToDatabaseType("pm2", "sqlserver");
            config.setModelAssignedToDatabaseType("pm1", "any");
            factory = new DataSourceFactory(config);
            DataSource ds2 = factory.getDatasource("pm2");
            if (!ds2.getDBType().equalsIgnoreCase("sqlserver")) {
                throw new TransactionRuntimeException("Required DB Type of sqlserver for model pm2 is :" + ds2.getDBType());
            }
            TestLogger.log("Test2 Required DS2 " + ds2.getDBType());
            factory.cleanup();
            ConfigPropertyLoader.reset();
            config = ConfigPropertyLoader.getInstance();
            config.setModelAssignedToDatabaseType("pm2", "sqlserver");
            config.setModelAssignedToDatabaseType("pm1", "oracle");
            factory = new DataSourceFactory(config);
            DataSource ds3a = factory.getDatasource("pm2");
            if (!ds3a.getDBType().equalsIgnoreCase("sqlserver")) {
                throw new TransactionRuntimeException("Required DB Type of sqlserver for model pm12 is :" + ds3a.getDBType());
            }
            DataSource ds3b = factory.getDatasource("pm1");
            if (!ds3b.getDBType().equalsIgnoreCase("oracle")) {
                throw new TransactionRuntimeException("Required DB Type of oracle for model pm1  is :" + ds3b.getDBType());
            }
            TestLogger.log("Test3 Required DS3a " + ds3a.getDBType());
            TestLogger.log("Test3 Required DS3b " + ds3b.getDBType());
            factory.cleanup();
        }
        catch (QueryTestFailedException e) {
            e.printStackTrace();
        }
    }

    public static interface DataBaseTypes {
        public static final String MYSQL = "mysql";
        public static final String ORACLE = "oracle";
        public static final String POSTRES = "postgres";
        public static final String SQLSERVER = "sqlserver";
        public static final String DB2 = "db2";
        public static final String SYBASE = "sybase";
        public static final String DERBY = "derby";
        public static final String ANY = "any";
    }
}

