/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.CorrelatedReferenceCollectorVisitor;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestCorrelatedReferenceCollectorVisitor {
    @Test
    public void testDeepNesting() throws Exception {
        String sql = "select * from bqt1.smalla where exists (select intnum from bqt1.smalla x where smalla.intnum = x.intnum and exists (select intnum from bqt1.smalla where exists (select intnum from bqt1.smalla x where smalla.intnum = x.intnum)))";
        Command command = TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        command = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null);
        command = ((ExistsCriteria)((Query)command).getCriteria()).getCommand();
        LinkedList correlatedReferences = new LinkedList();
        GroupSymbol gs = new GroupSymbol("bqt1.smalla");
        ResolverUtil.resolveGroup((GroupSymbol)gs, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        CorrelatedReferenceCollectorVisitor.collectReferences((LanguageObject)command, Arrays.asList(gs), correlatedReferences, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Assert.assertEquals((long)1L, (long)correlatedReferences.size());
    }
}

