/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import junit.framework.TestCase;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.FakeConnector;
import org.teiid.dqp.internal.datamgr.TestConnectorWorkItem;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.translator.ExecutionFactory;

public final class TestConnectorManager
extends TestCase {
    private AtomicRequestMessage request;
    private ConnectorManager csm;

    static ConnectorManager getConnectorManager() throws Exception {
        final FakeConnector c = new FakeConnector();
        ConnectorManager cm = new ConnectorManager("FakeConnector", "FakeConnector"){

            public ExecutionFactory getExecutionFactory() {
                return c;
            }

            public Object getConnectionFactory() {
                return c;
            }
        };
        cm.start();
        return cm;
    }

    public TestConnectorManager(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.request = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        this.csm = TestConnectorManager.getConnectorManager();
    }

    void helpAssureOneState() throws Exception {
        this.csm.registerRequest(this.request);
        ConnectorWork state = this.csm.getState(this.request.getAtomicRequestID());
        TestConnectorManager.assertEquals((Object)state, (Object)this.csm.getState(this.request.getAtomicRequestID()));
    }

    public void testCreateAndAddRequestState() throws Exception {
        this.helpAssureOneState();
        TestConnectorManager.assertEquals((String)"Expected size of 1", (int)1, (int)this.csm.size());
    }

    public void testIllegalCreate() throws Exception {
        this.helpAssureOneState();
        try {
            this.helpAssureOneState();
            TestConnectorManager.fail((String)"expected exception");
        }
        catch (AssertionError e) {
            TestConnectorManager.assertEquals((String)"State already existed", (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testRemoveRequestState() throws Exception {
        this.helpAssureOneState();
        this.csm.removeState(this.request.getAtomicRequestID());
        TestConnectorManager.assertEquals((String)"Expected size of 0", (int)0, (int)this.csm.size());
    }

    public void testRemoveUnknownRequestState() throws Exception {
        this.helpAssureOneState();
        this.csm.removeState(new AtomicRequestID(new RequestID("ZZZZ", 3210L), 5, 5));
        TestConnectorManager.assertEquals((String)"Expected size of 1", (int)1, (int)this.csm.size());
    }
}

