/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestCommonTableOptimizations {
    @Test
    public void testDuplicateSourceQuery() {
        String sql = "SELECT e1 FROM pm1.g1 union all select e1 from pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("a"), Arrays.asList("b")};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1 FROM pm1.g1", new List[]{Arrays.asList("a"), Arrays.asList("b")});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
        Assert.assertEquals((long)3L, (long)dataManager.getCommandHistory().size());
    }

    @Ignore
    @Test
    public void testDuplicateSimpleQuery() {
        String sql = "SELECT e1 FROM pm1.g1 union all select e2 from pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("a"), Arrays.asList("b")};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1 FROM pm1.g1", new List[]{Arrays.asList("a"), Arrays.asList("b")});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
        Assert.assertEquals((long)3L, (long)dataManager.getCommandHistory().size());
    }
}

