/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.io.CharArrayWriter;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import net.sf.saxon.TransformerFactoryImpl;
import org.teiid.query.processor.xml.Element;
import org.teiid.query.processor.xml.NodeDescriptor;

public class TestElement
extends TestCase {
    private CharArrayWriter streamResultHolder;
    private TransformerHandler handler;

    public TestElement(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.streamResultHolder = new CharArrayWriter();
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        this.handler = factory.newTransformerHandler();
        this.handler.setResult(new StreamResult(this.streamResultHolder));
        this.handler.startDocument();
    }

    public void testStartAndEndEmptyElement() throws Exception {
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)"E1", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        Element element = new Element(descriptor, this.handler);
        element.startElement();
        element.endElement();
        this.handler.endDocument();
        TestElement.assertEquals((String)new String(this.streamResultHolder.toCharArray()), (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><E1/>");
    }

    public void testStartAndEndElement() throws Exception {
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)"E1", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        Element element = new Element(descriptor, this.handler);
        element.setContent("test");
        element.startElement();
        element.endElement();
        this.handler.endDocument();
        TestElement.assertEquals((String)new String(this.streamResultHolder.toCharArray()), (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><E1>test</E1>");
    }

    public void testAddAttributes() throws Exception {
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)"E1", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        Element element = new Element(descriptor, this.handler);
        descriptor = NodeDescriptor.createNodeDescriptor((String)"a1", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        element.setAttribute(descriptor, "test attribute");
        element.setContent("test");
        element.startElement();
        element.endElement();
        this.handler.endDocument();
        TestElement.assertEquals((String)new String(this.streamResultHolder.toCharArray()), (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><E1 a1=\"test attribute\">test</E1>");
    }

    public void testIsChildOf() throws Exception {
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)"E1", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        Element element1 = new Element(descriptor, this.handler);
        descriptor = NodeDescriptor.createNodeDescriptor((String)"E2", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        Element element2 = new Element(descriptor, this.handler);
        descriptor = NodeDescriptor.createNodeDescriptor((String)"E3", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        Element element3 = new Element(descriptor, this.handler);
        element2.setParent(element1);
        element3.setParent(element2);
        TestElement.assertTrue((boolean)element3.isChildOf(element1));
    }

    public void testNamespace() throws Exception {
        Properties namespaceURIs = new Properties();
        namespaceURIs.setProperty("n", "http://test");
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)"E1", (String)"n", (boolean)true, null, (Properties)namespaceURIs, null, (boolean)false, null, (String)"preserve");
        Element element = new Element(descriptor, this.handler);
        element.setContent("test");
        element.startElement();
        element.endElement();
        this.handler.endDocument();
        TestElement.assertEquals((String)new String(this.streamResultHolder.toCharArray()), (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><n:E1 xmlns:n=\"http://test\">test</n:E1>");
    }

    public void testNamespace2() throws Exception {
        Properties namespaceURIs = new Properties();
        namespaceURIs.setProperty("n", "http://test");
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)"E1", null, (boolean)true, null, (Properties)namespaceURIs, null, (boolean)false, null, (String)"preserve");
        Element element = new Element(descriptor, this.handler);
        element.setContent("test");
        element.startElement();
        namespaceURIs = new Properties();
        namespaceURIs.setProperty("n", "");
        descriptor = NodeDescriptor.createNodeDescriptor((String)"E2", (String)"n", (boolean)true, null, (Properties)namespaceURIs, null, (boolean)false, null, (String)"preserve");
        Element element2 = new Element(descriptor, this.handler);
        element2.setContent("test");
        element2.startElement();
        element2.endElement();
        element.endElement();
        this.handler.endDocument();
        TestElement.assertEquals((String)new String(this.streamResultHolder.toCharArray()), (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><E1 xmlns:n=\"http://test\">test<n:E2>test</n:E2></E1>");
    }
}

