/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.AccessibleByteArrayOutputStream;

public class ReaderInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = DataTypeManager.MAX_LOB_MEMORY_BYTES;
    private final Reader reader;
    private Writer writer;
    private char[] charBuffer;
    private AccessibleByteArrayOutputStream out = new AccessibleByteArrayOutputStream();
    private boolean hasMore = true;
    private int pos;

    public ReaderInputStream(Reader reader, Charset charset) {
        this(reader, charset, DEFAULT_BUFFER_SIZE);
    }

    public ReaderInputStream(Reader reader, Charset charset, int bufferSize) {
        this.reader = reader;
        this.writer = new OutputStreamWriter((OutputStream)this.out, charset);
        this.charBuffer = new char[bufferSize];
    }

    @Override
    public int read() throws IOException {
        while (this.pos >= this.out.getCount()) {
            if (!this.hasMore) {
                return -1;
            }
            this.out.reset();
            this.pos = 0;
            int charsRead = this.reader.read(this.charBuffer);
            if (charsRead == -1) {
                this.writer.close();
                this.hasMore = false;
                continue;
            }
            this.writer.write(this.charBuffer, 0, charsRead);
            this.writer.flush();
        }
        return this.out.getBuffer()[this.pos++] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

