/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class ExtensibleBufferedOutputStream
extends OutputStream {
    protected ByteBuffer buf;
    protected int bytesWritten;
    private int startPosition;

    @Override
    public void write(int b) throws IOException {
        this.ensureBuffer();
        this.buf.put((byte)b);
    }

    private void ensureBuffer() throws IOException {
        if (this.buf != null) {
            if (this.buf.remaining() != 0) {
                return;
            }
            this.flush();
        }
        this.buf = this.newBuffer();
        this.startPosition = this.buf.position();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        do {
            this.ensureBuffer();
            int toCopy = Math.min(this.buf.remaining(), len);
            this.buf.put(b, off, toCopy);
            len -= toCopy;
            off += toCopy;
        } while (this.buf.remaining() <= 0);
    }

    @Override
    public void flush() throws IOException {
        int bytes;
        if (this.buf != null && (bytes = this.buf.position() - this.startPosition) > 0) {
            this.bytesWritten += this.flushDirect(bytes);
        }
        this.buf = null;
    }

    protected abstract ByteBuffer newBuffer() throws IOException;

    protected abstract int flushDirect(int var1) throws IOException;

    @Override
    public void close() throws IOException {
        this.flush();
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }
}

