/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.query.QueryPlugin;
import org.teiid.translator.ExecutionFactory;

public class ConnectorManagerRepository
implements Serializable {
    private static final long serialVersionUID = -1611063218178314458L;
    private Map<String, ConnectorManager> repo = new ConcurrentHashMap<String, ConnectorManager>();
    private boolean shared;

    public ConnectorManagerRepository() {
    }

    protected ConnectorManagerRepository(boolean b) {
        this.shared = b;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void addConnectorManager(String connectorName, ConnectorManager mgr) {
        this.repo.put(connectorName, mgr);
    }

    public ConnectorManager getConnectorManager(String connectorName) {
        return this.repo.get(connectorName);
    }

    public Map<String, ConnectorManager> getConnectorManagers() {
        return this.repo;
    }

    public ConnectorManager removeConnectorManager(String connectorName) {
        return this.repo.remove(connectorName);
    }

    public void createConnectorManagers(VDBMetaData deployment, ExecutionFactoryProvider provider) throws ConnectorManagerException {
        for (ModelMetaData model : deployment.getModelMetaDatas().values()) {
            List sourceNames = model.getSourceNames();
            if (sourceNames.size() != new HashSet(sourceNames).size()) {
                throw new ConnectorManagerException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31101, new Object[]{model.getName(), deployment.getName(), deployment.getVersion()}));
            }
            if (sourceNames.size() > 1 && !model.isSupportsMultiSourceBindings()) {
                throw new ConnectorManagerException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31102, new Object[]{model.getName(), deployment.getName(), deployment.getVersion()}));
            }
            for (SourceMappingMetadata source : model.getSourceMappings()) {
                ConnectorManager cm = this.getConnectorManager(source.getName());
                String name = source.getTranslatorName();
                String connection = source.getConnectionJndiName();
                if (cm != null) {
                    if (cm.getTranslatorName().equals(name) && EquivalenceUtil.areEqual((Object)cm.getConnectionName(), (Object)connection)) continue;
                    throw new ConnectorManagerException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31103, new Object[]{source, deployment.getName(), deployment.getVersion()}));
                }
                cm = this.createConnectorManager(name, connection);
                ExecutionFactory<Object, Object> ef = provider.getExecutionFactory(name);
                cm.setExecutionFactory(ef);
                this.addConnectorManager(source.getName(), cm);
            }
        }
    }

    protected ConnectorManager createConnectorManager(String name, String connection) {
        return new ConnectorManager(name, connection);
    }

    public static interface ExecutionFactoryProvider {
        public ExecutionFactory<Object, Object> getExecutionFactory(String var1) throws ConnectorManagerException;
    }

    public static class ConnectorManagerException
    extends TeiidException {
        public ConnectorManagerException(String msg) {
            super(msg);
        }

        public ConnectorManagerException(Throwable t) {
            super(t);
        }
    }
}

