/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.AbstractCaseExpression;
import org.teiid.query.sql.symbol.Expression;

public class SearchedCaseExpression
extends AbstractCaseExpression {
    private List when = null;

    public SearchedCaseExpression(List when, List then) {
        this.setWhen(when, then);
    }

    @Override
    public int getWhenCount() {
        return this.when == null ? 0 : this.when.size();
    }

    public List getWhen() {
        return this.when;
    }

    public Criteria getWhenCriteria(int index) {
        return (Criteria)this.when.get(index);
    }

    @Override
    public void setWhen(List when, List then) {
        if (when == null || then == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0036"));
        }
        if (when.size() != then.size() || when.size() < 1) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0036"));
        }
        for (int i = 0; i < when.size(); ++i) {
            if (!(when.get(i) instanceof Criteria)) {
                throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0039"));
            }
            if (then.get(i) instanceof Expression) continue;
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0038"));
        }
        if (this.when != when) {
            this.when = Collections.unmodifiableList(when);
        }
        this.setThen(then);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        int whenCount = this.getWhenCount();
        ArrayList<Object> whenCopy = new ArrayList<Object>(whenCount);
        ArrayList<Object> thenCopy = new ArrayList<Object>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whenCopy.add(this.getWhenCriteria(i).clone());
            thenCopy.add(this.getThenExpression(i).clone());
        }
        Expression elseExpr = this.getElseExpression();
        if (elseExpr != null) {
            elseExpr = (Expression)this.getElseExpression().clone();
        }
        SearchedCaseExpression copy = new SearchedCaseExpression(whenCopy, thenCopy);
        copy.setType(this.getType());
        copy.setElseExpression(elseExpr);
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SearchedCaseExpression)) {
            return false;
        }
        return ((Object)this.when).equals(((SearchedCaseExpression)obj).when);
    }
}

