/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.client.plan.Annotation;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestMaterialization {
    @Test
    public void testMaterializedTransformation() throws Exception {
        String userSql = "SELECT MATVIEW.E1 FROM MATVIEW";
        TransformationMetadata metadata = RealMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, (QueryMetadataInterface)metadata, null);
        TestOptimizer.helpPlanCommand(command, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.e1 FROM MatTable.MatTable AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        Collection annotations = analysis.getAnnotations();
        Assert.assertNotNull((String)"Expected annotations but got none", (Object)annotations);
        Assert.assertTrue((String)"Expected one annotation", (annotations.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected catagory mat view", (Object)((Annotation)annotations.iterator().next()).getCategory(), (Object)"Materialized View");
    }

    @Ignore(value="we no longer auto detect this case, if we need this logic it will have to be added to the rewriter since it changes select into to an insert")
    @Test
    public void testMaterializedTransformationLoading() throws Exception {
        String userSql = "SELECT MATVIEW.E1 INTO MatTable.MatStage FROM MATVIEW";
        TransformationMetadata metadata = RealMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, (QueryMetadataInterface)metadata, null);
        TestOptimizer.helpPlanCommand(command, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.x FROM MatSrc.MatSrc AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        Collection annotations = analysis.getAnnotations();
        Assert.assertNotNull((String)"Expected annotations but got none", (Object)annotations);
        Assert.assertTrue((String)"Expected one annotation", (annotations.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected catagory mat view", (Object)((Annotation)annotations.iterator().next()).getCategory(), (Object)"Materialized View");
    }

    @Test
    public void testMaterializedTransformationNoCache() throws Exception {
        String userSql = "SELECT MATVIEW.E1 FROM MATVIEW OPTION NOCACHE MatView.MatView";
        TransformationMetadata metadata = RealMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, (QueryMetadataInterface)metadata, null);
        TestOptimizer.helpPlanCommand(command, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.x FROM MatSrc.MatSrc AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        Collection annotations = analysis.getAnnotations();
        Assert.assertNotNull((String)"Expected annotations but got none", (Object)annotations);
        Assert.assertTrue((String)"Expected one annotation", (annotations.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected catagory mat view", (Object)((Annotation)annotations.iterator().next()).getCategory(), (Object)"Materialized View");
    }

    @Test
    public void testMaterializedTransformationNoCache2() throws Exception {
        String userSql = "SELECT MATVIEW.E1 FROM MATVIEW OPTION NOCACHE";
        TransformationMetadata metadata = RealMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, (QueryMetadataInterface)metadata, null);
        TestOptimizer.helpPlanCommand(command, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.x FROM MatSrc.MatSrc AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        Collection annotations = analysis.getAnnotations();
        Assert.assertNotNull((String)"Expected annotations but got none", (Object)annotations);
        Assert.assertTrue((String)"Expected one annotation", (annotations.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected catagory mat view", (Object)((Annotation)annotations.iterator().next()).getCategory(), (Object)"Materialized View");
    }

    @Test
    public void testNoCacheInTransformation() throws Exception {
        String userSql = "SELECT VGROUP.E1 FROM VGROUP";
        TransformationMetadata metadata = RealMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, (QueryMetadataInterface)metadata, null);
        TestOptimizer.helpPlanCommand(command, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.x FROM MatSrc.MatSrc AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testTableNoCacheDoesntCascade() throws Exception {
        String userSql = "SELECT MATVIEW1.E1 FROM MATVIEW1 option nocache matview.matview1";
        TransformationMetadata metadata = RealMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, (QueryMetadataInterface)metadata, null);
        TestOptimizer.helpPlanCommand(command, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.e1 FROM MatTable.MatTable AS g_0 WHERE g_0.e1 = '1'"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testNoCacheCascade() throws Exception {
        String userSql = "SELECT MATVIEW1.E1 FROM MATVIEW1 option nocache";
        TransformationMetadata metadata = RealMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, (QueryMetadataInterface)metadata, null);
        TestOptimizer.helpPlanCommand(command, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.x FROM MatSrc.MatSrc AS g_0 WHERE g_0.x = '1'"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testDefaultMaterialization() throws Exception {
        String userSql = "SELECT * from vgroup2";
        TransformationMetadata metadata = RealMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, (QueryMetadataInterface)metadata, null);
        CommandContext cc = new CommandContext();
        GlobalTableStoreImpl gts = new GlobalTableStoreImpl(null, metadata.getVdbMetaData(), (QueryMetadataInterface)metadata);
        cc.setGlobalTableStore((GlobalTableStore)gts);
        ProcessorPlan plan = TestOptimizer.getPlan(command, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), analysis, true, cc);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT #MAT_MATVIEW.VGROUP2.x FROM #MAT_MATVIEW.VGROUP2"}, plan);
        Collection annotations = analysis.getAnnotations();
        Assert.assertNotNull((String)"Expected annotations but got none", (Object)annotations);
        Assert.assertEquals((String)"Expected one annotation", (long)1L, (long)annotations.size());
        Assert.assertEquals((String)"Expected catagory mat view", (Object)((Annotation)annotations.iterator().next()).getCategory(), (Object)"Materialized View");
    }

    @Test
    public void testDefaultMaterializationWithPK() throws Exception {
        String userSql = "SELECT * from vgroup3 where x = 'foo'";
        TransformationMetadata metadata = RealMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, (QueryMetadataInterface)metadata, null);
        CommandContext cc = new CommandContext();
        GlobalTableStoreImpl gts = new GlobalTableStoreImpl(null, metadata.getVdbMetaData(), (QueryMetadataInterface)metadata);
        cc.setGlobalTableStore((GlobalTableStore)gts);
        RelationalPlan plan = (RelationalPlan)TestOptimizer.getPlan(command, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), analysis, true, cc);
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)plan.getRootNode().getEstimateNodeCardinality());
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT #MAT_MATVIEW.VGROUP3.x, #MAT_MATVIEW.VGROUP3.y FROM #MAT_MATVIEW.VGROUP3 WHERE #MAT_MATVIEW.VGROUP3.x = 'foo'"}, (ProcessorPlan)plan);
        Collection annotations = analysis.getAnnotations();
        Assert.assertNotNull((String)"Expected annotations but got none", (Object)annotations);
        Assert.assertEquals((String)"Expected one annotation", (long)1L, (long)annotations.size());
        Assert.assertEquals((String)"Expected catagory mat view", (Object)((Annotation)annotations.iterator().next()).getCategory(), (Object)"Materialized View");
    }

    @Test
    public void testDefaultMaterializationWithCacheHint() throws Exception {
        String userSql = "SELECT * from vgroup4";
        TransformationMetadata metadata = RealMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, (QueryMetadataInterface)metadata, null);
        CommandContext cc = new CommandContext();
        GlobalTableStoreImpl gts = new GlobalTableStoreImpl(null, metadata.getVdbMetaData(), (QueryMetadataInterface)metadata);
        cc.setGlobalTableStore((GlobalTableStore)gts);
        ProcessorPlan plan = TestOptimizer.getPlan(command, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), analysis, true, cc);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT #MAT_MATVIEW.VGROUP4.x FROM #MAT_MATVIEW.VGROUP4"}, plan);
        Collection annotations = analysis.getAnnotations();
        Assert.assertNotNull((String)"Expected annotations but got none", (Object)annotations);
        Assert.assertEquals((String)"Expected one annotation", (long)2L, (long)annotations.size());
        Assert.assertEquals((String)"Expected catagory mat view", (Object)((Annotation)annotations.iterator().next()).getCategory(), (Object)"Materialized View");
    }
}

