/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.xml.NameInSourceResolverVisitor;
import org.teiid.query.optimizer.xml.SourceNodeGenaratorVisitor;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.processor.xml.TestXMLProcessor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;

public class TestNameInSourceResolverVisitor
extends TestCase {
    static HashMap infos = new HashMap();

    XMLPlannerEnvironment getEnv(String sql) throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadataCached();
        Query query = (Query)TestXMLProcessor.helpGetCommand(sql, (QueryMetadataInterface)metadata);
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)query, (boolean)true);
        GroupSymbol group = (GroupSymbol)groups.iterator().next();
        MappingDocument docOrig = (MappingDocument)metadata.getMappingNode(metadata.getGroupID(group.getName()));
        MappingDocument doc = docOrig.clone();
        XMLPlannerEnvironment env = new XMLPlannerEnvironment((QueryMetadataInterface)metadata);
        env.mappingDoc = doc;
        TestNameInSourceResolverVisitor.setResultInfo("xmltest.group.items", new DummyCommand("xmltest.group.items", new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}));
        TestNameInSourceResolverVisitor.setResultInfo("xmltest.suppliers", new DummyCommand("xmltest.suppliers", new String[]{"supplierNum", "supplierName", "supplierZipCode", "itemNum"}));
        TestNameInSourceResolverVisitor.setResultInfo("xmltest.orders", new DummyCommand("xmltest.orders", new String[]{"orderNum", "orderDate", "orderQty", "orderStatus"}));
        return env;
    }

    private static void setResultInfo(String groupName, Command command) {
        ResultSetInfo rsInfo = new ResultSetInfo(groupName);
        rsInfo.setCommand(command);
        infos.put(groupName, rsInfo);
    }

    private static ResultSetInfo getResultInfo(String groupName) {
        return (ResultSetInfo)infos.get(groupName);
    }

    public void testResolve() throws Exception {
        XMLPlannerEnvironment env = this.getEnv("SELECT * FROM xmltest.doc9");
        MappingDocument doc = env.mappingDoc;
        doc.acceptVisitor((MappingVisitor)new NameValidator(false));
        doc = SourceNodeGenaratorVisitor.extractSourceNodes((MappingDocument)doc);
        doc.acceptVisitor((MappingVisitor)new Navigator(true, (MappingVisitor)new SourceFixer()));
        NameInSourceResolverVisitor.resolveElements((MappingDocument)doc, (XMLPlannerEnvironment)env);
        doc.acceptVisitor((MappingVisitor)new NameValidator(true));
    }

    static class DummyCommand
    extends Command {
        List list = new ArrayList();

        DummyCommand(String groupName, String[] symbols) {
            for (int i = 0; i < symbols.length; ++i) {
                this.list.add(new ElementSymbol(groupName + "." + symbols[i]));
            }
        }

        public List getProjectedSymbols() {
            return this.list;
        }

        public boolean areResultsCachable() {
            return false;
        }

        public Object clone() {
            return null;
        }

        public int getType() {
            return 0;
        }

        public void acceptVisitor(LanguageVisitor visitor) {
        }
    }

    static class NameValidator
    extends MappingVisitor {
        boolean shouldPass;

        public NameValidator(boolean pass) {
            this.shouldPass = pass;
        }

        public void visit(MappingAttribute attribute) {
            if (attribute.getNameInSource() != null) {
                if (this.shouldPass) {
                    Assert.assertNotNull((Object)attribute.getElementSymbol());
                } else {
                    Assert.assertNull((Object)attribute.getElementSymbol());
                }
            }
        }

        public void visit(MappingElement element) {
            if (element.getNameInSource() != null) {
                if (this.shouldPass) {
                    Assert.assertNotNull((Object)element.getElementSymbol());
                } else {
                    Assert.assertNull((Object)element.getElementSymbol());
                }
            }
        }
    }

    static class SourceFixer
    extends MappingVisitor {
        SourceFixer() {
        }

        public void visit(MappingSourceNode sourceNode) {
            ResultSetInfo info = TestNameInSourceResolverVisitor.getResultInfo(sourceNode.getResultName());
            HashMap<ElementSymbol, ElementSymbol> symbolMap = new HashMap<ElementSymbol, ElementSymbol>();
            for (ElementSymbol element : info.getCommand().getProjectedSymbols()) {
                symbolMap.put(element, element);
            }
            sourceNode.setSymbolMap(symbolMap);
            sourceNode.setResultSetInfo(info);
        }
    }
}

