/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.CommandContext;
import org.teiid.UserDefinedAggregate;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.AggregateAttributes;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestAggregatePushdown;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.TestValidator;

public class TestAggregateProcessing {
    static void sampleDataBQT3(FakeDataManager dataMgr) throws Exception {
        int j;
        int i;
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        List[] tuples = new List[20];
        for (i = 0; i < tuples.length; ++i) {
            tuples[i] = new ArrayList(17);
            tuples[i].add(new Integer(i));
            tuples[i].add("" + i);
            tuples[i].add(new Integer(i + 1));
            for (j = 0; j < 14; ++j) {
                tuples[i].add(null);
            }
        }
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "bqt1.smalla", tuples);
        tuples = new List[20];
        for (i = 0; i < tuples.length; ++i) {
            tuples[i] = new ArrayList(17);
            tuples[i].add(new Integer(i));
            for (j = 0; j < 16; ++j) {
                tuples[i].add(null);
            }
        }
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "bqt2.mediumb", tuples);
    }

    private void sampleDataBQT_defect9842(FakeDataManager dataMgr) throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        List[] tuples = new List[5];
        for (int i = 0; i < tuples.length; ++i) {
            int k = i + 10;
            tuples[i] = new ArrayList(17);
            if (i < 2) {
                tuples[i].add(new Integer(1));
            } else {
                tuples[i].add(new Integer(2));
            }
            tuples[i].add("" + k);
            tuples[i].add(new Integer(k + 1));
            tuples[i].add("" + (k + 1));
            tuples[i].add(new Float(0.5));
            for (int j = 0; j < 8; ++j) {
                tuples[i].add(null);
            }
            tuples[i].add(new Short((short)k));
            tuples[i].add(null);
            tuples[i].add(new BigDecimal("" + k));
            tuples[i].add(null);
        }
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "bqt1.smalla", tuples);
    }

    @Test
    public void testAggregateOnBQT() throws Exception {
        String sql = "SELECT IntKey, SUM(IntNum) FROM BQT1.SmallA GROUP BY IntKey, IntNum HAVING IntNum > 10 ORDER BY IntKey";
        List[] expected = new List[]{Arrays.asList(new Integer(10), new Long(11L)), Arrays.asList(new Integer(11), new Long(12L)), Arrays.asList(new Integer(12), new Long(13L)), Arrays.asList(new Integer(13), new Long(14L)), Arrays.asList(new Integer(14), new Long(15L)), Arrays.asList(new Integer(15), new Long(16L)), Arrays.asList(new Integer(16), new Long(17L)), Arrays.asList(new Integer(17), new Long(18L)), Arrays.asList(new Integer(18), new Long(19L)), Arrays.asList(new Integer(19), new Long(20L))};
        FakeDataManager dataManager = new FakeDataManager();
        TestAggregateProcessing.sampleDataBQT3(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAggregateSubquery() throws Exception {
        String sql = "SELECT IntKey, SUM((select IntNum from bqt1.smallb where intkey = smalla.intkey)) FROM BQT1.SmallA GROUP BY IntKey, IntNum HAVING IntNum > 10 ORDER BY IntKey";
        List[] expected = new List[]{Arrays.asList(1, 2L), Arrays.asList(2, 3L)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.IntKey, g_0.IntNum FROM BQT1.SmallA AS g_0 WHERE g_0.IntNum > 10", new List[]{Arrays.asList(1, 2), Arrays.asList(2, 3)});
        dataManager.addData("SELECT g_0.IntNum FROM BQT1.SmallB AS g_0 WHERE g_0.IntKey = 1", new List[]{Arrays.asList(2)});
        dataManager.addData("SELECT g_0.IntNum FROM BQT1.SmallB AS g_0 WHERE g_0.IntKey = 2", new List[]{Arrays.asList(3)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAggregateOnBQT2() throws Exception {
        String sql = "SELECT IntNum, IsNotNull FROM (SELECT IntNum, LongNum, COUNT(IntNum) AS IsNotNull FROM BQT1.SmallA GROUP BY IntNum, LongNum HAVING LongNum IS NULL ) AS x ORDER BY IntNum, IsNotNull";
        List[] expected = new List[]{Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(3), new Integer(1)), Arrays.asList(new Integer(4), new Integer(1)), Arrays.asList(new Integer(5), new Integer(1)), Arrays.asList(new Integer(6), new Integer(1)), Arrays.asList(new Integer(7), new Integer(1)), Arrays.asList(new Integer(8), new Integer(1)), Arrays.asList(new Integer(9), new Integer(1)), Arrays.asList(new Integer(10), new Integer(1)), Arrays.asList(new Integer(11), new Integer(1)), Arrays.asList(new Integer(12), new Integer(1)), Arrays.asList(new Integer(13), new Integer(1)), Arrays.asList(new Integer(14), new Integer(1)), Arrays.asList(new Integer(15), new Integer(1)), Arrays.asList(new Integer(16), new Integer(1)), Arrays.asList(new Integer(17), new Integer(1)), Arrays.asList(new Integer(18), new Integer(1)), Arrays.asList(new Integer(19), new Integer(1)), Arrays.asList(new Integer(20), new Integer(1))};
        FakeDataManager dataManager = new FakeDataManager();
        TestAggregateProcessing.sampleDataBQT3(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAggregateOnBQT_defect9842() throws Exception {
        String sql = "SELECT IntKey, SUM((BigDecimalValue)*(ShortValue)-(BigDecimalValue)*(ShortValue)*(FloatNum)) AS MySum FROM BQT1.SmallA GROUP BY IntKey ORDER BY IntKey";
        List[] expected = new List[]{Arrays.asList(new Integer(1), new BigDecimal("110.5000000")), Arrays.asList(new Integer(2), new BigDecimal("254.5000000"))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT_defect9842(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase186260() {
        String sql = "SELECT COUNT(DISTINCT pm1.g2.e1), COUNT(DISTINCT pm1.g3.e1) FROM pm1.g2, pm1.g3";
        List[] expected = new List[]{Arrays.asList(new Integer(3), new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAggregatePushdown() {
        Command command = TestProcessor.helpParse("select e1, count(e2), max(e2) from (select e1, e2, e3 from pm1.g1 union all select e1, e2, e3 from pm1.g2 union all select e1, e2, e3 from pm2.g1) z group by e1");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        capFinder.addCapabilities("pm1", (SourceCapabilities)TestAggregatePushdown.getAggregateCapabilities());
        capFinder.addCapabilities("pm2", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e1, COUNT(g_0.e2), MAX(g_0.e2) FROM pm1.g1 AS g_0 GROUP BY g_0.e1 HAVING MAX(g_0.e2) IS NOT NULL", new List[]{Arrays.asList("a", 2, 1)});
        dataManager.addData("SELECT g_0.e1, COUNT(g_0.e2), MAX(g_0.e2) FROM pm1.g2 AS g_0 GROUP BY g_0.e1 HAVING MAX(g_0.e2) IS NOT NULL", new List[]{Arrays.asList("a", 3, 2)});
        dataManager.addData("SELECT g_0.e1, g_0.e2 FROM pm2.g1 AS g_0", new List[]{Arrays.asList("a", 3), Arrays.asList("xyz", 4), Arrays.asList(null, 5)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{Arrays.asList(null, 1, 5), Arrays.asList("a", 6, 3), Arrays.asList("xyz", 1, 4)};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testUnionAggregatePushdown() {
        Command command = TestProcessor.helpParse("select count(*), max(e3) from (select e1, e2, e3 from pm1.g1 union all (select convert(e2, string) as a, e2, e3 from pm2.g2 order by a limit 10)) x group by e1, e2");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        capFinder.addCapabilities("pm1", (SourceCapabilities)TestAggregatePushdown.getAggregateCapabilities());
        BasicSourceCapabilities bac = TestAggregatePushdown.getAggregateCapabilities();
        bac.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm2", (SourceCapabilities)bac);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e1, g_0.e2, COUNT(*), MAX(g_0.e3) FROM pm1.g1 AS g_0 GROUP BY g_0.e1, g_0.e2 HAVING MAX(g_0.e3) IS NOT NULL", new List[]{Arrays.asList("2", 2, 2, Boolean.FALSE), Arrays.asList("1", 1, 3, Boolean.TRUE)});
        dataManager.addData("SELECT v_0.c_0, v_0.c_1, COUNT(*), MAX(v_0.c_2) FROM (SELECT convert(g_0.e2, string) AS c_0, g_0.e2 AS c_1, g_0.e3 AS c_2 FROM pm2.g2 AS g_0 ORDER BY c_0 LIMIT 10) AS v_0 GROUP BY v_0.c_0, v_0.c_1 HAVING MAX(v_0.c_2) IS NOT NULL", new List[]{Arrays.asList("1", 1, 4, Boolean.FALSE)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{Arrays.asList(7, Boolean.TRUE), Arrays.asList(2, Boolean.FALSE)};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testPushDownOverUnionMixed1() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setFunctionSupport("power", true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm1", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select max(e2), count(*), stddev_pop(e2), var_samp(e2) from (select e1, e2 from pm1.g1 union all select e1, e2 from pm2.g2) z"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e2 FROM pm1.g1 AS g_0", new List[]{Arrays.asList(1), Arrays.asList(2)});
        dataManager.addData("SELECT MAX(g_0.e2), COUNT(*), COUNT(g_0.e2), SUM(power(g_0.e2, 2)), SUM(g_0.e2) FROM pm2.g2 AS g_0 HAVING MAX(g_0.e2) IS NOT NULL", new List[]{Arrays.asList(5, 6, 4, BigInteger.valueOf(50L), 10L)});
        List[] expected = new List[]{Arrays.asList(5, 8, 2.1147629234082532, 5.366666666666666)};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBooleanAgg() {
        String sql = "select every(e3), any(e3) from pm1.g1";
        List[] expected = new List[]{Arrays.asList(Boolean.FALSE, Boolean.TRUE)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStatsFunctions() {
        String sql = "select stddev_pop(e2), var_samp(e2) from pm1.g1";
        List[] expected = new List[]{Arrays.asList(1.0671873729054748, 1.3666666666666667)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStatsFunctions1() {
        String sql = "select stddev_samp(e2), var_pop(e2) from (select 2 e2) x";
        List[] expected = new List[]{Arrays.asList(null, 0.0)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testJira1621() throws Exception {
        String sql = "SELECT sum(t2.e4) as s, max(t1.e1 || t2.e1) FROM pm1.g1 as t1, pm1.g2 as t2, pm1.g3 as t3 WHERE t1.e1 = coalesce(t2.e1, 'b') AND t2.e2 = t3.e2 GROUP BY t2.e2, t2.e3, t3.e2 ORDER BY s";
        List[] expected = new List[]{Arrays.asList(null, "cc"), Arrays.asList(0.0, "bb"), Arrays.asList(2.0, null), Arrays.asList(21.0, "aa"), Arrays.asList(24.0, "aa")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiJoinCriteria() throws Exception {
        String sql = "SELECT count(t2.e4) as s FROM pm1.g1 as t1, pm1.g2 as t2, pm1.g3 as t3 WHERE t1.e1 = t2.e1 and t2.e2 = t3.e2 and t1.e3 || t2.e3 = t3.e3";
        List[] expected = new List[]{Arrays.asList(0)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiJoinGroupBy() throws Exception {
        String sql = "SELECT count(t2.e4) as s, t1.e3 || t2.e3 FROM pm1.g1 as t1, pm1.g2 as t2, pm1.g3 as t3 WHERE t1.e1 = t2.e1 and t2.e2 = t3.e2 GROUP BY t1.e3 || t2.e3";
        List[] expected = new List[]{Arrays.asList(9, "falsefalse"), Arrays.asList(2, "falsetrue"), Arrays.asList(4, "truefalse"), Arrays.asList(1, "truetrue")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testArrayAggOrderByPersistence() throws Exception {
        String sql = "SELECT array_agg(e2 order by e1) from pm1.g1 group by e3";
        List[] expected = new List[]{Arrays.asList(new ArrayImpl((Object[])new Integer[]{1, 0, 0, 2})), Arrays.asList(new ArrayImpl((Object[])new Integer[]{3, 1}))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        org.teiid.query.util.CommandContext cc = TestProcessor.createCommandContext();
        BufferManagerImpl impl = BufferManagerFactory.getTestBufferManager(0L, 2);
        impl.setUseWeakReferences(false);
        cc.setBufferManager((BufferManager)impl);
        TestProcessor.helpProcess(plan, cc, dataManager, expected);
    }

    @Test
    public void testDupGroupCombination() throws Exception {
        String sql = "select count(e2), e1 from (select distinct e1, e2, e3 from pm1.g1) x group by e1";
        List[] expected = new List[]{Arrays.asList(2, "a")};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3 FROM pm1.g1", new List[]{Arrays.asList("a", 0, Boolean.TRUE), Arrays.asList("a", 0, Boolean.FALSE)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAggFilter() throws Exception {
        String sql = "SELECT e2, count(*) filter (where e3) from pm1.g1 group by e2 order by e2";
        List[] expected = new List[]{Arrays.asList(0, 0), Arrays.asList(1, 1), Arrays.asList(2, 0), Arrays.asList(3, 1)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testUserDefined() throws Exception {
        MetadataStore ms = RealMetadataFactory.example1Store();
        Schema s = (Schema)ms.getSchemas().get("PM1");
        AggregateAttributes aa = this.addAgg(s, "myagg", SumAll.class, "integer");
        this.addAgg(s, "myagg2", LongSumAll.class, "long");
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata(ms, "test", new FunctionTree[0]);
        Command c = TestResolver.helpResolve("select myagg2(distinct e2) from pm1.g1", (QueryMetadataInterface)metadata);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.LONG, (Object)((Expression)c.getProjectedSymbols().get(0)).getType());
        TestValidator.helpValidate("SELECT myagg(e2) from pm1.g1", new String[]{"myagg(e2)"}, (QueryMetadataInterface)metadata);
        TestValidator.helpValidate("SELECT myagg(distinct e2) from pm1.g1", new String[]{"myagg(DISTINCT e2)"}, (QueryMetadataInterface)metadata);
        TestValidator.helpValidate("SELECT myagg(e2 order by e1) from pm1.g1", new String[]{"myagg(ALL e2 ORDER BY e1)"}, (QueryMetadataInterface)metadata);
        TestValidator.helpValidate("SELECT myagg(ALL e2, e2) over () from pm1.g1", new String[0], (QueryMetadataInterface)metadata);
        aa.setAllowsDistinct(true);
        aa.setAllowsOrderBy(true);
        TestValidator.helpValidate("SELECT myagg(distinct e2) from pm1.g1", new String[0], (QueryMetadataInterface)metadata);
        TestValidator.helpValidate("SELECT myagg(e2 order by e1) from pm1.g1", new String[0], (QueryMetadataInterface)metadata);
        aa.setAnalytic(true);
        TestValidator.helpValidate("SELECT myagg(distinct e2) from pm1.g1", new String[]{"myagg(DISTINCT e2)"}, (QueryMetadataInterface)metadata);
        TestValidator.helpValidate("SELECT myagg(ALL e2, e2) over () from pm1.g1", new String[0], (QueryMetadataInterface)metadata);
        aa.setAnalytic(false);
        List[] expected = new List[]{Arrays.asList(6, 6), Arrays.asList(8, 8)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan("select myagg(all e2, e2 order by e1), myagg(all e2, e2) from pm1.g1 group by e3", (QueryMetadataInterface)metadata);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    private AggregateAttributes addAgg(Schema s, String name, Class<?> clazz, String returns) {
        FunctionMethod fm = new FunctionMethod();
        fm.setName(name);
        fm.setInvocationClass(clazz.getName());
        fm.setInvocationMethod("addInput");
        FunctionParameter fp = new FunctionParameter();
        fp.setType("integer");
        fp.setName("arg");
        fp.setVarArg(true);
        fm.getInputParameters().add(fp);
        FunctionParameter fpout = new FunctionParameter();
        fpout.setType(returns);
        fpout.setName("outp");
        fm.setOutputParameter(fpout);
        AggregateAttributes aa = new AggregateAttributes();
        fm.setAggregateAttributes(aa);
        s.getFunctions().put(fm.getName(), fm);
        return aa;
    }

    @Test
    public void testMultiCount() throws Exception {
        String sql = "SELECT count(pm1.g1.e2), count(pm2.g2.e2) from pm1.g1, pm2.g2 where pm1.g1.e1 = pm2.g2.e1";
        List[] expected = new List[]{Arrays.asList(3, 2)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e1 AS c_0, COUNT(g_0.e2) AS c_1 FROM pm1.g1 AS g_0 GROUP BY g_0.e1 ORDER BY c_0", new List[]{Arrays.asList("a", 1), Arrays.asList("b", 2)});
        dataManager.addData("SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm2.g2 AS g_0 ORDER BY c_0", new List[]{Arrays.asList("a", 6), Arrays.asList("b", 5)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestAggregatePushdown.getAggregatesFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testUnaliasedAggInDeleteCompensation() throws Exception {
        String sql = "delete from pm3.g1 where e1 = (SELECT MAX(e1) FROM pm3.g1 as z where e2 = pm3.g1.e2)";
        List[] expected = new List[]{Arrays.asList(1)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm3.g1 AS g_0 ORDER BY c_1, c_0", new List[]{Arrays.asList("a", 1)});
        dataManager.addData("SELECT MAX(g_0.e1) AS c_0, g_0.e2 AS c_1 FROM pm3.g1 AS g_0 GROUP BY g_0.e2 ORDER BY c_1, c_0", new List[]{Arrays.asList("a", 1)});
        dataManager.addData("DELETE FROM pm3.g1 WHERE pm3.g1.e1 = 'a'", new List[]{Arrays.asList(1)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example4(), TestAggregatePushdown.getAggregatesFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testEmptyCountOverJoin() {
        Command command = TestProcessor.helpParse("select count(pm1.g1.e2) from pm1.g1, pm1.g2 where pm1.g1.e1 = pm1.g2.e1");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities bsc = TestAggregatePushdown.getAggregateCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, false);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)bsc);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e1 AS c_0, COUNT(g_0.e2) AS c_1 FROM pm1.g1 AS g_0 GROUP BY g_0.e1 ORDER BY c_0", new List[0]);
        dataManager.addData("SELECT g_0.e1 AS c_0 FROM pm1.g2 AS g_0 ORDER BY c_0", new List[0]);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCountOfGroupingColumn() {
        Command command = TestProcessor.helpParse("select e1, count(e1) from pm1.g1, (select 1 from pm1.g2 limit 2) x group by e1");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)bsc);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e1 FROM pm1.g1 AS g_0", new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b")});
        dataManager.addData("SELECT 1 FROM pm1.g2 AS g_0", new List[]{Arrays.asList(1), Arrays.asList(1)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{Arrays.asList("a", 4), Arrays.asList("b", 2)};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testUnaliasedViewAgg() throws Exception {
        String sql = "SELECT MIN(x.count) FROM agg x";
        TransformationMetadata metadata = RealMetadataFactory.fromDDL("create foreign table smalla (intkey integer); create view agg (count integer) as select count(*) from smalla", "x", "y");
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, new String[]{"SELECT MIN(v_0.c_0) FROM (SELECT COUNT(*) AS c_0 FROM y.smalla AS g_0) AS v_0"}, TestAggregatePushdown.getAggregatesFinder(), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testStringAgg() throws Exception {
        String sql = "SELECT string_agg(e1, ',') from pm1.g1 group by e3";
        List[] expected = new List[]{Arrays.asList("a,b,a"), Arrays.asList("a,c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestAggregatePushdown.getAggregatesFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStringAggBinary() throws Exception {
        String sql = "SELECT cast(string_agg(to_bytes(e1, 'UTF-8'), X'AB') as varbinary) from pm1.g1 group by e3";
        List[] expected = new List[]{Arrays.asList(new BinaryType(new byte[]{97, -85, 98, -85, 97})), Arrays.asList(new BinaryType(new byte[]{97, -85, 99}))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestAggregatePushdown.getAggregatesFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    public static class LongSumAll
    implements UserDefinedAggregate<Long> {
        private boolean isNull = true;
        private long result;

        public void addInput(Integer ... vals) {
            this.isNull = false;
            Integer[] arr$ = vals;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                this.result += (long)i;
            }
        }

        public Long getResult(CommandContext commandContext) {
            if (this.isNull) {
                return null;
            }
            return this.result;
        }

        public void reset() {
            this.isNull = true;
            this.result = 0L;
        }
    }

    public static class SumAll
    implements UserDefinedAggregate<Integer> {
        private boolean isNull = true;
        private int result;

        public void addInput(Integer ... vals) {
            this.isNull = false;
            Integer[] arr$ = vals;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                this.result += i;
            }
        }

        public Integer getResult(CommandContext commandContext) {
            if (this.isNull) {
                return null;
            }
            return this.result;
        }

        public void reset() {
            this.isNull = true;
            this.result = 0;
        }
    }
}

