/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.junit.Test;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestObjectTable {
    @Test
    public void testIterator() throws Exception {
        String sql = "select x.* from bqt1.smalla, objecttable('ov' passing objectvalue as ov COLUMNS x string 'teiid_row', y integer 'teiid_row_number') x";
        List[] expected = new List[]{Arrays.asList("hello", 1), Arrays.asList("world", 2), Arrays.asList("x", 1), Arrays.asList("y", 2)};
        TestObjectTable.process(sql, expected);
    }

    @Test
    public void testProjection() throws Exception {
        String sql = "select y, z from bqt1.smalla, objecttable('ov' passing objectvalue as ov COLUMNS x string 'teiid_row', y integer 'teiid_row_number', z integer 'teiid_row.length') x order by x.x desc limit 1";
        List[] expected = new List[]{Arrays.asList(2, 1)};
        TestObjectTable.process(sql, expected);
    }

    @Test
    public void testContext() throws Exception {
        String sql = "select * from objecttable('teiid_context' COLUMNS y string 'teiid_row.userName') as X";
        List[] expected = new List[]{Arrays.asList("user")};
        TestObjectTable.process(sql, expected);
    }

    public static void process(String sql, List<?>[] expectedResults) throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT BQT1.SmallA.ObjectValue FROM BQT1.SmallA", new List[]{Collections.singletonList(Arrays.asList("hello", "world")), Collections.singletonList(Arrays.asList("x", null, "y")), Collections.singletonList(null)});
        Properties p = new Properties();
        p.put("allowed-languages", "teiid_script");
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.exampleBQTCached().getMetadataStore(), "bqt", p, new FunctionTree[0]);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata);
        TestProcessor.helpProcess(plan, TestProcessor.createCommandContext(), dataManager, expectedResults);
    }

    @Test
    public void testNull() throws Exception {
        String sql = "select * from objecttable('teiid_context' COLUMNS y string 'teiid_row.generatedKeys.toString') as X";
        List[] expected = new List[]{Collections.singletonList(null)};
        TestObjectTable.process(sql, expected);
    }
}

