/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.util.CommandContext;

public class AccessInfo
implements Serializable {
    private static final long serialVersionUID = -2608267960584191359L;
    private transient Set<Object> objectsAccessed;
    private boolean sensitiveToMetadataChanges = true;
    private List<List<String>> externalNames;
    private long creationTime = System.currentTimeMillis();

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.externalNames = AccessInfo.initExternalList(this.externalNames, this.objectsAccessed);
        out.defaultWriteObject();
    }

    public boolean isSensitiveToMetadataChanges() {
        return this.sensitiveToMetadataChanges;
    }

    public void setSensitiveToMetadataChanges(boolean sensitiveToMetadataChanges) {
        this.sensitiveToMetadataChanges = sensitiveToMetadataChanges;
    }

    private static List<List<String>> initExternalList(List<List<String>> externalNames, Set<? extends Object> accessed) {
        if (externalNames == null) {
            externalNames = new ArrayList<List<String>>(accessed.size());
            for (Object object : accessed) {
                Object t;
                if (object instanceof AbstractMetadataRecord) {
                    t = (AbstractMetadataRecord)object;
                    externalNames.add(Arrays.asList(t.getParent().getName(), t.getName()));
                    continue;
                }
                if (!(object instanceof TempMetadataID)) continue;
                t = (TempMetadataID)object;
                externalNames.add(Arrays.asList(((TempMetadataID)t).getID()));
            }
        }
        return externalNames;
    }

    public void addAccessedObject(Object id) {
        if (this.objectsAccessed == null) {
            this.objectsAccessed = new HashSet<Object>();
        }
        this.objectsAccessed.add(id);
    }

    public Set<Object> getObjectsAccessed() {
        return this.objectsAccessed;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    void populate(CommandContext context, boolean data) {
        Set<Object> objects = null;
        objects = data ? context.getDataObjects() : context.getPlanningObjects();
        this.objectsAccessed = objects == null || objects.isEmpty() ? Collections.emptySet() : objects;
    }

    void restore() throws TeiidComponentException, TeiidProcessingException {
        if (this.objectsAccessed != null) {
            return;
        }
        VDBMetaData vdb = DQPWorkContext.getWorkContext().getVDB();
        TransformationMetadata tm = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        GlobalTableStore globalStore = (GlobalTableStore)vdb.getAttachment(GlobalTableStore.class);
        if (!this.externalNames.isEmpty()) {
            this.objectsAccessed = new HashSet<Object>(this.externalNames.size());
            for (List<String> key : this.externalNames) {
                if (key.size() == 1) {
                    String matTableName = key.get(0);
                    TempMetadataID id = globalStore.getGlobalTempTableMetadataId(matTableName);
                    if (id == null) {
                        String viewFullName = matTableName.substring("#MAT_".length());
                        id = globalStore.getGlobalTempTableMetadataId(tm.getGroupID(viewFullName));
                    }
                    this.objectsAccessed.add(id);
                    continue;
                }
                Schema s = tm.getMetadataStore().getSchema(key.get(0));
                AbstractMetadataRecord.Modifiable m = (AbstractMetadataRecord.Modifiable)s.getTables().get(key.get(1));
                if (m == null) {
                    m = (AbstractMetadataRecord.Modifiable)s.getProcedures().get(key.get(1));
                }
                if (m == null) continue;
                this.objectsAccessed.add(m);
            }
        } else {
            this.objectsAccessed = Collections.emptySet();
        }
        this.externalNames = null;
    }

    boolean validate(boolean data, long modTime) {
        if (this.objectsAccessed == null || modTime < 0L) {
            return true;
        }
        for (Object o : this.objectsAccessed) {
            if (!data) {
                if (!(o instanceof AbstractMetadataRecord.Modifiable)) continue;
                AbstractMetadataRecord.Modifiable m = (AbstractMetadataRecord.Modifiable)o;
                if (m.getLastModified() < 0L) {
                    return false;
                }
                if (!this.sensitiveToMetadataChanges || m.getLastModified() - modTime <= this.creationTime) continue;
                return false;
            }
            if (!(o instanceof AbstractMetadataRecord.DataModifiable) || ((AbstractMetadataRecord.DataModifiable)o).getLastDataModification() - modTime <= this.creationTime) continue;
            return false;
        }
        return true;
    }
}

