/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.teiid.api.exception.query.InvalidFunctionException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionForm;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;

public class FunctionLibrary {
    public static final String CONVERT = "convert";
    public static final String CAST = "cast";
    public static final String LOOKUP = "lookup";
    public static final String USER = "user";
    public static final String ENV = "env";
    public static final String SESSION_ID = "session_id";
    public static final String CONTEXT = "context";
    public static final String ROWLIMIT = "rowlimit";
    public static final String ROWLIMITEXCEPTION = "rowlimitexception";
    public static final String DECODESTRING = "decodestring";
    public static final String DECODEINTEGER = "decodeinteger";
    public static final String COMMAND_PAYLOAD = "commandpayload";
    public static final String CONCAT = "CONCAT";
    public static final String CONCAT2 = "CONCAT2";
    public static final String CONCAT_OPERATOR = "||";
    public static final String SUBSTRING = "substring";
    public static final String NVL = "NVL";
    public static final String IFNULL = "IFNULL";
    public static final String FROM_UNIXTIME = "from_unixtime";
    public static final String TIMESTAMPADD = "timestampadd";
    public static final String PARSETIME = "parsetime";
    public static final String PARSEDATE = "parsedate";
    public static final String FORMATTIME = "formattime";
    public static final String FORMATDATE = "formatdate";
    public static final String NULLIF = "nullif";
    public static final String COALESCE = "coalesce";
    public static final String SPACE = "space";
    public static final String ARRAY_GET = "array_get";
    public static final String JSONARRAY = "jsonarray";
    private FunctionTree systemFunctions;
    private FunctionTree[] userFunctions;

    public FunctionLibrary(FunctionTree systemFuncs, FunctionTree ... userFuncs) {
        this.systemFunctions = systemFuncs;
        this.userFunctions = userFuncs;
    }

    public List<String> getFunctionCategories() {
        TreeSet<String> categories = new TreeSet<String>();
        categories.addAll(this.systemFunctions.getCategories());
        if (this.userFunctions != null) {
            for (FunctionTree tree : this.userFunctions) {
                categories.addAll(tree.getCategories());
            }
        }
        ArrayList<String> categoryList = new ArrayList<String>(categories);
        return categoryList;
    }

    public List<FunctionForm> getFunctionForms(String category) {
        ArrayList<FunctionForm> forms = new ArrayList<FunctionForm>();
        forms.addAll(this.systemFunctions.getFunctionForms(category));
        if (this.userFunctions != null) {
            for (FunctionTree tree : this.userFunctions) {
                forms.addAll(tree.getFunctionForms(category));
            }
        }
        Collections.sort(forms);
        return forms;
    }

    public FunctionForm findFunctionForm(String name, int numArgs) {
        FunctionForm form = this.systemFunctions.findFunctionForm(name, numArgs);
        if (form == null && this.userFunctions != null) {
            FunctionTree tree;
            FunctionTree[] arr$ = this.userFunctions;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (form = (tree = arr$[i$]).findFunctionForm(name, numArgs)) == null; ++i$) {
            }
        }
        return form;
    }

    public FunctionDescriptor findFunction(String name, Class<?>[] types) {
        FunctionDescriptor descriptor = this.systemFunctions.getFunction(name, types);
        if (descriptor == null && this.userFunctions != null) {
            FunctionTree tree;
            FunctionTree[] arr$ = this.userFunctions;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (descriptor = (tree = arr$[i$]).getFunction(name, types)) == null; ++i$) {
            }
        }
        return descriptor;
    }

    public FunctionDescriptor[] determineNecessaryConversions(String name, Class<?> returnType, Expression[] args, Class<?>[] types, boolean hasUnknownType) throws InvalidFunctionException {
        if (types.length == 0) {
            return null;
        }
        LinkedList<FunctionMethod> functionMethods = new LinkedList<FunctionMethod>();
        functionMethods.addAll(this.systemFunctions.findFunctionMethods(name, types.length));
        if (this.userFunctions != null) {
            for (FunctionTree tree : this.userFunctions) {
                functionMethods.addAll(tree.findFunctionMethods(name, types.length));
            }
        }
        int bestScore = Integer.MAX_VALUE;
        boolean ambiguous = false;
        FunctionMethod result = null;
        for (FunctionMethod nextMethod : functionMethods) {
            int i;
            int currentScore = 0;
            List methodTypes = nextMethod.getInputParameters();
            for (i = 0; i < types.length; ++i) {
                String tmpTypeName = ((FunctionParameter)methodTypes.get(Math.min(i, methodTypes.size() - 1))).getType();
                Class targetType = DataTypeManager.getDataTypeClass((String)tmpTypeName);
                Class sourceType = types[i];
                if (sourceType == null) {
                    ++currentScore;
                    continue;
                }
                if (sourceType.isArray()) {
                    if (this.isVarArgArrayParam(nextMethod, types, i, targetType)) continue;
                    sourceType = DataTypeManager.DefaultDataClasses.OBJECT;
                }
                try {
                    Transform t = this.getConvertFunctionDescriptor(sourceType, targetType);
                    if (t == null) continue;
                    if (t.isExplicit()) {
                        if (!(args[i] instanceof Constant) || ResolverUtil.convertConstant(DataTypeManager.getDataTypeName((Class)sourceType), tmpTypeName, (Constant)args[i]) == null) break;
                        ++currentScore;
                        continue;
                    }
                    ++currentScore;
                    continue;
                }
                catch (InvalidFunctionException e) {
                    break;
                }
            }
            if (i != types.length || currentScore > bestScore) continue;
            if (hasUnknownType) {
                if (returnType != null) {
                    try {
                        Transform t = this.getConvertFunctionDescriptor(DataTypeManager.getDataTypeClass((String)nextMethod.getOutputParameter().getType()), returnType);
                        if (t != null) {
                            currentScore = t.isExplicit() ? (currentScore += types.length + 1) : ++currentScore;
                        }
                    }
                    catch (InvalidFunctionException e) {
                        currentScore += types.length * types.length;
                    }
                }
                boolean bl = ambiguous = currentScore == bestScore;
            }
            if (currentScore >= bestScore) continue;
            if (currentScore == 0) {
                return null;
            }
            bestScore = currentScore;
            result = nextMethod;
        }
        if (ambiguous || result == null) {
            throw new InvalidFunctionException(QueryPlugin.Event.TEIID30418);
        }
        return this.getConverts(result, types);
    }

    private FunctionDescriptor[] getConverts(FunctionMethod method, Class<?>[] types) {
        List methodTypes = method.getInputParameters();
        FunctionDescriptor[] result = new FunctionDescriptor[types.length];
        for (int i = 0; i < types.length; ++i) {
            String tmpTypeName = ((FunctionParameter)methodTypes.get(Math.min(i, methodTypes.size() - 1))).getType();
            Class targetType = DataTypeManager.getDataTypeClass((String)tmpTypeName);
            Class<?> sourceType = types[i];
            if (sourceType == null) {
                result[i] = this.findTypedConversionFunction(DataTypeManager.DefaultDataClasses.NULL, targetType);
                continue;
            }
            if (sourceType == targetType || this.isVarArgArrayParam(method, types, i, targetType)) continue;
            result[i] = this.findTypedConversionFunction(sourceType, targetType);
        }
        return result;
    }

    public boolean isVarArgArrayParam(FunctionMethod method, Class<?>[] types, int i, Class<?> targetType) {
        return i == types.length - 1 && method.isVarArgs() && i == method.getInputParameterCount() - 1 && types[i].getComponentType() == targetType;
    }

    private Transform getConvertFunctionDescriptor(Class<?> sourceType, Class<?> targetType) throws InvalidFunctionException {
        if (sourceType.equals(targetType)) {
            return null;
        }
        Transform result = DataTypeManager.getTransform(sourceType, targetType);
        if (result == null) {
            throw new InvalidFunctionException(QueryPlugin.Event.TEIID30419);
        }
        return result;
    }

    public FunctionDescriptor findTypedConversionFunction(Class<?> sourceType, Class<?> targetType) {
        FunctionDescriptor fd = this.findFunction(CONVERT, new Class[]{sourceType, DataTypeManager.DefaultDataClasses.STRING});
        if (fd != null) {
            return this.copyFunctionChangeReturnType(fd, targetType);
        }
        return null;
    }

    public FunctionDescriptor copyFunctionChangeReturnType(FunctionDescriptor fd, Class<?> returnType) {
        if (fd != null) {
            FunctionDescriptor fdImpl = fd;
            FunctionDescriptor copy = fdImpl.clone();
            copy.setReturnType(returnType);
            return copy;
        }
        return fd;
    }

    public static boolean isConvert(Function function) {
        Expression[] args = function.getArgs();
        String funcName = function.getName();
        return args.length == 2 && (funcName.equalsIgnoreCase(CONVERT) || funcName.equalsIgnoreCase(CAST));
    }
}

