/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;

public class ForEachRowPlan
extends ProcessorPlan {
    private ProcessorPlan queryPlan;
    private ProcedurePlan rowProcedure;
    private Map<ElementSymbol, Expression> params;
    private Map<Expression, Integer> lookupMap;
    private ProcessorDataManager dataMgr;
    private BufferManager bufferMgr;
    private QueryProcessor queryProcessor;
    private TupleSource tupleSource;
    private QueryProcessor rowProcessor;
    private List<?> currentTuple;
    private int updateCount;

    @Override
    public ProcessorPlan clone() {
        ForEachRowPlan clone = new ForEachRowPlan();
        clone.setQueryPlan(this.queryPlan.clone());
        clone.setRowProcedure((ProcedurePlan)this.rowProcedure.clone());
        clone.setParams(this.params);
        clone.setLookupMap(this.lookupMap);
        return clone;
    }

    @Override
    public void close() throws TeiidComponentException {
        if (this.queryProcessor != null) {
            this.queryProcessor.closeProcessing();
            if (this.rowProcessor != null) {
                this.rowProcessor.closeProcessing();
            }
        }
    }

    @Override
    public List<Expression> getOutputElements() {
        return Command.getUpdateCommandSymbol();
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.setContext(context);
        this.dataMgr = dataMgr;
        this.bufferMgr = bufferMgr;
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        while (true) {
            if (this.currentTuple == null) {
                this.currentTuple = this.tupleSource.nextTuple();
                if (this.currentTuple == null) {
                    TupleBatch result = new TupleBatch(1, new List[]{Arrays.asList(this.updateCount)});
                    result.setTerminationFlag(true);
                    return result;
                }
            }
            if (this.rowProcessor == null) {
                this.rowProcedure.reset();
                this.rowProcedure.setRunInContext(false);
                CommandContext context = this.getContext().clone();
                this.rowProcessor = new QueryProcessor(this.rowProcedure, context, this.bufferMgr, this.dataMgr);
                Evaluator eval = new Evaluator(Collections.emptyMap(), this.dataMgr, context);
                for (Map.Entry<ElementSymbol, Expression> entry : this.params.entrySet()) {
                    Integer index = this.lookupMap.get(entry.getValue());
                    if (index != null) {
                        this.rowProcedure.getCurrentVariableContext().setValue(entry.getKey(), this.currentTuple.get(index));
                        continue;
                    }
                    this.rowProcedure.getCurrentVariableContext().setValue(entry.getKey(), eval.evaluate(entry.getValue(), null));
                }
            }
            this.rowProcessor.nextBatch();
            this.rowProcessor.closeProcessing();
            this.rowProcessor = null;
            this.currentTuple = null;
            ++this.updateCount;
        }
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        this.queryProcessor = new QueryProcessor(this.queryPlan, this.getContext(), this.bufferMgr, this.dataMgr);
        this.tupleSource = new BatchCollector.BatchProducerTupleSource(this.queryProcessor);
    }

    public void setQueryPlan(ProcessorPlan queryPlan) {
        this.queryPlan = queryPlan;
    }

    public void setRowProcedure(ProcedurePlan rowProcedure) {
        this.rowProcedure = rowProcedure;
    }

    public void setParams(Map<ElementSymbol, Expression> params) {
        this.params = params;
    }

    public void setLookupMap(Map<Expression, Integer> symbolMap) {
        this.lookupMap = symbolMap;
    }

    @Override
    public void reset() {
        super.reset();
        this.queryPlan.reset();
        this.updateCount = 0;
        this.currentTuple = null;
        this.rowProcessor = null;
        this.queryProcessor = null;
        this.tupleSource = null;
    }

    @Override
    public boolean requiresTransaction(boolean transactionalReads) {
        return true;
    }

    public String toString() {
        StringBuilder val = new StringBuilder("ForEach ");
        val.append(this.queryPlan).append("\n{\n");
        val.append(this.rowProcedure);
        val.append("}\n");
        return val.toString();
    }
}

