/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.RuleAssignOutputElements;
import org.teiid.query.sql.lang.SetQuery;

public class TestRuleAssignOutputElements {
    public void helpTestIsUnionNoAll(PlanNode node, boolean expected) {
        boolean actual = RuleAssignOutputElements.hasDupRemoval((PlanNode)node);
        Assert.assertEquals((String)"Got incorrect answer finding no all union", (Object)expected, (Object)actual);
    }

    @Test
    public void testFindNoAllUnion1() {
        PlanNode projNode = NodeFactory.getNewNode((int)8);
        PlanNode accessNode = NodeFactory.getNewNode((int)1);
        projNode.addLastChild(accessNode);
        this.helpTestIsUnionNoAll(projNode, false);
    }

    @Test
    public void testFindNoAllUnion2() {
        PlanNode unionNode = NodeFactory.getNewNode((int)256);
        unionNode.setProperty(NodeConstants.Info.SET_OPERATION, (Object)SetQuery.Operation.UNION);
        unionNode.setProperty(NodeConstants.Info.USE_ALL, (Object)Boolean.TRUE);
        PlanNode projNode1 = NodeFactory.getNewNode((int)8);
        PlanNode accessNode1 = NodeFactory.getNewNode((int)1);
        PlanNode projNode2 = NodeFactory.getNewNode((int)8);
        PlanNode accessNode2 = NodeFactory.getNewNode((int)1);
        unionNode.addLastChild(projNode1);
        projNode1.addLastChild(accessNode1);
        unionNode.addLastChild(projNode2);
        projNode2.addLastChild(accessNode2);
        this.helpTestIsUnionNoAll(unionNode, false);
    }

    @Test
    public void testFindNoAllUnion3() {
        PlanNode unionNode = NodeFactory.getNewNode((int)256);
        unionNode.setProperty(NodeConstants.Info.SET_OPERATION, (Object)SetQuery.Operation.UNION);
        unionNode.setProperty(NodeConstants.Info.USE_ALL, (Object)Boolean.FALSE);
        PlanNode projNode1 = NodeFactory.getNewNode((int)8);
        PlanNode accessNode1 = NodeFactory.getNewNode((int)1);
        PlanNode projNode2 = NodeFactory.getNewNode((int)8);
        PlanNode accessNode2 = NodeFactory.getNewNode((int)1);
        unionNode.addLastChild(projNode1);
        projNode1.addLastChild(accessNode1);
        unionNode.addLastChild(projNode2);
        projNode2.addLastChild(accessNode2);
        this.helpTestIsUnionNoAll(unionNode, true);
    }

    @Test
    public void testFindNoAllUnion4() {
        PlanNode unionNode1 = NodeFactory.getNewNode((int)256);
        unionNode1.setProperty(NodeConstants.Info.SET_OPERATION, (Object)SetQuery.Operation.UNION);
        unionNode1.setProperty(NodeConstants.Info.USE_ALL, (Object)Boolean.TRUE);
        PlanNode unionNode2 = NodeFactory.getNewNode((int)256);
        unionNode2.setProperty(NodeConstants.Info.SET_OPERATION, (Object)SetQuery.Operation.UNION);
        unionNode2.setProperty(NodeConstants.Info.USE_ALL, (Object)Boolean.FALSE);
        PlanNode projNode1 = NodeFactory.getNewNode((int)8);
        PlanNode accessNode1 = NodeFactory.getNewNode((int)1);
        PlanNode projNode2 = NodeFactory.getNewNode((int)8);
        PlanNode accessNode2 = NodeFactory.getNewNode((int)1);
        PlanNode projNode3 = NodeFactory.getNewNode((int)8);
        PlanNode accessNode3 = NodeFactory.getNewNode((int)1);
        unionNode1.addLastChild(projNode1);
        projNode1.addLastChild(accessNode1);
        unionNode1.addLastChild(unionNode2);
        unionNode2.addLastChild(projNode2);
        projNode2.addLastChild(accessNode2);
        unionNode2.addLastChild(projNode3);
        projNode3.addLastChild(accessNode3);
        this.helpTestIsUnionNoAll(unionNode1, true);
    }
}

