/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.teiid.adminapi.Admin;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class DDLStringVisitor {
    private static final String TAB = "\t";
    private static final String NEWLINE = "\n";
    private static final HashSet<String> LENGTH_DATATYPES = new HashSet<String>(Arrays.asList("char", "clob", "blob", "object", "xml", "string", "varbinary", "biginteger"));
    private static final HashSet<String> PRECISION_DATATYPES = new HashSet<String>(Arrays.asList("bigdecimal"));
    protected StringBuilder buffer = new StringBuilder();
    private boolean includeTables = true;
    private boolean includeProcedures = true;
    private boolean includeFunctions = true;
    private Pattern filter;
    private Map<String, String> prefixMap;
    protected boolean usePrefixes = true;
    private static final Map<String, String> BUILTIN_PREFIXES = new HashMap<String, String>();

    public static String getDDLString(Schema schema, EnumSet<Admin.SchemaObjectType> types, String regexPattern) {
        DDLStringVisitor visitor = new DDLStringVisitor(types, regexPattern);
        visitor.visit(schema);
        return visitor.toString();
    }

    public DDLStringVisitor(EnumSet<Admin.SchemaObjectType> types, String regexPattern) {
        if (types != null) {
            this.includeTables = types.contains(Admin.SchemaObjectType.TABLES);
            this.includeProcedures = types.contains(Admin.SchemaObjectType.PROCEDURES);
            this.includeFunctions = types.contains(Admin.SchemaObjectType.FUNCTIONS);
        }
        if (regexPattern != null) {
            this.filter = Pattern.compile(regexPattern);
        }
    }

    private void visit(Schema schema) {
        boolean first = true;
        if (this.includeTables) {
            for (Table t : schema.getTables().values()) {
                if (first) {
                    first = false;
                } else {
                    this.append(NEWLINE);
                    this.append(NEWLINE);
                }
                this.visit(t);
            }
        }
        if (this.includeProcedures) {
            for (Procedure p : schema.getProcedures().values()) {
                if (first) {
                    first = false;
                } else {
                    this.append(NEWLINE);
                    this.append(NEWLINE);
                }
                this.visit(p);
            }
        }
        if (this.includeFunctions) {
            for (FunctionMethod f : schema.getFunctions().values()) {
                if (first) {
                    first = false;
                } else {
                    this.append(NEWLINE);
                    this.append(NEWLINE);
                }
                this.visit(f);
            }
        }
    }

    private void visit(Table table) {
        if (this.filter != null && !this.filter.matcher(table.getName()).matches()) {
            return;
        }
        this.append("CREATE").append(" ");
        if (table.isPhysical()) {
            this.append("FOREIGN TABLE");
        } else if (table.getTableType() == Table.Type.TemporaryTable) {
            this.append("GLOBAL").append(" ").append("TEMPORARY").append(" ").append("TABLE");
        } else {
            this.append("VIEW");
        }
        this.append(" ");
        String name = this.addTableBody(table);
        if (table.getTableType() != Table.Type.TemporaryTable) {
            if (table.isVirtual()) {
                this.append(NEWLINE).append("AS").append(NEWLINE).append(table.getSelectTransformation());
            }
            this.append(";");
            if (table.isInsertPlanEnabled()) {
                this.buildTrigger(name, "INSERT", table.getInsertPlan());
            }
            if (table.isUpdatePlanEnabled()) {
                this.buildTrigger(name, "UPDATE", table.getUpdatePlan());
            }
            if (table.isDeletePlanEnabled()) {
                this.buildTrigger(name, "DELETE", table.getDeletePlan());
            }
        }
    }

    public String addTableBody(Table table) {
        String options;
        String name = SQLStringVisitor.escapeSinglePart(table.getName());
        this.append(name);
        if (table.getColumns() != null) {
            this.append(" ");
            this.append("(");
            boolean first = true;
            for (Column c : table.getColumns()) {
                if (first) {
                    first = false;
                } else {
                    this.append(",");
                }
                this.visit(table, c);
            }
            this.buildContraints(table);
            this.append(NEWLINE);
            this.append(")");
        }
        if (!(options = this.buildTableOptions(table)).isEmpty()) {
            this.append(" ").append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
        return name;
    }

    protected DDLStringVisitor append(Object o) {
        this.buffer.append(o);
        return this;
    }

    private void buildTrigger(String name, String type, String plan) {
        this.append(NEWLINE);
        this.append(NEWLINE);
        this.append("CREATE TRIGGER ON").append(" ");
        this.append(name).append(" ").append("INSTEAD OF").append(" ").append(type).append(" ").append("AS").append(NEWLINE);
        this.append(plan);
        this.append(";");
    }

    private String buildTableOptions(Table table) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)table);
        if (table.isMaterialized()) {
            this.addOption(options, "MATERIALIZED", table.isMaterialized());
            if (table.getMaterializedTable() != null) {
                this.addOption(options, "MATERIALIZED_TABLE", table.getMaterializedTable().getName());
            }
        }
        if (table.supportsUpdate()) {
            this.addOption(options, "UPDATABLE", table.supportsUpdate());
        }
        if (table.getCardinality() != -1) {
            if ((float)table.getCardinality() != table.getCardinalityAsFloat()) {
                this.addOption(options, "CARDINALITY", (long)table.getCardinalityAsFloat());
            } else {
                this.addOption(options, "CARDINALITY", table.getCardinality());
            }
        }
        if (!table.getProperties().isEmpty()) {
            for (String key : table.getProperties().keySet()) {
                this.addOption(options, key, table.getProperty(key, false));
            }
        }
        return options.toString();
    }

    private void addCommonOptions(StringBuilder sb, AbstractMetadataRecord record) {
        if (record.getUUID() != null && !record.getUUID().startsWith("tid:")) {
            this.addOption(sb, "UUID", record.getUUID());
        }
        if (record.getAnnotation() != null) {
            this.addOption(sb, "ANNOTATION", record.getAnnotation());
        }
        if (record.getNameInSource() != null && !record.getNameInSource().equals(record.getName())) {
            this.addOption(sb, "NAMEINSOURCE", record.getNameInSource());
        }
    }

    private void buildContraints(Table table) {
        this.addConstraints(table.getAccessPatterns(), "AP", "ACCESSPATTERN");
        KeyRecord pk = table.getPrimaryKey();
        if (pk != null) {
            this.addConstraint("PK", "PRIMARY KEY", pk, true);
        }
        this.addConstraints(table.getUniqueKeys(), "UNIQUE", "UNIQUE");
        this.addConstraints(table.getIndexes(), "INDEX", "INDEX");
        this.addConstraints(table.getFunctionBasedIndexes(), "INDEX", "INDEX");
        for (int i = 0; i < table.getForeignKeys().size(); ++i) {
            ForeignKey key = (ForeignKey)table.getForeignKeys().get(i);
            this.addConstraint("FK" + i, "FOREIGN KEY", (KeyRecord)key, false);
            this.append(" ").append("REFERENCES");
            if (key.getPrimaryKey() != null) {
                this.append(" ").append(new GroupSymbol(((Table)key.getPrimaryKey().getParent()).getFullName()));
            } else if (key.getReferenceTableName() != null) {
                this.append(" ").append(new GroupSymbol(key.getReferenceTableName()));
            }
            this.append(" ");
            this.addNames(key.getReferenceColumns());
            this.appendOptions((AbstractMetadataRecord)key);
        }
    }

    private void addConstraints(List<KeyRecord> constraints, String defaultName, String type) {
        for (int i = 0; i < constraints.size(); ++i) {
            KeyRecord constraint = constraints.get(i);
            this.addConstraint(defaultName + i, type, constraint, true);
        }
    }

    private void addConstraint(String defaultName, String type, KeyRecord constraint, boolean addOptions) {
        this.append(",").append(NEWLINE).append(TAB);
        boolean nameMatches = defaultName.equals(constraint.getName());
        if (!nameMatches) {
            this.append("CONSTRAINT").append(" ").append(SQLStringVisitor.escapeSinglePart(constraint.getName())).append(" ");
        }
        this.append(type);
        this.addColumns(constraint.getColumns(), false);
        if (addOptions) {
            this.appendOptions((AbstractMetadataRecord)constraint);
        }
    }

    private void addColumns(List<Column> columns, boolean includeType) {
        this.append("(");
        boolean first = true;
        for (Column c : columns) {
            if (first) {
                first = false;
            } else {
                this.append(",").append(" ");
            }
            if (includeType) {
                this.appendColumn((BaseColumn)c, true, includeType);
                this.appendColumnOptions((BaseColumn)c);
                continue;
            }
            if (c.getParent() instanceof KeyRecord) {
                this.append(c.getNameInSource());
                continue;
            }
            this.append(SQLStringVisitor.escapeSinglePart(c.getName()));
        }
        this.append(")");
    }

    private void addNames(List<String> columns) {
        if (columns != null) {
            this.append("(");
            boolean first = true;
            for (String c : columns) {
                if (first) {
                    first = false;
                } else {
                    this.append(",").append(" ");
                }
                this.append(SQLStringVisitor.escapeSinglePart(c));
            }
            this.append(")");
        }
    }

    private void visit(Table table, Column column) {
        this.append(NEWLINE).append(TAB);
        if (table.getTableType() == Table.Type.TemporaryTable && column.isAutoIncremented() && column.getNullType() == BaseColumn.NullType.No_Nulls && column.getJavaType() == DataTypeManager.DefaultDataClasses.INTEGER) {
            this.append(SQLStringVisitor.escapeSinglePart(column.getName()));
            this.append(" ");
            this.append("SERIAL");
        } else {
            this.appendColumn((BaseColumn)column, true, true);
            if (column.isAutoIncremented()) {
                this.append(" ").append("AUTO_INCREMENT");
            }
        }
        this.appendDefault((BaseColumn)column);
        this.appendColumnOptions((BaseColumn)column);
    }

    private void appendDefault(BaseColumn column) {
        if (column.getDefaultValue() != null) {
            this.append(" ").append("DEFAULT").append(" ").append("'").append(StringUtil.replaceAll((String)column.getDefaultValue(), (String)"'", (String)"''")).append("'");
        }
    }

    private void appendColumn(BaseColumn column, boolean includeName, boolean includeType) {
        if (includeName) {
            this.append(SQLStringVisitor.escapeSinglePart(column.getName()));
        }
        if (includeType) {
            String runtimeTypeName = column.getDatatype().getRuntimeTypeName();
            if (includeName) {
                this.append(" ");
            }
            this.append(runtimeTypeName);
            if (LENGTH_DATATYPES.contains(runtimeTypeName)) {
                if (column.getLength() != 0 && column.getLength() != column.getDatatype().getLength()) {
                    this.append("(").append(column.getLength()).append(")");
                }
            } else if (PRECISION_DATATYPES.contains(runtimeTypeName) && (column.getPrecision() != column.getDatatype().getPrecision() || column.getScale() != column.getDatatype().getScale())) {
                this.append("(").append(column.getPrecision());
                if (column.getScale() != 0) {
                    this.append(",").append(column.getScale());
                }
                this.append(")");
            }
            for (int dims = column.getArrayDimensions(); dims > 0; --dims) {
                this.append("[").append("]");
            }
            if (column.getNullType() == BaseColumn.NullType.No_Nulls) {
                this.append(" ").append("NOT NULL");
            }
        }
    }

    private void appendColumnOptions(BaseColumn column) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)column);
        if (!column.getDatatype().isBuiltin()) {
            this.addOption(options, "UDT", column.getDatatype().getName() + "(" + column.getLength() + ", " + column.getPrecision() + ", " + column.getScale() + ")");
        }
        if (column.getDatatype().getRadix() != 0 && column.getRadix() != column.getDatatype().getRadix()) {
            this.addOption(options, "RADIX", column.getRadix());
        }
        if (column instanceof Column) {
            this.buildColumnOptions((Column)column, options);
        }
        if (options.length() != 0) {
            this.append(" ").append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
    }

    private void buildColumnOptions(Column column, StringBuilder options) {
        if (!column.isSelectable()) {
            this.addOption(options, "SELECTABLE", column.isSelectable());
        }
        if (!column.isUpdatable() && column.getParent() instanceof Table && ((Table)column.getParent()).supportsUpdate()) {
            this.addOption(options, "UPDATABLE", column.isUpdatable());
        }
        if (column.isCurrency()) {
            this.addOption(options, "CURRENCY", column.isCurrency());
        }
        if (!column.isCaseSensitive() && column.getDatatype().isCaseSensitive()) {
            this.addOption(options, "CASE_SENSITIVE", column.isCaseSensitive());
        }
        if (!column.isSigned() && column.getDatatype().isSigned()) {
            this.addOption(options, "SIGNED", column.isSigned());
        }
        if (column.isFixedLength()) {
            this.addOption(options, "FIXED_LENGTH", column.isFixedLength());
        }
        if (column.getCharOctetLength() != 0 && column.getLength() != column.getCharOctetLength()) {
            this.addOption(options, "CHAR_OCTET_LENGTH", column.getCharOctetLength());
        }
        if (column.getSearchType() != null && (!column.getSearchType().equals((Object)column.getDatatype().getSearchType()) || column.isSearchTypeSet())) {
            this.addOption(options, "SEARCHABLE", column.getSearchType().name());
        }
        if (column.getMinimumValue() != null) {
            this.addOption(options, "MIN_VALUE", column.getMinimumValue());
        }
        if (column.getMaximumValue() != null) {
            this.addOption(options, "MAX_VALUE", column.getMaximumValue());
        }
        if (column.getNativeType() != null) {
            this.addOption(options, "NATIVE_TYPE", column.getNativeType());
        }
        if (column.getNullValues() != -1) {
            this.addOption(options, "NULL_VALUE_COUNT", column.getNullValues());
        }
        if (column.getDistinctValues() != -1) {
            this.addOption(options, "DISTINCT_VALUES", column.getDistinctValues());
        }
        this.buildOptions((AbstractMetadataRecord)column, options);
    }

    private void appendOptions(AbstractMetadataRecord record) {
        StringBuilder options = new StringBuilder();
        this.buildOptions(record, options);
        if (options.length() != 0) {
            this.append(" ").append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
    }

    private void buildOptions(AbstractMetadataRecord record, StringBuilder options) {
        if (!record.getProperties().isEmpty()) {
            for (Map.Entry entry : record.getProperties().entrySet()) {
                this.addOption(options, (String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void addOption(StringBuilder sb, String key, Object value) {
        if (sb.length() != 0) {
            sb.append(",").append(" ");
        }
        value = value != null ? new Constant(value) : Constant.NULL_CONSTANT;
        if (key != null && key.length() > 2 && key.charAt(0) == '{') {
            String origKey = key;
            int index = key.indexOf(125);
            if (index > 1) {
                String uri = key.substring(1, index);
                key = key.substring(index + 1, key.length());
                String prefix = BUILTIN_PREFIXES.get(uri);
                if (prefix == null && this.usePrefixes) {
                    if (this.prefixMap == null) {
                        this.prefixMap = new LinkedHashMap<String, String>();
                    } else {
                        prefix = this.prefixMap.get(uri);
                    }
                    if (prefix == null) {
                        prefix = "n" + this.prefixMap.size();
                        this.prefixMap.put(uri, prefix);
                    }
                }
                key = prefix != null ? prefix + ":" + key : origKey;
            }
        }
        sb.append(SQLStringVisitor.escapeSinglePart(key)).append(" ").append(value);
    }

    private void visit(Procedure procedure) {
        String options;
        if (this.filter != null && !this.filter.matcher(procedure.getName()).matches()) {
            return;
        }
        this.append("CREATE").append(" ");
        if (procedure.isVirtual()) {
            this.append("VIRTUAL");
        } else {
            this.append("FOREIGN");
        }
        this.append(" ").append("PROCEDURE").append(" ").append(SQLStringVisitor.escapeSinglePart(procedure.getName()));
        this.append("(");
        boolean first = true;
        for (ProcedureParameter pp : procedure.getParameters()) {
            if (first) {
                first = false;
            } else {
                this.append(",").append(" ");
            }
            this.visit(pp);
        }
        this.append(")");
        if (procedure.getResultSet() != null) {
            this.append(" ").append("RETURNS").append(" ").append("TABLE").append(" ");
            this.addColumns(procedure.getResultSet().getColumns(), true);
        }
        if (!(options = this.buildProcedureOptions(procedure)).isEmpty()) {
            this.append(NEWLINE).append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
        if (procedure.isVirtual()) {
            this.append(NEWLINE).append("AS").append(NEWLINE);
            String plan = procedure.getQueryPlan();
            this.append(plan);
        }
    }

    private String buildProcedureOptions(Procedure procedure) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)procedure);
        if (procedure.getUpdateCount() != 1) {
            this.addOption(options, "UPDATECOUNT", procedure.getUpdateCount());
        }
        if (!procedure.getProperties().isEmpty()) {
            for (String key : procedure.getProperties().keySet()) {
                this.addOption(options, key, procedure.getProperty(key, false));
            }
        }
        return options.toString();
    }

    private void visit(ProcedureParameter param) {
        ProcedureParameter.Type type = param.getType();
        String typeStr = null;
        switch (type) {
            case InOut: {
                typeStr = "INOUT";
                break;
            }
            case ReturnValue: 
            case Out: {
                typeStr = "OUT";
                break;
            }
            case In: {
                typeStr = param.isVarArg() ? "VARIADIC" : "IN";
            }
        }
        this.append(typeStr).append(" ");
        this.appendColumn((BaseColumn)param, true, true);
        if (type == ProcedureParameter.Type.ReturnValue) {
            this.append(" ").append("RESULT");
        }
        this.appendDefault((BaseColumn)param);
        this.appendColumnOptions((BaseColumn)param);
    }

    private void visit(FunctionMethod function) {
        if (this.filter != null && !this.filter.matcher(function.getName()).matches()) {
            return;
        }
        this.append("CREATE").append(" ");
        if (function.getPushdown().equals((Object)FunctionMethod.PushDown.MUST_PUSHDOWN)) {
            this.append("FOREIGN");
        } else {
            this.append("VIRTUAL");
        }
        this.append(" ").append("FUNCTION").append(" ").append(SQLStringVisitor.escapeSinglePart(function.getName()));
        this.append("(");
        boolean first = true;
        for (FunctionParameter fp : function.getInputParameters()) {
            if (first) {
                first = false;
            } else {
                this.append(",").append(" ");
            }
            this.visit(fp);
        }
        this.append(")");
        this.append(" ").append("RETURNS").append(" ");
        this.append(function.getOutputParameter().getType());
        String options = this.buildFunctionOptions(function);
        if (!options.isEmpty()) {
            this.append(NEWLINE).append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
        this.append(";");
    }

    private String buildFunctionOptions(FunctionMethod function) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)function);
        if (function.getCategory() != null) {
            this.addOption(options, "CATEGORY", function.getCategory());
        }
        if (!function.getDeterminism().equals((Object)FunctionMethod.Determinism.DETERMINISTIC)) {
            this.addOption(options, "DETERMINISM", function.getDeterminism().name());
        }
        if (function.getInvocationClass() != null) {
            this.addOption(options, "JAVA_CLASS", function.getInvocationClass());
        }
        if (function.getInvocationMethod() != null) {
            this.addOption(options, "JAVA_METHOD", function.getInvocationMethod());
        }
        if (!function.getProperties().isEmpty()) {
            for (String key : function.getProperties().keySet()) {
                this.addOption(options, key, function.getProperty(key, false));
            }
        }
        return options.toString();
    }

    private void visit(FunctionParameter param) {
        if (param.isVarArg()) {
            this.append("VARIADIC").append(" ");
        }
        this.append(SQLStringVisitor.escapeSinglePart(param.getName())).append(" ").append(param.getType());
    }

    public String toString() {
        if (this.prefixMap != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.prefixMap.entrySet()) {
                sb.append("SET NAMESPACE '").append(StringUtil.replaceAll((String)entry.getKey(), (String)"'", (String)"''")).append('\'').append(" AS ").append(SQLStringVisitor.escapeSinglePart(entry.getValue())).append(";\n");
            }
            return sb.append(NEWLINE).toString() + this.buffer.toString();
        }
        return this.buffer.toString();
    }

    static {
        for (Map.Entry entry : MetadataFactory.BUILTIN_NAMESPACES.entrySet()) {
            BUILTIN_PREFIXES.put((String)entry.getValue(), (String)entry.getKey());
        }
    }
}

