/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Symbol;

public class GroupSymbol
extends Symbol
implements Comparable<GroupSymbol> {
    public static final String TEMP_GROUP_PREFIX = "#";
    private String definition;
    private Object metadataID;
    private boolean isTempTable;
    private boolean isGlobalTable;
    private boolean isProcedure;
    private Object modelMetadataId;
    private String outputDefinition;
    private String schema;

    public GroupSymbol(String name) {
        super(name);
    }

    public GroupSymbol(String name, String definition) {
        super(name);
        this.setDefinition(definition);
    }

    private GroupSymbol(String schmea, String shortName, String definition) {
        this.schema = schmea;
        this.setShortName(shortName);
        this.setDefinition(definition);
    }

    public Object getModelMetadataId() {
        return this.modelMetadataId;
    }

    public void setModelMetadataId(Object modelMetadataId) {
        this.modelMetadataId = modelMetadataId;
    }

    public String getNonCorrelationName() {
        if (this.definition == null) {
            return this.getName();
        }
        return this.getDefinition();
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
        this.outputDefinition = definition;
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public void setMetadataID(Object metadataID) {
        if (metadataID == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0016"));
        }
        if (this.isImplicitTempGroupSymbol()) {
            this.isTempTable = true;
        }
        this.metadataID = metadataID;
    }

    public boolean isResolved() {
        return this.metadataID != null;
    }

    public boolean isTempGroupSymbol() {
        return this.isTempTable || this.metadataID == null && this.isImplicitTempGroupSymbol();
    }

    public boolean isImplicitTempGroupSymbol() {
        return GroupSymbol.isTempGroupName(this.getNonCorrelationName());
    }

    @Override
    public int compareTo(GroupSymbol o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public GroupSymbol clone() {
        GroupSymbol copy = new GroupSymbol(this.schema, this.getShortName(), this.getDefinition());
        copy.metadataID = this.metadataID;
        copy.setIsTempTable(this.isTempTable);
        copy.setProcedure(this.isProcedure);
        copy.outputDefinition = this.outputDefinition;
        copy.outputName = this.outputName;
        copy.isGlobalTable = this.isGlobalTable;
        copy.modelMetadataId = this.modelMetadataId;
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GroupSymbol)) {
            return false;
        }
        GroupSymbol other = (GroupSymbol)obj;
        if (this.schema == null || other.schema == null) {
            return this.getName().equals(other.getName());
        }
        return EquivalenceUtil.areEqual((Object)this.schema, (Object)other.schema) && this.getShortName().equals(other.getShortName());
    }

    public boolean hasAlias() {
        return this.getDefinition() != null;
    }

    public void setIsTempTable(boolean isTempTable) {
        this.isTempTable = isTempTable;
    }

    public static boolean isTempGroupName(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith(TEMP_GROUP_PREFIX);
    }

    public boolean isTempTable() {
        return this.isTempTable;
    }

    public boolean isProcedure() {
        return this.isProcedure;
    }

    public void setProcedure(boolean isProcedure) {
        this.isProcedure = isProcedure;
    }

    public String getOutputDefinition() {
        return this.outputDefinition == null ? this.getDefinition() : this.outputDefinition;
    }

    public void setOutputDefinition(String outputDefinition) {
        this.outputDefinition = outputDefinition;
    }

    public boolean isGlobalTable() {
        return this.isGlobalTable;
    }

    public void setGlobalTable(boolean isGlobalTable) {
        this.isGlobalTable = isGlobalTable;
    }

    @Override
    public String getName() {
        if (this.schema != null) {
            return this.schema + "." + this.getShortName();
        }
        return super.getName();
    }

    @Override
    public int hashCode() {
        if (this.schema != null) {
            return HashCodeUtil.hashCode((int)this.schema.hashCode(), (int)this.getShortName().hashCode());
        }
        return super.hashCode();
    }

    @Override
    public void setName(String name) {
        int index = name.indexOf(46);
        if (index > 0) {
            this.schema = new String(name.substring(0, index));
            name = new String(name.substring(index + 1));
        } else {
            this.schema = null;
        }
        super.setShortName(name);
    }

    public String getSchema() {
        return this.schema;
    }
}

