/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.List;
import org.teiid.common.buffer.AbstractTupleSource;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.BatchCollector;

public class BatchIterator
extends AbstractTupleSource {
    private final BatchCollector.BatchProducer source;
    private boolean saveOnMark;
    private TupleBuffer buffer;
    private boolean done;
    private boolean mark;

    public BatchIterator(BatchCollector.BatchProducer source) {
        this.source = source;
    }

    @Override
    protected TupleBatch getBatch(int row) throws TeiidComponentException, TeiidProcessingException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<?> finalRow() throws TeiidComponentException, TeiidProcessingException {
        if (this.buffer != null && this.getCurrentIndex() <= this.buffer.getRowCount()) {
            this.batch = this.buffer.getBatch(this.getCurrentIndex());
        }
        while (this.available() < 1) {
            if (this.done) {
                return null;
            }
            this.batch = this.source.nextBatch();
            this.done = this.batch.getTerminationFlag();
            if (this.buffer != null && (!this.saveOnMark || this.mark)) {
                this.buffer.addTupleBatch(this.batch, true);
            }
            if (!this.done || this.buffer == null) continue;
            this.buffer.close();
        }
        return this.getCurrentTuple();
    }

    @Override
    protected List<?> getCurrentTuple() throws TeiidComponentException, BlockedException, TeiidProcessingException {
        List<?> tuple = super.getCurrentTuple();
        this.saveTuple(tuple);
        return tuple;
    }

    private void saveTuple(List<?> tuple) throws TeiidComponentException {
        if (tuple != null && this.mark && this.saveOnMark && this.getCurrentIndex() > this.buffer.getRowCount()) {
            this.buffer.setRowCount(this.getCurrentIndex() - 1);
            this.buffer.addTuple(tuple);
        }
    }

    @Override
    public int available() {
        if (this.batch != null && this.batch.containsRow(this.getCurrentIndex())) {
            return this.batch.getEndRow() - this.getCurrentIndex() + 1;
        }
        return 0;
    }

    public void setBuffer(TupleBuffer buffer, boolean saveOnMark) {
        this.buffer = buffer;
        this.saveOnMark = saveOnMark;
    }

    @Override
    public void closeSource() {
        if (this.buffer != null) {
            this.buffer.remove();
            this.buffer = null;
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.buffer != null) {
            this.mark = false;
            return;
        }
    }

    @Override
    public void mark() throws TeiidComponentException {
        super.mark();
        if (this.buffer != null && this.saveOnMark && this.getCurrentIndex() > this.buffer.getRowCount()) {
            this.buffer.purge();
        }
        this.mark = true;
        this.saveTuple(this.currentTuple);
    }

    @Override
    public void setPosition(int position) {
        if (this.buffer == null && position < this.getCurrentIndex() && position < (this.batch != null ? this.batch.getBeginRow() : Integer.MAX_VALUE)) {
            throw new UnsupportedOperationException("Backwards positioning is not allowed");
        }
        super.setPosition(position);
    }

    public boolean ensureSave() {
        if (!this.saveOnMark || this.mark) {
            return false;
        }
        this.mark = true;
        return true;
    }

    public void disableSave() {
        if (this.buffer != null) {
            this.saveOnMark = true;
            this.mark = false;
            if (this.batch != null && this.batch.getEndRow() <= this.buffer.getRowCount()) {
                this.batch = null;
            }
        }
    }

    public void readAhead(long limit) throws TeiidComponentException, TeiidProcessingException {
        if (this.buffer == null || this.done) {
            return;
        }
        if ((long)this.buffer.getManagedRowCount() > limit) {
            return;
        }
        if (this.batch != null && this.buffer.getRowCount() < this.batch.getEndRow()) {
            this.buffer.addTupleBatch(this.batch, true);
        }
        TupleBatch tb = this.source.nextBatch();
        this.done = tb.getTerminationFlag();
        this.buffer.addTupleBatch(tb, true);
        if (this.done) {
            this.buffer.close();
        }
    }

    public TupleBuffer getBuffer() {
        return this.buffer;
    }
}

