/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.FilteredCommand;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Update
extends ProcedureContainer
implements FilteredCommand {
    private GroupSymbol group;
    private SetClauseList changeList = new SetClauseList();
    private Criteria criteria;
    private Criteria constraint;

    public Update() {
    }

    @Override
    public int getType() {
        return 3;
    }

    public Update(GroupSymbol group, SetClauseList changeList) {
        this.group = group;
        this.changeList = changeList;
    }

    public Update(GroupSymbol group, SetClauseList changeList, Criteria criteria) {
        this(group, changeList);
        this.criteria = criteria;
    }

    @Override
    public GroupSymbol getGroup() {
        return this.group;
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    public void setChangeList(SetClauseList changeList) {
        this.changeList = changeList;
    }

    public SetClauseList getChangeList() {
        return this.changeList;
    }

    public void addChange(ElementSymbol id, Expression value) {
        this.changeList.addClause(id, value);
    }

    @Override
    public Criteria getCriteria() {
        return this.criteria;
    }

    @Override
    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.group);
        myHash = HashCodeUtil.hashCode(myHash, this.changeList);
        if (this.criteria != null) {
            myHash = HashCodeUtil.hashCode(myHash, this.criteria);
        }
        return myHash;
    }

    @Override
    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Update)) {
            return false;
        }
        Update other = (Update)obj;
        return EquivalenceUtil.areEqual(this.getGroup(), other.getGroup()) && this.getChangeList().equals(other.getChangeList()) && this.sameOptionAndHint(other) && EquivalenceUtil.areEqual(this.getCriteria(), other.getCriteria());
    }

    @Override
    public Object clone() {
        Update copy = new Update();
        if (this.group != null) {
            copy.setGroup(this.group.clone());
        }
        copy.setChangeList((SetClauseList)this.changeList.clone());
        if (this.criteria != null) {
            copy.setCriteria((Criteria)this.criteria.clone());
        }
        this.copyMetadataState(copy);
        if (this.constraint != null) {
            copy.constraint = (Criteria)this.constraint.clone();
        }
        return copy;
    }

    public List getProjectedSymbols() {
        return Command.getUpdateCommandSymbol();
    }

    @Override
    public boolean areResultsCachable() {
        return false;
    }

    public Criteria getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Criteria constraint) {
        this.constraint = constraint;
    }
}

