/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Block
extends Statement
implements Statement.Labeled {
    private List<Statement> statements = new ArrayList<Statement>();
    private boolean atomic;
    private String label;
    private String exceptionGroup;
    private List<Statement> exceptionStatements;

    public Block() {
    }

    public Block(Statement statement) {
        this();
        this.statements.add(statement);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    public void addStatement(Statement statement) {
        this.addStatement(statement, false);
    }

    public void addStatement(Statement statement, boolean exception) {
        AssignmentStatement stmt;
        Command cmd;
        if (statement instanceof AssignmentStatement && (cmd = (stmt = (AssignmentStatement)statement).getCommand()) != null) {
            this.internalAddStatement(new CommandStatement(cmd), exception);
            stmt.setCommand(null);
            stmt.setExpression(null);
            if (stmt.getVariable().getShortName().equalsIgnoreCase("ROWCOUNT") && stmt.getVariable().getGroupSymbol() != null && stmt.getVariable().getGroupSymbol().getName().equalsIgnoreCase("VARIABLES")) {
                return;
            }
            String fullName = "VARIABLES.ROWCOUNT";
            stmt.setExpression(new ElementSymbol(fullName));
        }
        this.internalAddStatement(statement, exception);
    }

    private void internalAddStatement(Statement statement, boolean exception) {
        if (exception) {
            if (this.exceptionStatements == null) {
                this.exceptionStatements = new ArrayList<Statement>();
            }
            this.exceptionStatements.add(statement);
        } else {
            this.statements.add(statement);
        }
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Block clone() {
        Block copy = new Block();
        copy.setAtomic(this.atomic);
        copy.statements = LanguageObject.Util.deepClone(this.statements, Statement.class);
        if (this.exceptionStatements != null) {
            copy.exceptionStatements = LanguageObject.Util.deepClone(this.exceptionStatements, Statement.class);
        }
        copy.exceptionGroup = this.exceptionGroup;
        copy.setLabel(this.label);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        Block other = (Block)obj;
        return this.atomic == other.atomic && StringUtil.equalsIgnoreCase(this.label, other.label) && EquivalenceUtil.areEqual(this.getStatements(), other.getStatements()) && EquivalenceUtil.areEqual(this.exceptionGroup, this.exceptionGroup) && EquivalenceUtil.areEqual(this.exceptionStatements, this.exceptionStatements);
    }

    public int hashCode() {
        return this.statements.hashCode();
    }

    @Override
    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public void setAtomic(boolean atomic) {
        this.atomic = atomic;
    }

    @Override
    public int getType() {
        return 11;
    }

    public String getExceptionGroup() {
        return this.exceptionGroup;
    }

    public void setExceptionGroup(String exceptionGroup) {
        this.exceptionGroup = exceptionGroup;
    }

    public List<Statement> getExceptionStatements() {
        return this.exceptionStatements;
    }

    public void setExceptionStatements(List<Statement> exceptionStatements) {
        this.exceptionStatements = exceptionStatements;
    }
}

