/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import org.junit.Test;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.FakeFunctionMetadataSource;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestAggregatePushdown {
    public static BasicSourceCapabilities getAggregateCapabilities() {
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_HAVING, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        return caps;
    }

    public static CapabilitiesFinder getAggregatesFinder() {
        return new DefaultCapabilitiesFinder((SourceCapabilities)TestAggregatePushdown.getAggregateCapabilities());
    }

    @Test
    public void testCase6327() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        String sql = "SELECT a12.intkey AS REGION_NBR, SUM(a11.intnum) AS WJXBFS1 FROM bqt1.smalla AS a11 INNER JOIN bqt2.smalla AS a12 ON a11.stringkey = a12.stringkey WHERE a11.stringkey = 0 GROUP BY a12.intkey";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT SUM(a11.intnum) FROM bqt1.smalla AS a11 WHERE a11.stringkey = '0' HAVING SUM(a11.intnum) IS NOT NULL", "SELECT a12.intkey FROM bqt2.smalla AS a12 WHERE a12.stringkey = '0'"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testAggregateOfJoinExpression() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        String sql = "SELECT a12.intkey, MAX(a12.stringkey), MIN(a11.intnum+a12.intnum) FROM bqt1.smalla AS a11 INNER JOIN bqt2.smalla AS a12 ON a11.stringkey = a12.stringkey GROUP BY a12.intkey";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.StringKey, g_0.IntKey, g_0.IntNum FROM BQT2.SmallA AS g_0 GROUP BY g_0.StringKey, g_0.IntKey, g_0.IntNum", "SELECT g_0.StringKey, g_0.IntNum FROM BQT1.SmallA AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testAggregateOfJoinExpression1() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        String sql = "SELECT a12.intkey, MAX(a12.stringkey), SUM(a11.intnum+a12.intnum) FROM bqt1.smalla AS a11 INNER JOIN bqt2.smalla AS a12 ON a11.stringkey = a12.stringkey GROUP BY a12.intkey";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.StringKey, g_0.IntKey, g_0.IntNum FROM BQT2.SmallA AS g_0", "SELECT g_0.StringKey, g_0.IntNum FROM BQT1.SmallA AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testInvariantAggregate() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "SELECT max(y.e2) from pm1.g1 x, pm2.g1 y where x.e3 = y.e3 group by y.e3";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e3 FROM pm1.g1 AS g_0", "SELECT g_0.e3, MAX(g_0.e2) FROM pm2.g1 AS g_0 GROUP BY g_0.e3"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCase6211() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        String sql = "select sum(a11.intnum) Profit, (sum(a11.intnum) / sum(a11.floatnum)) WJXBFS2 from bqt1.smalla a11 join bqt2.smallb a12 on a11.intkey=a12.intkey group by a12.intkey";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.IntKey FROM BQT2.SmallB AS g_0", "SELECT g_0.IntKey, SUM(g_0.IntNum), SUM(g_0.FloatNum) FROM BQT1.SmallA AS g_0 GROUP BY g_0.IntKey"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testAggregatePushdown1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleAggregatesCached();
        String sql = "SELECT o_dealerid, o_productid, sum(o_amount) FROM m1.order, m1.dealer, m2.product WHERE o_dealerid=d_dealerid AND o_productid=p_productid AND d_state = 'CA' AND p_divid = 100 GROUP BY o_dealerid, o_productid";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, TestAggregatePushdown.getAggregatesFinder(), new String[]{"SELECT g_0.O_ProductID, g_0.O_DealerID, SUM(g_0.O_Amount) FROM m1.\"order\" AS g_0, m1.dealer AS g_1 WHERE (g_0.O_DealerID = g_1.D_DealerID) AND (g_1.D_State = 'CA') AND (g_0.O_ProductID IN (<dependent values>)) GROUP BY g_0.O_ProductID, g_0.O_DealerID", "SELECT g_0.P_ProductID AS c_0 FROM m2.product AS g_0 WHERE g_0.P_DivID = 100 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testAggregatePushdown2() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleAggregatesCached();
        String sql = "SELECT o_dealerid, o_productid, sum(o_amount) FROM m1.order, m1.dealer, m2.product WHERE o_dealerid=d_dealerid AND o_productid=p_productid AND d_state = 'CA' AND p_divid = 100 GROUP BY o_dealerid, o_productid having max(o_amount) < 100";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, TestAggregatePushdown.getAggregatesFinder(), new String[]{"SELECT g_0.P_ProductID AS c_0 FROM m2.product AS g_0 WHERE g_0.P_DivID = 100 ORDER BY c_0", "SELECT g_0.O_ProductID, g_0.O_DealerID, MAX(g_0.O_Amount), SUM(g_0.O_Amount) FROM m1.\"order\" AS g_0, m1.dealer AS g_1 WHERE (g_0.O_DealerID = g_1.D_DealerID) AND (g_1.D_State = 'CA') AND (g_0.O_ProductID IN (<dependent values>)) GROUP BY g_0.O_ProductID, g_0.O_DealerID"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testAvgAggregate() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "SELECT avg(y.e2) from pm1.g1 x, pm2.g1 y where x.e3 = y.e3 group by x.e2, y.e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e3, g_0.e2 FROM pm1.g1 AS g_0", "SELECT g_0.e3, g_0.e1, SUM(g_0.e2), COUNT(g_0.e2) FROM pm2.g1 AS g_0 GROUP BY g_0.e3, g_0.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testAvgAggregateFiltered() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "SELECT avg(y.e2) filter (where y.e1 = 1) from pm1.g1 x, pm2.g1 y where x.e3 = y.e3 group by x.e2, y.e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e3, g_0.e2 FROM pm1.g1 AS g_0", "SELECT g_0.e3, g_0.e1, g_0.e2 FROM pm2.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 2, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testAvgAggregateFiltered1() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ADVANCED_OLAP, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "SELECT avg(y.e2) filter (where x.e1 = 1) from pm1.g1 x, pm2.g1 y where x.e3 = y.e3 group by x.e2, y.e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e3, g_0.e2, g_0.e1 FROM pm1.g1 AS g_0", "SELECT g_0.e3, g_0.e1, g_0.e2 FROM pm2.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testStddevAggregate() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setFunctionSupport("power", true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "SELECT stddev_pop(y.e2) from pm1.g1 x, pm2.g1 y where x.e3 = y.e3 group by x.e2, y.e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e3 AS c_0, g_0.e1 AS c_1, COUNT(g_0.e2) AS c_2, SUM(power(g_0.e2, 2)) AS c_3, SUM(g_0.e2) AS c_4 FROM pm2.g1 AS g_0 GROUP BY g_0.e3, g_0.e1 ORDER BY c_0", "SELECT g_0.e3 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCountAggregate() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "SELECT count(y.e2) from pm1.g1 x, pm2.g1 y where x.e3 = y.e3 group by x.e2, y.e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e3, g_0.e2 FROM pm1.g1 AS g_0", "SELECT g_0.e3, g_0.e1, COUNT(g_0.e2) FROM pm2.g1 AS g_0 GROUP BY g_0.e3, g_0.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testOuterJoinPreventsPushdown() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "SELECT count(y.e2) from pm1.g1 x left outer join pm2.g1 y on x.e3 = y.e3 group by x.e2, y.e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e3, g_0.e2 FROM pm1.g1 AS g_0", "SELECT g_0.e3, g_0.e1, g_0.e2 FROM pm2.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCase5724() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("select count(*), a.intnum from bqt1.smalla as a, bqt2.smallb as b where a.intkey = b.intkey group by a.intnum", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT a.intkey, a.intnum FROM bqt1.smalla AS a", "SELECT b.intkey FROM bqt2.smallb AS b"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCase6210() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        caps.setFunctionSupport("convert", true);
        caps.setFunctionSupport("/", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        String sql = "select a11.intkey ITEM_ID, sum(a11.intnum) WJXBFS1 from bqt1.smalla a11 join bqt2.smalla a12 on (a11.stringkey = a12.stringkey) join bqt2.smallb a13 on (a11.intkey = a13.intkey) where a13.intnum in (10) group by a11.intkey";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.IntKey FROM BQT2.SmallB AS g_0 WHERE g_0.IntNum = 10", "SELECT g_0.StringKey FROM BQT2.SmallA AS g_0", "SELECT g_0.StringKey, g_0.IntKey, SUM(g_0.IntNum) FROM BQT1.SmallA AS g_0 GROUP BY g_0.StringKey, g_0.IntKey"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{3, 0, 0, 0, 0, 1, 0, 2, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testNoGroupAggregatePushdown() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("select count(*) from bqt1.smalla", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT count(*) from bqt1.smalla"}, true);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testNoHavingAggregate() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("select stringkey, max(intkey) from bqt1.smalla group by stringkey having count(intkey) = 1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT COUNT(g_0.IntKey), g_0.StringKey, MAX(g_0.IntKey) FROM BQT1.SmallA AS g_0 GROUP BY g_0.StringKey"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testHavingCriteriaPushDown() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select X.e1 FROM vm1.g1 X group by X.e1 having X.e1 = 1 and sum(X.e2) = 2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 WHERE pm1.g1.e1 = '1'"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testCountXMLAgg() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select count(X.e1), xmlagg(xmlelement(name e1, x.e1) order by x.e2) FROM pm1.g1 as X, pm2.g2 as Y group by X.e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT 1 FROM pm2.g2 AS g_0", "SELECT g_0.e2, g_0.e1 FROM pm1.g1 AS g_0"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testBusObjQuestion1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, true);
        capFinder.addCapabilities("db2model", (SourceCapabilities)caps);
        capFinder.addCapabilities("oraclemodel", (SourceCapabilities)caps);
        capFinder.addCapabilities("msmodel", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBusObj();
        String sql = "SELECT Q1.S, Q2.C, Q1.PRODUCT, Q1.REGION AS Q1R, Q2.REGION AS Q2R FROM (SELECT SUM(SALES) AS S, REGION, PRODUCT FROM DB2_TABLE WHERE PRODUCT IN ('GUNS', 'TOYS', 'VIDEOTAPES') GROUP BY REGION, PRODUCT) Q1 FULL OUTER JOIN (SELECT SUM(COSTS) AS C, REGION FROM ORACLE_TABLE WHERE \"YEAR\" = '1999' GROUP BY REGION) Q2 ON Q1.REGION = Q2.REGION";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT REGION, SUM(SALES), PRODUCT FROM db2model.DB2_TABLE WHERE PRODUCT IN ('GUNS', 'TOYS', 'VIDEOTAPES') GROUP BY REGION, PRODUCT", "SELECT REGION, SUM(COSTS) FROM oraclemodel.Oracle_table WHERE \"YEAR\" = '1999' GROUP BY REGION"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testBusObjQuestion2() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, true);
        capFinder.addCapabilities("db2model", (SourceCapabilities)caps);
        capFinder.addCapabilities("oraclemodel", (SourceCapabilities)caps);
        capFinder.addCapabilities("msmodel", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBusObj();
        String sql = "SELECT SUM(F.SALES), G.REGION, T.YEAR FROM SALES F, GEOGRAPHY G, msModel.TIME T WHERE (F.CITY = G.CITY) AND (F.MONTH = T.MONTH) AND G.REGION IN ('BORDEAUX', 'POLINESIA') AND T.YEAR = '1999' GROUP BY G.REGION, T.YEAR";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.\"MONTH\" AS c_0, g_0.\"YEAR\" AS c_1 FROM msmodel.\"TIME\" AS g_0 WHERE g_0.\"YEAR\" = '1999' ORDER BY c_0", "SELECT g_0.\"MONTH\", g_0.CITY, SUM(g_0.SALES) FROM db2model.SALES AS g_0 WHERE (g_0.\"MONTH\" IN (<dependent values>)) AND (g_0.CITY IN (<dependent values>)) GROUP BY g_0.\"MONTH\", g_0.CITY", "SELECT g_0.CITY AS c_0, g_0.REGION AS c_1 FROM oraclemodel.GEOGRAPHY AS g_0 WHERE g_0.REGION IN ('BORDEAUX', 'POLINESIA') ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 1, 0, 0, 0, 1, 0, 2, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testBusObjQuestion2Hint() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, true);
        capFinder.addCapabilities("db2model", (SourceCapabilities)caps);
        capFinder.addCapabilities("oraclemodel", (SourceCapabilities)caps);
        capFinder.addCapabilities("msmodel", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBusObj();
        String sql = "SELECT SUM(F.SALES), G.REGION, T.YEAR FROM SALES F MAKEDEP, GEOGRAPHY G, msModel.TIME T WHERE (F.CITY = G.CITY) AND (F.MONTH = T.MONTH) AND G.REGION IN ('BORDEAUX', 'POLINESIA') AND T.YEAR = '1999' GROUP BY G.REGION, T.YEAR";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.\"MONTH\" AS c_0, g_0.\"YEAR\" AS c_1 FROM msmodel.\"TIME\" AS g_0 WHERE g_0.\"YEAR\" = '1999' ORDER BY c_0", "SELECT g_0.\"MONTH\", g_0.CITY, SUM(g_0.SALES) FROM db2model.SALES AS g_0 WHERE (g_0.\"MONTH\" IN (<dependent values>)) AND (g_0.CITY IN (<dependent values>)) GROUP BY g_0.\"MONTH\", g_0.CITY", "SELECT g_0.CITY AS c_0, g_0.REGION AS c_1 FROM oraclemodel.GEOGRAPHY AS g_0 WHERE g_0.REGION IN ('BORDEAUX', 'POLINESIA') ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 1, 0, 0, 0, 1, 0, 2, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testBusObjQuestion2HintVariation() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, true);
        capFinder.addCapabilities("db2model", (SourceCapabilities)caps);
        capFinder.addCapabilities("oraclemodel", (SourceCapabilities)caps);
        capFinder.addCapabilities("msmodel", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBusObj();
        String sql = "SELECT SUM(F.SALES), G.REGION, T.YEAR FROM SALES F MAKEDEP, GEOGRAPHY2 G, msModel.TIME T WHERE (F.CITY = G.CITY) AND (F.MONTH = T.MONTH) AND G.REGION IN ('BORDEAUX', 'POLINESIA') AND T.YEAR = '1999' GROUP BY G.REGION, T.YEAR";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.\"MONTH\" AS c_0, g_0.\"YEAR\" AS c_1 FROM msmodel.\"TIME\" AS g_0 WHERE g_0.\"YEAR\" = '1999' ORDER BY c_0", "SELECT g_0.\"MONTH\", g_1.REGION, SUM(g_0.SALES) FROM db2model.SALES AS g_0, db2model.GEOGRAPHY2 AS g_1 WHERE (g_0.CITY = g_1.CITY) AND (g_1.REGION IN ('BORDEAUX', 'POLINESIA')) AND (g_0.\"MONTH\" IN (<dependent values>)) GROUP BY g_0.\"MONTH\", g_1.REGION"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testBusObjQuestion3() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, true);
        capFinder.addCapabilities("db2model", (SourceCapabilities)caps);
        capFinder.addCapabilities("oraclemodel", (SourceCapabilities)caps);
        capFinder.addCapabilities("msmodel", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBusObj();
        String sql = "select sum(c0), sum(b0), c1, b2 FROM db2Table, OraTable where c2=b2 group by c1, b2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.c2, g_0.c1, g_0.c0 FROM db2model.DB2TABLE AS g_0", "SELECT g_0.b2 AS c_0, g_0.b0 AS c_1 FROM oraclemodel.OraTable AS g_0 ORDER BY c_0"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 2, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushDownOverUnion() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select e1, max(e2) from (select e1, e2 from pm1.g1 union all select e1, e2 from pm1.g2) y group by e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, MAX(g_0.e2) FROM pm1.g1 AS g_0 GROUP BY g_0.e1", "SELECT g_0.e1, MAX(g_0.e2) FROM pm1.g2 AS g_0 GROUP BY g_0.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testPushDownOverUnionFiltered() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select e1, count(*) filter (where e3) from (select e1, e2, e3 from pm1.g1 union all select e1, e2, e3 from pm1.g2) y group by e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, g_0.e3 FROM pm1.g1 AS g_0", "SELECT g_0.e1, g_0.e3 FROM pm1.g2 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testPushDownOverUnionFiltered1() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ADVANCED_OLAP, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select e1, count(*) filter (where e3) from (select e1, e2, e3 from pm1.g1 union all select e1, e2, e3 from pm1.g2) y group by e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, COUNT(*) FILTER(WHERE g_0.e3) FROM pm1.g1 AS g_0 GROUP BY g_0.e1 HAVING COUNT(*) > 0", "SELECT g_0.e1, COUNT(*) FILTER(WHERE g_0.e3) FROM pm1.g2 AS g_0 GROUP BY g_0.e1 HAVING COUNT(*) > 0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testPushDownOverUnionFiltered3() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ADVANCED_OLAP, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select e1, count(*) filter (where e3 > rand()) from (select e1, e2, e3 from pm1.g1 union all select e1, e2, e3 from pm1.g2) y group by e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, g_0.e3 FROM pm1.g1 AS g_0", "SELECT g_0.e1, g_0.e3 FROM pm1.g2 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testPushDownOverUnion1() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select max(e2) from (select e1, e2 from pm1.g1 union all select e1, e2 from pm1.g2) z", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT MAX(g_0.e2) FROM pm1.g2 AS g_0 HAVING MAX(g_0.e2) IS NOT NULL", "SELECT MAX(g_0.e2) FROM pm1.g1 AS g_0 HAVING MAX(g_0.e2) IS NOT NULL"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testPushDownOverUnion2() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select count(e2) from (select e1, e2 from pm1.g1 union select e1, e2 from pm1.g2) z", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, g_0.e2 FROM pm1.g2 AS g_0", "SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testPushDownOverUnionMixed() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        ProcessorPlan plan = TestOptimizer.helpPlan("select max(e2), count(*) from (select e1, e2 from pm1.g1 union all select e1, e2 from pm2.g2) z", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT MAX(g_0.e2), COUNT(*) FROM pm1.g1 AS g_0 HAVING MAX(g_0.e2) IS NOT NULL", "SELECT g_0.e2 FROM pm2.g2 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testPushDownOverUnionMixed1() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        BasicSourceCapabilities caps1 = TestAggregatePushdown.getAggregateCapabilities();
        caps1.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, false);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps1);
        ProcessorPlan plan = TestOptimizer.helpPlan("select max(e2), count(*) from (select e1, e2 from pm1.g1 union all select e1, e2 from pm2.g2) z", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT MAX(g_0.e2), COUNT(*) FROM pm2.g2 AS g_0 HAVING MAX(g_0.e2) IS NOT NULL", "SELECT MAX(g_0.e2), COUNT(*) FROM pm1.g1 AS g_0 HAVING MAX(g_0.e2) IS NOT NULL"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testPushDownOverUnionGroupingExpression() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)TestAggregatePushdown.getAggregateCapabilities());
        ProcessorPlan plan = TestOptimizer.helpPlan("select max(e2), case when e1 is null then 0 else 1 end from (select e1, e2 from pm1.g1 union all select e1, e2 from pm2.g2) z group by case when e1 is null then 0 else 1 end", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, g_0.e2 FROM pm2.g2 AS g_0", "SELECT v_0.c_0, MAX(v_0.c_1) FROM (SELECT CASE WHEN g_0.e1 IS NULL THEN 0 ELSE 1 END AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0) AS v_0 GROUP BY v_0.c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 0, 1});
    }

    @Test
    public void testPushDownOverUnionGroupingExpressionPartitioned() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select max(e2), case when e1 is null then 0 else 1 end from (select e1, e2, 1 as part from pm1.g1 union all select e1, e2, 2 as part from pm1.g2) z group by case when e1 is null then 0 else 1 end, part", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT MAX(v_0.c_2), v_0.c_0 FROM (SELECT CASE WHEN g_0.e1 IS NULL THEN 0 ELSE 1 END AS c_0, 1 AS c_1, g_0.e2 AS c_2 FROM pm1.g1 AS g_0) AS v_0 GROUP BY v_0.c_0, v_0.c_1", "SELECT MAX(v_0.c_2), v_0.c_0 FROM (SELECT CASE WHEN g_0.e1 IS NULL THEN 0 ELSE 1 END AS c_0, 2 AS c_1, g_0.e2 AS c_2 FROM pm1.g2 AS g_0) AS v_0 GROUP BY v_0.c_0, v_0.c_1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testForCase836073GroupBy() throws Exception {
        String sql = "select count(*) from bqt1.smallb where formatdate(bqt1.smallb.DateValue,'yyyyMM') = '200309'";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, TestAggregatePushdown.getAggregatesFinder(), new String[]{"SELECT g_0.DateValue FROM BQT1.SmallB AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testSingleTableRestriction() throws Exception {
        String sql = "select count(*) from bqt1.smallb, bqt1.smalla";
        BasicSourceCapabilities bsc = TestAggregatePushdown.getAggregateCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ONLY_SINGLE_TABLE_GROUP_BY, true);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)bsc), new String[]{"SELECT 1 FROM BQT1.SmallB AS g_0, BQT1.SmallA AS g_1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushDownOverUnionGroupingWithCount() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select count(*) from (select e1, e2, 1 as part from pm1.g1 union all select e1, e2, 2 as part from pm1.g2) z group by e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, COUNT(*) FROM pm1.g1 AS g_0 GROUP BY g_0.e1 HAVING COUNT(*) > 0", "SELECT g_0.e1, COUNT(*) FROM pm1.g2 AS g_0 GROUP BY g_0.e1 HAVING COUNT(*) > 0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testUnionGroupingWithRollup() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select count(*) from (select e1, e2, 1 as part from pm1.g1 union all select e1, e2, 2 as part from pm1.g2) z group by rollup(e1)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm1.g2 AS g_0", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testRollupPushdown() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select max(e1), e2 from pm1.g2 group by rollup(e2)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e2, g_0.e1 FROM pm1.g2 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY_ROLLUP, true);
        plan = TestOptimizer.helpPlan("select max(e1), e2 from pm1.g2 group by rollup(e2)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT MAX(g_0.e1), g_0.e2 FROM pm1.g2 AS g_0 GROUP BY ROLLUP(g_0.e2)"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testRollupOrderByPushdown() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY_ROLLUP, true);
        ProcessorPlan plan = TestOptimizer.helpPlan("select max(e1), e2 from pm1.g2 group by rollup(e2) order by e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT MAX(v_0.c_1) AS c_0, v_0.c_0 AS c_1 FROM (SELECT g_0.e2 AS c_0, g_0.e1 AS c_1 FROM pm1.g2 AS g_0 GROUP BY ROLLUP(g_0.e2)) AS v_0 ORDER BY c_1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY_EXTENDED_GROUPING, true);
        plan = TestOptimizer.helpPlan("select max(e1), e2 from pm1.g2 group by rollup(e2) order by e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT MAX(g_0.e1) AS c_0, g_0.e2 AS c_1 FROM pm1.g2 AS g_0 GROUP BY ROLLUP(g_0.e2) ORDER BY c_1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testRollupHaving() throws Exception {
        String sql = "select e1, sum(e2) from pm1.g1 group by rollup(e1) having e1 is not null";
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY_ROLLUP, true);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1, SUM(g_0.e2) FROM pm1.g1 AS g_0 WHERE g_0.e1 IS NOT NULL GROUP BY ROLLUP(g_0.e1) HAVING g_0.e1 IS NOT NULL"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testStringAggPushdown() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_STRING, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.WINDOW_FUNCTION_ORDER_BY_AGGREGATES, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select string_agg(e1, ',') from pm1.g2 group by e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT string_agg(g_0.e1, ',') FROM pm1.g2 AS g_0 GROUP BY g_0.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testUserDefinedAggPushdown() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ELEMENTARY_OLAP, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.WINDOW_FUNCTION_DISTINCT_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.WINDOW_FUNCTION_ORDER_BY_AGGREGATES, true);
        caps.setFunctionSupport("FIRST_VALUE", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource(), true));
        ProcessorPlan plan = TestOptimizer.helpPlan("select FIRST_VALUE(e1) OVER (ORDER BY e2) from pm1.g2", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT FIRST_VALUE(ALL g_0.e1) OVER (ORDER BY g_0.e2) FROM pm1.g2 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }
}

